/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.references.KubernetesLabelKeyReference;
import com.intellij.kubernetes.references.KubernetesLabelKeyRenameHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J/\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J2\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/kubernetes/references/KubernetesLabelKeyRenameHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "<init>", "()V", "isAvailableOnDataContext", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "rename", "targets", "", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "usages", "Lcom/intellij/usageView/UsageInfo;", "newName", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "findUsages", "resolver", "Lcom/intellij/kubernetes/KubernetesResolver;", "ref", "Lcom/intellij/kubernetes/references/KubernetesLabelKeyReference;", "getLabelKeyReference", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesLabelKeyRenameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLabelKeyRenameHandler.kt\ncom/intellij/kubernetes/references/KubernetesLabelKeyRenameHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n30#2,2:136\n30#2,2:138\n1563#3:140\n1634#3,3:141\n1869#3,2:144\n1869#3,2:146\n*S KotlinDebug\n*F\n+ 1 KubernetesLabelKeyRenameHandler.kt\ncom/intellij/kubernetes/references/KubernetesLabelKeyRenameHandler\n*L\n37#1:136,2\n42#1:138,2\n124#1:140\n124#1:141,3\n106#1:144,2\n112#1:146,2\n*E\n"})
public final class KubernetesLabelKeyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getLabelKeyReference(dataContext) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (dataContext == null) {
            return;
        }
        KubernetesLabelKeyReference kubernetesLabelKeyReference = this.getLabelKeyReference(dataContext);
        if (kubernetesLabelKeyReference == null) {
            return;
        }
        KubernetesLabelKeyReference ref = kubernetesLabelKeyReference;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Collection<YAMLKeyValue> targets2 = ((KubernetesResolver)object).findTargetLabelDeclarationsForUsages(ref.getElement(), ref.getKey(), null);
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)CollectionsKt.firstOrNull((Iterable)targets2);
        PsiElement $i$f$service22 = yAMLKeyValue != null ? (PsiElement)yAMLKeyValue : ref.getElement();
        Intrinsics.checkNotNull((Object)$i$f$service22);
        PsiElement mainTarget = $i$f$service22;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ComponentManager $this$service$iv2 = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesResolver> serviceClass$iv2 = KubernetesResolver.class;
            Object object2 = $this$service$iv2.getService(serviceClass$iv2);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
            }
            Collection<UsageInfo> usages = this.findUsages((KubernetesResolver)object2, ref);
            Object object3 = PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
            Intrinsics.checkNotNull((Object)object3);
            this.rename(project, targets2, usages, (String)object3);
            return;
        }
        new RenameDialog(project, mainTarget, editor, ref, targets2, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ KubernetesLabelKeyReference $ref;
            final /* synthetic */ Collection<YAMLKeyValue> $targets;
            final /* synthetic */ KubernetesLabelKeyRenameHandler this$0;
            {
                this.$project = $project;
                this.$ref = $ref;
                this.$targets = $targets;
                this.this$0 = $receiver;
                super($project, $mainTarget, null, $editor);
            }

            protected void createCheckboxes(JPanel panel2, GridBagConstraints gbConstraints) {
                super.createCheckboxes(panel2, gbConstraints);
                this.getCbSearchInComments().setVisible(false);
            }

            protected boolean isToSearchForTextOccurrencesForRename() {
                return false;
            }

            protected boolean isToSearchInCommentsForRename() {
                return false;
            }

            protected String getFullName() {
                Object[] objectArray = new Object[]{this.$ref.getKey()};
                String string = KubernetesBundle.message((String)"KubernetesLabelKeyRenameHandler.full.name", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            protected void doAction() {
                this.invokeRefactoring(new BaseRefactoringProcessor(this.$project, this.$targets, this.$ref, this.this$0, this){
                    private final KubernetesResolver resolver;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Collection<YAMLKeyValue> $targets;
                    final /* synthetic */ KubernetesLabelKeyReference $ref;
                    final /* synthetic */ KubernetesLabelKeyRenameHandler this$0;
                    final /* synthetic */ invoke.1 this$1;
                    {
                        this.$project = $project;
                        this.$targets = $targets;
                        this.$ref = $ref;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super($project);
                        ComponentManager $this$service$iv = (ComponentManager)$project;
                        boolean $i$f$service = false;
                        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        this.resolver = (KubernetesResolver)object;
                    }

                    public final KubernetesResolver getResolver() {
                        return this.resolver;
                    }

                    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        return new UsageViewDescriptor(this.$targets, this.$ref){
                            final /* synthetic */ Collection<YAMLKeyValue> $targets;
                            final /* synthetic */ KubernetesLabelKeyReference $ref;
                            {
                                this.$targets = $targets;
                                this.$ref = $ref;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public PsiElement[] getElements() {
                                void $this$mapTo$iv$iv;
                                Iterable $this$map$iv = this.$targets;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it);
                                }
                                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                return thisCollection$iv.toArray(new PsiElement[0]);
                            }

                            public String getProcessedElementsHeader() {
                                Object[] objectArray = new Object[]{this.$ref.getKey()};
                                String string = KubernetesBundle.message((String)"KubernetesLabelKeyRenameHandler.processed.elements.header", (Object[])objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }

                            public String getCodeReferencesText(int usagesCount, int filesCount) {
                                Object[] objectArray = new Object[]{usagesCount, filesCount};
                                String string = KubernetesBundle.message((String)"KubernetesLabelKeyRenameHandler.code.references.text", (Object[])objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }
                        };
                    }

                    protected UsageInfo[] findUsages() {
                        Collection $this$toTypedArray$iv = KubernetesLabelKeyRenameHandler.access$findUsages(this.this$0, this.resolver, this.$ref);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new UsageInfo[0]);
                    }

                    protected void performRefactoring(UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        Collection collection = ArraysKt.asList((Object[])usages);
                        String string = this.this$1.getNewName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
                        this.this$0.rename(this.$project, this.$targets, collection, string);
                    }

                    protected String getCommandName() {
                        String string = KubernetesBundle.message((String)"KubernetesLabelKeyRenameHandler.command.name", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return string;
                    }
                });
                this.close(0);
            }
        }.show();
    }

    public final void rename(@NotNull Project project, @NotNull Collection<? extends YAMLKeyValue> targets2, @NotNull Collection<? extends UsageInfo> usages, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        WriteCommandAction.runWriteCommandAction((Project)project, () -> KubernetesLabelKeyRenameHandler.rename$lambda$2(project, usages, targets2, newName));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<UsageInfo> findUsages(KubernetesResolver resolver, KubernetesLabelKeyReference ref) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = resolver.findLabelReferrers(ref.getElement(), ref.getKey(), null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UsageInfo((PsiElement)it, false));
        }
        return (List)destination$iv$iv;
    }

    private final KubernetesLabelKeyReference getLabelKeyReference(DataContext dataContext) {
        if (dataContext == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor2);
        return psiReference instanceof KubernetesLabelKeyReference ? (KubernetesLabelKeyReference)psiReference : null;
    }

    private static final void rename$lambda$2(Project $project, Collection $usages, Collection $targets, String $newName) {
        UsageInfo it;
        YAMLElementGenerator gen = YAMLElementGenerator.getInstance((Project)$project);
        Iterable $this$forEach$iv = $usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YAMLKeyValue newVal;
            YAMLKeyValue usageElement;
            it = (UsageInfo)element$iv;
            boolean bl = false;
            PsiElement psiElement = it.getElement();
            if ((psiElement instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement : null) == null) continue;
            usageElement = usageElement;
            Intrinsics.checkNotNullExpressionValue((Object)gen.createYamlKeyValue($newName, usageElement.getValueText()), (String)"createYamlKeyValue(...)");
            usageElement.replace((PsiElement)newVal);
        }
        $this$forEach$iv = $targets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YAMLKeyValue newVal;
            it = (YAMLKeyValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)gen.createYamlKeyValue($newName, it.getValueText()), (String)"createYamlKeyValue(...)");
            it.replace((PsiElement)newVal);
        }
    }

    public static final /* synthetic */ Collection access$findUsages(KubernetesLabelKeyRenameHandler $this, KubernetesResolver resolver, KubernetesLabelKeyReference ref) {
        return $this.findUsages(resolver, ref);
    }
}

