/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ExecutableFileFormatUtil;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.TrivialRunParameters;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.kotlin.commonNative.debugger.KonanInstaller;
import com.jetbrains.kotlin.commonNative.debugger.RunConfigurationWithExecutable;
import com.jetbrains.kotlin.commonNative.debugger.workspace.WorkspaceBase;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"createRunParameters", "Lcom/jetbrains/cidr/execution/TrivialRunParameters;", "runConfig", "Lcom/jetbrains/kotlin/commonNative/debugger/RunConfigurationWithExecutable;", "executableArchitecture", "Lcom/jetbrains/cidr/ArchitectureType;", "getExecutableArchitecture", "(Lcom/jetbrains/kotlin/commonNative/debugger/RunConfigurationWithExecutable;)Lcom/jetbrains/cidr/ArchitectureType;", "kotlin-ultimate.native-debugger"})
@SourceDebugExtension(value={"SMAP\nKonanInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KonanInstaller.kt\ncom/jetbrains/kotlin/commonNative/debugger/KonanInstallerKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,79:1\n30#2,2:80\n*S KotlinDebug\n*F\n+ 1 KonanInstaller.kt\ncom/jetbrains/kotlin/commonNative/debugger/KonanInstallerKt\n*L\n31#1:80,2\n*E\n"})
public final class KonanInstallerKt {
    @NotNull
    public static final TrivialRunParameters createRunParameters(@NotNull RunConfigurationWithExecutable runConfig) {
        Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
        Project project = runConfig.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<WorkspaceBase> serviceClass$iv = WorkspaceBase.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        WorkspaceBase workspace = (WorkspaceBase)object;
        KonanInstaller installer = new KonanInstaller(runConfig);
        return new TrivialRunParameters((DebuggerDriverConfiguration)workspace.getLldbDriverConfiguration(), (Installer)installer, KonanInstallerKt.getExecutableArchitecture(runConfig));
    }

    private static final ArchitectureType getExecutableArchitecture(RunConfigurationWithExecutable $this$executableArchitecture) {
        ArchitectureType architectureType;
        File file = $this$executableArchitecture.getExecutableFile();
        if (file == null) {
            return ArchitectureType.UNKNOWN;
        }
        File exe = file;
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                ArchitectureType architectureType2 = ExecutableFileFormatUtil.tryReadPeMachineType((String)exe.getPath());
                architectureType = architectureType2;
                Intrinsics.checkNotNullExpressionValue((Object)architectureType2, (String)"tryReadPeMachineType(...)");
                break;
            }
            case 2: {
                ArchitectureType architectureType3 = ExecutableFileFormatUtil.tryReadElfMachineType((String)exe.getPath());
                architectureType = architectureType3;
                Intrinsics.checkNotNullExpressionValue((Object)architectureType3, (String)"tryReadElfMachineType(...)");
                break;
            }
            case 3: {
                ArchitectureType architectureType4 = ArchitectureType.forVmCpuArch((CpuArch)CpuArch.CURRENT);
                architectureType = architectureType4;
                Intrinsics.checkNotNullExpressionValue((Object)architectureType4, (String)"forVmCpuArch(...)");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operating system for Kotlin/Native debugger.".toString());
            }
        }
        return architectureType;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

