/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.project.Project;
import com.jetbrains.kotlin.commonNative.debugger.BinaryExecutable;
import com.jetbrains.kotlin.commonNative.debugger.KonanDebugBundle;
import com.jetbrains.kotlin.commonNative.debugger.runconfig.AttachmentStrategy;
import com.jetbrains.kotlin.commonNative.debugger.runconfig.BinaryRunConfiguration;
import com.jetbrains.kotlin.commonNative.debugger.runconfig.BinaryRunConfigurationType;
import com.jetbrains.kotlin.commonNative.debugger.workspace.WorkspaceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@InternalIgnoreDependencyViolation
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/LLDBBackend;", "Lcom/intellij/openapi/externalSystem/debugger/DebuggerBackendExtension;", "<init>", "()V", "id", "", "debugConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "processName", "processParameters", "findDebugVariant", "Lcom/jetbrains/kotlin/commonNative/debugger/BinaryExecutable$Variant$Debug;", "Companion", "kotlin-ultimate.native-debugger"})
@SourceDebugExtension(value={"SMAP\nLLDBBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLDBBackend.kt\ncom/jetbrains/kotlin/commonNative/debugger/LLDBBackend\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n30#2,2:103\n30#2,2:105\n774#3:107\n865#3,2:108\n774#3:110\n865#3,2:111\n1374#3:113\n1460#3,2:114\n808#3,11:116\n1462#3,3:127\n295#3,2:130\n*S KotlinDebug\n*F\n+ 1 LLDBBackend.kt\ncom/jetbrains/kotlin/commonNative/debugger/LLDBBackend\n*L\n33#1:103,2\n85#1:105,2\n86#1:107\n86#1:108,2\n87#1:110\n87#1:111,2\n88#1:113\n88#1:114,2\n88#1:116,11\n88#1:127,3\n90#1:130,2\n*E\n"})
public final class LLDBBackend
implements DebuggerBackendExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "Gradle LLDB";
    @NotNull
    public static final String DEBUG_SERVER_PATH_KEY = "DEBUG_SERVER_PATH";
    @NotNull
    public static final String DEBUG_SERVER_ARGS_KEY = "DEBUG_SERVER_ARGS";
    @NotNull
    public static final String PROJECT_PATH_KEY = "PROJECT_PATH";
    @NotNull
    public static final String ATTACH_BY_NAME_KEY = "ATTACH_BY_NAME";

    @NotNull
    public String id() {
        return ID;
    }

    @NotNull
    public RunnerAndConfigurationSettings debugConfigurationSettings(@NotNull Project project, @NotNull String processName, @NotNull String processParameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        HashMap params = this.splitParameters(processParameters);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RunManager> serviceClass$iv = RunManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RunManager runManager = (RunManager)object;
        RunnerAndConfigurationSettings settings2 = runManager.createConfiguration(processName, BinaryRunConfigurationType.Companion.getInstance().getFactory());
        RunConfiguration runConfiguration = settings2.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.kotlin.commonNative.debugger.runconfig.BinaryRunConfiguration");
        BinaryRunConfiguration $this$debugConfigurationSettings_u24lambda_u241 = (BinaryRunConfiguration)runConfiguration;
        boolean bl = false;
        BinaryExecutable.Variant.Debug variant = this.findDebugVariant(project, processName);
        $this$debugConfigurationSettings_u24lambda_u241.setExecutable(variant.getFile());
        $this$debugConfigurationSettings_u24lambda_u241.setAttachmentStrategy(AttachmentStrategy.ByName.INSTANCE);
        $this$debugConfigurationSettings_u24lambda_u241.setWorkingDirectory(variant.getParams().getWorkingDirectory());
        $this$debugConfigurationSettings_u24lambda_u241.setProgramParameters(variant.getParams().getProgramParameters());
        $this$debugConfigurationSettings_u24lambda_u241.setEnvs(variant.getParams().getEnvironmentVariables());
        String string = (String)params.get(ATTACH_BY_NAME_KEY);
        boolean bl2 = string != null ? !Boolean.parseBoolean(string) : false;
        if (bl2) {
            String string2 = (String)params.get("DEBUG_SERVER_PORT");
            if (string2 != null) {
                int it = Integer.parseInt(string2);
                boolean bl3 = false;
                $this$debugConfigurationSettings_u24lambda_u241.setAttachmentStrategy(new AttachmentStrategy.ByPort(it));
            }
        }
        settings2.setActivateToolWindowBeforeRun(false);
        return settings2;
    }

    /*
     * WARNING - void declaration
     */
    private final BinaryExecutable.Variant.Debug findDebugVariant(Project project, String processName) {
        Object v3;
        block7: {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            BinaryExecutable it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String string = processName.substring(StringsKt.lastIndexOf$default((CharSequence)processName, (char)':', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String taskName = string;
            String string2 = processName.substring(0, StringsKt.lastIndexOf$default((CharSequence)processName, (char)':', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String projectPrefix = string2;
            boolean taskIsTest = StringsKt.endsWith$default((String)taskName, (String)"Test", (boolean)false, (int)2, null);
            boolean taskIsRun = StringsKt.startsWith$default((String)taskName, (String)"run", (boolean)false, (int)2, null);
            Function1 execFilter = arg_0 -> LLDBBackend.findDebugVariant$lambda$2(taskIsTest, taskName, taskIsRun, arg_0);
            Function1 variantFilter = arg_0 -> LLDBBackend.findDebugVariant$lambda$3(taskIsRun, taskName, taskIsTest, arg_0);
            Object $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WorkspaceBase> serviceClass$iv = WorkspaceBase.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            $this$service$iv = ((WorkspaceBase)object).getAllAvailableExecutables();
            boolean $i$f$filter = false;
            serviceClass$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BinaryExecutable)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)it.getProjectPrefix(), (String)projectPrefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BinaryExecutable)element$iv$iv;
                boolean bl = false;
                if (!((Boolean)execFilter.invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$filterIsInstanceTo$iv$iv;
                it = (BinaryExecutable)element$iv$iv;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv = it.getVariants();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv2 instanceof BinaryExecutable.Variant.Debug)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List variants = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = variants;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BinaryExecutable.Variant.Debug it2 = (BinaryExecutable.Variant.Debug)element$iv;
                boolean bl = false;
                if (!((Boolean)variantFilter.invoke((Object)it2)).booleanValue()) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        BinaryExecutable.Variant.Debug debug = v3;
        if (debug == null) {
            Object[] objectArray = new Object[]{processName};
            throw new ExecutionException(KonanDebugBundle.message("error.message.no.executable.for.processname", objectArray));
        }
        return debug;
    }

    private static final boolean findDebugVariant$lambda$2(boolean $taskIsTest, String $taskName, boolean $taskIsRun, BinaryExecutable exec) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        if ($taskIsTest) {
            String targetId = StringsKt.removeSuffix((String)$taskName, (CharSequence)"Test");
            bl = StringsKt.contains$default((CharSequence)exec.getTargetName(), (CharSequence)targetId, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)exec.getName(), (CharSequence)"test", (boolean)false, (int)2, null);
        } else {
            bl = $taskIsRun;
        }
        return bl;
    }

    private static final boolean findDebugVariant$lambda$3(boolean $taskIsRun, String $taskName, boolean $taskIsTest, BinaryExecutable.Variant variant) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if ($taskIsRun) {
            String executableId = StringsKt.removePrefix((String)$taskName, (CharSequence)"run");
            bl = StringsKt.contains$default((CharSequence)variant.getGradleTask(), (CharSequence)executableId, (boolean)false, (int)2, null);
        } else {
            bl = $taskIsTest;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/LLDBBackend$Companion;", "", "<init>", "()V", "ID", "", "DEBUG_SERVER_PATH_KEY", "DEBUG_SERVER_ARGS_KEY", "PROJECT_PATH_KEY", "ATTACH_BY_NAME_KEY", "kotlin-ultimate.native-debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

