/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J?\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001eR\u0018\u0010\u0014\u001a\u00020\u0011*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)V", "getSubclassOptInApplicabilityAndMessage", "Lkotlin/Pair;", "", "", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "representation", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "getRepresentation", "(Lorg/jetbrains/kotlin/descriptors/ClassKind;)Ljava/lang/String;", "checkOptInArgumentIsMarker", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInAnnotationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,122:1\n46#2:123\n1878#3,3:124\n64#4:127\n71#4:128\n*S KotlinDebug\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n*L\n44#1:123\n67#1:124,3\n84#1:127\n87#1:128\n*E\n"})
public final class FirOptInAnnotationCallChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirOptInAnnotationCallChecker INSTANCE = new FirOptInAnnotationCallChecker();

    private FirOptInAnnotationCallChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirAnnotationCall expression) {
        block12: {
            boolean isSubclassOptIn;
            ClassId classId;
            block11: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ConeClassLikeLookupTag coneClassLikeLookupTag = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(FirTypeUtilsKt.getConeType(expression.getAnnotationTypeRef()));
                if (coneClassLikeLookupTag == null) {
                    return;
                }
                ConeClassLikeLookupTag lookupTag = coneClassLikeLookupTag;
                classId = lookupTag.getClassId();
                boolean isRequiresOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID());
                boolean isOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID());
                isSubclassOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID());
                if (!isRequiresOptIn && !isOptIn) break block11;
                if (!isOptIn) break block12;
                Object $this$arguments$iv = expression;
                boolean $i$f$getArguments222 = false;
                List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments2.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getOPT_IN_WITHOUT_ARGUMENTS(), null, (int)8, null);
                } else {
                    FirExpression $i$f$getArguments222 = FirAnnotationUtilsKt.findArgumentByName$default(expression, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
                    List list2 = $i$f$getArguments222 != null ? FirAnnotationHelpersKt.extractClassesFromArgument($i$f$getArguments222, context.getSession()) : null;
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    $this$arguments$iv = ((Iterable)list2).iterator();
                    int $i$f$getArguments222 = 0;
                    while ($this$arguments$iv.hasNext()) {
                        int index2 = $i$f$getArguments222++;
                        FirRegularClassSymbol classSymbol = (FirRegularClassSymbol)$this$arguments$iv.next();
                        KtSourceElement source = FirOptInUsageBaseChecker.INSTANCE.getSourceForIsMarkerDiagnostic(expression, index2);
                        this.checkOptInArgumentIsMarker(reporter, context, classSymbol, classId, source);
                    }
                }
                break block12;
            }
            if (isSubclassOptIn) {
                FirClassSymbol declaration;
                Pair<Boolean, String> $this$arguments$iv = CollectionsKt.lastOrNull(context.getContainingDeclarations());
                FirClassSymbol firClassSymbol = declaration = $this$arguments$iv instanceof FirClassSymbol ? (FirClassSymbol)$this$arguments$iv : null;
                if (declaration != null) {
                    $this$arguments$iv = this.getSubclassOptInApplicabilityAndMessage(declaration);
                    boolean isSubclassOptInApplicable = (Boolean)$this$arguments$iv.component1();
                    String message2 = (String)$this$arguments$iv.component2();
                    if (!isSubclassOptInApplicable && message2 != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)message2, null, (int)16, null);
                        return;
                    }
                }
                FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(expression, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
                List list3 = firExpression != null ? FirAnnotationHelpersKt.extractClassesFromArgument(firExpression, context.getSession()) : null;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List classSymbols = list3;
                Iterable $this$forEachIndexed$iv = classSymbols;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void classSymbol;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)item$iv;
                    int index3 = n;
                    boolean bl = false;
                    KtSourceElement source = FirOptInUsageBaseChecker.INSTANCE.getSourceForIsMarkerDiagnostic(expression, index3);
                    INSTANCE.checkOptInArgumentIsMarker(reporter, context, (FirRegularClassSymbol)classSymbol, classId, source);
                }
            }
        }
    }

    @NotNull
    public final Pair<Boolean, String> getSubclassOptInApplicabilityAndMessage(@NotNull FirClassSymbol<?> classSymbol) {
        Intrinsics.checkNotNullParameter(classSymbol, (String)"classSymbol");
        ClassKind kind2 = classSymbol.getClassKind();
        String classKindRepresentation = this.getRepresentation(kind2);
        if (kind2 == ClassKind.ENUM_CLASS || kind2 == ClassKind.OBJECT || kind2 == ClassKind.ANNOTATION_CLASS) {
            return TuplesKt.to((Object)false, (Object)classKindRepresentation);
        }
        Modality modality2 = FirHelpersKt.modality(classSymbol);
        if (modality2 == Modality.FINAL || modality2 == Modality.SEALED) {
            Boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string = modality2.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return TuplesKt.to((Object)bl, (Object)stringBuilder.append(string).append(' ').append(classKindRepresentation).toString());
        }
        FirClassLikeSymbol $this$isFun$iv = classSymbol;
        boolean $i$f$isFun = false;
        if ($this$isFun$iv.getRawStatus().isFun()) {
            return TuplesKt.to((Object)false, (Object)"fun interface");
        }
        FirClassLikeSymbol $this$isLocal$iv = classSymbol;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getClassId().isLocal()) {
            return TuplesKt.to((Object)false, (Object)("local " + classKindRepresentation));
        }
        return TuplesKt.to((Object)true, null);
    }

    private final String getRepresentation(ClassKind $this$representation) {
        String string;
        if (WhenMappings.$EnumSwitchMapping$0[$this$representation.ordinal()] == 1) {
            string = "enum entry";
        } else {
            String string2 = $this$representation.getCodeRepresentation();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    private final void checkOptInArgumentIsMarker(DiagnosticReporter reporter, CheckerContext context, FirRegularClassSymbol classSymbol, ClassId annotationClassId, KtSourceElement source) {
        FirOptInUsageBaseChecker $this$checkOptInArgumentIsMarker_u24lambda_u241 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if ($this$checkOptInArgumentIsMarker_u24lambda_u241.loadExperimentalityForMarkerAnnotation(classSymbol, context.getSession()) == null) {
            KtDiagnosticFactory1<ClassId> ktDiagnosticFactory1;
            ClassId classId = annotationClassId;
            if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                ktDiagnosticFactory1 = FirErrors.INSTANCE.getOPT_IN_ARGUMENT_IS_NOT_MARKER();
            } else if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID())) {
                ktDiagnosticFactory1 = FirErrors.INSTANCE.getSUBCLASS_OPT_IN_ARGUMENT_IS_NOT_MARKER();
            } else {
                return;
            }
            KtDiagnosticFactory1<ClassId> diagnostic = ktDiagnosticFactory1;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), diagnostic, (Object)classSymbol.getClassId(), null, (int)16, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

