/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal.refactoringTesting;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.CompilationStatusTracker;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.MoveRefactoringUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/CompilationStatusTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "compilationStatusListener", "org/jetbrains/kotlin/idea/actions/internal/refactoringTesting/CompilationStatusTracker$compilationStatusListener$1", "Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/CompilationStatusTracker$compilationStatusListener$1;", "runBuildAction", "Lkotlin/Function0;", "", "getRunBuildAction", "()Lkotlin/jvm/functions/Function0;", "runBuildAction$delegate", "Lkotlin/Lazy;", "checkByBuild", "", "cancelledChecker", "kotlin.idea"})
public final class CompilationStatusTracker {
    @NotNull
    private final Project project;
    @NotNull
    private final compilationStatusListener.1 compilationStatusListener;
    @NotNull
    private final Lazy runBuildAction$delegate;

    public CompilationStatusTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.compilationStatusListener = new CompilationStatusListener(this){
            private boolean hasCompilerError;
            private boolean compilationFinished;
            {
                KotlinPluginDisposable disposable = KotlinPluginDisposable.Companion.getInstance(CompilationStatusTracker.access$getProject$p($receiver));
                MessageBusConnection messageBusConnection = CompilationStatusTracker.access$getProject$p($receiver).getMessageBus().connect((Disposable)disposable);
                Topic topic = CompilerTopics.COMPILATION_STATUS;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"COMPILATION_STATUS");
                messageBusConnection.subscribe(topic, (Object)this);
            }

            public final boolean getHasCompilerError() {
                return this.hasCompilerError;
            }

            public final boolean getCompilationFinished() {
                return this.compilationFinished;
            }

            public final void reset() {
                this.compilationFinished = false;
                this.hasCompilerError = false;
            }

            public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                Intrinsics.checkNotNullParameter((Object)compileContext, (String)"compileContext");
                this.hasCompilerError = this.hasCompilerError || aborted || errors != 0;
                this.compilationFinished = true;
            }
        };
        this.runBuildAction$delegate = MoveRefactoringUtilsKt.lazyPub(CompilationStatusTracker::runBuildAction_delegate$lambda$1);
    }

    private final Function0<Unit> getRunBuildAction() {
        Lazy lazy = this.runBuildAction$delegate;
        return (Function0)lazy.getValue();
    }

    public final boolean checkByBuild(@NotNull Function0<Boolean> cancelledChecker) {
        Intrinsics.checkNotNullParameter(cancelledChecker, (String)"cancelledChecker");
        this.compilationStatusListener.reset();
        ApplicationManager.getApplication().invokeAndWait(() -> CompilationStatusTracker.checkByBuild$lambda$2(this));
        while (!((Boolean)cancelledChecker.invoke()).booleanValue() && !this.compilationStatusListener.getCompilationFinished()) {
            Thread.yield();
        }
        return !this.compilationStatusListener.getHasCompilerError();
    }

    private static final Unit runBuildAction_delegate$lambda$1$lambda$0(AnAction $action, AnActionEvent $event) {
        $action.actionPerformed($event);
        return Unit.INSTANCE;
    }

    private static final Function0 runBuildAction_delegate$lambda$1() {
        ActionManager am = ActionManager.getInstance();
        AnAction action2 = am.getAction("CompileProject");
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), "unknown", new Presentation(), ActionManager.getInstance(), 0);
        return () -> CompilationStatusTracker.runBuildAction_delegate$lambda$1$lambda$0(action2, event);
    }

    private static final void checkByBuild$lambda$2(CompilationStatusTracker this$0) {
        this$0.getRunBuildAction().invoke();
    }

    public static final /* synthetic */ Project access$getProject$p(CompilationStatusTracker $this) {
        return $this.project;
    }
}

