/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines.CoroutinesIds;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines.PreferCurrentCoroutineContextToCoroutineContextInspectionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\u00020\u00132\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\u00020\u0011*\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0011*\u00020\u0013H\u0002J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/coroutines/PreferCurrentCoroutineContextToCoroutineContextInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "<init>", "()V", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/Unit;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lkotlin/Unit;", "isCoroutineContextFunctionAccess", "reference", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "isCurrentCoroutineContextFunctionPresent", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "kotlin.code-insight.inspections.shared"})
public final class PreferCurrentCoroutineContextToCoroutineContextInspection
extends KotlinApplicableInspectionBase.Simple<KtExpression, Unit> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtExpression element, @NotNull Unit context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return KotlinBundle.message((String)"inspection.prefer.current.coroutine.context.to.coroutine.context.inspection.description", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.expressionVisitor(arg_0 -> PreferCurrentCoroutineContextToCoroutineContextInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtExpression element) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression2 = element;
        Object object = ktExpression2 instanceof KtNameReferenceExpression && KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element)) == null ? (KtNameReferenceExpression)element : (ktExpression2 instanceof KtDotQualifiedExpression ? ((ktExpression = ((KtDotQualifiedExpression)element).getSelectorExpression()) instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null) : null);
        if (object == null) {
            return null;
        }
        KtNameReferenceExpression nameReferenceExpression = object;
        if (!this.isCoroutineContextFunctionAccess($this$prepareContext, nameReferenceExpression)) {
            return null;
        }
        if (!this.isCurrentCoroutineContextFunctionPresent($this$prepareContext)) {
            return null;
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCoroutineContextFunctionAccess(KaSession $this$isCoroutineContextFunctionAccess, KtNameReferenceExpression reference) {
        if (!Intrinsics.areEqual((Object)reference.getReferencedNameAsName(), (Object)PreferCurrentCoroutineContextToCoroutineContextInspectionKt.access$getKOTLIN_COROUTINES_CONTEXT_ID$p().getCallableName())) return false;
        KaSymbol kaSymbol = $this$isCoroutineContextFunctionAccess.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)reference)));
        KaPropertySymbol kaPropertySymbol = kaSymbol instanceof KaPropertySymbol ? (KaPropertySymbol)kaSymbol : null;
        if (!Intrinsics.areEqual((Object)(kaPropertySymbol != null ? kaPropertySymbol.getCallableId() : null), (Object)PreferCurrentCoroutineContextToCoroutineContextInspectionKt.access$getKOTLIN_COROUTINES_CONTEXT_ID$p())) return false;
        return true;
    }

    private final boolean isCurrentCoroutineContextFunctionPresent(KaSession $this$isCurrentCoroutineContextFunctionPresent) {
        Sequence<KaCallableSymbol> foundSymbols = $this$isCurrentCoroutineContextFunctionPresent.findTopLevelCallables(CoroutinesIds.INSTANCE.getCURRENT_COROUTINE_CONTEXT_ID().getPackageName(), CoroutinesIds.INSTANCE.getCURRENT_COROUTINE_CONTEXT_ID().getCallableName());
        return SequencesKt.any(foundSymbols);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtExpression> createQuickFix(@NotNull KtExpression element, @NotNull Unit context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new KotlinModCommandQuickFix<KtExpression>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"inspection.prefer.current.coroutine.context.to.coroutine.context.inspection.fix", (Object[])new Object[0]);
            }

            /*
             * WARNING - void declaration
             */
            protected void applyFix(Project project, KtExpression element, ModPsiUpdater updater2) {
                PsiElement psiElement;
                void $this$replaced$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KtExpression currentCoroutineContextCall = new KtPsiFactory(project, false, 2, null).createExpression(CoroutinesIds.INSTANCE.getCURRENT_COROUTINE_CONTEXT_ID().asSingleFqName() + "()");
                PsiElement psiElement2 = (PsiElement)element;
                PsiElement newElement$iv = (PsiElement)currentCoroutineContextCall;
                boolean $i$f$replaced = false;
                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                    psiElement = newElement$iv;
                } else {
                    PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                    if (result$iv instanceof KtExpression) {
                        psiElement = result$iv;
                    } else {
                        Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                        if (ktExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                        psiElement = (PsiElement)ktExpression;
                    }
                }
                KtExpression replaced = (KtExpression)psiElement;
                ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)replaced);
            }
        };
    }

    private static final Unit buildVisitor$lambda$0(PreferCurrentCoroutineContextToCoroutineContextInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this$0.visitTargetElement((KtElement)expression, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }
}

