/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.debugger.impl.DexDebugFacility;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.sun.jdi.Method;
import com.sun.jdi.VirtualMachine;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.MethodBytecodeVerifier;
import org.jetbrains.kotlin.idea.debugger.base.util.MethodBytecodeVerifierFromArray;
import org.jetbrains.kotlin.idea.debugger.base.util.MethodBytecodeVerifierWithReturnOpcode;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0010H\u0002\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"isSimpleGetter", "", "Lcom/sun/jdi/Method;", "isLateinitVariableGetter", "isOldBackendLateinitVariableGetter", "isIRBackendLateinitVariableGetterReturningAny", "isIRBackendLateinitVariableGetter", "commonLateinitVarPropertyBytecodes", "", "lateinitVarReturningAnyBytecodes", "lateinitVarPropertyBytecodes", "isSimpleStaticVariableGetter", "isSimpleMemberVariableGetter", "isJVMStaticVariableGetter", "verifyMethod", "expectedNumOfBytecodes", "", "opcodes", "methodBytecodeVerifier", "Lorg/jetbrains/kotlin/idea/debugger/base/util/MethodBytecodeVerifier;", "isReturnOpcode", "kotlin.jvm-debugger.base.util"})
public final class KotlinMethodBytecodeInfoKt {
    @NotNull
    private static final int[] commonLateinitVarPropertyBytecodes;
    @NotNull
    private static final int[] lateinitVarReturningAnyBytecodes;
    @NotNull
    private static final int[] lateinitVarPropertyBytecodes;

    public static final boolean isSimpleGetter(@NotNull Method $this$isSimpleGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isSimpleGetter, (String)"<this>");
        VirtualMachine virtualMachine = $this$isSimpleGetter.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return false;
        }
        return KotlinMethodBytecodeInfoKt.isSimpleMemberVariableGetter($this$isSimpleGetter) || KotlinMethodBytecodeInfoKt.isSimpleStaticVariableGetter($this$isSimpleGetter) || KotlinMethodBytecodeInfoKt.isJVMStaticVariableGetter($this$isSimpleGetter);
    }

    public static final boolean isLateinitVariableGetter(@NotNull Method $this$isLateinitVariableGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isLateinitVariableGetter, (String)"<this>");
        VirtualMachine virtualMachine = $this$isLateinitVariableGetter.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return false;
        }
        return KotlinMethodBytecodeInfoKt.isOldBackendLateinitVariableGetter($this$isLateinitVariableGetter) || KotlinMethodBytecodeInfoKt.isIRBackendLateinitVariableGetter($this$isLateinitVariableGetter) || KotlinMethodBytecodeInfoKt.isIRBackendLateinitVariableGetterReturningAny($this$isLateinitVariableGetter);
    }

    public static final boolean isOldBackendLateinitVariableGetter(@NotNull Method $this$isOldBackendLateinitVariableGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isOldBackendLateinitVariableGetter, (String)"<this>");
        VirtualMachine virtualMachine = $this$isOldBackendLateinitVariableGetter.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return false;
        }
        int[] nArray = new int[]{25, 180, 89, 199, 18, 184};
        return KotlinMethodBytecodeInfoKt.verifyMethod($this$isOldBackendLateinitVariableGetter, 14, nArray);
    }

    public static final boolean isIRBackendLateinitVariableGetterReturningAny(@NotNull Method $this$isIRBackendLateinitVariableGetterReturningAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isIRBackendLateinitVariableGetterReturningAny, (String)"<this>");
        VirtualMachine virtualMachine = $this$isIRBackendLateinitVariableGetterReturningAny.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return false;
        }
        return KotlinMethodBytecodeInfoKt.verifyMethod($this$isIRBackendLateinitVariableGetterReturningAny, 19, new MethodBytecodeVerifierFromArray(lateinitVarReturningAnyBytecodes));
    }

    public static final boolean isIRBackendLateinitVariableGetter(@NotNull Method $this$isIRBackendLateinitVariableGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isIRBackendLateinitVariableGetter, (String)"<this>");
        VirtualMachine virtualMachine = $this$isIRBackendLateinitVariableGetter.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return false;
        }
        return KotlinMethodBytecodeInfoKt.verifyMethod($this$isIRBackendLateinitVariableGetter, 17, new MethodBytecodeVerifierFromArray(lateinitVarPropertyBytecodes));
    }

    private static final boolean isSimpleStaticVariableGetter(Method $this$isSimpleStaticVariableGetter) {
        int[] nArray = new int[]{178};
        return KotlinMethodBytecodeInfoKt.verifyMethod($this$isSimpleStaticVariableGetter, 4, nArray);
    }

    private static final boolean isSimpleMemberVariableGetter(Method $this$isSimpleMemberVariableGetter) {
        int[] nArray = new int[]{25, 180};
        return KotlinMethodBytecodeInfoKt.verifyMethod($this$isSimpleMemberVariableGetter, 5, nArray);
    }

    private static final boolean isJVMStaticVariableGetter(Method $this$isJVMStaticVariableGetter) {
        return KotlinMethodBytecodeInfoKt.verifyMethod($this$isJVMStaticVariableGetter, 7, new MethodBytecodeVerifier(){

            protected boolean verify(int opcode, int position) {
                return switch (position) {
                    case 0 -> {
                        if (opcode == 178) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (opcode == 178 || opcode == 182) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> KotlinMethodBytecodeInfoKt.access$isReturnOpcode(opcode);
                    default -> false;
                };
            }
        });
    }

    private static final boolean verifyMethod(Method $this$verifyMethod, int expectedNumOfBytecodes, int[] opcodes) {
        return KotlinMethodBytecodeInfoKt.verifyMethod($this$verifyMethod, expectedNumOfBytecodes, new MethodBytecodeVerifierWithReturnOpcode(opcodes));
    }

    private static final boolean verifyMethod(Method $this$verifyMethod, int expectedNumOfBytecodes, MethodBytecodeVerifier methodBytecodeVerifier) {
        if ($this$verifyMethod.bytecodes().length != expectedNumOfBytecodes) {
            return false;
        }
        MethodBytecodeUtil.visit((Method)$this$verifyMethod, (MethodVisitor)methodBytecodeVerifier, (boolean)false);
        return methodBytecodeVerifier.getResult();
    }

    private static final boolean isReturnOpcode(int $this$isReturnOpcode) {
        return 172 <= $this$isReturnOpcode ? $this$isReturnOpcode < 177 : false;
    }

    public static final /* synthetic */ boolean access$isReturnOpcode(int $receiver) {
        return KotlinMethodBytecodeInfoKt.isReturnOpcode($receiver);
    }

    static {
        int[] nArray = new int[]{25, 180, 89, 198, 176, 87, 18, 184};
        commonLateinitVarPropertyBytecodes = nArray;
        nArray = new int[]{178, 176};
        lateinitVarReturningAnyBytecodes = ArraysKt.plus((int[])commonLateinitVarPropertyBytecodes, (int[])nArray);
        nArray = new int[]{1, 176};
        lateinitVarPropertyBytecodes = ArraysKt.plus((int[])commonLateinitVarPropertyBytecodes, (int[])nArray);
    }
}

