/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.sun.jdi.Location;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculator;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinVariableNameFinder;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxysKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%*\u00020\u0019H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006(\u00b2\u0006\u0010\u0010)\u001a\b\u0012\u0004\u0012\u00020#0%X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrame;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "includeFrameVariables", "", "location", "Lcom/sun/jdi/Location;", "<init>", "(Lcom/intellij/debugger/jdi/StackFrameProxyImpl;Lcom/intellij/xdebugger/XSourcePosition;Ljava/util/List;ZLcom/sun/jdi/Location;)V", "equals", "other", "", "hashCode", "", "buildVariablesThreadAction", "", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "children", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "addOptimisedVariables", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "createOptimisedVariableMessageNode", "Lcom/intellij/xdebugger/frame/XNamedValue;", "kotlin.jvm.PlatformType", "name", "", "getUniqueNames", "", "findVisibleVariableNames", "getSourcePosition", "kotlin.jvm-debugger.coroutines", "visibleVariableNames"})
public class CoroutineStackFrame
extends KotlinStackFrame {
    @Nullable
    private final XSourcePosition position;
    @NotNull
    private final List<JavaValue> spilledVariables;
    private final boolean includeFrameVariables;

    public CoroutineStackFrame(@NotNull StackFrameProxyImpl frame, @Nullable XSourcePosition position, @NotNull List<? extends JavaValue> spilledVariables, boolean includeFrameVariables, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(spilledVariables, (String)"spilledVariables");
        super(CoroutineStackFrameProxysKt.safeCoroutineStackFrameProxy(location, spilledVariables, frame), spilledVariables.isEmpty() || includeFrameVariables ? InlineStackTraceCalculator.INSTANCE.calculateVisibleVariables(frame) : CollectionsKt.emptyList());
        this.position = position;
        this.spilledVariables = spilledVariables;
        this.includeFrameVariables = includeFrameVariables;
        this.getDescriptor().updateRepresentation(null, DescriptorLabelListener.DUMMY_LISTENER);
    }

    public /* synthetic */ CoroutineStackFrame(StackFrameProxyImpl stackFrameProxyImpl, XSourcePosition xSourcePosition, List list2, boolean bl, Location location, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            location = SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl);
        }
        this(stackFrameProxyImpl, xSourcePosition, list2, bl, location);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        JavaStackFrame javaStackFrame = other instanceof JavaStackFrame ? (JavaStackFrame)other : null;
        if (javaStackFrame == null) {
            return false;
        }
        JavaStackFrame frame = javaStackFrame;
        return Intrinsics.areEqual((Object)this.getDescriptor().getFrameProxy(), (Object)frame.getDescriptor().getFrameProxy());
    }

    public int hashCode() {
        return this.getDescriptor().getFrameProxy().hashCode();
    }

    protected void buildVariablesThreadAction(@NotNull DebuggerContextImpl debuggerContext, @NotNull XValueChildrenList children, @NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)debuggerContext, (String)"debuggerContext");
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.includeFrameVariables || this.spilledVariables.isEmpty()) {
            super.buildVariablesThreadAction(debuggerContext, children, node);
            DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            DebugProcessImpl debugProcess = debugProcessImpl;
            this.addOptimisedVariables(debugProcess, children);
        } else {
            for (JavaValue variable : this.spilledVariables) {
                children.add((XNamedValue)variable);
            }
        }
    }

    private final void addOptimisedVariables(DebugProcessImpl debugProcess, XValueChildrenList children) {
        Lazy visibleVariableNames$delegate = LazyKt.lazy(() -> CoroutineStackFrame.addOptimisedVariables$lambda$0(this, children));
        for (JavaValue variable : this.spilledVariables) {
            String name2;
            Intrinsics.checkNotNullExpressionValue((Object)variable.getName(), (String)"getName(...)");
            if (CoroutineStackFrame.addOptimisedVariables$lambda$1((Lazy<? extends Set<String>>)visibleVariableNames$delegate).contains(name2)) continue;
            children.add((XNamedValue)variable);
            CoroutineStackFrame.addOptimisedVariables$lambda$1((Lazy<? extends Set<String>>)visibleVariableNames$delegate).add(name2);
        }
        List<String> declaredVariableNames = this.findVisibleVariableNames(debugProcess);
        for (String name2 : declaredVariableNames) {
            if (CoroutineStackFrame.addOptimisedVariables$lambda$1((Lazy<? extends Set<String>>)visibleVariableNames$delegate).contains(name2)) continue;
            children.add(this.createOptimisedVariableMessageNode(name2));
        }
    }

    private final XNamedValue createOptimisedVariableMessageNode(String name2) {
        Object[] objectArray = new Object[]{"'" + name2 + "'"};
        return JavaStackFrame.createMessageNode((String)KotlinDebuggerCoroutinesBundle.message("optimised.variable.message", objectArray), (Icon)AllIcons.General.Information);
    }

    private final Set<String> getUniqueNames(XValueChildrenList $this$getUniqueNames) {
        Set names = new LinkedHashSet();
        int n = $this$getUniqueNames.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String string = $this$getUniqueNames.getName(i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            names.add(string);
        }
        return names;
    }

    private final List<String> findVisibleVariableNames(DebugProcessImpl debugProcess) {
        StackFrameProxyImpl stackFrameProxyImpl = this.getStackFrameProxy();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"getStackFrameProxy(...)");
        Location location = SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl);
        if (location == null) {
            return CollectionsKt.emptyList();
        }
        Location location2 = location;
        Object object = ReadAction.nonBlocking(() -> CoroutineStackFrame.findVisibleVariableNames$lambda$2(debugProcess, location2)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (List)object;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        XSourcePosition xSourcePosition = this.position;
        if (xSourcePosition == null) {
            xSourcePosition = super.getSourcePosition();
        }
        return xSourcePosition;
    }

    private static final Set addOptimisedVariables$lambda$0(CoroutineStackFrame this$0, XValueChildrenList $children) {
        return this$0.getUniqueNames($children);
    }

    private static final Set<String> addOptimisedVariables$lambda$1(Lazy<? extends Set<String>> $visibleVariableNames$delegate) {
        Lazy<? extends Set<String>> lazy = $visibleVariableNames$delegate;
        return (Set)lazy.getValue();
    }

    private static final List findVisibleVariableNames$lambda$2(DebugProcessImpl $debugProcess, Location $location) {
        return new KotlinVariableNameFinder($debugProcess).findVisibleVariableNames($location);
    }
}

