/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration.kpm;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmFragment;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmFragmentKt;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"calculateFragmentExternalModuleName", "", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "fragment", "Lorg/jetbrains/kotlin/gradle/idea/kpm/IdeaKpmFragment;", "calculateFragmentInternalModuleName", "externalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "resolverCtx", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "gradlePathToQualifiedName", "rootName", "gradlePath", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleSourceSetDataInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleSourceSetDataInitializer.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializerKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,157:1\n37#2:158\n36#2,3:159\n*S KotlinDebug\n*F\n+ 1 KotlinGradleSourceSetDataInitializer.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializerKt\n*L\n155#1:158\n155#1:159,3\n*E\n"})
public final class KotlinGradleSourceSetDataInitializerKt {
    private static final String calculateFragmentExternalModuleName(IdeaModule gradleModule, IdeaKpmFragment fragment) {
        return gradleModule.getName() + ":" + fragment.getCoordinates().getModule().getModuleName() + "." + IdeaKpmFragmentKt.getName((IdeaKpmFragment)fragment);
    }

    private static final String calculateFragmentInternalModuleName(IdeaModule gradleModule, ExternalProject externalProject, IdeaKpmFragment fragment, ProjectResolverContext resolverCtx) {
        String delimiter = null;
        StringBuilder moduleName = new StringBuilder();
        String buildSrcGroup = resolverCtx.getBuildSrcGroup();
        if (resolverCtx.isUseQualifiedModuleNames()) {
            delimiter = ".";
            if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                moduleName.append(buildSrcGroup).append(delimiter);
            }
            String string = gradleModule.getProject().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = externalProject.getQName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getQName(...)");
            v2 = moduleName.append(KotlinGradleSourceSetDataInitializerKt.gradlePathToQualifiedName(string, string2));
        } else {
            delimiter = "_";
            if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                moduleName.append(buildSrcGroup).append(delimiter);
            }
            v2 = moduleName.append(gradleModule.getName());
        }
        moduleName.append(delimiter);
        moduleName.append(fragment.getCoordinates().getModule().getModuleName() + "." + IdeaKpmFragmentKt.getName((IdeaKpmFragment)fragment));
        String string = PathUtilRt.suggestFileName((String)moduleName.toString(), (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestFileName(...)");
        return string;
    }

    private static final String gradlePathToQualifiedName(String rootName, String gradlePath) {
        CharSequence charSequence = gradlePath;
        Regex regex = new Regex(":");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (String)(StringsKt.startsWith$default((String)gradlePath, (String)":", (boolean)false, (int)2, null) ? rootName + "." : "") + Arrays.stream(thisCollection$iv.toArray(new String[0])).filter(arg_0 -> KotlinGradleSourceSetDataInitializerKt.gradlePathToQualifiedName$lambda$1(KotlinGradleSourceSetDataInitializerKt::gradlePathToQualifiedName$lambda$0, arg_0)).collect(Collectors.joining("."));
    }

    private static final boolean gradlePathToQualifiedName$lambda$0(String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return ((CharSequence)s).length() > 0;
    }

    private static final boolean gradlePathToQualifiedName$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$calculateFragmentExternalModuleName(IdeaModule gradleModule, IdeaKpmFragment fragment) {
        return KotlinGradleSourceSetDataInitializerKt.calculateFragmentExternalModuleName(gradleModule, fragment);
    }

    public static final /* synthetic */ String access$calculateFragmentInternalModuleName(IdeaModule gradleModule, ExternalProject externalProject, IdeaKpmFragment fragment, ProjectResolverContext resolverCtx) {
        return KotlinGradleSourceSetDataInitializerKt.calculateFragmentInternalModuleName(gradleModule, externalProject, fragment, resolverCtx);
    }
}

