/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.java;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmDefaultModeKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.load.java.structure.LightClassOriginKind;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J \u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0018\u0010\u0014\u001a\u00020\u000f*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/java/UnimplementedKotlinInterfaceMemberAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "findUnimplementedMethod", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "shouldBeImplemented", "", "method", "Lcom/intellij/psi/HierarchicalMethodSignature;", "signaturesVisibleThroughKotlinSuperClass", "", "isBinaryOrigin", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)Z", "report", "kotlin.core"})
@SourceDebugExtension(value={"SMAP\nUnimplementedKotlinInterfaceMemberAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnimplementedKotlinInterfaceMemberAnnotator.kt\norg/jetbrains/kotlin/idea/java/UnimplementedKotlinInterfaceMemberAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,88:1\n774#2:89\n865#2,2:90\n295#2,2:95\n58#3:92\n183#4,2:93\n12637#5,2:97\n*S KotlinDebug\n*F\n+ 1 UnimplementedKotlinInterfaceMemberAnnotator.kt\norg/jetbrains/kotlin/idea/java/UnimplementedKotlinInterfaceMemberAnnotator\n*L\n38#1:89\n38#1:90,2\n49#1:95,2\n43#1:92\n45#1:93,2\n62#1:97,2\n*E\n"})
public final class UnimplementedKotlinInterfaceMemberAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
            if (!(element instanceof PsiClass) || Intrinsics.areEqual((Object)((PsiClass)element).getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
                return;
            }
            if (((PsiClass)element).isInterface() || ((PsiClass)element).hasModifierProperty("abstract")) {
                return;
            }
            if (ClassUtil.getAnyMethodToImplement((PsiClass)((PsiClass)element)) != null) {
                return;
            }
            KtLightMethod ktLightMethod = this.findUnimplementedMethod((PsiClass)element);
            if (ktLightMethod == null) break block3;
            KtLightMethod it = ktLightMethod;
            boolean bl = false;
            this.report(it, holder2, (PsiClass)element);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightMethod findUnimplementedMethod(PsiClass psiClass) {
        Object v3;
        block6: {
            void $this$firstOrNull$iv;
            PsiClass kotlinSuperClass;
            Object object;
            Object v1;
            List signaturesFromKotlinInterfaces;
            block5: {
                void $this$filterTo$iv$iv;
                Collection collection = psiClass.getVisibleSignatures();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVisibleSignatures(...)");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PsiMethod method;
                    HierarchicalMethodSignature signature = (HierarchicalMethodSignature)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)signature.getMethod(), (String)"getMethod(...)");
                    if (!(method instanceof KtLightMethod && method.hasModifierProperty("default") && !method.hasModifierProperty("static"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection $this$ifEmpty$iv = (List)destination$iv$iv;
                boolean $i$f$ifEmpty = false;
                if ($this$ifEmpty$iv.isEmpty()) {
                    boolean bl = false;
                    return null;
                }
                signaturesFromKotlinInterfaces = (List)$this$ifEmpty$iv;
                Sequence $this$firstOrNull$iv2 = SequencesKt.generateSequence((Object)psiClass, UnimplementedKotlinInterfaceMemberAnnotator::findUnimplementedMethod$lambda$3);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv2) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl = false;
                    if (!(it instanceof KtLightClassForSourceDeclaration)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            if ((object = (kotlinSuperClass = (PsiClass)v1)) == null || (object = object.getVisibleSignatures()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object signaturesVisibleThroughKotlinSuperClass = object;
            Iterable element$iv = signaturesFromKotlinInterfaces;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                HierarchicalMethodSignature it = (HierarchicalMethodSignature)element$iv2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.shouldBeImplemented(it, (Collection<? extends HierarchicalMethodSignature>)signaturesVisibleThroughKotlinSuperClass)) continue;
                v3 = element$iv2;
                break block6;
            }
            v3 = null;
        }
        Iterator iterator2 = v3;
        PsiMethod psiMethod = iterator2 != null ? iterator2.getMethod() : null;
        return psiMethod instanceof KtLightMethod ? (KtLightMethod)psiMethod : null;
    }

    private final boolean shouldBeImplemented(HierarchicalMethodSignature method, Collection<? extends HierarchicalMethodSignature> signaturesVisibleThroughKotlinSuperClass) {
        boolean bl;
        PsiMethod psiMethod;
        block4: {
            if (signaturesVisibleThroughKotlinSuperClass.contains(method)) {
                return false;
            }
            PsiMethod psiMethod2 = method.getMethod();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"getMethod(...)");
            psiMethod = psiMethod2;
            if (this.isBinaryOrigin(psiMethod)) {
                return false;
            }
            PsiAnnotation[] psiAnnotationArray = psiMethod.getModifierList().getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
            Object[] $this$any$iv = psiAnnotationArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiAnnotation it = (PsiAnnotation)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)JvmStandardClassIds.INSTANCE.getJVM_STATIC_FQ_NAME().asString())) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        JvmDefaultMode jvmDefaultMode = JvmDefaultModeKt.getJvmDefaultMode((LanguageVersionSettings)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)psiMethod));
        return !jvmDefaultMode.isEnabled();
    }

    private final boolean isBinaryOrigin(PsiMethod $this$isBinaryOrigin) {
        PsiClass psiClass = $this$isBinaryOrigin.getContainingClass();
        KtLightClassMarker ktLightClassMarker = psiClass instanceof KtLightClassMarker ? (KtLightClassMarker)psiClass : null;
        return (ktLightClassMarker != null ? ktLightClassMarker.getOriginKind() : null) == LightClassOriginKind.BINARY;
    }

    private final void report(KtLightMethod method, AnnotationHolder holder2, PsiClass psiClass) {
        String key = psiClass instanceof PsiEnumConstantInitializer ? "enum.constant.should.implement.method" : "class.must.be.abstract";
        Object[] objectArray = new Object[]{HighlightNamesUtil.formatClass((PsiClass)psiClass, (boolean)false), JavaHighlightUtil.formatMethod((PsiMethod)((PsiMethod)method)), HighlightNamesUtil.formatClass((PsiClass)method.getContainingClass(), (boolean)false)};
        String string = JavaErrorBundle.message((String)key, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message2 = string;
        QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
        AnnotationBuilder annotationBuilder = holder2.newAnnotation(HighlightSeverity.ERROR, message2).range(HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)psiClass)).withFix((IntentionAction)quickFixFactory.createImplementMethodsFix(psiClass));
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"withFix(...)");
        AnnotationBuilder error = annotationBuilder;
        if (!(psiClass instanceof PsiAnonymousClass)) {
            PsiModifierList psiModifierList = psiClass.getModifierList();
            if (!(psiModifierList != null ? psiModifierList.hasExplicitModifier("final") : false)) {
                AnnotationBuilder annotationBuilder2 = error.withFix((IntentionAction)quickFixFactory.createModifierListFix((PsiModifierListOwner)psiClass, "abstract", true, false));
                Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder2, (String)"withFix(...)");
                error = annotationBuilder2;
            }
        }
        error.create();
    }

    private static final PsiClass findUnimplementedMethod$lambda$3(PsiClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuperClass();
    }
}

