/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaDeclarationContainerSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaNamedSymbol;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.MemberUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.ElementContext;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\"\u0018\u0010\t\u001a\u00020\n*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0018\u0010\f\u001a\u00020\n*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u000f"}, d2={"computeElementContext", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/ElementContext;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "retainNonOverridableMembers", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "callableMemberSymbols", "isOverridable", "", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)Z", "isFinalClass", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol;)Z", "kotlin.code-insight.fixes.k2"})
@SourceDebugExtension(value={"SMAP\nMakeOverriddenMemberOpenFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakeOverriddenMemberOpenFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/MakeOverriddenMemberOpenFixKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n774#2:101\n865#2,2:102\n*S KotlinDebug\n*F\n+ 1 MakeOverriddenMemberOpenFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/MakeOverriddenMemberOpenFixKt\n*L\n91#1:101\n91#1:102,2\n*E\n"})
public final class MakeOverriddenMemberOpenFixKt {
    private static final ElementContext computeElementContext(KaSession $this$computeElementContext, KtNamedDeclaration element) {
        List overriddenNonOverridableMembers = new ArrayList();
        List containingDeclarationNames = new ArrayList();
        KaDeclarationSymbol kaDeclarationSymbol = $this$computeElementContext.getSymbol((KtDeclaration)element);
        KaCallableSymbol kaCallableSymbol = kaDeclarationSymbol instanceof KaCallableSymbol ? (KaCallableSymbol)kaDeclarationSymbol : null;
        if (kaCallableSymbol == null) {
            return null;
        }
        KaCallableSymbol symbol = kaCallableSymbol;
        List allOverriddenSymbols = SequencesKt.toList($this$computeElementContext.getAllOverriddenSymbols(symbol));
        for (KaCallableSymbol overriddenSymbol : MakeOverriddenMemberOpenFixKt.retainNonOverridableMembers(allOverriddenSymbols)) {
            String containingDeclarationName;
            KaDeclarationSymbol containingSymbol;
            PsiElement overriddenMember;
            block6: {
                block5: {
                    overriddenMember = overriddenSymbol.getPsi();
                    containingSymbol = $this$computeElementContext.getContainingDeclaration(overriddenSymbol);
                    if (overriddenMember == null || !(overriddenMember instanceof KtCallableDeclaration) || !KotlinCommonRefactoringUtilKt.canRefactorElement(overriddenMember) || !(containingSymbol instanceof KaNamedSymbol)) break block5;
                    KtModifierList ktModifierList = ((KtCallableDeclaration)overriddenMember).getModifierList();
                    boolean bl = ktModifierList != null ? ktModifierList.hasModifier(KtTokens.OPEN_KEYWORD) : false;
                    if (!bl) break block6;
                }
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((KaNamedSymbol)((Object)containingSymbol)).getName().asString(), (String)"asString(...)");
            overriddenNonOverridableMembers.add(SmartPointersKt.createSmartPointer((PsiElement)overriddenMember));
            containingDeclarationNames.add(containingDeclarationName);
        }
        return new ElementContext(overriddenNonOverridableMembers, containingDeclarationNames);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KaCallableSymbol> retainNonOverridableMembers(Collection<? extends KaCallableSymbol> callableMemberSymbols) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = callableMemberSymbols;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KaCallableSymbol it = (KaCallableSymbol)element$iv$iv;
            boolean bl = false;
            if (!(!MakeOverriddenMemberOpenFixKt.isOverridable(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isOverridable(KaCallableSymbol $this$isOverridable) {
        if ($this$isOverridable.getModality() == KaSymbolModality.FINAL) return false;
        if ($this$isOverridable.getVisibility() == KaSymbolVisibility.PRIVATE) return false;
        KaDeclarationContainerSymbol kaDeclarationContainerSymbol = MemberUtilsKt.getSymbolContainingMemberDeclarations($this$isOverridable);
        if (!(kaDeclarationContainerSymbol instanceof KaNamedClassSymbol)) return true;
        KaNamedClassSymbol kaNamedClassSymbol = (KaNamedClassSymbol)kaDeclarationContainerSymbol;
        if (kaNamedClassSymbol == null) return true;
        if (!MakeOverriddenMemberOpenFixKt.isFinalClass(kaNamedClassSymbol)) return true;
        return false;
    }

    private static final boolean isFinalClass(KaNamedClassSymbol $this$isFinalClass) {
        return $this$isFinalClass.getModality() == KaSymbolModality.FINAL && $this$isFinalClass.getClassKind() != KaClassKind.ENUM_CLASS;
    }

    public static final /* synthetic */ ElementContext access$computeElementContext(KaSession $receiver, KtNamedDeclaration element) {
        return MakeOverriddenMemberOpenFixKt.computeElementContext($receiver, element);
    }
}

