/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionInfo;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinImportQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.AutoImportVariant;
import org.jetbrains.kotlin.idea.quickfix.ImportFixHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0094\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H$R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportLikeQuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinImportQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "importVariants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)V", "getImportVariants", "()Ljava/util/List;", "modificationCountOnCreate", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "createImportAction", "Lcom/intellij/codeInsight/hint/QuestionAction;", "isAvailable", "", "isClassDefinitelyPositivelyImportedAlready", "containingFile", "classQualifiedName", "Lorg/jetbrains/kotlin/name/FqName;", "fix", "importVariant", "ImportQuestionAction", "kotlin.code-insight.fixes.k2"})
@ApiStatus.Internal
public abstract class ImportLikeQuickFix
extends KotlinImportQuickFixAction<KtElement> {
    @NotNull
    private final List<AutoImportVariant> importVariants;
    private final long modificationCountOnCreate;

    public ImportLikeQuickFix(@NotNull KtElement element, @NotNull List<? extends AutoImportVariant> importVariants) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(importVariants, (String)"importVariants");
        super(element);
        this.importVariants = importVariants;
        this.modificationCountOnCreate = PsiModificationTracker.getInstance((Project)element.getProject()).getModificationCount();
        if (!(!((Collection)this.importVariants).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    protected final List<AutoImportVariant> getImportVariants() {
        return this.importVariants;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (editor == null) {
                return;
            }
            QuestionAction questionAction = this.createImportAction(editor, file);
            if (questionAction == null) break block1;
            questionAction.execute();
        }
    }

    @Override
    @Nullable
    public QuestionAction createImportAction(@NotNull Editor editor, @NotNull KtFile file) {
        QuestionAction questionAction;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.getElement() != null) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            questionAction = new ImportQuestionAction(this, project, editor, file, this.importVariants, false, 16, null);
        } else {
            questionAction = null;
        }
        return questionAction;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.modificationCountOnCreate == PsiModificationTracker.getInstance((Project)project).getModificationCount()) {
            return true;
        }
        AutoImportVariant autoImportVariant = (AutoImportVariant)CollectionsKt.firstOrNull(this.importVariants);
        FqName fqName2 = autoImportVariant != null ? autoImportVariant.getFqName() : null;
        return fqName2 == null || !this.isClassDefinitelyPositivelyImportedAlready(file, fqName2);
    }

    protected boolean isClassDefinitelyPositivelyImportedAlready(@NotNull KtFile containingFile, @NotNull FqName classQualifiedName) {
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter((Object)classQualifiedName, (String)"classQualifiedName");
        return false;
    }

    protected abstract void fix(@NotNull AutoImportVariant var1, @NotNull KtFile var2, @NotNull Project var3);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportLikeQuickFix$ImportQuestionAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "importVariants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "onTheFly", "", "<init>", "(Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportLikeQuickFix;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFile;Ljava/util/List;Z)V", "execute", "kotlin.code-insight.fixes.k2"})
    protected final class ImportQuestionAction
    implements QuestionAction {
        @NotNull
        private final Project project;
        @NotNull
        private final Editor editor;
        @NotNull
        private final KtFile file;
        @NotNull
        private final List<AutoImportVariant> importVariants;
        private final boolean onTheFly;
        final /* synthetic */ ImportLikeQuickFix this$0;

        public ImportQuestionAction(@NotNull ImportLikeQuickFix this$0, @NotNull Project project, @NotNull Editor editor, @NotNull KtFile file, List<? extends AutoImportVariant> importVariants, boolean onTheFly) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(importVariants, (String)"importVariants");
            this.this$0 = this$0;
            this.project = project;
            this.editor = editor;
            this.file = file;
            this.importVariants = importVariants;
            this.onTheFly = onTheFly;
            if (!(!((Collection)this.importVariants).isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ ImportQuestionAction(ImportLikeQuickFix importLikeQuickFix, Project project, Editor editor, KtFile ktFile2, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(importLikeQuickFix, project, editor, ktFile2, list2, bl);
        }

        public boolean execute() {
            KotlinAddImportActionInfo.ExecuteListener executeListener = KotlinAddImportActionInfo.INSTANCE.getExecuteListener((PsiFile)this.file);
            if (executeListener != null) {
                executeListener.onExecute(this.importVariants);
            }
            switch (this.importVariants.size()) {
                case 1: {
                    this.this$0.fix((AutoImportVariant)CollectionsKt.single(this.importVariants), this.file, this.project);
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            if (this.onTheFly) {
                return false;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.this$0.fix((AutoImportVariant)CollectionsKt.first(this.importVariants), this.file, this.project);
                return true;
            }
            ImportFixHelper.INSTANCE.createListPopupWithImportVariants(this.project, this.importVariants, (Function1<? super AutoImportVariant, Unit>)((Function1)arg_0 -> ImportQuestionAction.execute$lambda$0(this.this$0, this, arg_0))).showInBestPositionFor(this.editor);
            return true;
        }

        private static final Unit execute$lambda$0(ImportLikeQuickFix this$0, ImportQuestionAction this$1, AutoImportVariant variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            this$0.fix(variant, this$1.file, this$1.project);
            return Unit.INSTANCE;
        }
    }
}

