/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven;

import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/MavenKotlinBuildSystemDependencyManager;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "findPomFile", "Lcom/intellij/psi/xml/XmlFile;", "addDependency", "", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "getBuildScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isProjectSyncPending", "isProjectSyncInProgress", "startProjectSync", "kotlin.maven"})
public final class MavenKotlinBuildSystemDependencyManager
implements KotlinBuildSystemDependencyManager {
    @NotNull
    private final Project project;

    public MavenKotlinBuildSystemDependencyManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ProjectStructureUtils.isMavenModule(module);
    }

    private final XmlFile findPomFile(Module module) {
        PsiFile psiFile = KotlinMavenConfigurator.Companion.findModulePomFile(module);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Override
    public void addDependency(@NotNull Module module, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptor, (String)"libraryDescriptor");
        XmlFile xmlFile = this.findPomFile(module);
        if (xmlFile == null) {
            return;
        }
        XmlFile pomFile = xmlFile;
        PomFile pomFile2 = PomFile.Companion.forFileOrNull(pomFile);
        if (pomFile2 == null) {
            return;
        }
        PomFile pom = pomFile2;
        String string = libraryDescriptor.getPreferredVersion();
        if (string == null && (string = libraryDescriptor.getMaxVersion()) == null) {
            string = libraryDescriptor.getMinVersion();
        }
        String version = string;
        MavenId mavenId = new MavenId(libraryDescriptor.getLibraryGroupId(), libraryDescriptor.getLibraryArtifactId(), version);
        DependencyScope dependencyScope = libraryDescriptor.getPreferredScope();
        MavenArtifactScope scope = switch (dependencyScope == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dependencyScope.ordinal()]) {
            case 1 -> MavenArtifactScope.COMPILE;
            case 2 -> MavenArtifactScope.TEST;
            case 3 -> MavenArtifactScope.RUNTIME;
            case 4 -> MavenArtifactScope.PROVIDED;
            default -> MavenArtifactScope.COMPILE;
        };
        PomFile.addDependency$default(pom, mavenId, scope, null, false, null, 28, null);
    }

    @Override
    @Nullable
    public VirtualFile getBuildScriptFile(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        XmlFile xmlFile = this.findPomFile(module);
        return xmlFile != null ? xmlFile.getVirtualFile() : null;
    }

    @Override
    public boolean isProjectSyncPending() {
        boolean isNotificationVisible = (Boolean)ExternalSystemProjectNotificationAware.Companion.isNotificationVisibleProperty(this.project, MavenUtil.SYSTEM_ID).get();
        return isNotificationVisible;
    }

    @Override
    public boolean isProjectSyncInProgress() {
        return false;
    }

    @Override
    public void startProjectSync() {
        ExternalSystemProjectTracker.Companion.getInstance(this.project).scheduleProjectRefresh();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DependencyScope.values().length];
            try {
                nArray[DependencyScope.COMPILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyScope.TEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyScope.RUNTIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyScope.PROVIDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

