/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggestionProvider;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "jvmName", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;)V", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class AddJvmNameAnnotationFix
extends KotlinQuickFixAction<KtElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String jvmName;

    public AddJvmNameAnnotationFix(@NotNull KtElement element, @NotNull String jvmName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
        super((PsiElement)element);
        this.jvmName = jvmName;
    }

    @NotNull
    public String getText() {
        String string;
        if (this.getElement() instanceof KtAnnotationEntry) {
            string = KotlinBundle.message((String)"fix.change.jvm.name", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[]{JvmFileClassUtil.INSTANCE.getJVM_NAME().shortName()};
            string = KotlinBundle.message((String)"fix.add.annotation.text.self", (Object[])objectArray);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement element = ktElement;
        KtElement ktElement2 = element;
        if (ktElement2 instanceof KtAnnotationEntry) {
            KtValueArgumentList argList = ((KtAnnotationEntry)element).getValueArgumentList();
            KtValueArgumentList newArgList = new KtPsiFactory(project, false, 2, null).createCallArguments("(\"" + this.jvmName + "\")");
            PsiElement psiElement = argList != null ? argList.replace((PsiElement)newArgList) : ((KtAnnotationEntry)element).addAfter((PsiElement)newArgList, ((KtAnnotationEntry)element).getLastChild());
        } else if (ktElement2 instanceof KtFunction) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)element, JvmFileClassUtil.INSTANCE.getJVM_NAME(), "\"" + this.jvmName + "\"", null, null, 12, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "typeElements", "", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAddJvmNameAnnotationFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddJvmNameAnnotationFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1869#2,2:78\n1869#2,2:80\n*S KotlinDebug\n*F\n+ 1 AddJvmNameAnnotationFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix$Companion\n*L\n72#1:78,2\n69#1:80,2\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function = ktNamedFunction;
            String string = function.getName();
            if (string == null) {
                return null;
            }
            String functionName = string;
            PsiElement psiElement2 = function.getParent();
            if (psiElement2 == null) {
                return null;
            }
            PsiElement containingDeclaration = psiElement2;
            Fe10KotlinNewDeclarationNameValidator nameValidator = new Fe10KotlinNewDeclarationNameValidator(containingDeclaration, (PsiElement)function, KotlinNameSuggestionProvider.ValidatorTarget.FUNCTION, null, 8, null);
            Object object = function.getReceiverTypeReference();
            if (object == null || (object = this.typeElements((KtTypeReference)object)) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"", null, null, (int)0, null, Companion::createAction$lambda$0, (int)30, null)) == null) {
                object = "";
            }
            Object receiverTypeElements = object;
            String jvmName = KotlinNameSuggester.Companion.suggestNameByName(functionName + (String)receiverTypeElements, (Function1<? super String, Boolean>)((Function1)nameValidator));
            KtAnnotationEntry ktAnnotationEntry = ModifierListModifactorKt.findAnnotation((KtAnnotated)function, JvmFileClassUtil.INSTANCE.getJVM_NAME());
            return new AddJvmNameAnnotationFix((KtElement)(ktAnnotationEntry != null ? (KtElementImplStub)ktAnnotationEntry : (KtElementImplStub)function), jvmName);
        }

        private final List<KtTypeElement> typeElements(KtTypeReference $this$typeElements) {
            List typeElements;
            block1: {
                typeElements = new ArrayList();
                Object object = $this$typeElements.getTypeElement();
                if (object == null || (object = object.getTypeArgumentsAsTypes()) == null) break block1;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtTypeReference it = (KtTypeReference)element$iv;
                    boolean bl = false;
                    org.jetbrains.kotlin.idea.quickfix.AddJvmNameAnnotationFix$Companion.typeElements$collect(typeElements, it);
                }
            }
            return typeElements;
        }

        private static final CharSequence createAction$lambda$0(KtTypeElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        private static final void typeElements$collect(List<KtTypeElement> typeElements, KtTypeReference typeReference) {
            KtTypeReference ktTypeReference = typeReference;
            if (ktTypeReference == null || (ktTypeReference = ktTypeReference.getTypeElement()) == null) {
                return;
            }
            KtTypeReference typeElement2 = ktTypeReference;
            List list2 = typeElement2.getTypeArgumentsAsTypes();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeArgumentsAsTypes(...)");
            List typeArguments2 = list2;
            if (typeArguments2.isEmpty()) {
                typeElements.add((KtTypeElement)typeElement2);
            } else {
                Iterable $this$forEach$iv = typeArguments2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtTypeReference it = (KtTypeReference)element$iv;
                    boolean bl = false;
                    org.jetbrains.kotlin.idea.quickfix.AddJvmNameAnnotationFix$Companion.typeElements$collect(typeElements, it);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

