/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ultimate.nodejs.protractor;

import com.intellij.execution.actions.CompatibleRunConfigurationProducer;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.KotlinJSRunConfigurationDataProvider;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.run.RcUtilsKt;
import org.jetbrains.kotlin.idea.ultimate.nodejs.NodeJsUtilKt;
import org.jetbrains.kotlin.idea.ultimate.nodejs.TestElementPath;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.KotlinProtractorConfigurationType;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.KotlinProtractorRunConfiguration;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.KotlinProtractorRunSettings;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.ProtractorConfigData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014J&\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfigurationProducer;", "Lcom/intellij/execution/actions/CompatibleRunConfigurationProducer;", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfiguration;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/tooling/KotlinJSRunConfigurationDataProvider;", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/ProtractorConfigData;", "<init>", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "isForTests", "", "()Z", "getConfigurationData", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isConfigurationFromCompatibleContext", "configuration", "setupConfigurationFromCompatibleContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "kotlin-ultimate.javascript.nodeJs"})
public final class KotlinProtractorRunConfigurationProducer
extends CompatibleRunConfigurationProducer<KotlinProtractorRunConfiguration>
implements KotlinJSRunConfigurationDataProvider<ProtractorConfigData> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return (ConfigurationFactory)KotlinProtractorConfigurationType.Companion.getInstance();
    }

    @Override
    public boolean isForTests() {
        return true;
    }

    @Override
    @Nullable
    public ProtractorConfigData getConfigurationData(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Module module = context.getModule();
        if (module == null || (module = JsUtilsKt.asJsModule(module)) == null) {
            return null;
        }
        Module module2 = module;
        if (KotlinFacetUtils.isNewMultiPlatformModule(module2)) {
            return null;
        }
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        if (!TestElementPath.Companion.isModuleAssociatedDir(element, module2)) {
            return null;
        }
        String string = JsUtilsKt.getJsTestOutputFilePath(module2);
        if (string == null) {
            return null;
        }
        String testFilePath = string;
        return new ProtractorConfigData(element, module2, testFilePath);
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull KotlinProtractorRunConfiguration configuration2, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProtractorConfigData protractorConfigData = this.getConfigurationData(context);
        if (protractorConfigData == null) {
            return false;
        }
        ProtractorConfigData configData = protractorConfigData;
        return Intrinsics.areEqual((Object)configuration2.getRunSettings().getTestFileSystemDependentPath(), (Object)FileUtil.toSystemDependentName((String)configData.getJsOutputFilePath()));
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull KotlinProtractorRunConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        ProtractorConfigData protractorConfigData = this.getConfigurationData(context);
        if (protractorConfigData == null) {
            return false;
        }
        ProtractorConfigData configData = protractorConfigData;
        sourceElement.set((Object)element);
        configuration2.setRunSettings(KotlinProtractorRunSettings.copy$default(configuration2.getRunSettings(), null, null, configData.getJsOutputFilePath(), null, null, NodeJsUtilKt.getNodeJsEnvironmentVars(configData.getModule(), true), 27, null));
        String string = configuration2.suggestedName();
        if (string == null) {
            string = "Unknown";
        }
        configuration2.setName(string);
        RcUtilsKt.addBuildTask((RunConfiguration)configuration2);
        return true;
    }
}

