/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ultimate.nodejs.protractor;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorConsoleFilter;
import com.intellij.javascript.protractor.ProtractorDetector;
import com.intellij.javascript.protractor.ProtractorOutputToGeneralTestEventsConverter;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.navigation.JSTestLocationProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.ultimate.nodejs.KotlinJavascriptBundle;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.KotlinProtractorRunConfiguration;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.KotlinProtractorRunSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0002!\"B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunState;", "Lcom/intellij/execution/configurations/RunProfileState;", "Lcom/intellij/javascript/nodejs/debug/NodeLocalDebugRunProfileState;", "runConfiguration", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "protractorPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "<init>", "(Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/javascript/nodejs/util/NodePackage;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "runSettings", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunSettings;", "execute", "Lcom/intellij/execution/ExecutionResult;", "debugPort", "", "createSmtRunnerConsoleView", "Lcom/intellij/execution/ui/ConsoleView;", "workingDirectory", "Ljava/nio/file/Path;", "foldCommandLine", "", "consoleView", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter;", "Companion", "ProtractorConsoleProperties", "kotlin-ultimate.javascript.nodeJs"})
@SourceDebugExtension(value={"SMAP\nKotlinProtractorRunState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProtractorRunState.kt\norg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class KotlinProtractorRunState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinProtractorRunConfiguration runConfiguration;
    @NotNull
    private final ExecutionEnvironment environment;
    @NotNull
    private final NodePackage protractorPackage;
    @NotNull
    private final Project project;
    @NotNull
    private final KotlinProtractorRunSettings runSettings;
    @NotNull
    private static final String FRAMEWORK_NAME = "KotlinProtractorJavaScriptTestRunner";
    @NotNull
    private static final String INTELLIJ_CONFIG_FILE_PATH = "protractor-intellij/lib/protractor-intellij-config.js";

    public KotlinProtractorRunState(@NotNull KotlinProtractorRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage protractorPackage) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)protractorPackage, (String)"protractorPackage");
        this.runConfiguration = runConfiguration;
        this.environment = environment;
        this.protractorPackage = protractorPackage;
        Project project = this.runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.runSettings = this.runConfiguration.getRunSettings();
    }

    @NotNull
    public ExecutionResult execute(int debugPort) {
        NodeJsLocalInterpreter nodeJsLocalInterpreter = this.runSettings.getInterpreterRef().resolveAsLocal(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsLocalInterpreter, (String)"resolveAsLocal(...)");
        NodeJsLocalInterpreter interpreter = nodeJsLocalInterpreter;
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler oSProcessHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)oSProcessHandler, (String)"createProcessHandler(...)");
        OSProcessHandler processHandler = oSProcessHandler;
        ConsoleView consoleView = this.createSmtRunnerConsoleView(commandLine.getWorkingDirectory());
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler));
        consoleView.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView, (ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        AnAction[] anActionArray = new AnAction[]{new ToggleAutoTestAction()};
        executionResult.setRestartActions(anActionArray);
        return (ExecutionResult)executionResult;
    }

    private final ConsoleView createSmtRunnerConsoleView(Path workingDirectory) {
        Executor executor = this.environment.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        ProtractorConsoleProperties testConsoleProperties = new ProtractorConsoleProperties(this.runConfiguration, executor, (SMTestLocator)new JSTestLocationProvider((JsTestFrameworkDetector)ProtractorDetector.Companion.getInstance()));
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)FRAMEWORK_NAME, (TestConsoleProperties)((TestConsoleProperties)testConsoleProperties));
        Intrinsics.checkNotNullExpressionValue((Object)baseTestsOutputConsoleView, (String)"createConsole(...)");
        BaseTestsOutputConsoleView consoleView = baseTestsOutputConsoleView;
        consoleView.addMessageFilter((Filter)new ProtractorConsoleFilter(this.project, workingDirectory));
        Disposer.register((Disposable)((Disposable)this.environment), (Disposable)((Disposable)consoleView));
        return (ConsoleView)consoleView;
    }

    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        ArrayList<Object> arrayList;
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        String string = PathUtil.getFileName((String)this.runSettings.getConfigFileSystemDependentPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String configFileName = string;
        String string2 = PathUtil.getFileName((String)this.runSettings.getTestFileSystemDependentPath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
        String testFileName = string2;
        String seleniumAddress = this.runSettings.getSeleniumAddress();
        ArrayList<Object> $this$foldCommandLine_u24lambda_u240 = arrayList = new ArrayList<Object>();
        boolean bl = false;
        $this$foldCommandLine_u24lambda_u240.add("protractor");
        if (!StringsKt.isBlank((CharSequence)configFileName)) {
            $this$foldCommandLine_u24lambda_u240.add(configFileName);
        }
        if (!StringsKt.isBlank((CharSequence)testFileName)) {
            $this$foldCommandLine_u24lambda_u240.add("--specs=" + testFileName);
        }
        if (!StringsKt.isBlank((CharSequence)seleniumAddress)) {
            $this$foldCommandLine_u24lambda_u240.add("--seleniumAddress=" + seleniumAddress);
        }
        $this$foldCommandLine_u24lambda_u240.addAll(ParametersListUtil.parse((String)((Object)StringsKt.trim((CharSequence)this.runSettings.getExtraOptions())).toString()));
        ArrayList<Object> parameters2 = arrayList;
        String string3 = ParametersListUtil.join((List)parameters2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
        String foldedCommandLine = string3;
        JsbtUtil.foldCommandLine((ConsoleView)consoleView, (ProcessHandler)processHandler, (String)foldedCommandLine);
    }

    private final GeneralCommandLine createCommandLine(NodeJsLocalInterpreter interpreter, int debugPort) {
        String string;
        File file;
        GeneralCommandLine generalCommandLine;
        GeneralCommandLine $this$createCommandLine_u24lambda_u241 = generalCommandLine = new GeneralCommandLine();
        boolean bl = false;
        $this$createCommandLine_u24lambda_u241.setCharset(StandardCharsets.UTF_8);
        GeneralCommandLine commandLine = generalCommandLine;
        this.runSettings.getEnvData().configureCommandLine(commandLine, true);
        String originalConfigFilePath = this.runSettings.getConfigFileSystemDependentPath();
        String testFilePath = this.runSettings.getTestFileSystemDependentPath();
        String seleniumAddress = this.runSettings.getSeleniumAddress();
        boolean withConfigFile = !StringsKt.isBlank((CharSequence)originalConfigFilePath);
        commandLine.setWorkDirectory(this.project.getBasePath());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, (List)CollectionsKt.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)((NodeJsInterpreter)interpreter), (boolean)true);
        NodeCommandLineUtil.configureUsefulEnvironment((GeneralCommandLine)commandLine);
        commandLine.addParameter(ProtractorUtil.getProtractorMainJsFile((NodePackage)this.protractorPackage).getAbsolutePath());
        try {
            file = HelperFilesLocator.getFileRelativeToHelpersDir((String)INTELLIJ_CONFIG_FILE_PATH);
        }
        catch (IOException e) {
            throw new ExecutionException(KotlinJavascriptBundle.message("protractor.cannot.locate.wrapper.config.file", new Object[0]), (Throwable)e);
        }
        File intellijConfigFile = file;
        commandLine.addParameter(intellijConfigFile.getAbsolutePath());
        if (withConfigFile) {
            string = originalConfigFilePath;
        } else {
            File tempConfigFile = File.createTempFile("protractor", "conf.js");
            Intrinsics.checkNotNull((Object)tempConfigFile);
            FilesKt.writeText$default((File)tempConfigFile, (String)"exports.config = {}", null, (int)2, null);
            string = tempConfigFile.getAbsolutePath();
        }
        String actualConfigFilePath = string;
        commandLine.addParameter("--intellijOriginalConfigFile=" + actualConfigFilePath);
        if (!StringsKt.isBlank((CharSequence)testFilePath)) {
            commandLine.addParameter("--specs=" + testFilePath);
        }
        if (!StringsKt.isBlank((CharSequence)seleniumAddress)) {
            commandLine.addParameter("--seleniumAddress=" + seleniumAddress);
        }
        commandLine.addParameters(ParametersListUtil.parse((String)((Object)StringsKt.trim((CharSequence)this.runSettings.getExtraOptions())).toString()));
        commandLine.addParameter("--disableChecks");
        return commandLine;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunState$Companion;", "", "<init>", "()V", "FRAMEWORK_NAME", "", "getFRAMEWORK_NAME", "()Ljava/lang/String;", "INTELLIJ_CONFIG_FILE_PATH", "kotlin-ultimate.javascript.nodeJs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFRAMEWORK_NAME() {
            return FRAMEWORK_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunState$ProtractorConsoleProperties;", "Lcom/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties;", "Lcom/intellij/execution/testframework/sm/SMCustomMessagesParsing;", "configuration", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfiguration;", "executor", "Lcom/intellij/execution/Executor;", "myLocator", "Lcom/intellij/execution/testframework/sm/runner/SMTestLocator;", "<init>", "(Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfiguration;Lcom/intellij/execution/Executor;Lcom/intellij/execution/testframework/sm/runner/SMTestLocator;)V", "getTestLocator", "createTestEventsConverter", "Lcom/intellij/javascript/protractor/ProtractorOutputToGeneralTestEventsConverter;", "testFrameworkName", "", "consoleProperties", "Lcom/intellij/execution/testframework/TestConsoleProperties;", "kotlin-ultimate.javascript.nodeJs"})
    private static final class ProtractorConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        @NotNull
        private final SMTestLocator myLocator;

        public ProtractorConsoleProperties(@NotNull KotlinProtractorRunConfiguration configuration2, @NotNull Executor executor, @NotNull SMTestLocator myLocator) {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)myLocator, (String)"myLocator");
            super((RunConfiguration)configuration2, Companion.getFRAMEWORK_NAME(), executor);
            this.myLocator = myLocator;
            this.setUsePredefinedMessageFilter(false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setIdBasedTestTree(true);
            this.setPrintTestingStartedTime(false);
        }

        @NotNull
        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }

        @NotNull
        public ProtractorOutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            Intrinsics.checkNotNullParameter((Object)testFrameworkName, (String)"testFrameworkName");
            Intrinsics.checkNotNullParameter((Object)consoleProperties, (String)"consoleProperties");
            return new ProtractorOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties.isEditable());
        }
    }
}

