/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JUnitVersion;
import com.intellij.execution.junit.JunitLibrarySetupKt;
import com.intellij.execution.junit.codeInspection.JUnitMalformedSignatureVisitor$inParameterResolverContext$;
import com.intellij.execution.junit.references.MethodSourceReference;
import com.intellij.execution.junit.references.PsiMethodSourceResolveResult;
import com.intellij.jvm.analysis.quickFix.CompositeModCommandQuickFix;
import com.intellij.jvm.analysis.quickFix.JvmActionUtilKt;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.ChangeTypeRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.junit.JUnitCommonClassNames;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnchorOwner;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u0000 n2\u00020\u0001:\u0006ijklmnB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0002J\f\u0010%\u001a\u00020\u0005*\u00020&H\u0002J\f\u0010%\u001a\u00020\u0005*\u00020\u0011H\u0002J\f\u0010%\u001a\u00020\u0005*\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020,2\u0006\u0010-\u001a\u00020\rH\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020\rH\u0002J\"\u00100\u001a\b\u0012\u0004\u0012\u00020\r0\u0007*\u00020\r2\u000e\b\u0002\u00101\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0002J\u0018\u00102\u001a\u00020,2\u0006\u0010-\u001a\u00020\r2\u0006\u00103\u001a\u00020\rH\u0002J\u0010\u00104\u001a\u00020,2\u0006\u0010-\u001a\u00020\rH\u0002J\u0010\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\u000fH\u0002J\f\u00107\u001a\u00020\u0005*\u00020\u0011H\u0002J\f\u00108\u001a\u00020\u0005*\u000209H\u0002J\f\u0010:\u001a\u00020\u0005*\u00020\u0011H\u0002J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010<\u001a\u00020,2\u0006\u0010#\u001a\u00020\u0011H\u0002J\f\u0010=\u001a\u00020\u0005*\u00020\u0011H\u0002J\u0010\u0010>\u001a\u00020,2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010?\u001a\u00020,2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u00020$H\u0002J\u0010\u0010B\u001a\u00020,2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010C\u001a\u00020,2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u001e\u0010D\u001a\u00020,2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00072\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0016\u0010F\u001a\u00020\u00052\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007H\u0002J\u0018\u0010G\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010H\u001a\u00020\u001eH\u0002J\u0016\u0010I\u001a\u0004\u0018\u00010J*\u00020K2\u0006\u0010L\u001a\u00020MH\u0002J(\u0010N\u001a\u00020,2\u0006\u0010O\u001a\u00020M2\u0006\u0010P\u001a\u00020*2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u0011H\u0002J*\u0010R\u001a\u00020,2\u0006\u0010S\u001a\u00020\u00112\b\u0010O\u001a\u0004\u0018\u00010M2\u0006\u0010P\u001a\u00020*2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0012\u0010T\u001a\u00020\u00052\b\u0010-\u001a\u0004\u0018\u00010MH\u0002J\u0010\u0010U\u001a\u00020\u00052\u0006\u0010O\u001a\u00020MH\u0002J\u001c\u0010V\u001a\u0004\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010W2\u0006\u0010#\u001a\u00020JH\u0002J\u0010\u0010Y\u001a\u00020\u00052\u0006\u0010#\u001a\u00020JH\u0002J\u0012\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010#\u001a\u00020JH\u0002J\u0018\u0010\\\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010]\u001a\u00020\u001eH\u0002J\u0018\u0010^\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010]\u001a\u00020\u001eH\u0002J\u0018\u0010_\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010`\u001a\u00020\u001eH\u0002J \u0010a\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010P\u001a\u00020b2\u0006\u0010c\u001a\u00020WH\u0002J\u0018\u0010d\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010e\u001a\u00020\u001eH\u0002J \u0010f\u001a\u00020,2\u0006\u0010`\u001a\u00020\u001e2\u0006\u0010g\u001a\u00020W2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010h\u001a\u00020,2\u0006\u0010H\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u0004\u0018\u00010\b*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006o"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ignorableAnnotations", "", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;ZLjava/util/List;)V", "visitClass", "node", "Lorg/jetbrains/uast/UClass;", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "dataPoint", "Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$AnnotatedSignatureProblem;", "ruleSignatureProblem", "registeredExtensionProblem", "classRuleSignatureProblem", "beforeAfterProblem", "beforeAfterEachProblem", "beforeAfterClassProblem", "beforeAfterAllProblem", "junit4TestProblem", "junit56TestProblem", "shortName", "Lcom/intellij/psi/PsiAnnotation;", "getShortName", "(Lcom/intellij/psi/PsiAnnotation;)Ljava/lang/String;", "notPrivate", "Lorg/jetbrains/uast/UastVisibility;", "method", "Lorg/jetbrains/uast/UDeclaration;", "inParameterResolverContext", "Lorg/jetbrains/uast/UParameter;", "Lcom/intellij/psi/PsiModifierListOwner;", "hasPotentialAutomaticParameterResolver", "element", "Lcom/intellij/psi/PsiElement;", "checkUnconstructableClass", "", "aClass", "checkMalformedClass", "checkMalformedNestedClass", "nestedClassHierarchy", "current", "checkMalformedJUnit4NestedClass", "outerClass", "checkMalformedJUnit5NestedClass", "checkMalformedCallbackExtension", "field", "isNoArg", "suspendModifierIsAllowed", "Lorg/jetbrains/uast/UElement;", "isSuspendFunction", "checkSuspendFunction", "checkJUnit3Test", "isParameterizedTest", "checkedMalformedSetupTeardown", "checkSuite", "checkIllegalCombinedAnnotations", "decl", "checkRepeatedTestNonPositive", "checkMalformedParameterized", "checkConflictingSourceAnnotations", "annotations", "hasCustomProvider", "checkMethodSource", "methodSource", "getSourceMethodForClass", "Lcom/intellij/psi/PsiMethod;", "Lcom/intellij/execution/junit/references/PsiMethodSourceResolveResult;", "owner", "Lcom/intellij/psi/PsiClass;", "checkAbsentSourceProvider", "containingClass", "attributeValue", "sourceProviderName", "checkSourceProvider", "sourceProvider", "classHasParameterResolverField", "implementationsTestInstanceAnnotated", "getComponentType", "Lcom/intellij/psi/PsiType;", "returnType", "hasMultipleParameters", "getPassedParameter", "Lcom/intellij/psi/PsiParameter;", "checkNullSource", "annotation", "checkEmptySource", "checkEnumSource", "enumSource", "checkSourceTypeAndParameterTypeAgree", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "componentType", "checkValuesSource", "valuesSource", "checkEnumConstants", "enumType", "checkCsvSource", "MakeJUnit4InnerClassRunnableFix", "AnnotatedSignatureProblem", "ClassSignatureQuickFix", "FieldSignatureQuickfix", "MethodSignatureQuickfix", "Companion", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnitMalformedDeclarationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 7 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1333:1\n1761#2,3:1334\n1761#2,2:1341\n1763#2:1344\n1761#2,3:1349\n295#2,2:1352\n774#2:1354\n865#2,2:1355\n1740#2,3:1357\n295#2,2:1362\n1740#2,2:1368\n1742#2:1372\n295#2,2:1375\n774#2:1382\n865#2,2:1383\n774#2:1385\n865#2,2:1386\n1869#2,2:1388\n295#2,2:1390\n295#2,2:1392\n1869#2:1406\n1870#2:1421\n1761#2,3:1432\n1761#2,3:1440\n1761#2,3:1443\n1761#2,3:1460\n1869#2:1463\n1869#2,2:1464\n1870#2:1466\n1563#2:1479\n1634#2,3:1480\n1869#2,2:1483\n1869#2,2:1485\n774#2:1487\n865#2,2:1488\n785#2:1490\n796#2:1491\n1878#2,2:1492\n797#2,2:1494\n1880#2:1496\n799#2:1497\n774#2:1498\n865#2,2:1499\n785#2:1501\n796#2:1502\n1878#2,2:1503\n797#2,2:1505\n1880#2:1507\n799#2:1508\n774#2:1509\n865#2,2:1510\n785#2:1512\n796#2:1513\n1878#2,2:1514\n797#2,2:1516\n1880#2:1518\n799#2:1519\n1255#3,2:1337\n477#3:1339\n1255#3:1340\n1256#3:1345\n183#3,2:1373\n183#3,2:1377\n183#3,2:1379\n171#4:1343\n171#4:1405\n171#4:1420\n171#4:1456\n171#4:1467\n12637#5,2:1346\n19652#5,2:1360\n12637#5,2:1364\n3170#5,11:1394\n11546#5,9:1407\n13472#5:1416\n13473#5:1418\n11555#5:1419\n12637#5,2:1430\n12797#5,3:1435\n1310#5,2:1438\n11546#5,9:1446\n13472#5:1455\n13473#5:1458\n11555#5:1459\n4135#5,11:1468\n67#6:1348\n19#7:1366\n19#7:1367\n19#7:1370\n19#7:1381\n1#8:1371\n1#8:1417\n1#8:1457\n37#9:1422\n36#9,3:1423\n37#9:1426\n36#9,3:1427\n*S KotlinDebug\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor\n*L\n227#1:1334,3\n244#1:1341,2\n244#1:1344\n272#1:1349,3\n288#1:1352,2\n302#1:1354\n302#1:1355,2\n325#1:1357,3\n340#1:1362,2\n400#1:1368,2\n400#1:1372\n440#1:1375,2\n477#1:1382\n477#1:1383,2\n485#1:1385\n485#1:1386,2\n509#1:1388,2\n526#1:1390,2\n530#1:1392,2\n577#1:1406\n577#1:1421\n693#1:1432,3\n756#1:1440,3\n758#1:1443,3\n762#1:1460,3\n846#1:1463\n847#1:1464,2\n846#1:1466\n877#1:1479\n877#1:1480,3\n880#1:1483,2\n901#1:1485,2\n147#1:1487\n147#1:1488,2\n158#1:1490\n158#1:1491\n158#1:1492,2\n158#1:1494,2\n158#1:1496\n158#1:1497\n174#1:1498\n174#1:1499,2\n186#1:1501\n186#1:1502\n186#1:1503,2\n186#1:1505,2\n186#1:1507\n186#1:1508\n200#1:1509\n200#1:1510,2\n212#1:1512\n212#1:1513\n212#1:1514,2\n212#1:1516,2\n212#1:1518\n212#1:1519\n232#1:1337,2\n242#1:1339\n243#1:1340\n243#1:1345\n426#1:1373,2\n449#1:1377,2\n465#1:1379,2\n245#1:1343\n568#1:1405\n588#1:1420\n759#1:1456\n854#1:1467\n251#1:1346,2\n339#1:1360,2\n375#1:1364,2\n567#1:1394,11\n582#1:1407,9\n582#1:1416\n582#1:1418\n582#1:1419\n684#1:1430,2\n708#1:1435,3\n717#1:1438,2\n759#1:1446,9\n759#1:1455\n759#1:1458\n759#1:1459\n876#1:1468,11\n258#1:1348\n388#1:1366\n389#1:1367\n401#1:1370\n476#1:1381\n582#1:1417\n759#1:1457\n621#1:1422\n621#1:1423,3\n652#1:1426\n652#1:1427,3\n*E\n"})
final class JUnitMalformedSignatureVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ProblemsHolder holder;
    private final boolean isOnTheFly;
    @NotNull
    private final List<String> ignorableAnnotations;
    @NotNull
    private final AnnotatedSignatureProblem dataPoint;
    @NotNull
    private final AnnotatedSignatureProblem ruleSignatureProblem;
    @NotNull
    private final AnnotatedSignatureProblem registeredExtensionProblem;
    @NotNull
    private final AnnotatedSignatureProblem classRuleSignatureProblem;
    @NotNull
    private final AnnotatedSignatureProblem beforeAfterProblem;
    @NotNull
    private final AnnotatedSignatureProblem beforeAfterEachProblem;
    @NotNull
    private final AnnotatedSignatureProblem beforeAfterClassProblem;
    @NotNull
    private final AnnotatedSignatureProblem beforeAfterAllProblem;
    @NotNull
    private final AnnotatedSignatureProblem junit4TestProblem;
    @NotNull
    private final AnnotatedSignatureProblem junit56TestProblem;
    @Deprecated
    public static final int FIELD = 0;
    @Deprecated
    public static final int METHOD = 1;
    @Deprecated
    public static final int SINGLE = 0;
    @Deprecated
    public static final int DOUBLE = 1;
    @Deprecated
    @NotNull
    public static final String TEST_INSTANCE_PER_CLASS = "@org.junit.jupiter.api.TestInstance(TestInstance.Lifecycle.PER_CLASS)";
    @Deprecated
    @NotNull
    public static final String METHOD_SOURCE_RETURN_TYPE = "java.util.stream.Stream<org.junit.jupiter.params.provider.Arguments>";
    @Deprecated
    @NotNull
    public static final String COROUTINES_CONTINUATION_TYPE = "kotlin.coroutines.Continuation<? super kotlin.Unit>";
    @NotNull
    private static final List<String> checkableRunners;
    @NotNull
    private static final List<String> validEmptySourceTypeBefore510;
    @NotNull
    private static final List<String> validEmptySourceTypeAfter510;
    @NotNull
    private static final Map<UastVisibility, JvmModifier> visibilityToModifier;
    @NotNull
    private static final List<String> singleParamProviders;
    @NotNull
    private static final List<String> multipleParameterProviders;
    @NotNull
    private static final List<String> nonCombinedTests;
    @NotNull
    private static final List<String> parameterizedSources;

    public JUnitMalformedSignatureVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull List<String> ignorableAnnotations) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(ignorableAnnotations, (String)"ignorableAnnotations");
        this.holder = holder;
        this.isOnTheFly = isOnTheFly;
        this.ignorableAnnotations = ignorableAnnotations;
        Object object = new String[]{"org.junit.experimental.theories.DataPoint", "org.junit.experimental.theories.DataPoints"};
        this.dataPoint = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object[])object), true, false, false, null, null, JUnitMalformedSignatureVisitor::dataPoint$lambda$0, null, 188, null);
        object = new String[]{"org.junit.rules.TestRule", "org.junit.rules.MethodRule"};
        this.ruleSignatureProblem = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object)"org.junit.Rule"), false, false, false, null, CollectionsKt.listOf((Object[])object), JUnitMalformedSignatureVisitor::ruleSignatureProblem$lambda$1, null, 156, null);
        this.registeredExtensionProblem = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object)"org.junit.jupiter.api.extension.RegisterExtension"), null, false, false, null, CollectionsKt.listOf((Object)"org.junit.jupiter.api.extension.Extension"), arg_0 -> JUnitMalformedSignatureVisitor.registeredExtensionProblem$lambda$2(this, arg_0), null, 158, null);
        this.classRuleSignatureProblem = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object)"org.junit.ClassRule"), true, false, false, null, CollectionsKt.listOf((Object)"org.junit.rules.TestRule"), JUnitMalformedSignatureVisitor::classRuleSignatureProblem$lambda$3, null, 156, null);
        object = new String[]{"org.junit.Before", "org.junit.After"};
        this.beforeAfterProblem = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object[])object), false, false, false, true, null, JUnitMalformedSignatureVisitor::beforeAfterProblem$lambda$4, arg_0 -> JUnitMalformedSignatureVisitor.beforeAfterProblem$lambda$6(this, arg_0), 44, null);
        object = new String[]{"org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach"};
        this.beforeAfterEachProblem = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object[])object), false, false, false, true, null, (Function1)new Function1<UDeclaration, UastVisibility>((Object)this){

            public final UastVisibility invoke(UDeclaration p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JUnitMalformedSignatureVisitor.access$notPrivate((JUnitMalformedSignatureVisitor)((Object)this.receiver), p0);
            }
        }, arg_0 -> JUnitMalformedSignatureVisitor.beforeAfterEachProblem$lambda$8(this, arg_0), 44, null);
        object = new String[]{"org.junit.BeforeClass", "org.junit.AfterClass"};
        this.beforeAfterClassProblem = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object[])object), true, false, false, true, null, JUnitMalformedSignatureVisitor::beforeAfterClassProblem$lambda$9, arg_0 -> JUnitMalformedSignatureVisitor.beforeAfterClassProblem$lambda$11(this, arg_0), 44, null);
        String[] stringArray = new String[]{"org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"};
        object = CollectionsKt.listOf((Object[])stringArray);
        stringArray = (String[])new Function1<UDeclaration, UastVisibility>((Object)this){

            public final UastVisibility invoke(UDeclaration p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JUnitMalformedSignatureVisitor.access$notPrivate((JUnitMalformedSignatureVisitor)((Object)this.receiver), p0);
            }
        };
        this.beforeAfterAllProblem = new AnnotatedSignatureProblem(this, (List)object, true, false, true, true, null, (Function1)stringArray, arg_0 -> JUnitMalformedSignatureVisitor.beforeAfterAllProblem$lambda$13(this, arg_0), 36, null);
        this.junit4TestProblem = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object)"org.junit.Test"), false, false, false, true, null, JUnitMalformedSignatureVisitor::junit4TestProblem$lambda$14, arg_0 -> JUnitMalformedSignatureVisitor.junit4TestProblem$lambda$16(this, arg_0), 44, null);
        this.junit56TestProblem = new AnnotatedSignatureProblem(this, CollectionsKt.listOf((Object)"org.junit.jupiter.api.Test"), false, false, false, true, null, (Function1)new Function1<UDeclaration, UastVisibility>((Object)this){

            public final UastVisibility invoke(UDeclaration p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JUnitMalformedSignatureVisitor.access$notPrivate((JUnitMalformedSignatureVisitor)((Object)this.receiver), p0);
            }
        }, arg_0 -> JUnitMalformedSignatureVisitor.junit56TestProblem$lambda$18(this, arg_0), 44, null);
    }

    public boolean visitClass(@NotNull UClass node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.checkUnconstructableClass(node);
        this.checkMalformedNestedClass(node);
        return true;
    }

    public boolean visitField(@NotNull UField node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.checkMalformedCallbackExtension(node);
        this.dataPoint.check(this.holder, node);
        this.ruleSignatureProblem.check(this.holder, node);
        this.classRuleSignatureProblem.check(this.holder, node);
        this.registeredExtensionProblem.check(this.holder, node);
        return true;
    }

    public boolean visitMethod(@NotNull UMethod node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.checkMalformedParameterized(node);
        this.checkRepeatedTestNonPositive(node);
        this.checkIllegalCombinedAnnotations((UDeclaration)node);
        this.dataPoint.check(this.holder, node);
        this.checkSuite(node);
        this.checkedMalformedSetupTeardown(node);
        this.beforeAfterProblem.check(this.holder, node);
        this.beforeAfterEachProblem.check(this.holder, node);
        this.beforeAfterClassProblem.check(this.holder, node);
        this.beforeAfterAllProblem.check(this.holder, node);
        this.ruleSignatureProblem.check(this.holder, node);
        this.classRuleSignatureProblem.check(this.holder, node);
        this.checkJUnit3Test(node);
        this.junit4TestProblem.check(this.holder, node);
        this.junit56TestProblem.check(this.holder, node);
        return true;
    }

    private final String getShortName(PsiAnnotation $this$shortName) {
        String string = $this$shortName.getQualifiedName();
        return string != null ? StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null) : null;
    }

    private final UastVisibility notPrivate(UDeclaration method) {
        return method.getVisibility() == UastVisibility.PRIVATE ? UastVisibility.PUBLIC : null;
    }

    private final boolean inParameterResolverContext(UParameter $this$inParameterResolverContext) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$inParameterResolverContext.getUAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UAnnotation ann = (UAnnotation)element$iv;
                    boolean bl2 = false;
                    PsiClass psiClass = ann.resolve();
                    boolean bl3 = psiClass != null ? this.inParameterResolverContext((PsiModifierListOwner)psiClass) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean inParameterResolverContext(UMethod $this$inParameterResolverContext) {
        boolean bl;
        block2: {
            Sequence alternatives;
            PsiElement psiElement = $this$inParameterResolverContext.getSourcePsi();
            if (psiElement == null) {
                return false;
            }
            PsiElement sourcePsi = psiElement;
            Class[] classArray = new Class[]{UMethod.class};
            Sequence $this$any$iv = alternatives = UastFacade.INSTANCE.convertToAlternatives(sourcePsi, classArray);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                UMethod it = (UMethod)element$iv;
                boolean bl2 = false;
                if (!this.inParameterResolverContext((PsiModifierListOwner)it.getJavaPsi())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean inParameterResolverContext(PsiModifierListOwner $this$inParameterResolverContext) {
        void $this$parentOfType$iv;
        boolean hasRegisteredExtension;
        block14: {
            boolean hasAnnotation;
            block13: {
                boolean bl;
                void $this$filterIsInstance$iv;
                Stream stream = MetaAnnotationUtil.findMetaAnnotationsInHierarchy((PsiModifierListOwner)$this$inParameterResolverContext, (Collection)CollectionsKt.listOf((Object)"org.junit.jupiter.api.extension.ExtendWith"));
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"findMetaAnnotationsInHierarchy(...)");
                Sequence extendsWith = StreamsKt.asSequence((Stream)stream);
                Stream stream2 = MetaAnnotationUtil.findMetaAnnotationsInHierarchy((PsiModifierListOwner)$this$inParameterResolverContext, (Collection)CollectionsKt.listOf((Object)"org.junit.jupiter.api.extension.Extensions"));
                Intrinsics.checkNotNullExpressionValue((Object)stream2, (String)"findMetaAnnotationsInHierarchy(...)");
                Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)stream2), JUnitMalformedSignatureVisitor::inParameterResolverContext$lambda$21));
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)inParameterResolverContext$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence extensionsEntries = sequence2;
                Sequence $this$any$iv = SequencesKt.plus((Sequence)extendsWith, (Sequence)extensionsEntries);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    PsiAnnotation annotation = (PsiAnnotation)element$iv;
                    boolean bl3 = false;
                    Object object = annotation;
                    if (object != null && (object = AnalysisUastUtilKt.flattenedAttributeValues((PsiAnnotation)object, (String)"value")) != null) {
                        boolean bl4;
                        block12: {
                            Iterable $this$any$iv2 = (Iterable)object;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl4 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    PsiAnnotationMemberValue it = (PsiAnnotationMemberValue)element$iv2;
                                    boolean bl5 = false;
                                    PsiElement $this$toUElementOfType$iv = (PsiElement)it;
                                    boolean $i$f$toUElementOfType = false;
                                    UClassLiteralExpression uClassLiteral = (UClassLiteralExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClassLiteralExpression.class);
                                    if (!(uClassLiteral != null && InheritanceUtil.isInheritor((PsiType)uClassLiteral.getType(), (String)"org.junit.jupiter.api.extension.ParameterResolver"))) continue;
                                    bl4 = true;
                                    break block12;
                                }
                                bl4 = false;
                            }
                        }
                        bl2 = bl4;
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block13;
                }
                bl = hasAnnotation = false;
            }
            if (hasAnnotation) {
                return true;
            }
            if ($this$inParameterResolverContext instanceof PsiClass) {
                PsiField[] psiFieldArray = ((PsiClass)$this$inParameterResolverContext).getFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                Object[] $this$any$iv = psiFieldArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiField field = (PsiField)element$iv;
                    boolean bl = false;
                    if (!(field.hasAnnotation("org.junit.jupiter.api.extension.RegisterExtension") && InheritanceUtil.isInheritor((PsiType)field.getType(), (String)"org.junit.jupiter.api.extension.ParameterResolver"))) continue;
                    v8 = true;
                    break block14;
                }
                v8 = false;
            } else {
                v8 = hasRegisteredExtension = false;
            }
        }
        if (hasRegisteredExtension) {
            return true;
        }
        PsiElement $i$f$any = (PsiElement)$this$inParameterResolverContext;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiModifierListOwner.class, (boolean)true);
        boolean bl = psiModifierListOwner != null ? this.inParameterResolverContext(psiModifierListOwner) : false;
        if (bl) {
            return true;
        }
        return this.hasPotentialAutomaticParameterResolver((PsiElement)$this$inParameterResolverContext);
    }

    private final boolean hasPotentialAutomaticParameterResolver(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots(TestUtils.isInTestCode((PsiElement)element));
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
        for (VirtualFile resourceRoot : virtualFileArray) {
            boolean bl;
            block5: {
                PsiDirectory psiDirectory;
                PsiDirectory psiDirectory2;
                PsiDirectory directory = PsiManager.getInstance((Project)module2.getProject()).findDirectory(resourceRoot);
                String serviceFile = directory != null && (psiDirectory2 = directory.findSubdirectory("META-INF")) != null && (psiDirectory = psiDirectory2.findSubdirectory("services")) != null ? psiDirectory.findFile("org.junit.jupiter.api.extension.Extension") : null;
                Object object = serviceFile;
                if (object == null || (object = object.getText()) == null || (object = StringsKt.lines((CharSequence)((CharSequence)object))) == null) continue;
                Object serviceFqns = object;
                Iterable $this$any$iv = (Iterable)serviceFqns;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String serviceFqn = (String)element$iv;
                        boolean bl2 = false;
                        PsiClass service = JavaPsiFacade.getInstance((Project)module2.getProject()).findClass(serviceFqn, module2.getModuleContentScope());
                        if (!InheritanceUtil.isInheritor((PsiClass)service, (String)"org.junit.jupiter.api.extension.ParameterResolver")) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkUnconstructableClass(UClass aClass) {
        PsiClass javaClass = aClass.getJavaPsi();
        if (javaClass.isInterface() || javaClass.isEnum() || javaClass.isAnnotationType()) {
            return;
        }
        if (javaClass.hasModifier(JvmModifier.ABSTRACT)) {
            return;
        }
        PsiMethod[] psiMethodArray = javaClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
        List constructors = ArraysKt.toList((Object[])psiMethodArray);
        if (TestUtils.isJUnitTestClass((PsiClass)javaClass)) {
            this.checkMalformedClass(aClass);
            if (!((Collection)constructors).isEmpty()) {
                Object v1;
                block11: {
                    Iterable $this$firstOrNull$iv = constructors;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Object[] parameters;
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.getParameterList().getParameters(), (String)"getParameters(...)");
                        if (!(it.hasModifier(JvmModifier.PUBLIC) && (it.getParameterList().isEmpty() || parameters.length == 1 && TypeUtils.isJavaLangString((PsiType)((PsiParameter)ArraysKt.first((Object[])parameters)).getType())))) continue;
                        v1 = element$iv;
                        break block11;
                    }
                    v1 = null;
                }
                PsiMethod compatibleConstr = v1;
                if (compatibleConstr == null) {
                    String string = JUnitBundle.message("jvm.inspections.unconstructable.test.case.junit3.descriptor", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message = string;
                    ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)aClass), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                    return;
                }
            }
        } else if (TestUtils.isJUnit4TestClass((PsiClass)javaClass, (boolean)false)) {
            this.checkMalformedClass(aClass);
            if (!((Collection)constructors).isEmpty()) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = constructors;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PsiMethod it = (PsiMethod)element$iv$iv;
                    boolean bl = false;
                    if (!it.hasModifier(JvmModifier.PUBLIC)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List publicConstructors = (List)destination$iv$iv;
                if (publicConstructors.size() != 1 || !((PsiMethod)CollectionsKt.first((List)publicConstructors)).getParameterList().isEmpty()) {
                    String string = JUnitBundle.message("jvm.inspections.unconstructable.test.case.junit4.descriptor", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message = string;
                    ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)aClass), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                    return;
                }
            }
        }
    }

    private final void checkMalformedClass(UClass aClass) {
        PsiClass javaClass = aClass.getJavaPsi();
        if (!javaClass.hasModifier(JvmModifier.PUBLIC) && !AnalysisUastUtilKt.isAnonymousOrLocal((UClass)aClass)) {
            String string = JUnitBundle.message("jvm.inspections.unconstructable.test.case.not.public.descriptor", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            LocalQuickFix[] fixes = JvmActionUtilKt.createModifierQuickfixes((UDeclaration)((UDeclaration)aClass), (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.PUBLIC, (boolean)true, (boolean)false, (int)4, null));
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)aClass), (String)message, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length), null, (int)8, null);
        }
    }

    private final void checkMalformedNestedClass(UClass aClass) {
        boolean bl;
        List classHierarchy;
        block5: {
            classHierarchy = JUnitMalformedSignatureVisitor.nestedClassHierarchy$default(this, aClass, null, 1, null);
            if (classHierarchy.isEmpty()) {
                return;
            }
            Iterable $this$all$iv = classHierarchy;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    UClass it = (UClass)element$iv;
                    boolean bl2 = false;
                    if (it.getJavaPsi().hasModifier(JvmModifier.ABSTRACT)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        UClass outer = (UClass)CollectionsKt.last((List)classHierarchy);
        this.checkMalformedJUnit4NestedClass(aClass, outer);
        this.checkMalformedJUnit5NestedClass(aClass);
    }

    private final List<UClass> nestedClassHierarchy(UClass $this$nestedClassHierarchy, List<? extends UClass> current) {
        UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)$this$nestedClassHierarchy));
        if (containingClass == null) {
            return current;
        }
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)containingClass), (Iterable)this.nestedClassHierarchy(containingClass, current));
    }

    static /* synthetic */ List nestedClassHierarchy$default(JUnitMalformedSignatureVisitor jUnitMalformedSignatureVisitor, UClass uClass, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return jUnitMalformedSignatureVisitor.nestedClassHierarchy(uClass, list);
    }

    private final void checkMalformedJUnit4NestedClass(UClass aClass, UClass outerClass) {
        Object v1;
        block6: {
            boolean bl;
            block5: {
                if (aClass.isInterface() || aClass.getJavaPsi().hasModifier(JvmModifier.ABSTRACT)) {
                    return;
                }
                UMethod[] $this$none$iv = aClass.getMethods();
                boolean $i$f$none = false;
                int n = $this$none$iv.length;
                for (int i = 0; i < n; ++i) {
                    UMethod element$iv;
                    UMethod it = element$iv = $this$none$iv[i];
                    boolean bl2 = false;
                    if (!it.getJavaPsi().hasAnnotation("org.junit.Test")) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
            Iterable $this$firstOrNull$iv = outerClass.getUAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UAnnotation it = (UAnnotation)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"org.junit.runner.RunWith")) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        if (v1 != null) {
            return;
        }
        String string = JUnitBundle.message("jvm.inspections.junit.malformed.missing.nested.annotation.descriptor", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new MakeJUnit4InnerClassRunnableFix(aClass)};
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)aClass), (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
    }

    private final void checkMalformedJUnit5NestedClass(UClass aClass) {
        PsiClass javaClass = aClass.getJavaPsi();
        if (aClass.isInterface() || aClass.getJavaPsi().hasModifier(JvmModifier.ABSTRACT)) {
            return;
        }
        if (!javaClass.hasAnnotation("org.junit.jupiter.api.Nested")) {
            boolean bl;
            block6: {
                UMethod[] $this$any$iv = aClass.getMethods();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    UMethod element$iv;
                    UMethod it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!it.getJavaPsi().hasAnnotation("org.junit.jupiter.api.Test")) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (!bl) {
                return;
            }
        }
        if (javaClass.hasAnnotation("org.junit.jupiter.api.Nested") && !aClass.isStatic() && aClass.getVisibility() != UastVisibility.PRIVATE) {
            return;
        }
        String string = JUnitBundle.message("jvm.inspections.junit.malformed.missing.nested.annotation.descriptor", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        String string2 = aClass.getJavaPsi().getName();
        if (string2 == null) {
            return;
        }
        ClassSignatureQuickFix fix = new ClassSignatureQuickFix(string2, false, aClass.getVisibility() == UastVisibility.PRIVATE, javaClass.hasAnnotation("org.junit.jupiter.api.Nested") ? null : "org.junit.jupiter.api.Nested");
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)aClass), (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
    }

    private final void checkMalformedCallbackExtension(UField field) {
        String[] stringArray;
        PsiElement psiElement;
        PsiElement javaField;
        block12: {
            block11: {
                PsiElement psiElement2;
                block10: {
                    block9: {
                        psiElement2 = field.getJavaPsi();
                        if (psiElement2 == null) break block9;
                        PsiElement $this$asSafely$iv = psiElement2;
                        boolean $i$f$asSafely = false;
                        PsiElement psiElement3 = $this$asSafely$iv;
                        if (!(psiElement3 instanceof PsiField)) {
                            psiElement3 = null;
                        }
                        if ((psiElement2 = (PsiField)psiElement3) != null) break block10;
                    }
                    return;
                }
                javaField = psiElement2;
                psiElement = field.getJavaPsi();
                if (psiElement == null) break block11;
                PsiElement $this$asSafely$iv = psiElement;
                boolean $i$f$asSafely = false;
                PsiElement psiElement4 = $this$asSafely$iv;
                if (!(psiElement4 instanceof PsiField)) {
                    psiElement4 = null;
                }
                if ((psiElement = (PsiField)psiElement4) != null && (psiElement = psiElement.getType()) != null) break block12;
            }
            return;
        }
        PsiElement type = psiElement;
        if (!field.isStatic() && javaField.hasAnnotation("org.junit.jupiter.api.extension.RegisterExtension") && AnalysisUastUtilKt.isInheritorOf((PsiType)type, (String[])(stringArray = new String[]{"org.junit.jupiter.api.extension.BeforeAllCallback", "org.junit.jupiter.api.extension.AfterAllCallback"}))) {
            Object[] objectArray = new Object[]{type.getPresentableText()};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.extension.class.level.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            LocalQuickFix[] fixes = JvmActionUtilKt.createModifierQuickfixes((UDeclaration)((UDeclaration)field), (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.STATIC, (boolean)true, (boolean)false, (int)4, null));
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)field), (String)message, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length), null, (int)8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNoArg(UMethod $this$isNoArg) {
        boolean bl;
        if ($this$isNoArg.getUastParameters().isEmpty()) return true;
        Iterable $this$all$iv = $this$isNoArg.getUastParameters();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            UParameter param = (UParameter)element$iv;
            boolean bl2 = false;
            PsiElement psiElement = param.getJavaPsi();
            PsiElement psiElement2 = psiElement;
            if (psiElement == null) return false;
            PsiElement $this$asSafely$iv = psiElement2;
            boolean $i$f$asSafely = false;
            PsiElement psiElement3 = $this$asSafely$iv;
            if (!(psiElement3 instanceof PsiParameter)) {
                psiElement3 = null;
            }
            PsiParameter psiParameter = (PsiParameter)psiElement3;
            psiElement2 = psiParameter;
            if (psiParameter == null) return false;
            PsiElement it = psiElement2;
            boolean bl3 = false;
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)it), (Collection)this.ignorableAnnotations, (int)0)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private final boolean suspendModifierIsAllowed(UElement $this$suspendModifierIsAllowed) {
        JUnitVersion jUnitVersion = JunitLibrarySetupKt.getUJUnitVersion($this$suspendModifierIsAllowed);
        if (jUnitVersion == null) {
            return true;
        }
        JUnitVersion version = jUnitVersion;
        return version.compareTo(JUnitVersion.Companion.getV_6_X()) >= 0;
    }

    private final boolean isSuspendFunction(UMethod $this$isSuspendFunction) {
        if (!Intrinsics.areEqual((Object)$this$isSuspendFunction.getLang(), (Object)Language.findLanguageByID((String)"kotlin"))) {
            return false;
        }
        String string = $this$isSuspendFunction.getJavaPsi().getModifierList().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"suspend", (boolean)false, (int)2, null)) {
            return false;
        }
        UParameter uParameter = (UParameter)CollectionsKt.firstOrNull((List)$this$isSuspendFunction.getUastParameters());
        return Intrinsics.areEqual((Object)(uParameter != null && (uParameter = uParameter.getType()) != null ? uParameter.getCanonicalText() : null), (Object)COROUTINES_CONTINUATION_TYPE);
    }

    private final boolean checkSuspendFunction(UMethod method) {
        boolean bl;
        if (!this.suspendModifierIsAllowed((UElement)method) && this.isSuspendFunction(method)) {
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.suspend.function.descriptor", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)method), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkJUnit3Test(UMethod method) {
        UMethod uMethod;
        Object v1;
        Sequence alternatives;
        block9: {
            PsiElement psiElement = method.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            Class[] classArray = new Class[]{UMethod.class};
            Sequence $this$firstOrNull$iv = alternatives = UastFacade.INSTANCE.convertToAlternatives(sourcePsi, classArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UMethod it = (UMethod)element$iv;
                boolean bl = false;
                if (!it.isStatic()) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        if ((uMethod = (UMethod)v1) == null && (uMethod = (UMethod)SequencesKt.firstOrNull((Sequence)alternatives)) == null) {
            return;
        }
        UMethod javaMethod = uMethod;
        if (method.isConstructor()) {
            return;
        }
        if (!TestUtils.isJUnit3TestMethod((PsiMethod)javaMethod.getJavaPsi())) {
            return;
        }
        PsiClass psiClass = method.getJavaPsi().getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)"org.junit.runner.RunWith", (int)1)) {
            return;
        }
        if (this.checkSuspendFunction(method)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)method.getReturnType()) || method.getVisibility() != UastVisibility.PUBLIC || javaMethod.isStatic() || !this.isNoArg(method) && !this.isParameterizedTest(method)) {
            Object[] objectArray = new Object[]{"public", "non-static", 1};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.no.arg.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new MethodSignatureQuickfix(method.getName(), false, null, JvmModifier.PUBLIC, null, 20, null)};
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)method), (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
            return;
        }
    }

    private final boolean isParameterizedTest(UMethod $this$isParameterizedTest) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$isParameterizedTest.getUAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UAnnotation it = (UAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"org.junit.jupiter.params.ParameterizedTest")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final void checkedMalformedSetupTeardown(UMethod method) {
        UMethod uMethod;
        Object v1;
        Sequence alternatives;
        block7: {
            if (!Intrinsics.areEqual((Object)"setUp", (Object)method.getName()) && !Intrinsics.areEqual((Object)"tearDown", (Object)method.getName())) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)method.getJavaPsi().getContainingClass(), (String)"junit.framework.TestCase")) {
                return;
            }
            PsiElement psiElement = method.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            if (this.checkSuspendFunction(method)) {
                return;
            }
            Class[] classArray = new Class[]{UMethod.class};
            Sequence $this$firstOrNull$iv = alternatives = UastFacade.INSTANCE.convertToAlternatives(sourcePsi, classArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UMethod it = (UMethod)element$iv;
                boolean bl = false;
                if (!it.isStatic()) continue;
                v1 = element$iv;
                break block7;
            }
            v1 = null;
        }
        if ((uMethod = (UMethod)v1) == null && (uMethod = (UMethod)SequencesKt.firstOrNull((Sequence)alternatives)) == null) {
            return;
        }
        UMethod javaMethod = uMethod;
        if (!Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)method.getReturnType()) || method.getVisibility() == UastVisibility.PRIVATE || javaMethod.isStatic() || !this.isNoArg(method)) {
            Object object = new Object[]{"non-private", "non-static", 1};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.no.arg.descriptor", object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            object = method.getName();
            Iterator iterator = JvmModifier.PUBLIC;
            Map map = MapsKt.emptyMap();
            MethodSignatureQuickfix quickFix = new MethodSignatureQuickfix((String)object, false, true, (JvmModifier)iterator, map);
            object = new LocalQuickFix[]{quickFix};
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)method), (String)message, (LocalQuickFix[])object, null, (int)8, null);
            return;
        }
    }

    private final void checkSuite(UMethod method) {
        UMethod uMethod;
        Object v1;
        Sequence alternatives;
        block7: {
            if (!Intrinsics.areEqual((Object)"suite", (Object)method.getName())) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)method.getJavaPsi().getContainingClass(), (String)"junit.framework.TestCase")) {
                return;
            }
            PsiElement psiElement = method.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            if (this.checkSuspendFunction(method)) {
                return;
            }
            Class[] classArray = new Class[]{UMethod.class};
            Sequence $this$firstOrNull$iv = alternatives = UastFacade.INSTANCE.convertToAlternatives(sourcePsi, classArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UMethod it = (UMethod)element$iv;
                boolean bl = false;
                if (!it.isStatic()) continue;
                v1 = element$iv;
                break block7;
            }
            v1 = null;
        }
        if ((uMethod = (UMethod)v1) == null && (uMethod = (UMethod)SequencesKt.firstOrNull((Sequence)alternatives)) == null) {
            return;
        }
        UMethod javaMethod = uMethod;
        if (method.getVisibility() == UastVisibility.PRIVATE || !javaMethod.isStatic() || !this.isNoArg(method)) {
            Object object = new Object[]{"non-private", "static", 0};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.no.arg.descriptor", object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            object = method.getName();
            Iterator iterator = JvmModifier.PUBLIC;
            Map map = MapsKt.emptyMap();
            MethodSignatureQuickfix quickFix = new MethodSignatureQuickfix((String)object, true, false, (JvmModifier)iterator, map);
            object = new LocalQuickFix[]{quickFix};
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)method), (String)message, (LocalQuickFix[])object, null, (int)8, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIllegalCombinedAnnotations(UDeclaration decl) {
        void $this$filterTo$iv$iv;
        PsiElement $this$asSafely$iv = decl.getJavaPsi();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiModifierListOwner)) {
            psiElement = null;
        }
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)psiElement;
        if (psiModifierListOwner == null) {
            return;
        }
        PsiModifierListOwner javaPsi = psiModifierListOwner;
        Iterable $this$filter$iv = nonCombinedTests;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)javaPsi, (Collection)CollectionsKt.listOf((Object)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List annotatedTest = (List)destination$iv$iv;
        if (annotatedTest.size() > 1) {
            String last = StringsKt.substringAfterLast$default((String)((String)CollectionsKt.last((List)annotatedTest)), (char)'.', null, (int)2, null);
            String annText = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)annotatedTest, (int)1), null, null, null, (int)0, null, JUnitMalformedSignatureVisitor::checkIllegalCombinedAnnotations$lambda$39, (int)31, null);
            Object[] $i$f$filterTo2 = new Object[]{annText, last};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.test.combination.descriptor", $i$f$filterTo2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)decl, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            return;
        }
        if (annotatedTest.size() == 1 && !Intrinsics.areEqual((Object)CollectionsKt.first((List)annotatedTest), (Object)"org.junit.jupiter.params.ParameterizedTest")) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = parameterizedSources;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)javaPsi, (Collection)CollectionsKt.listOf((Object)it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List annotatedArgSource = (List)destination$iv$iv2;
            if (!((Collection)annotatedArgSource).isEmpty()) {
                String testAnnText = StringsKt.substringAfterLast$default((String)((String)CollectionsKt.first((List)annotatedTest)), (char)'.', null, (int)2, null);
                String argAnnText = CollectionsKt.joinToString$default((Iterable)annotatedArgSource, null, null, null, (int)0, null, JUnitMalformedSignatureVisitor::checkIllegalCombinedAnnotations$lambda$41, (int)31, null);
                Object[] objectArray = new Object[]{argAnnText, testAnnText};
                String string = JUnitBundle.message("jvm.inspections.junit.malformed.test.combination.descriptor", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)decl, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                return;
            }
        }
    }

    private final void checkRepeatedTestNonPositive(UMethod method) {
        UAnnotation uAnnotation = method.findAnnotation("org.junit.jupiter.api.RepeatedTest");
        if (uAnnotation == null) {
            return;
        }
        UAnnotation repeatedAnno = uAnnotation;
        UExpression uExpression = repeatedAnno.findDeclaredAttributeValue("value");
        if (uExpression == null) {
            return;
        }
        UExpression repeatedNumber = uExpression;
        PsiElement psiElement = repeatedNumber.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement repeatedSrcPsi = psiElement;
        Object constant = repeatedNumber.evaluate();
        if (constant instanceof Integer && ((Number)constant).intValue() <= 0) {
            this.holder.registerProblem(repeatedSrcPsi, JUnitBundle.message("jvm.inspections.junit.malformed.repetition.number.descriptor", new Object[0]), new LocalQuickFix[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkMalformedParameterized(UMethod method) {
        if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method.getJavaPsi()), (Collection)CollectionsKt.listOf((Object)"org.junit.jupiter.params.ParameterizedTest"))) {
            return;
        }
        usedSourceAnnotations = MetaAnnotationUtil.findMetaAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method.getJavaPsi()), (Collection)JUnitCommonClassNames.SOURCE_ANNOTATIONS).toList();
        Intrinsics.checkNotNull(usedSourceAnnotations);
        this.checkConflictingSourceAnnotations(usedSourceAnnotations, method);
        $this$forEach$iv = usedSourceAnnotations;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block16: {
                block17: {
                    block20: {
                        block18: {
                            block19: {
                                annotation = (PsiAnnotation)element$iv;
                                $i$a$-forEach-JUnitMalformedSignatureVisitor$checkMalformedParameterized$1 = false;
                                var9_9 = annotation.getQualifiedName();
                                if (var9_9 == null) continue;
                                switch (var9_9.hashCode()) {
                                    case -2084799780: {
                                        if (var9_9.equals("org.junit.jupiter.params.provider.ValueSource")) break;
                                        ** break;
                                    }
                                    case 935951080: {
                                        if (!var9_9.equals("org.junit.jupiter.params.provider.NullAndEmptySource")) {
                                            ** break;
                                        }
                                        break block16;
                                    }
                                    case 522918328: {
                                        if (!var9_9.equals("org.junit.jupiter.params.provider.EmptySource")) {
                                            ** break;
                                        }
                                        break block17;
                                    }
                                    case 2141896013: {
                                        if (!var9_9.equals("org.junit.jupiter.params.provider.CsvFileSource")) {
                                            ** break;
                                        }
                                        break block18;
                                    }
                                    case -1320765300: {
                                        if (!var9_9.equals("org.junit.jupiter.params.provider.EnumSource")) {
                                            ** break;
                                        }
                                        break block19;
                                    }
                                    case 2045373586: {
                                        if (!var9_9.equals("org.junit.jupiter.params.provider.NullSource")) {
                                            ** break;
                                        }
                                        break block20;
                                    }
                                    case 2129905772: {
                                        if (!var9_9.equals("org.junit.jupiter.params.provider.MethodSource")) ** break;
                                        Intrinsics.checkNotNull((Object)annotation);
                                        this.checkMethodSource(method, annotation);
                                        ** break;
                                    }
                                }
                                Intrinsics.checkNotNull((Object)annotation);
                                this.checkValuesSource(method, annotation);
                                ** break;
                            }
                            Intrinsics.checkNotNull((Object)annotation);
                            this.checkEnumSource(method, annotation);
                            ** break;
                        }
                        Intrinsics.checkNotNull((Object)annotation);
                        this.checkCsvSource(annotation);
                        ** break;
                    }
                    Intrinsics.checkNotNull((Object)annotation);
                    this.checkNullSource(method, annotation);
                    ** break;
                }
                Intrinsics.checkNotNull((Object)annotation);
                this.checkEmptySource(method, annotation);
                ** break;
            }
            Intrinsics.checkNotNull((Object)annotation);
            this.checkNullSource(method, annotation);
            this.checkEmptySource(method, annotation);
lbl65:
            // 15 sources

        }
    }

    private final void checkConflictingSourceAnnotations(List<? extends PsiAnnotation> annotations, UMethod method) {
        boolean isMultipleParameterProvider;
        Object v1;
        boolean isSingleParameterProvider;
        PsiAnnotation firstSingleParameterProvider;
        block9: {
            Object v0;
            block8: {
                Iterable $this$firstOrNull$iv = annotations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiAnnotation ann = (PsiAnnotation)element$iv;
                    boolean bl = false;
                    if (!CollectionsKt.contains((Iterable)singleParamProviders, (Object)ann.getQualifiedName())) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            firstSingleParameterProvider = v0;
            isSingleParameterProvider = firstSingleParameterProvider != null;
            Iterable $this$firstOrNull$iv = annotations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiAnnotation ann = (PsiAnnotation)element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)multipleParameterProviders, (Object)ann.getQualifiedName())) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        PsiAnnotation firstMultipleParameterProvider = v1;
        boolean bl = isMultipleParameterProvider = firstMultipleParameterProvider != null;
        if (!isMultipleParameterProvider && !isSingleParameterProvider && this.hasCustomProvider(annotations)) {
            return;
        }
        if (!isMultipleParameterProvider) {
            String string;
            if (!isSingleParameterProvider) {
                string = JUnitBundle.message("jvm.inspections.junit.malformed.param.no.sources.are.provided.descriptor", new Object[0]);
            } else if (this.hasMultipleParameters(method.getJavaPsi())) {
                Object[] objectArray = new Object[]{this.getShortName(firstSingleParameterProvider)};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.param.multiple.parameters.descriptor", objectArray);
            } else {
                return;
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            Object message = string2;
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)((UDeclaration)method), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        }
    }

    private final boolean hasCustomProvider(List<? extends PsiAnnotation> annotations) {
        block4: for (PsiAnnotation psiAnnotation : annotations) {
            String string = psiAnnotation.getQualifiedName();
            if (string == null) continue;
            switch (string.hashCode()) {
                case -2080918126: {
                    if (string.equals("org.junit.jupiter.params.provider.ArgumentsSources")) break;
                    continue block4;
                }
                case -205673727: {
                    if (!string.equals("org.junit.jupiter.params.provider.ArgumentsSource")) continue block4;
                    return true;
                }
            }
            PsiAnnotationMemberValue attributes = psiAnnotation.findAttributeValue("value");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = attributes instanceof PsiArrayInitializerMemberValue ? (PsiAnnotationMemberValue[])attributes : null;
            boolean bl = psiAnnotationMemberValueArray != null && (psiAnnotationMemberValueArray = psiAnnotationMemberValueArray.getInitializers()) != null ? !(psiAnnotationMemberValueArray.length == 0) : false;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMethodSource(UMethod method, PsiAnnotation methodSource) {
        PsiMethod psiMethod = method.getJavaPsi();
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        List annotationMemberValue = AnalysisUastUtilKt.flattenedAttributeValues((PsiAnnotation)methodSource, (String)"value");
        if (annotationMemberValue.isEmpty()) {
            Object object;
            block14: {
                if (methodSource.findAttributeValue("value") == null) {
                    return;
                }
                PsiMethod[] psiMethodArray = containingClass.findMethodsByName(method.getName(), true);
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
                Object[] $this$singleOrNull$iv = psiMethodArray;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    PsiMethod it = (PsiMethod)element$iv;
                    boolean bl = false;
                    JvmParameter[] jvmParameterArray = it.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
                    boolean bl2 = ((Object[])jvmParameterArray).length == 0;
                    if (!bl2) continue;
                    if (found$iv) {
                        object = null;
                        break block14;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                object = !found$iv ? null : single$iv;
            }
            PsiMethod foundMethod = (PsiMethod)object;
            PsiElement $this$toUElementOfType$iv = (PsiElement)foundMethod;
            boolean $i$f$toUElementOfType = false;
            UMethod uFoundMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uFoundMethod != null) {
                this.checkSourceProvider(uFoundMethod, containingClass, (PsiElement)methodSource, method);
            } else {
                this.checkAbsentSourceProvider(containingClass, (PsiElement)methodSource, method.getName(), method);
            }
            return;
        }
        Iterable $this$forEach$iv = annotationMemberValue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiAnnotationMemberValue attributeValue = (PsiAnnotationMemberValue)element$iv;
            boolean bl = false;
            for (PsiReference reference : attributeValue.getReferences()) {
                PsiMethodSourceResolveResult sourceProvider;
                block15: {
                    PsiMethodSourceResolveResult psiMethodSourceResolveResult;
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    ResolveResult[] sourceProviders;
                    if (!(reference instanceof MethodSourceReference)) continue;
                    ResolveResult[] resolveResultArray = sourceProviders = ((MethodSourceReference)reference).multiResolve(false);
                    boolean $i$f$mapNotNull = false;
                    void var19_32 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        PsiMethodSourceResolveResult it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                        boolean bl3 = false;
                        void it = element$iv$iv;
                        boolean bl4 = false;
                        if ((it instanceof PsiMethodSourceResolveResult ? (PsiMethodSourceResolveResult)it : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    for (PsiMethodSourceResolveResult it : (Iterable)((List)destination$iv$iv)) {
                        boolean bl6 = false;
                        PsiClass psiClass2 = method.getJavaPsi().getContainingClass();
                        if (psiClass2 == null) {
                            return;
                        }
                        if ((it = this.getSourceMethodForClass(it, psiClass2)) == null) continue;
                        psiMethodSourceResolveResult = it;
                        break block15;
                    }
                    psiMethodSourceResolveResult = sourceProvider = null;
                }
                if (sourceProvider == null) {
                    PsiElement psiElement = (PsiElement)attributeValue;
                    String string = ((MethodSourceReference)reference).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    this.checkAbsentSourceProvider(containingClass, psiElement, string, method);
                    return;
                }
                PsiElement $this$toUElementOfType$iv = (PsiElement)sourceProvider;
                boolean $i$f$toUElementOfType = false;
                UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                if (uMethod == null) {
                    return;
                }
                UMethod uSourceProvider = uMethod;
                this.checkSourceProvider(uSourceProvider, containingClass, (PsiElement)attributeValue, method);
                return;
            }
        }
    }

    private final PsiMethod getSourceMethodForClass(PsiMethodSourceResolveResult $this$getSourceMethodForClass, PsiClass owner) {
        PsiElement psiElement = $this$getSourceMethodForClass.getElement();
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        if ($this$getSourceMethodForClass.getOwners().isEmpty()) {
            return method;
        }
        return owner.findMethodBySignature(method, true);
    }

    private final void checkAbsentSourceProvider(PsiClass containingClass, PsiElement attributeValue, String sourceProviderName, UMethod method) {
        PsiElement psiElement;
        PsiElement psiElement2;
        if (containingClass.isInterface() || PsiUtil.isAbstractClass((PsiClass)containingClass)) {
            return;
        }
        if (PsiTreeUtilKt.isAncestor((PsiElement)((PsiElement)method.getJavaPsi()), (PsiElement)attributeValue, (boolean)true)) {
            psiElement2 = attributeValue;
        } else {
            PsiIdentifier psiIdentifier = method.getJavaPsi().getNameIdentifier();
            psiElement2 = psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)method.getJavaPsi();
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)psiElement2);
        if (uElement == null || (psiElement = uElement.getSourcePsi()) == null) {
            return;
        }
        PsiElement place = psiElement;
        Object[] objectArray = new Object[]{sourceProviderName};
        String string = JUnitBundle.message("jvm.inspections.junit.malformed.param.method.source.unresolved.descriptor", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        if (this.isOnTheFly) {
            objectArray = new JvmModifier[]{JvmModifier.PUBLIC};
            List modifiers = CollectionsKt.mutableListOf((Object[])objectArray);
            if (!TestUtils.testInstancePerClass((PsiClass)containingClass)) {
                modifiers.add(JvmModifier.STATIC);
            }
            PsiType psiType = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createTypeFromText(METHOD_SOURCE_RETURN_TYPE, (PsiElement)containingClass);
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"createTypeFromText(...)");
            PsiType typeFromText = psiType;
            Project project = containingClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            CreateMethodRequest request = MethodRequestsKt.methodRequest((Project)project, (String)sourceProviderName, (List)modifiers, (JvmType)((JvmType)typeFromText));
            List actions = JvmElementActionFactories.createMethodActions((JvmClass)((JvmClass)containingClass), (CreateMethodRequest)request);
            List list = IntentionWrapper.wrapToQuickFixes((List)actions, (PsiFile)containingClass.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wrapToQuickFixes(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] quickFixes = thisCollection$iv.toArray(new LocalQuickFix[0]);
            this.holder.registerProblem(place, message, Arrays.copyOf(quickFixes, quickFixes.length));
        } else {
            this.holder.registerProblem(place, message, new LocalQuickFix[0]);
        }
    }

    private final void checkSourceProvider(UMethod sourceProvider, PsiClass containingClass, PsiElement attributeValue, UMethod method) {
        PsiElement psiElement;
        PsiElement psiElement2;
        if (PsiTreeUtilKt.isAncestor((PsiElement)((PsiElement)method.getJavaPsi()), (PsiElement)attributeValue, (boolean)true)) {
            psiElement2 = attributeValue;
        } else {
            PsiIdentifier psiIdentifier = method.getJavaPsi().getNameIdentifier();
            psiElement2 = psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)method.getJavaPsi();
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)psiElement2);
        if (uElement == null || (psiElement = uElement.getSourcePsi()) == null) {
            return;
        }
        PsiElement place = psiElement;
        String providerName = sourceProvider.getName();
        if (!(sourceProvider.isStatic() || containingClass == null || TestUtils.testInstancePerClass((PsiClass)containingClass) || this.implementationsTestInstanceAnnotated(containingClass))) {
            PsiAnnotation psiAnnotation = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createAnnotationFromText(TEST_INSTANCE_PER_CLASS, (PsiElement)containingClass);
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"createAnnotationFromText(...)");
            PsiAnnotation annotation = psiAnnotation;
            List actions = new ArrayList();
            List list = annotation.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
            Object object = CollectionsKt.first((List)list);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl");
            PsiAnnotationMemberValue value = ((PsiNameValuePairImpl)object).getValue();
            if (value != null) {
                JvmModifiersOwner jvmModifiersOwner = (JvmModifiersOwner)containingClass;
                AnnotationAttributeRequest[] annotationAttributeRequestArray = new AnnotationAttributeRequest[1];
                String string = value.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                annotationAttributeRequestArray[0] = AnnotationAttributeValueRequestKt.constantAttribute((String)"value", (String)string);
                actions.addAll(JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)jvmModifiersOwner, (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)"org.junit.jupiter.api.TestInstance", (AnnotationAttributeRequest[])annotationAttributeRequestArray)));
            }
            actions.addAll(JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((JvmModifiersOwner)sourceProvider), (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.STATIC, (boolean)true, (boolean)false, (int)4, null)));
            List list2 = IntentionWrapper.wrapToQuickFixes((List)actions, (PsiFile)sourceProvider.getJavaPsi().getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"wrapToQuickFixes(...)");
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] quickFixes = thisCollection$iv.toArray(new LocalQuickFix[0]);
            Object[] objectArray = new Object[]{providerName};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.param.method.source.static.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            this.holder.registerProblem(place, message, Arrays.copyOf(quickFixes, quickFixes.length));
        } else if (!((Collection)sourceProvider.getUastParameters()).isEmpty() && !this.classHasParameterResolverField(containingClass)) {
            Object[] objectArray = new Object[]{providerName};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.param.method.source.no.params.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            this.holder.registerProblem(place, message, new LocalQuickFix[0]);
        } else {
            PsiType componentType = this.getComponentType(sourceProvider.getReturnType(), method.getJavaPsi());
            if (componentType == null) {
                Object[] objectArray = new Object[]{providerName};
                String string = JUnitBundle.message("jvm.inspections.junit.malformed.param.method.source.return.type.descriptor", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                this.holder.registerProblem(place, message, new LocalQuickFix[0]);
            } else if (this.hasMultipleParameters(method.getJavaPsi()) && !InheritanceUtil.isInheritor((PsiType)componentType, (String)"org.junit.jupiter.params.provider.Arguments") && !componentType.equalsToText("java.lang.Object") && !componentType.getDeepComponentType().equalsToText("java.lang.Object")) {
                String string = JUnitBundle.message("jvm.inspections.junit.malformed.param.wrapped.in.arguments.descriptor", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                this.holder.registerProblem(place, message, new LocalQuickFix[0]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean classHasParameterResolverField(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        if (aClass.isInterface()) {
            return false;
        }
        PsiField[] psiFieldArray = aClass.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
        Object[] $this$any$iv = psiFieldArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            PsiField field = (PsiField)element$iv;
            boolean bl = false;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)field), (String)"org.junit.jupiter.api.extension.RegisterExtension", (int)0)) {
                PsiType psiType = field.getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                String[] stringArray = new String[]{"org.junit.jupiter.api.extension.ParameterResolver"};
                if (AnalysisUastUtilKt.isInheritorOf((PsiType)psiType, (String[])stringArray)) {
                    return true;
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean implementationsTestInstanceAnnotated(PsiClass containingClass) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)((SearchScope)containingClass.getResolveScope()), (boolean)true).asIterable();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl2 = false;
                    if (!TestUtils.testInstancePerClass((PsiClass)it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final PsiType getComponentType(PsiType returnType, PsiMethod method) {
        PsiType streamItemType;
        PsiType collectionItemType;
        PsiType psiType = collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)returnType, (GlobalSearchScope)method.getResolveScope());
        if (psiType != null) {
            return psiType;
        }
        if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.IntStream")) {
            return (PsiType)PsiTypes.intType();
        }
        if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.LongStream")) {
            return (PsiType)PsiTypes.longType();
        }
        if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.DoubleStream")) {
            return (PsiType)PsiTypes.doubleType();
        }
        PsiType psiType2 = streamItemType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.stream.Stream", (int)0, (boolean)true);
        if (psiType2 != null) {
            return psiType2;
        }
        return PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.Iterator", (int)0, (boolean)true);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasMultipleParameters(PsiMethod method) {
        containingClass = method.getContainingClass();
        if (containingClass == null) ** GOTO lbl-1000
        v0 = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getParameters(...)");
        $this$count$iv = v0;
        $i$f$count = false;
        count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            param = (PsiParameter)element$iv;
            $i$a$-count-JUnitMalformedSignatureVisitor$hasMultipleParameters$1 = false;
            if (InheritanceUtil.isInheritor((PsiType)param.getType(), (String)"org.junit.jupiter.api.TestInfo") || InheritanceUtil.isInheritor((PsiType)param.getType(), (String)"org.junit.jupiter.api.TestReporter")) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)param);
            if (!this.inParameterResolverContext((PsiModifierListOwner)param) && !MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)param), (Collection)this.ignorableAnnotations)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            ++count$iv;
        }
        if (count$iv > 1 && !this.inParameterResolverContext((PsiModifierListOwner)containingClass)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        return v2;
    }

    private final PsiParameter getPassedParameter(PsiMethod method) {
        Object object;
        block1: {
            PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
            Object[] $this$firstOrNull$iv = psiParameterArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiParameter param = (PsiParameter)element$iv;
                boolean bl = false;
                if (!(!InheritanceUtil.isInheritor((PsiType)param.getType(), (String)"org.junit.jupiter.api.TestInfo") && !InheritanceUtil.isInheritor((PsiType)param.getType(), (String)"org.junit.jupiter.api.TestReporter") && !MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)param), (Collection)this.ignorableAnnotations))) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (PsiParameter)object;
    }

    private final void checkNullSource(UMethod method, PsiAnnotation annotation) {
        String message;
        Object[] objectArray;
        if (this.hasMultipleParameters(method.getJavaPsi())) {
            objectArray = new Object[]{this.getShortName(annotation)};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.param.multiple.parameters.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            message = string;
            this.holder.registerProblem((PsiElement)annotation, message, new LocalQuickFix[0]);
        }
        if (this.getPassedParameter(method.getJavaPsi()) == null) {
            objectArray = new Object[]{this.getShortName(annotation)};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.source.without.params.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            message = string;
            this.holder.registerProblem(annotation.getNavigationElement(), message, new LocalQuickFix[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEmptySource(UMethod method, PsiAnnotation annotation) {
        if (this.hasMultipleParameters(method.getJavaPsi())) {
            Object[] objectArray = new Object[]{this.getShortName(annotation)};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.param.multiple.parameters.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            this.holder.registerProblem(annotation.getNavigationElement(), message, new LocalQuickFix[0]);
            return;
        }
        PsiParameter passedParameter = this.getPassedParameter(method.getJavaPsi());
        if (passedParameter == null) {
            Object[] objectArray = new Object[]{this.getShortName(annotation)};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.source.without.params.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            this.holder.registerProblem(annotation.getNavigationElement(), message, new LocalQuickFix[0]);
        } else {
            PsiType psiType = passedParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            PsiType type = psiType;
            if (type instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type).resolve();
                if (psiClass == null) {
                    return;
                }
                PsiClass psiClass2 = psiClass;
                JUnitVersion jUnitVersion = JunitLibrarySetupKt.getUJUnitVersion((UElement)method);
                if (jUnitVersion == null) {
                    return;
                }
                JUnitVersion version = jUnitVersion;
                if (version.compareTo(JUnitVersion.Companion.getV_5_10_0()) < 0) {
                    boolean bl;
                    block23: {
                        $this$any$iv = validEmptySourceTypeBefore510;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)psiClass2.getQualifiedName())) continue;
                                bl = true;
                                break block23;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return;
                    }
                } else {
                    boolean isCollectionOrMap;
                    void $this$mapNotNullTo$iv$iv;
                    Object element$iv2;
                    boolean bl;
                    block24: {
                        $this$any$iv = validEmptySourceTypeAfter510;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                String it = (String)element$iv2;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)psiClass2.getQualifiedName())) continue;
                                bl = true;
                                break block24;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return;
                    }
                    PsiMethod[] psiMethodArray = psiClass2.getConstructors();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
                    Object[] $this$mapNotNull$iv = psiMethodArray;
                    boolean $i$f$mapNotNull = false;
                    element$iv2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        UMethod it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                        boolean bl4 = false;
                        PsiMethod it = (PsiMethod)element$iv$iv;
                        boolean bl5 = false;
                        PsiElement $this$toUElementOfType$iv = (PsiElement)it;
                        boolean $i$f$toUElementOfType = false;
                        if ((UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class) == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List constructors = (List)destination$iv$iv;
                    boolean bl7 = isCollectionOrMap = InheritanceUtil.isInheritor((PsiClass)psiClass2, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)psiClass2, (String)"java.util.Map");
                    if (isCollectionOrMap) {
                        boolean bl8;
                        block25: {
                            Iterable $this$any$iv = constructors;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl8 = false;
                            } else {
                                for (Object element$iv3 : $this$any$iv) {
                                    UMethod it = (UMethod)element$iv3;
                                    boolean bl9 = false;
                                    if (!(it.getVisibility() == UastVisibility.PUBLIC && this.isNoArg(it))) continue;
                                    bl8 = true;
                                    break block25;
                                }
                                bl8 = false;
                            }
                        }
                        if (bl8) {
                            return;
                        }
                    }
                }
            }
            if (type instanceof PsiArrayType) {
                return;
            }
            Object[] objectArray = new Object[]{this.getShortName(annotation), type.getPresentableText()};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.param.empty.source.unsupported.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            this.holder.registerProblem(annotation.getNavigationElement(), message, new LocalQuickFix[0]);
        }
    }

    private final void checkEnumSource(UMethod method, PsiAnnotation enumSource) {
        PsiAnnotationMemberValue value = enumSource.findAttributeValue("value");
        if (!(value instanceof PsiClassObjectAccessExpression)) {
            return;
        }
        PsiType psiType = ((PsiClassObjectAccessExpression)value).getOperand().getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType enumType = psiType;
        this.checkSourceTypeAndParameterTypeAgree(method, value, enumType);
        this.checkEnumConstants(enumSource, enumType, method);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkSourceTypeAndParameterTypeAgree(UMethod method, PsiAnnotationMemberValue attributeValue, PsiType componentType) {
        block21: {
            block23: {
                block22: {
                    block20: {
                        parameters = method.getUastParameters();
                        if (parameters.size() != 1 || (paramType = ((UParameter)CollectionsKt.first((List)parameters)).getType()).isAssignableFrom(componentType) || InheritanceUtil.isInheritor((PsiType)componentType, (String)"org.junit.jupiter.params.provider.Arguments")) break block21;
                        if (!componentType.equalsToText("java.lang.String")) break block22;
                        if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)paramType)) {
                            return;
                        }
                        psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType);
                        if (psiClass == null) break block23;
                        if (psiClass.isEnum()) {
                            Intrinsics.checkNotNull((Object)attributeValue, (String)"null cannot be cast to non-null type com.intellij.psi.PsiLiteral");
                            if (psiClass.findFieldByName((String)((PsiLiteral)attributeValue).getValue(), false) != null) {
                                return;
                            }
                        }
                        if ((qualifiedName = psiClass.getQualifiedName()) != null) {
                            if (StringsKt.startsWith$default((String)qualifiedName, (String)"java.time.", (boolean)false, (int)2, null)) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)qualifiedName, (Object)"java.nio.file.Path")) {
                                return;
                            }
                        }
                        factoryMethod = (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, checkSourceTypeAndParameterTypeAgree$lambda$57(com.intellij.psi.PsiMethod ), (Lcom/intellij/psi/PsiMethod;)Ljava/lang/Boolean;)();
                        if (!psiClass.hasModifier(JvmModifier.ABSTRACT)) {
                            block19: {
                                v0 = psiClass.getConstructors();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getConstructors(...)");
                                for (PsiElement var13_13 : (PsiElement)v0) {
                                    if (!((Boolean)factoryMethod.invoke((Object)var13_13)).booleanValue()) continue;
                                    v1 = var13_13;
                                    break block19;
                                }
                                v1 = null;
                            }
                            if (v1 != null) {
                                return;
                            }
                        }
                        v2 = psiClass.getMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getMethods(...)");
                        var10_9 = v2;
                        var12_12 = ((Object[])var10_9).length;
                        for (var11_10 = 0; var11_10 < var12_12; ++var11_10) {
                            var13_13 = var10_9[var11_10];
                            it = (PsiMethod)var13_13;
                            $i$a$-find-JUnitMalformedSignatureVisitor$checkSourceTypeAndParameterTypeAgree$1 = false;
                            if (!it.hasModifier(JvmModifier.STATIC)) ** GOTO lbl-1000
                            Intrinsics.checkNotNull((Object)it);
                            if (((Boolean)factoryMethod.invoke((Object)it)).booleanValue()) {
                                v3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = false;
                            }
                            if (!v3) continue;
                            v4 = var13_13;
                            break block20;
                        }
                        v4 = null;
                    }
                    if (v4 != null) {
                        return;
                    }
                    break block23;
                }
                if (componentType.equalsToText("org.junit.jupiter.params.provider.NullEnum") && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType)) != null && psiClass.isEnum()) {
                    return;
                }
            }
            param = (UParameter)CollectionsKt.first((List)parameters);
            v5 = param.getSourcePsi();
            Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
            default = (PsiNameIdentifierOwner)v5;
            if (PsiTreeUtilKt.isAncestor((PsiElement)((PsiElement)method.getJavaPsi()), (PsiElement)((PsiElement)attributeValue), (boolean)true)) {
                v6 = (PsiElement)attributeValue;
            } else {
                v6 = default.getNameIdentifier();
                if (v6 == null) {
                    v6 = (PsiElement)default;
                }
            }
            var9_16 = UastContextKt.toUElement((PsiElement)v6);
            if (var9_16 == null || (var10_9 = var9_16.getSourcePsi()) == null) {
                return;
            }
            place = var10_9;
            if (param.findAnnotation("org.junit.jupiter.params.converter.ConvertWith") != null) {
                return;
            }
            var11_11 = new Object[]{componentType.getPresentableText(), paramType.getPresentableText()};
            v7 = JUnitBundle.message("jvm.inspections.junit.malformed.param.method.source.assignable.descriptor", var11_11);
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"message(...)");
            message = v7;
            this.holder.registerProblem(place, message, new LocalQuickFix[0]);
        }
    }

    private final void checkValuesSource(UMethod method, PsiAnnotation valuesSource) {
        String string;
        PsiElement psiElement;
        PsiMethod psiMethod = method.getJavaPsi();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"strings", (Object)PsiType.getJavaLangString((PsiManager)psiMethod.getManager(), (GlobalSearchScope)psiMethod.getResolveScope())), TuplesKt.to((Object)"ints", (Object)PsiTypes.intType()), TuplesKt.to((Object)"longs", (Object)PsiTypes.longType()), TuplesKt.to((Object)"doubles", (Object)PsiTypes.doubleType()), TuplesKt.to((Object)"shorts", (Object)PsiTypes.shortType()), TuplesKt.to((Object)"bytes", (Object)PsiTypes.byteType()), TuplesKt.to((Object)"floats", (Object)PsiTypes.floatType()), TuplesKt.to((Object)"chars", (Object)PsiTypes.charType()), TuplesKt.to((Object)"booleans", (Object)PsiTypes.booleanType()), TuplesKt.to((Object)"classes", (Object)PsiType.getJavaLangClass((PsiManager)psiMethod.getManager(), (GlobalSearchScope)psiMethod.getResolveScope()))};
        Map possibleValues = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$forEach$iv = possibleValues.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String valueKey = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = AnalysisUastUtilKt.flattenedAttributeValues((PsiAnnotation)valuesSource, (String)valueKey);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiType it;
                PsiAnnotationMemberValue value = (PsiAnnotationMemberValue)element$iv2;
                boolean bl2 = false;
                if ((PsiType)possibleValues.get(valueKey) == null) continue;
                boolean bl3 = false;
                this.checkSourceTypeAndParameterTypeAgree(method, value, it);
            }
        }
        int attributesNumber = valuesSource.getParameterList().getAttributes().length;
        if (PsiTreeUtilKt.isAncestor((PsiElement)((PsiElement)method.getJavaPsi()), (PsiElement)((PsiElement)valuesSource), (boolean)true)) {
            psiElement = (PsiElement)valuesSource;
        } else {
            PsiIdentifier psiIdentifier = method.getJavaPsi().getNameIdentifier();
            psiElement = psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)method.getJavaPsi();
        }
        PsiElement $this$toUElementOfType$iv = psiElement;
        boolean $i$f$toUElementOfType = false;
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UAnnotation.class);
        if (uAnnotation == null) {
            return;
        }
        UAnnotation annotation = uAnnotation;
        if (attributesNumber == 0) {
            string = JUnitBundle.message("jvm.inspections.junit.malformed.param.no.value.source.is.defined.descriptor", new Object[0]);
        } else if (attributesNumber > 1) {
            string = JUnitBundle.message("jvm.inspections.junit.malformed.param.exactly.one.type.of.input.must.be.provided.descriptor", new Object[0]);
        } else {
            return;
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String message = string2;
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UAnchorOwner)((UAnchorOwner)annotation), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEnumConstants(PsiAnnotation enumSource, PsiType enumType, UMethod method) {
        PsiAnnotationMemberValue mode = enumSource.findAttributeValue("mode");
        UElement uMode = UastContextKt.toUElement((PsiElement)((PsiElement)mode));
        if (uMode instanceof UReferenceExpression && (Intrinsics.areEqual((Object)"INCLUDE", (Object)((UReferenceExpression)uMode).getResolvedName()) || Intrinsics.areEqual((Object)"EXCLUDE", (Object)((UReferenceExpression)uMode).getResolvedName()))) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            List parameters;
            PsiType validType = enumType;
            if (Intrinsics.areEqual((Object)enumType.getCanonicalText(), (Object)"org.junit.jupiter.params.provider.NullEnum") && !((Collection)(parameters = method.getUastParameters())).isEmpty()) {
                validType = ((UParameter)CollectionsKt.first((List)parameters)).getType();
            }
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)validType);
            if (psiClass == null) {
                return;
            }
            PsiField[] psiFieldArray = psiClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            Object[] objectArray = psiFieldArray;
            boolean $i$f$filterIsInstance = false;
            void var10_11 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (PsiEnumConstant element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiEnumConstant)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiEnumConstant element$iv$iv;
                element$iv$iv = (PsiEnumConstant)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            Set allEnumConstants = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Set definedConstants = new LinkedHashSet();
            Iterable $this$forEach$iv = AnalysisUastUtilKt.flattenedAttributeValues((PsiAnnotation)enumSource, (String)"names");
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                Object object;
                UElement bl;
                PsiElement psiElement;
                Object value;
                PsiAnnotationMemberValue name = (PsiAnnotationMemberValue)element$iv;
                boolean bl2 = false;
                if (!(name instanceof PsiLiteralExpression) || !((value = ((PsiLiteralExpression)name).getValue()) instanceof String)) continue;
                if (PsiTreeUtilKt.isAncestor((PsiElement)((PsiElement)method.getJavaPsi()), (PsiElement)((PsiElement)name), (boolean)true)) {
                    psiElement = (PsiElement)name;
                } else {
                    PsiIdentifier psiIdentifier = method.getJavaPsi().getNameIdentifier();
                    psiElement = psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)method.getJavaPsi();
                }
                if ((bl = UastContextKt.toUElement((PsiElement)psiElement)) == null || (object = bl.getSourcePsi()) == null) continue;
                PsiElement sourcePsi = object;
                if (!allEnumConstants.contains(value)) {
                    string = JUnitBundle.message("jvm.inspections.junit.malformed.param.unresolved.enum.descriptor", new Object[0]);
                } else {
                    if (definedConstants.add(value)) continue;
                    string = JUnitBundle.message("jvm.inspections.junit.malformed.param.duplicated.enum.descriptor", new Object[0]);
                }
                object = string;
                Intrinsics.checkNotNull((Object)object);
                Object message = object;
                this.holder.registerProblem(sourcePsi, (String)message, new LocalQuickFix[0]);
            }
        }
    }

    private final void checkCsvSource(PsiAnnotation methodSource) {
        Iterable $this$forEach$iv = AnalysisUastUtilKt.flattenedAttributeValues((PsiAnnotation)methodSource, (String)"resources");
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiAnnotationMemberValue attributeValue = (PsiAnnotationMemberValue)element$iv;
            boolean bl = false;
            for (PsiReference ref : attributeValue.getReferences()) {
                String message;
                if (ref.isSoft() || !(ref instanceof FileReference)) continue;
                ResolveResult[] resolveResultArray = ((FileReference)ref).multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                if (!(((Object[])resolveResultArray).length == 0)) continue;
                Object[] objectArray = new Object[]{attributeValue.getText()};
                Intrinsics.checkNotNullExpressionValue((Object)JUnitBundle.message("jvm.inspections.junit.malformed.param.file.source.descriptor", objectArray), (String)"message(...)");
                LocalQuickFix[] localQuickFixArray = ((FileReference)ref).getQuickFixes();
                this.holder.registerProblem(((FileReference)ref).getElement(), message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        }
    }

    private static final UastVisibility dataPoint$lambda$0(UDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UastVisibility.PUBLIC;
    }

    private static final UastVisibility ruleSignatureProblem$lambda$1(UDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UastVisibility.PUBLIC;
    }

    private static final UastVisibility registeredExtensionProblem$lambda$2(JUnitMalformedSignatureVisitor this$0, UDeclaration decl) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        JUnitVersion jUnitVersion = JunitLibrarySetupKt.getUJUnitVersion((UElement)decl);
        if (jUnitVersion == null) {
            return null;
        }
        JUnitVersion junitVersion = jUnitVersion;
        return junitVersion.compareTo(JUnitVersion.Companion.getV_5_8_0()) < 0 ? this$0.notPrivate(decl) : null;
    }

    private static final UastVisibility classRuleSignatureProblem$lambda$3(UDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UastVisibility.PUBLIC;
    }

    private static final UastVisibility beforeAfterProblem$lambda$4(UDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UastVisibility.PUBLIC;
    }

    /*
     * WARNING - void declaration
     */
    private static final List beforeAfterProblem$lambda$6(JUnitMalformedSignatureVisitor this$0, UMethod method) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Iterable $this$filter$iv = method.getUastParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UParameter it = (UParameter)element$iv$iv;
            boolean bl = false;
            if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)it), (Collection)this$0.ignorableAnnotations)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List beforeAfterEachProblem$lambda$8(JUnitMalformedSignatureVisitor this$0, UMethod method) {
        List list;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (method.getUastParameters().isEmpty()) {
            list = CollectionsKt.emptyList();
        } else if (this$0.inParameterResolverContext(method)) {
            list = method.getUastParameters();
        } else {
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv = method.getUastParameters();
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void param;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                UParameter uParameter = (UParameter)element$iv$iv;
                int i = index$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)param.getType().getCanonicalText(), (Object)"org.junit.jupiter.api.TestInfo") || Intrinsics.areEqual((Object)param.getType().getCanonicalText(), (Object)"org.junit.jupiter.api.RepetitionInfo") || Intrinsics.areEqual((Object)param.getType().getCanonicalText(), (Object)"org.junit.jupiter.api.TestReporter") || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)param), (Collection)this$0.ignorableAnnotations) || i == 0 && this$0.suspendModifierIsAllowed((UElement)method) && this$0.isSuspendFunction(method) || this$0.inParameterResolverContext((UParameter)param))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final UastVisibility beforeAfterClassProblem$lambda$9(UDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UastVisibility.PUBLIC;
    }

    /*
     * WARNING - void declaration
     */
    private static final List beforeAfterClassProblem$lambda$11(JUnitMalformedSignatureVisitor this$0, UMethod method) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Iterable $this$filter$iv = method.getUastParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UParameter it = (UParameter)element$iv$iv;
            boolean bl = false;
            if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)it), (Collection)this$0.ignorableAnnotations)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List beforeAfterAllProblem$lambda$13(JUnitMalformedSignatureVisitor this$0, UMethod method) {
        List list;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (method.getUastParameters().isEmpty()) {
            list = CollectionsKt.emptyList();
        } else if (this$0.inParameterResolverContext(method)) {
            list = method.getUastParameters();
        } else {
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv = method.getUastParameters();
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void param;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                UParameter uParameter = (UParameter)element$iv$iv;
                int i = index$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)param.getType().getCanonicalText(), (Object)"org.junit.jupiter.api.TestInfo") || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)param), (Collection)this$0.ignorableAnnotations) || i == 0 && this$0.suspendModifierIsAllowed((UElement)method) && this$0.isSuspendFunction(method) || this$0.inParameterResolverContext((UParameter)param))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final UastVisibility junit4TestProblem$lambda$14(UDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UastVisibility.PUBLIC;
    }

    /*
     * WARNING - void declaration
     */
    private static final List junit4TestProblem$lambda$16(JUnitMalformedSignatureVisitor this$0, UMethod method) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Iterable $this$filter$iv = method.getUastParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UParameter it = (UParameter)element$iv$iv;
            boolean bl = false;
            if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)it), (Collection)this$0.ignorableAnnotations)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List junit56TestProblem$lambda$18(JUnitMalformedSignatureVisitor this$0, UMethod method) {
        List list;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (method.getUastParameters().isEmpty()) {
            list = CollectionsKt.emptyList();
        } else if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method.getJavaPsi()), (Collection)CollectionsKt.listOf((Object)"org.junit.jupiter.params.provider.ArgumentsSource"))) {
            list = null;
        } else if (this$0.inParameterResolverContext(method)) {
            list = method.getUastParameters();
        } else {
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv = method.getUastParameters();
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void param;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                UParameter uParameter = (UParameter)element$iv$iv;
                int i = index$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)param.getType().getCanonicalText(), (Object)"org.junit.jupiter.api.TestInfo") || Intrinsics.areEqual((Object)param.getType().getCanonicalText(), (Object)"org.junit.jupiter.api.TestReporter") || i == 0 && this$0.suspendModifierIsAllowed((UElement)method) && this$0.isSuspendFunction(method) || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)param), (Collection)this$0.ignorableAnnotations) || this$0.inParameterResolverContext((UParameter)param))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final List inParameterResolverContext$lambda$21(PsiAnnotation annotation) {
        Intrinsics.checkNotNull((Object)annotation);
        return AnalysisUastUtilKt.flattenedAttributeValues((PsiAnnotation)annotation, (String)"value");
    }

    private static final CharSequence checkIllegalCombinedAnnotations$lambda$39(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'@" + StringsKt.substringAfterLast$default((String)it, (char)'.', null, (int)2, null) + "'";
    }

    private static final CharSequence checkIllegalCombinedAnnotations$lambda$41(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'@" + StringsKt.substringAfterLast$default((String)it, (char)'.', null, (int)2, null) + "'";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkSourceTypeAndParameterTypeAgree$lambda$57(PsiMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.hasModifier(JvmModifier.PRIVATE)) return false;
        if (it.getParameterList().getParametersCount() != 1) return false;
        PsiParameter[] psiParameterArray = it.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        if (!((PsiParameter)ArraysKt.first((Object[])psiParameterArray)).getType().equalsToText("java.lang.String")) return false;
        return true;
    }

    public static final /* synthetic */ UastVisibility access$notPrivate(JUnitMalformedSignatureVisitor $this, UDeclaration method) {
        return $this.notPrivate(method);
    }

    static {
        Object[] objectArray = new String[]{"org.junit.runners.AllTests", "org.junit.runners.Parameterized", "org.junit.runners.BlockJUnit4ClassRunner", "org.junit.runners.JUnit4", "org.junit.runners.Suite", "org.junit.internal.runners.JUnit38ClassRunner", "org.junit.internal.runners.JUnit4ClassRunner", "org.junit.experimental.categories.Categories", "org.junit.experimental.categories.Enclosed"};
        checkableRunners = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"java.lang.String", "java.util.List", "java.util.Set", "java.util.Map"};
        validEmptySourceTypeBefore510 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"java.lang.String", "java.util.List", "java.util.Set", "java.util.SortedSet", "java.util.NavigableSet", "java.util.SortedMap", "java.util.NavigableMap", "java.util.Map", "java.util.Collection"};
        validEmptySourceTypeAfter510 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)UastVisibility.PUBLIC, (Object)JvmModifier.PUBLIC), TuplesKt.to((Object)UastVisibility.PROTECTED, (Object)JvmModifier.PROTECTED), TuplesKt.to((Object)UastVisibility.PRIVATE, (Object)JvmModifier.PRIVATE), TuplesKt.to((Object)UastVisibility.PACKAGE_LOCAL, (Object)JvmModifier.PACKAGE_LOCAL)};
        visibilityToModifier = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"org.junit.jupiter.params.provider.EnumSource", "org.junit.jupiter.params.provider.ValueSource", "org.junit.jupiter.params.provider.NullSource", "org.junit.jupiter.params.provider.EmptySource", "org.junit.jupiter.params.provider.NullAndEmptySource"};
        singleParamProviders = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"org.junit.jupiter.params.provider.MethodSource", "org.junit.jupiter.params.provider.CsvFileSource", "org.junit.jupiter.params.provider.CsvSource"};
        multipleParameterProviders = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.params.ParameterizedTest"};
        nonCombinedTests = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"org.junit.jupiter.params.provider.MethodSource", "org.junit.jupiter.params.provider.ValueSource", "org.junit.jupiter.params.provider.EnumSource", "org.junit.jupiter.params.provider.CsvFileSource", "org.junit.jupiter.params.provider.NullSource", "org.junit.jupiter.params.provider.EmptySource", "org.junit.jupiter.params.provider.NullAndEmptySource"};
        parameterizedSources = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u008d\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0018\b\u0002\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\f\u0012\u001e\b\u0002\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0003\u0018\u00010\f\u00a2\u0006\u0004\b\u0012\u0010\u0013J5\u0010\u0015\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00160\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020!J9\u0010\"\u001a\u00020\u001e*\u00020 2\u0006\u0010\u001b\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u00042\u0011\u0010%\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00160\u0003H\u0002JA\u0010&\u001a\u00020\u001e*\u00020 2\u0006\u0010\u001b\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u00042\u0011\u0010%\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00160\u00032\u0006\u0010'\u001a\u00020\u0004H\u0002J+\u0010(\u001a\u00020\u001e*\u00020 2\u000b\u0010)\u001a\u00070\u0004\u00a2\u0006\u0002\b*2\u0006\u0010\u001b\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u0010JG\u0010+\u001a\u00020\u001e*\u00020 2\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u00042\u0011\u0010%\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00160\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003H\u0002JO\u0010-\u001a\u00020\u001e*\u00020 2\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u00042\u0011\u0010%\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00160\u00032\u0006\u0010'\u001a\u00020\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003H\u0002JA\u0010.\u001a\u00020\u001e*\u00020 2\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u00042\u0011\u0010%\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00160\u00032\u0006\u0010'\u001a\u00020\u0004H\u0002J9\u0010/\u001a\u00020\u001e*\u00020 2\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u00042\u0011\u0010%\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00160\u0003H\u0002J?\u00100\u001a\u00020\u001e*\u00020 2\u000b\u0010)\u001a\u00070\u0004\u00a2\u0006\u0002\b*2\u0006\u0010\u001b\u001a\u00020\u00102\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u00101\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0003H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0003\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$AnnotatedSignatureProblem;", "", "annotations", "", "", "shouldBeStatic", "", "ignoreOnRunWith", "shouldBeInTestInstancePerClass", "shouldBeVoidType", "shouldBeSubTypeOf", "validVisibility", "Lkotlin/Function1;", "Lorg/jetbrains/uast/UDeclaration;", "Lorg/jetbrains/uast/UastVisibility;", "validParameters", "Lorg/jetbrains/uast/UMethod;", "Lorg/jetbrains/uast/UParameter;", "<init>", "(Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor;Ljava/util/List;Ljava/lang/Boolean;ZZLjava/lang/Boolean;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Boolean;", "modifierProblems", "Lcom/intellij/openapi/util/NlsSafe;", "decVisibility", "isStatic", "isInstancePerClass", "isApplicable", "element", "Lorg/jetbrains/uast/UElement;", "check", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "Lorg/jetbrains/uast/UField;", "fieldModifierProblem", "visibility", "annotation", "problems", "fieldTypeProblem", "type", "reportFieldProblem", "message", "Lcom/intellij/codeInspection/util/InspectionMessage;", "methodParameterProblem", "parameters", "methodParameterTypeProblem", "methodTypeProblem", "methodModifierProblem", "reportMethodProblem", "params", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnitMalformedDeclarationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$AnnotatedSignatureProblem\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1333:1\n19#2:1334\n19#2:1338\n19#2:1344\n1761#3,3:1335\n295#3,2:1339\n1761#3,3:1341\n295#3,2:1345\n1761#3,3:1350\n1761#3,3:1353\n1193#3,2:1356\n1267#3,4:1358\n1255#4,2:1347\n1#5:1349\n*S KotlinDebug\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$AnnotatedSignatureProblem\n*L\n939#1:1334\n949#1:1338\n1005#1:1344\n941#1:1335,3\n951#1:1339,2\n958#1:1341,3\n1008#1:1345,2\n1027#1:1350,3\n1035#1:1353,3\n1149#1:1356,2\n1149#1:1358,4\n1011#1:1347,2\n*E\n"})
    public final class AnnotatedSignatureProblem {
        @NotNull
        private final List<String> annotations;
        @Nullable
        private final Boolean shouldBeStatic;
        private final boolean ignoreOnRunWith;
        private final boolean shouldBeInTestInstancePerClass;
        @Nullable
        private final Boolean shouldBeVoidType;
        @Nullable
        private final List<String> shouldBeSubTypeOf;
        @Nullable
        private final Function1<UDeclaration, UastVisibility> validVisibility;
        @Nullable
        private final Function1<UMethod, List<UParameter>> validParameters;
        final /* synthetic */ JUnitMalformedSignatureVisitor this$0;

        public AnnotatedSignatureProblem(@NotNull JUnitMalformedSignatureVisitor this$0, @Nullable List<String> annotations, Boolean shouldBeStatic, boolean ignoreOnRunWith, @Nullable boolean shouldBeInTestInstancePerClass, @Nullable Boolean shouldBeVoidType, @Nullable List<String> shouldBeSubTypeOf, @Nullable Function1<? super UDeclaration, ? extends UastVisibility> validVisibility, Function1<? super UMethod, ? extends List<? extends UParameter>> validParameters) {
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            this.this$0 = this$0;
            this.annotations = annotations;
            this.shouldBeStatic = shouldBeStatic;
            this.ignoreOnRunWith = ignoreOnRunWith;
            this.shouldBeInTestInstancePerClass = shouldBeInTestInstancePerClass;
            this.shouldBeVoidType = shouldBeVoidType;
            this.shouldBeSubTypeOf = shouldBeSubTypeOf;
            this.validVisibility = validVisibility;
            this.validParameters = validParameters;
        }

        public /* synthetic */ AnnotatedSignatureProblem(JUnitMalformedSignatureVisitor jUnitMalformedSignatureVisitor, List list, Boolean bl, boolean bl2, boolean bl3, Boolean bl4, List list2, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = null;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = false;
            }
            if ((n & 0x10) != 0) {
                bl4 = null;
            }
            if ((n & 0x20) != 0) {
                list2 = null;
            }
            if ((n & 0x40) != 0) {
                function1 = null;
            }
            if ((n & 0x80) != 0) {
                function12 = null;
            }
            this(jUnitMalformedSignatureVisitor, list, bl, bl2, bl3, bl4, list2, (Function1<? super UDeclaration, ? extends UastVisibility>)function1, (Function1<? super UMethod, ? extends List<? extends UParameter>>)function12);
        }

        private final List<String> modifierProblems(UastVisibility validVisibility, UastVisibility decVisibility, boolean isStatic, boolean isInstancePerClass) {
            List problems = new ArrayList();
            if (this.shouldBeInTestInstancePerClass) {
                if (!isStatic && !isInstancePerClass) {
                    problems.add("static");
                }
            } else if (Intrinsics.areEqual((Object)this.shouldBeStatic, (Object)true) && !isStatic) {
                problems.add("static");
            } else if (Intrinsics.areEqual((Object)this.shouldBeStatic, (Object)false) && isStatic) {
                problems.add("non-static");
            }
            if (validVisibility != null && validVisibility != decVisibility) {
                problems.add(validVisibility.getText());
            }
            return problems;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isApplicable(UElement element) {
            block10: {
                boolean bl;
                block9: {
                    Object object;
                    block12: {
                        block11: {
                            UClassLiteralExpression uClassLiteralExpression;
                            void $this$asSafely$iv;
                            if (this.ignoreOnRunWith) break block10;
                            UClass uClass = UastUtils.getContainingUClass((UElement)element);
                            if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
                                return false;
                            }
                            UClass containingClass = uClass;
                            PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (Set)SetsKt.setOf((Object)"org.junit.runner.RunWith"));
                            if (annotation == null) break block10;
                            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)annotation.findAttributeValue("value")));
                            if (uElement == null) break block11;
                            object = uElement;
                            boolean $i$f$asSafely = false;
                            Object v1 = $this$asSafely$iv;
                            if (!(v1 instanceof UClassLiteralExpression)) {
                                v1 = null;
                            }
                            if ((uClassLiteralExpression = (UClassLiteralExpression)v1) != null && (object = uClassLiteralExpression.getType()) != null) break block12;
                        }
                        return false;
                    }
                    UElement runnerType = object;
                    Iterable $this$any$iv = Companion.getCheckableRunners();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String p0 = (String)element$iv;
                            boolean bl2 = false;
                            if (!runnerType.equalsToText(p0)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            return true;
        }

        public final void check(@NotNull ProblemsHolder holder, @NotNull UField element) {
            boolean bl;
            Object v2;
            String $this$firstOrNull$iv;
            Object $this$asSafely$iv;
            block13: {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!this.isApplicable((UElement)element)) {
                    return;
                }
                $this$asSafely$iv = element.getJavaPsi();
                boolean $i$f$asSafely22 = false;
                PsiElement psiElement = $this$asSafely$iv;
                if (!(psiElement instanceof PsiField)) {
                    psiElement = null;
                }
                PsiField psiField = (PsiField)psiElement;
                if (psiField == null) {
                    return;
                }
                PsiField javaPsi = psiField;
                Iterable $i$f$asSafely22 = this.annotations;
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)javaPsi), (Collection)this.annotations)) continue;
                    v2 = element$iv;
                    break block13;
                }
                v2 = null;
            }
            $this$asSafely$iv = v2;
            if ($this$asSafely$iv == null || ($this$firstOrNull$iv = StringsKt.substringAfterLast$default((String)$this$asSafely$iv, (String)".", null, (int)2, null)) == null) {
                return;
            }
            String annotation = $this$firstOrNull$iv;
            Function1<UDeclaration, UastVisibility> function1 = this.validVisibility;
            UastVisibility visibility = function1 != null ? (UastVisibility)function1.invoke((Object)element) : null;
            List<String> problems = this.modifierProblems(visibility, element.getVisibility(), element.isStatic(), false);
            if (Intrinsics.areEqual((Object)this.shouldBeVoidType, (Object)true) && !Intrinsics.areEqual((Object)element.getType(), (Object)PsiTypes.voidType())) {
                String string = PsiTypes.voidType().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.fieldTypeProblem(holder, element, visibility, annotation, problems, string);
                return;
            }
            List<String> list = this.shouldBeSubTypeOf;
            if (list != null) {
                boolean bl3;
                block14: {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!InheritanceUtil.isInheritor((PsiType)element.getType(), (String)it)) continue;
                            bl3 = true;
                            break block14;
                        }
                        bl3 = false;
                    }
                }
                bl = !bl3;
            } else {
                bl = false;
            }
            if (bl) {
                this.fieldTypeProblem(holder, element, visibility, annotation, problems, (String)CollectionsKt.first(this.shouldBeSubTypeOf));
                return;
            }
            if (!((Collection)problems).isEmpty()) {
                this.fieldModifierProblem(holder, element, visibility, annotation, problems);
                return;
            }
        }

        private final void fieldModifierProblem(ProblemsHolder $this$fieldModifierProblem, UField element, UastVisibility visibility, String annotation, List<String> problems) {
            String string;
            if (problems.size() == 1) {
                var8_6 = new Object[]{0, annotation, CollectionsKt.first(problems)};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.single.descriptor", var8_6);
            } else {
                var8_6 = new Object[]{0, annotation, CollectionsKt.first(problems), CollectionsKt.last(problems)};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.double.descriptor", var8_6);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String message = string2;
            this.reportFieldProblem($this$fieldModifierProblem, message, element, visibility);
        }

        private final void fieldTypeProblem(ProblemsHolder $this$fieldTypeProblem, UField element, UastVisibility visibility, String annotation, List<String> problems, String type) {
            if (problems.isEmpty()) {
                Object[] objectArray = new Object[]{0, annotation, type};
                String string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.typed.descriptor", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)$this$fieldTypeProblem, (UDeclaration)((UDeclaration)element), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            } else if (problems.size() == 1) {
                Object[] objectArray = new Object[]{0, annotation, CollectionsKt.first(problems), type};
                String string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.single.typed.descriptor", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                this.reportFieldProblem($this$fieldTypeProblem, message, element, visibility);
            } else {
                Object[] objectArray = new Object[]{0, annotation, CollectionsKt.first(problems), CollectionsKt.last(problems), type};
                String string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.double.typed.descriptor", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                this.reportFieldProblem($this$fieldTypeProblem, message, element, visibility);
            }
        }

        private final void reportFieldProblem(ProblemsHolder $this$reportFieldProblem, String message, UField element, UastVisibility visibility) {
            String string = element.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            FieldSignatureQuickfix quickFix = new FieldSignatureQuickfix(string, this.shouldBeStatic, Companion.getVisibilityToModifier().get(visibility));
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{quickFix};
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)$this$reportFieldProblem, (UDeclaration)((UDeclaration)element), (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
        }

        /*
         * WARNING - void declaration
         */
        public final void check(@NotNull ProblemsHolder holder, @NotNull UMethod element) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Class[] annotation;
            PsiMethod javaPsi;
            block27: {
                Sequence alternatives;
                Object v2;
                Class[] $this$firstOrNull$iv;
                PsiElement sourcePsi;
                block26: {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!this.isApplicable((UElement)element)) {
                        return;
                    }
                    PsiMethod $this$asSafely$iv = element.getJavaPsi();
                    boolean $i$f$asSafely = false;
                    PsiMethod psiMethod = $this$asSafely$iv;
                    if (!(psiMethod instanceof PsiMethod)) {
                        psiMethod = null;
                    }
                    if (psiMethod == null) {
                        return;
                    }
                    javaPsi = psiMethod;
                    PsiElement psiElement = element.getSourcePsi();
                    if (psiElement == null) {
                        return;
                    }
                    sourcePsi = psiElement;
                    Iterable iterable = this.annotations;
                    boolean $i$f$firstOrNull = false;
                    for (Class element$iv : $this$firstOrNull$iv) {
                        String it = (String)((Object)element$iv);
                        boolean bl4 = false;
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)javaPsi), (String)it, (int)1)) continue;
                        v2 = element$iv;
                        break block26;
                    }
                    v2 = null;
                }
                String $i$f$asSafely = v2;
                if ($i$f$asSafely == null || ($this$firstOrNull$iv = StringsKt.substringAfterLast$default((String)$i$f$asSafely, (char)'.', null, (int)2, null)) == null) {
                    return;
                }
                annotation = $this$firstOrNull$iv;
                $this$firstOrNull$iv = new Class[]{UMethod.class};
                Sequence $this$any$iv = alternatives = UastFacade.INSTANCE.convertToAlternatives(sourcePsi, $this$firstOrNull$iv);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    UMethod it = (UMethod)element$iv;
                    boolean bl5 = false;
                    if (!it.isStatic()) continue;
                    bl3 = true;
                    break block27;
                }
                bl3 = false;
            }
            boolean elementIsStatic = bl3;
            Function1<UDeclaration, UastVisibility> function1 = this.validVisibility;
            UastVisibility visibility = function1 != null ? (UastVisibility)function1.invoke((Object)element) : null;
            Function1<UMethod, List<UParameter>> function12 = this.validParameters;
            List params = function12 != null ? (List)function12.invoke((Object)element) : null;
            AnnotatedSignatureProblem annotatedSignatureProblem = this;
            UastVisibility uastVisibility = visibility;
            UastVisibility uastVisibility2 = element.getVisibility();
            boolean bl6 = elementIsStatic;
            PsiClass psiClass = javaPsi.getContainingClass();
            if (psiClass != null) {
                void cls;
                PsiClass bl5 = psiClass;
                boolean bl7 = bl6;
                UastVisibility uastVisibility3 = uastVisibility2;
                UastVisibility uastVisibility4 = uastVisibility;
                AnnotatedSignatureProblem annotatedSignatureProblem2 = annotatedSignatureProblem;
                boolean bl8 = false;
                boolean bl9 = TestUtils.testInstancePerClass((PsiClass)cls);
                annotatedSignatureProblem = annotatedSignatureProblem2;
                uastVisibility = uastVisibility4;
                uastVisibility2 = uastVisibility3;
                bl6 = bl7;
                bl2 = bl9;
            } else {
                bl2 = false;
            }
            List<String> problems = annotatedSignatureProblem.modifierProblems(uastVisibility, uastVisibility2, bl6, bl2);
            if (!this.this$0.suspendModifierIsAllowed((UElement)element) && this.this$0.isSuspendFunction(element)) {
                Object[] cls = new Object[]{annotation};
                String string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.suspend.function.descriptor", cls);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UDeclaration)((UDeclaration)element), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                return;
            }
            if (params != null && params.size() != element.getUastParameters().size()) {
                boolean bl10;
                if (Intrinsics.areEqual((Object)this.shouldBeVoidType, (Object)true) && !Intrinsics.areEqual((Object)element.getReturnType(), (Object)PsiTypes.voidType())) {
                    String string = PsiTypes.voidType().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.methodParameterTypeProblem(holder, element, visibility, (String)annotation, problems, string, params);
                    return;
                }
                List<String> list = this.shouldBeSubTypeOf;
                if (list != null) {
                    boolean bl11;
                    block28: {
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl11 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl12 = false;
                                if (!InheritanceUtil.isInheritor((PsiType)element.getReturnType(), (String)it)) continue;
                                bl11 = true;
                                break block28;
                            }
                            bl11 = false;
                        }
                    }
                    bl10 = !bl11;
                } else {
                    bl10 = false;
                }
                if (bl10) {
                    this.methodParameterTypeProblem(holder, element, visibility, (String)annotation, problems, (String)CollectionsKt.first(this.shouldBeSubTypeOf), params);
                    return;
                }
                this.methodParameterProblem(holder, element, visibility, (String)annotation, problems, params);
                return;
            }
            if (Intrinsics.areEqual((Object)this.shouldBeVoidType, (Object)true) && !Intrinsics.areEqual((Object)element.getReturnType(), (Object)PsiTypes.voidType()) && !this.this$0.isSuspendFunction(element)) {
                String string = PsiTypes.voidType().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.methodTypeProblem(holder, element, visibility, (String)annotation, problems, string);
                return;
            }
            List<String> list = this.shouldBeSubTypeOf;
            if (list != null) {
                boolean bl13;
                block29: {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl13 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl14 = false;
                            if (!InheritanceUtil.isInheritor((PsiType)element.getReturnType(), (String)it)) continue;
                            bl13 = true;
                            break block29;
                        }
                        bl13 = false;
                    }
                }
                bl = !bl13;
            } else {
                bl = false;
            }
            if (bl) {
                this.methodTypeProblem(holder, element, visibility, (String)annotation, problems, (String)CollectionsKt.first(this.shouldBeSubTypeOf));
                return;
            }
            if (!((Collection)problems).isEmpty()) {
                this.methodModifierProblem(holder, element, visibility, (String)annotation, problems);
                return;
            }
        }

        private final void methodParameterProblem(ProblemsHolder $this$methodParameterProblem, UMethod element, UastVisibility visibility, String annotation, List<String> problems, List<? extends UParameter> parameters) {
            String string;
            List list;
            List $this$methodParameterProblem_u24lambda_u247 = list = CollectionsKt.toMutableList((Collection)element.getUastParameters());
            boolean bl = false;
            $this$methodParameterProblem_u24lambda_u247.removeAll((Collection)parameters);
            List invalidParams = list;
            if (problems.isEmpty() && invalidParams.size() == 1) {
                var10_10 = new Object[]{annotation, ((UParameter)CollectionsKt.first((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.param.single.descriptor", var10_10);
            } else if (problems.isEmpty() && invalidParams.size() > 1) {
                var10_10 = new Object[]{annotation, CollectionsKt.joinToString$default((Iterable)invalidParams, null, null, null, (int)0, null, AnnotatedSignatureProblem::methodParameterProblem$lambda$8, (int)31, null), ((UParameter)CollectionsKt.last((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.param.double.descriptor", var10_10);
            } else if (problems.size() == 1 && invalidParams.size() == 1) {
                var10_10 = new Object[]{annotation, CollectionsKt.first(problems), ((UParameter)CollectionsKt.first((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.single.param.single.descriptor", var10_10);
            } else if (problems.size() == 1 && invalidParams.size() > 1) {
                var10_10 = new Object[]{annotation, CollectionsKt.first(problems), CollectionsKt.joinToString$default((Iterable)invalidParams, null, null, null, (int)0, null, AnnotatedSignatureProblem::methodParameterProblem$lambda$9, (int)31, null), ((UParameter)CollectionsKt.last((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.single.param.double.descriptor", var10_10);
            } else if (problems.size() == 2 && invalidParams.size() == 1) {
                var10_10 = new Object[]{annotation, CollectionsKt.first(problems), CollectionsKt.last(problems), ((UParameter)CollectionsKt.first((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.double.param.single.descriptor", var10_10);
            } else if (problems.size() == 2 && invalidParams.size() > 1) {
                var10_10 = new Object[]{annotation, CollectionsKt.first(problems), CollectionsKt.last(problems), CollectionsKt.joinToString$default((Iterable)invalidParams, null, null, null, (int)0, null, AnnotatedSignatureProblem::methodParameterProblem$lambda$10, (int)31, null), ((UParameter)CollectionsKt.last((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.double.param.double.descriptor", var10_10);
            } else {
                throw new IllegalStateException("Non valid problem.".toString());
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String message = string2;
            AnnotatedSignatureProblem.reportMethodProblem$default(this, $this$methodParameterProblem, message, element, visibility, null, 8, null);
        }

        private final void methodParameterTypeProblem(ProblemsHolder $this$methodParameterTypeProblem, UMethod element, UastVisibility visibility, String annotation, List<String> problems, String type, List<? extends UParameter> parameters) {
            String string;
            List list;
            List $this$methodParameterTypeProblem_u24lambda_u2411 = list = CollectionsKt.toMutableList((Collection)element.getUastParameters());
            boolean bl = false;
            $this$methodParameterTypeProblem_u24lambda_u2411.removeAll((Collection)parameters);
            List invalidParams = list;
            if (problems.isEmpty() && invalidParams.size() == 1) {
                var11_11 = new Object[]{annotation, type, ((UParameter)CollectionsKt.first((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.typed.param.single.descriptor", var11_11);
            } else if (problems.isEmpty() && invalidParams.size() > 1) {
                var11_11 = new Object[]{annotation, type, CollectionsKt.joinToString$default((Iterable)invalidParams, null, null, null, (int)0, null, AnnotatedSignatureProblem::methodParameterTypeProblem$lambda$12, (int)31, null), ((UParameter)CollectionsKt.last((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.typed.param.double.descriptor", var11_11);
            } else if (problems.size() == 1 && invalidParams.size() == 1) {
                var11_11 = new Object[]{annotation, CollectionsKt.first(problems), type, ((UParameter)CollectionsKt.first((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.single.typed.param.single.descriptor", var11_11);
            } else if (problems.size() == 1 && invalidParams.size() > 1) {
                var11_11 = new Object[]{annotation, CollectionsKt.first(problems), type, CollectionsKt.joinToString$default((Iterable)invalidParams, null, null, null, (int)0, null, AnnotatedSignatureProblem::methodParameterTypeProblem$lambda$13, (int)31, null), ((UParameter)CollectionsKt.last((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.single.typed.param.double.descriptor", var11_11);
            } else if (problems.size() == 2 && invalidParams.size() == 1) {
                var11_11 = new Object[]{annotation, CollectionsKt.first(problems), CollectionsKt.last(problems), type, ((UParameter)CollectionsKt.first((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.double.typed.param.single.descriptor", var11_11);
            } else if (problems.size() == 2 && invalidParams.size() > 1) {
                var11_11 = new Object[]{annotation, CollectionsKt.first(problems), CollectionsKt.last(problems), type, CollectionsKt.joinToString$default((Iterable)invalidParams, null, null, null, (int)0, null, AnnotatedSignatureProblem::methodParameterTypeProblem$lambda$14, (int)31, null), ((UParameter)CollectionsKt.last((List)invalidParams)).getName()};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.method.double.typed.param.double.descriptor", var11_11);
            } else {
                throw new IllegalStateException("Non valid problem.".toString());
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String message = string2;
            AnnotatedSignatureProblem.reportMethodProblem$default(this, $this$methodParameterTypeProblem, message, element, visibility, null, 8, null);
        }

        private final void methodTypeProblem(ProblemsHolder $this$methodTypeProblem, UMethod element, UastVisibility visibility, String annotation, List<String> problems, String type) {
            String string;
            if (problems.isEmpty()) {
                var9_7 = new Object[]{1, annotation, type};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.typed.descriptor", var9_7);
            } else if (problems.size() == 1) {
                var9_7 = new Object[]{1, annotation, CollectionsKt.first(problems), type};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.single.typed.descriptor", var9_7);
            } else {
                var9_7 = new Object[]{1, annotation, CollectionsKt.first(problems), CollectionsKt.last(problems), type};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.double.typed.descriptor", var9_7);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String message = string2;
            AnnotatedSignatureProblem.reportMethodProblem$default(this, $this$methodTypeProblem, message, element, visibility, null, 8, null);
        }

        private final void methodModifierProblem(ProblemsHolder $this$methodModifierProblem, UMethod element, UastVisibility visibility, String annotation, List<String> problems) {
            String string;
            if (problems.size() == 1) {
                var8_6 = new Object[]{1, annotation, CollectionsKt.first(problems)};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.single.descriptor", var8_6);
            } else {
                var8_6 = new Object[]{1, annotation, CollectionsKt.first(problems), CollectionsKt.last(problems)};
                string = JUnitBundle.message("jvm.inspections.junit.malformed.annotated.double.descriptor", var8_6);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String message = string2;
            AnnotatedSignatureProblem.reportMethodProblem$default(this, $this$methodModifierProblem, message, element, visibility, null, 8, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportMethodProblem(ProblemsHolder $this$reportMethodProblem, String message, UMethod element, UastVisibility visibility, List<? extends UParameter> params) {
            Map map;
            String string = element.getName();
            Boolean bl = this.shouldBeStatic;
            Boolean bl2 = this.shouldBeVoidType;
            JvmModifier jvmModifier = Companion.getVisibilityToModifier().get(visibility);
            List<? extends UParameter> list = params;
            if (list != null) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Iterable iterable = list;
                JvmModifier jvmModifier2 = jvmModifier;
                Boolean bl3 = bl2;
                Boolean bl4 = bl;
                String string2 = string;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var11_13 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    UParameter it = (UParameter)element$iv$iv;
                    boolean bl5 = false;
                    Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getType());
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                Map map3 = destination$iv$iv;
                string = string2;
                bl = bl4;
                bl2 = bl3;
                jvmModifier = jvmModifier2;
                map = map3;
            } else {
                map = MapsKt.emptyMap();
            }
            Map map4 = map;
            JvmModifier jvmModifier3 = jvmModifier;
            Boolean bl6 = bl2;
            Boolean bl7 = bl;
            String string3 = string;
            MethodSignatureQuickfix quickFix = new MethodSignatureQuickfix(string3, bl7, bl6, jvmModifier3, map4);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{quickFix};
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)$this$reportMethodProblem, (UDeclaration)((UDeclaration)element), (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
        }

        static /* synthetic */ void reportMethodProblem$default(AnnotatedSignatureProblem annotatedSignatureProblem, ProblemsHolder problemsHolder, String string, UMethod uMethod, UastVisibility uastVisibility, List list, int n, Object object) {
            if ((n & 4) != 0) {
                uastVisibility = null;
            }
            if ((n & 8) != 0) {
                list = null;
            }
            annotatedSignatureProblem.reportMethodProblem(problemsHolder, string, uMethod, uastVisibility, list);
        }

        private static final CharSequence methodParameterProblem$lambda$8(UParameter it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + it.getName() + "'";
        }

        private static final CharSequence methodParameterProblem$lambda$9(UParameter it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + it.getName() + "'";
        }

        private static final CharSequence methodParameterProblem$lambda$10(UParameter it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + it.getName() + "'";
        }

        private static final CharSequence methodParameterTypeProblem$lambda$12(UParameter it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + it.getName() + "'";
        }

        private static final CharSequence methodParameterTypeProblem$lambda$13(UParameter it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + it.getName() + "'";
        }

        private static final CharSequence methodParameterTypeProblem$lambda$14(UParameter it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + it.getName() + "'";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B:\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J(\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00170\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0015\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$ClassSignatureQuickFix;", "Lcom/intellij/jvm/analysis/quickFix/CompositeModCommandQuickFix;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "makeStatic", "", "makePublic", "annotation", "<init>", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;)V", "Ljava/lang/Boolean;", "getFamilyName", "getName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getActions", "", "Lkotlin/Function1;", "Lcom/intellij/lang/jvm/JvmModifiersOwner;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnitMalformedDeclarationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$ClassSignatureQuickFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,1333:1\n19#2:1334\n19#2:1335\n*S KotlinDebug\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$ClassSignatureQuickFix\n*L\n1166#1:1334\n1167#1:1335\n*E\n"})
    private static class ClassSignatureQuickFix
    extends CompositeModCommandQuickFix {
        @Nullable
        private final String name;
        @Nullable
        private final Boolean makeStatic;
        @Nullable
        private final Boolean makePublic;
        @Nullable
        private final String annotation;

        public ClassSignatureQuickFix(@Nullable String name, @Nullable Boolean makeStatic, @Nullable Boolean makePublic, @Nullable String annotation) {
            this.name = name;
            this.makeStatic = makeStatic;
            this.makePublic = makePublic;
            this.annotation = annotation;
        }

        public /* synthetic */ ClassSignatureQuickFix(String string, Boolean bl, Boolean bl2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = null;
            }
            if ((n & 4) != 0) {
                bl2 = null;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            this(string, bl, bl2, string2);
        }

        @NotNull
        public String getFamilyName() {
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.fix.class.signature", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.name};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.fix.class.signature.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            UElement uElement;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                    uElement = UastUtils.getUParentForIdentifier((PsiElement)element);
                    if (uElement == null) break block7;
                    UElement $this$asSafely$iv = uElement;
                    boolean $i$f$asSafely = false;
                    UElement uElement2 = $this$asSafely$iv;
                    if (!(uElement2 instanceof UClass)) {
                        uElement2 = null;
                    }
                    if ((uElement = (UClass)uElement2) != null) break block8;
                }
                return;
            }
            UElement javaDeclaration = uElement;
            PsiClass $this$asSafely$iv = javaDeclaration.getJavaPsi();
            boolean $i$f$asSafely = false;
            PsiClass psiClass = $this$asSafely$iv;
            if (!(psiClass instanceof PsiClass)) {
                psiClass = null;
            }
            if (psiClass == null) {
                return;
            }
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
            this.applyFixes(project, (PsiElement)psiClass, psiFile);
        }

        @NotNull
        protected List<Function1<JvmModifiersOwner, List<IntentionAction>>> getActions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List actions = new ArrayList();
            if (this.makeStatic != null) {
                actions.add(arg_0 -> ClassSignatureQuickFix.getActions$lambda$0(this, arg_0));
            }
            if (this.makePublic != null) {
                actions.add(arg_0 -> ClassSignatureQuickFix.getActions$lambda$1(this, arg_0));
            }
            if (this.annotation != null) {
                actions.add(arg_0 -> ClassSignatureQuickFix.getActions$lambda$2(this, arg_0));
            }
            return actions;
        }

        private static final List getActions$lambda$0(ClassSignatureQuickFix this$0, JvmModifiersOwner jvmClass) {
            Intrinsics.checkNotNullParameter((Object)jvmClass, (String)"jvmClass");
            return JvmElementActionFactories.createModifierActions((JvmModifiersOwner)jvmClass, (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.STATIC, (boolean)this$0.makeStatic, (boolean)false, (int)4, null));
        }

        private static final List getActions$lambda$1(ClassSignatureQuickFix this$0, JvmModifiersOwner jvmClass) {
            Intrinsics.checkNotNullParameter((Object)jvmClass, (String)"jvmClass");
            return JvmElementActionFactories.createModifierActions((JvmModifiersOwner)jvmClass, (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.PUBLIC, (boolean)this$0.makePublic, (boolean)false, (int)4, null));
        }

        private static final List getActions$lambda$2(ClassSignatureQuickFix this$0, JvmModifiersOwner jvmClass) {
            Intrinsics.checkNotNullParameter((Object)jvmClass, (String)"jvmClass");
            return JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)jvmClass, (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)this$0.annotation, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010\u00a8\u0006!"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$Companion;", "", "<init>", "()V", "FIELD", "", "METHOD", "SINGLE", "DOUBLE", "TEST_INSTANCE_PER_CLASS", "", "METHOD_SOURCE_RETURN_TYPE", "COROUTINES_CONTINUATION_TYPE", "checkableRunners", "", "getCheckableRunners", "()Ljava/util/List;", "validEmptySourceTypeBefore510", "validEmptySourceTypeAfter510", "visibilityToModifier", "", "Lorg/jetbrains/uast/UastVisibility;", "Lcom/intellij/lang/jvm/JvmModifier;", "getVisibilityToModifier", "()Ljava/util/Map;", "singleParamProviders", "getSingleParamProviders", "multipleParameterProviders", "getMultipleParameterProviders", "nonCombinedTests", "getNonCombinedTests", "parameterizedSources", "getParameterizedSources", "intellij.junit"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getCheckableRunners() {
            return checkableRunners;
        }

        @NotNull
        public final Map<UastVisibility, JvmModifier> getVisibilityToModifier() {
            return visibilityToModifier;
        }

        @NotNull
        public final List<String> getSingleParamProviders() {
            return singleParamProviders;
        }

        @NotNull
        public final List<String> getMultipleParameterProviders() {
            return multipleParameterProviders;
        }

        @NotNull
        public final List<String> getNonCombinedTests() {
            return nonCombinedTests;
        }

        @NotNull
        public final List<String> getParameterizedSources() {
            return parameterizedSources;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B*\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J(\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00170\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$FieldSignatureQuickfix;", "Lcom/intellij/jvm/analysis/quickFix/CompositeModCommandQuickFix;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "makeStatic", "", "newVisibility", "Lcom/intellij/lang/jvm/JvmModifier;", "<init>", "(Ljava/lang/String;Ljava/lang/Boolean;Lcom/intellij/lang/jvm/JvmModifier;)V", "Ljava/lang/Boolean;", "getFamilyName", "getName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getActions", "", "Lkotlin/Function1;", "Lcom/intellij/lang/jvm/JvmModifiersOwner;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnitMalformedDeclarationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$FieldSignatureQuickfix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,1333:1\n19#2:1334\n*S KotlinDebug\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$FieldSignatureQuickfix\n*L\n1196#1:1334\n*E\n"})
    private static final class FieldSignatureQuickfix
    extends CompositeModCommandQuickFix {
        @NotNull
        private final String name;
        @Nullable
        private final Boolean makeStatic;
        @Nullable
        private final JvmModifier newVisibility;

        public FieldSignatureQuickfix(@NotNull String name, @Nullable Boolean makeStatic, @Nullable JvmModifier newVisibility) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.makeStatic = makeStatic;
            this.newVisibility = newVisibility;
        }

        public /* synthetic */ FieldSignatureQuickfix(String string, Boolean bl, JvmModifier jvmModifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jvmModifier = null;
            }
            this(string, bl, jvmModifier);
        }

        @NotNull
        public String getFamilyName() {
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.fix.field.signature", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.name};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.fix.field.signature.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            UElement uElement;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                    uElement = UastUtils.getUParentForIdentifier((PsiElement)element);
                    if (uElement == null) break block6;
                    UElement $this$asSafely$iv = uElement;
                    boolean $i$f$asSafely = false;
                    UElement uElement2 = $this$asSafely$iv;
                    if (!(uElement2 instanceof UField)) {
                        uElement2 = null;
                    }
                    if ((uElement = (UField)uElement2) != null) break block7;
                }
                return;
            }
            UElement javaDeclaration = uElement;
            PsiElement psiElement = javaDeclaration.getJavaPsi();
            if (psiElement == null) {
                return;
            }
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
            this.applyFixes(project, psiElement, psiFile);
        }

        @NotNull
        protected List<Function1<JvmModifiersOwner, List<IntentionAction>>> getActions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List actions = new ArrayList();
            if (this.newVisibility != null) {
                actions.add(arg_0 -> FieldSignatureQuickfix.getActions$lambda$0(this, arg_0));
            }
            if (this.makeStatic != null) {
                actions.add(arg_0 -> FieldSignatureQuickfix.getActions$lambda$1(this, arg_0));
            }
            return actions;
        }

        private static final List getActions$lambda$0(FieldSignatureQuickfix this$0, JvmModifiersOwner jvmField) {
            Intrinsics.checkNotNullParameter((Object)jvmField, (String)"jvmField");
            return JvmElementActionFactories.createModifierActions((JvmModifiersOwner)jvmField, (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)this$0.newVisibility, (boolean)true, (boolean)false, (int)4, null));
        }

        private static final List getActions$lambda$1(FieldSignatureQuickfix this$0, JvmModifiersOwner jvmField) {
            Intrinsics.checkNotNullParameter((Object)jvmField, (String)"jvmField");
            return JvmElementActionFactories.createModifierActions((JvmModifiersOwner)jvmField, (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.STATIC, (boolean)this$0.makeStatic, (boolean)false, (int)4, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\t0\n0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0007H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$MakeJUnit4InnerClassRunnableFix;", "Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$ClassSignatureQuickFix;", "aClass", "Lorg/jetbrains/uast/UClass;", "<init>", "(Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor;Lorg/jetbrains/uast/UClass;)V", "getName", "", "getActions", "", "Lkotlin/Function1;", "Lcom/intellij/lang/jvm/JvmModifiersOwner;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "project", "Lcom/intellij/openapi/project/Project;", "getFamilyName", "applyFix", "", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnitMalformedDeclarationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$MakeJUnit4InnerClassRunnableFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,1333:1\n19#2:1334\n19#2:1335\n171#3:1336\n*S KotlinDebug\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$MakeJUnit4InnerClassRunnableFix\n*L\n366#1:1334\n367#1:1335\n353#1:1336\n*E\n"})
    private final class MakeJUnit4InnerClassRunnableFix
    extends ClassSignatureQuickFix {
        public MakeJUnit4InnerClassRunnableFix(UClass aClass) {
            Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
            super(aClass.getJavaPsi().getName(), true, aClass.getVisibility() != UastVisibility.PRIVATE, null);
        }

        @Override
        @NotNull
        public String getName() {
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.fix.class.signature.multi", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        protected List<Function1<JvmModifiersOwner, List<IntentionAction>>> getActions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List list = CollectionsKt.toMutableList((Collection)super.getActions(project));
            list.add(arg_0 -> MakeJUnit4InnerClassRunnableFix.getActions$lambda$0(JUnitMalformedSignatureVisitor.this, arg_0));
            return list;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.fix.class.signature.multi", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            UElement uElement;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                    uElement = UastUtils.getUParentForIdentifier((PsiElement)element);
                    if (uElement == null) break block7;
                    UElement $this$asSafely$iv = uElement;
                    boolean $i$f$asSafely = false;
                    UElement uElement2 = $this$asSafely$iv;
                    if (!(uElement2 instanceof UClass)) {
                        uElement2 = null;
                    }
                    if ((uElement = (UClass)uElement2) != null) break block8;
                }
                return;
            }
            UElement uClass = uElement;
            PsiClass $this$asSafely$iv = uClass.getJavaPsi();
            boolean $i$f$asSafely = false;
            PsiClass psiClass = $this$asSafely$iv;
            if (!(psiClass instanceof PsiClass)) {
                psiClass = null;
            }
            if (psiClass == null) {
                return;
            }
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
            this.applyFixes(project, (PsiElement)psiClass, psiFile);
        }

        private static final List getActions$lambda$0(JUnitMalformedSignatureVisitor this$0, JvmModifiersOwner owner) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                    object = owner.getSourceElement();
                    if (object == null) break block2;
                    PsiElement $this$toUElementOfType$iv = object;
                    boolean $i$f$toUElementOfType = false;
                    object = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
                    if (object != null && (object = JUnitMalformedSignatureVisitor.nestedClassHierarchy$default(this$0, (UClass)object, null, 1, null)) != null && (object = (UClass)CollectionsKt.lastOrNull((List)object)) != null) break block3;
                }
                return CollectionsKt.emptyList();
            }
            Object outerClass = object;
            AnnotationAttributeRequest[] annotationAttributeRequestArray = new AnnotationAttributeRequest[]{AnnotationAttributeValueRequestKt.classAttribute((String)"value", (String)"org.junit.experimental.runners.Enclosed")};
            AnnotationRequest request = AnnotationRequestsKt.annotationRequest((String)"org.junit.runner.RunWith", (AnnotationAttributeRequest[])annotationAttributeRequestArray);
            return JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)((JvmModifiersOwner)outerClass.getJavaPsi()), (AnnotationRequest)request);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BN\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J(\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001b0\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$MethodSignatureQuickfix;", "Lcom/intellij/jvm/analysis/quickFix/CompositeModCommandQuickFix;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "makeStatic", "", "shouldBeVoidType", "newVisibility", "Lcom/intellij/lang/jvm/JvmModifier;", "inCorrectParams", "", "Lcom/intellij/lang/jvm/types/JvmType;", "<init>", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lcom/intellij/lang/jvm/JvmModifier;Ljava/util/Map;)V", "Ljava/lang/Boolean;", "getFamilyName", "getName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getActions", "", "Lkotlin/Function1;", "Lcom/intellij/lang/jvm/JvmModifiersOwner;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnitMalformedDeclarationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$MethodSignatureQuickfix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,1333:1\n19#2:1334\n19#2:1335\n19#2:1336\n*S KotlinDebug\n*F\n+ 1 JUnitMalformedDeclarationInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitMalformedSignatureVisitor$MethodSignatureQuickfix\n*L\n1224#1:1334\n1232#1:1335\n1241#1:1336\n*E\n"})
    private static final class MethodSignatureQuickfix
    extends CompositeModCommandQuickFix {
        @NotNull
        private final String name;
        @Nullable
        private final Boolean makeStatic;
        @Nullable
        private final Boolean shouldBeVoidType;
        @Nullable
        private final JvmModifier newVisibility;
        @FileModifier.SafeFieldForPreview
        @Nullable
        private final Map<String, JvmType> inCorrectParams;

        public MethodSignatureQuickfix(@NotNull String name, @Nullable Boolean makeStatic, @Nullable Boolean shouldBeVoidType, @Nullable JvmModifier newVisibility, @Nullable Map<String, ? extends JvmType> inCorrectParams) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.makeStatic = makeStatic;
            this.shouldBeVoidType = shouldBeVoidType;
            this.newVisibility = newVisibility;
            this.inCorrectParams = inCorrectParams;
        }

        public /* synthetic */ MethodSignatureQuickfix(String string, Boolean bl, Boolean bl2, JvmModifier jvmModifier, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = null;
            }
            if ((n & 8) != 0) {
                jvmModifier = null;
            }
            if ((n & 0x10) != 0) {
                map = null;
            }
            this(string, bl, bl2, jvmModifier, map);
        }

        @NotNull
        public String getFamilyName() {
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.fix.method.signature", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.name};
            String string = JUnitBundle.message("jvm.inspections.junit.malformed.fix.method.signature.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            UElement uElement;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                    uElement = UastUtils.getUParentForIdentifier((PsiElement)element);
                    if (uElement == null) break block5;
                    UElement $this$asSafely$iv = uElement;
                    boolean $i$f$asSafely = false;
                    UElement uElement2 = $this$asSafely$iv;
                    if (!(uElement2 instanceof UMethod)) {
                        uElement2 = null;
                    }
                    if ((uElement = (UMethod)uElement2) != null) break block6;
                }
                return;
            }
            UElement javaDeclaration = uElement;
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
            this.applyFixes(project, (PsiElement)javaDeclaration.getJavaPsi(), psiFile);
        }

        @NotNull
        protected List<Function1<JvmModifiersOwner, List<IntentionAction>>> getActions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List actions = new ArrayList();
            if (Intrinsics.areEqual((Object)this.shouldBeVoidType, (Object)true)) {
                actions.add(MethodSignatureQuickfix::getActions$lambda$0);
            }
            if (this.newVisibility != null) {
                actions.add(arg_0 -> MethodSignatureQuickfix.getActions$lambda$1(this, arg_0));
            }
            if (this.inCorrectParams != null) {
                actions.add(arg_0 -> MethodSignatureQuickfix.getActions$lambda$2(this, arg_0));
            }
            if (this.makeStatic != null) {
                actions.add(arg_0 -> MethodSignatureQuickfix.getActions$lambda$3(this, arg_0));
            }
            return actions;
        }

        private static final List getActions$lambda$0(JvmModifiersOwner jvmMethod) {
            Intrinsics.checkNotNullParameter((Object)jvmMethod, (String)"jvmMethod");
            JvmModifiersOwner $this$asSafely$iv = jvmMethod;
            boolean $i$f$asSafely = false;
            JvmModifiersOwner jvmModifiersOwner = $this$asSafely$iv;
            if (!(jvmModifiersOwner instanceof JvmMethod)) {
                jvmModifiersOwner = null;
            }
            JvmMethod jvmMethod2 = (JvmMethod)jvmModifiersOwner;
            Intrinsics.checkNotNull((Object)jvmMethod2);
            return JvmElementActionFactories.createChangeTypeActions((JvmMethod)jvmMethod2, (ChangeTypeRequest)MethodRequestsKt.typeRequest((String)JvmPrimitiveTypeKind.VOID.getName(), (List)CollectionsKt.emptyList()));
        }

        private static final List getActions$lambda$1(MethodSignatureQuickfix this$0, JvmModifiersOwner jvmMethod) {
            Intrinsics.checkNotNullParameter((Object)jvmMethod, (String)"jvmMethod");
            return JvmElementActionFactories.createModifierActions((JvmModifiersOwner)jvmMethod, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)this$0.newVisibility, (boolean)true, (boolean)false));
        }

        private static final List getActions$lambda$2(MethodSignatureQuickfix this$0, JvmModifiersOwner jvmMethod) {
            Intrinsics.checkNotNullParameter((Object)jvmMethod, (String)"jvmMethod");
            JvmModifiersOwner $this$asSafely$iv = jvmMethod;
            boolean $i$f$asSafely = false;
            JvmModifiersOwner jvmModifiersOwner = $this$asSafely$iv;
            if (!(jvmModifiersOwner instanceof JvmMethod)) {
                jvmModifiersOwner = null;
            }
            JvmMethod jvmMethod2 = (JvmMethod)jvmModifiersOwner;
            Intrinsics.checkNotNull((Object)jvmMethod2);
            return JvmElementActionFactories.createChangeParametersActions((JvmMethod)jvmMethod2, (ChangeParametersRequest)MethodRequestsKt.setMethodParametersRequest((Iterable)this$0.inCorrectParams.entrySet()));
        }

        private static final List getActions$lambda$3(MethodSignatureQuickfix this$0, JvmModifiersOwner jvmMethod) {
            Intrinsics.checkNotNullParameter((Object)jvmMethod, (String)"jvmMethod");
            return JvmElementActionFactories.createModifierActions((JvmModifiersOwner)jvmMethod, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)this$0.makeStatic, (boolean)false));
        }
    }
}

