/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u0016B]\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0018\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u0012\u0012\t\u0012\u00078\u0001\u00a2\u0006\u0002\b\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/StampBasedCache;", "K", "V", "", "stampCalculator", "Lkotlin/Function1;", "", "valueCalculator", "tagCalculator", "", "maximumSize", "expireDuration", "Ljava/time/Duration;", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/lang/Long;Ljava/time/Duration;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/kubernetes/StampBasedCache$KeyData;", "Lkotlin/jvm/internal/EnhancedNullability;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "KeyData", "intellij.clouds.kubernetes"})
public final class StampBasedCache<K, V> {
    @NotNull
    private final Function1<K, Long> stampCalculator;
    @NotNull
    private final Function1<K, V> valueCalculator;
    @NotNull
    private final Function1<K, String> tagCalculator;
    @NotNull
    private final Cache<KeyData, V> cache;

    /*
     * WARNING - void declaration
     */
    public StampBasedCache(@NotNull Function1<? super K, Long> stampCalculator, @NotNull Function1<? super K, ? extends V> valueCalculator, @NotNull Function1<? super K, String> tagCalculator, @Nullable Long maximumSize, @Nullable Duration expireDuration) {
        void $this$cache_u24lambda_u241;
        Intrinsics.checkNotNullParameter(stampCalculator, (String)"stampCalculator");
        Intrinsics.checkNotNullParameter(valueCalculator, (String)"valueCalculator");
        Intrinsics.checkNotNullParameter(tagCalculator, (String)"tagCalculator");
        this.stampCalculator = stampCalculator;
        this.valueCalculator = valueCalculator;
        this.tagCalculator = tagCalculator;
        Caffeine caffeine = Caffeine.newBuilder();
        StampBasedCache stampBasedCache = this;
        boolean bl = false;
        if (expireDuration != null) {
            $this$cache_u24lambda_u241.expireAfterAccess(expireDuration);
        }
        if (maximumSize != null) {
            $this$cache_u24lambda_u241.maximumSize(maximumSize.longValue());
        }
        Cache cache = $this$cache_u24lambda_u241.softValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        stampBasedCache.cache = cache;
    }

    public /* synthetic */ StampBasedCache(Function1 function1, Function1 function12, Function1 function13, Long l, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function13 = StampBasedCache::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            l = 100L;
        }
        if ((n & 0x10) != 0) {
            duration = Duration.ofMinutes(1L);
        }
        this(function1, function12, function13, l, duration);
    }

    public final V get(K key) {
        long stamp = ((Number)this.stampCalculator.invoke(key)).longValue();
        String tag = (String)this.tagCalculator.invoke(key);
        Object object = this.cache.get((Object)new KeyData(tag, stamp), arg_0 -> StampBasedCache.get$lambda$3(arg_0 -> StampBasedCache.get$lambda$2(this, key, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)object);
        return (V)object;
    }

    private static final String _init_$lambda$0(Object it) {
        return String.valueOf(it);
    }

    private static final Object get$lambda$2(StampBasedCache this$0, Object $key, KeyData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.valueCalculator.invoke($key);
    }

    private static final Object get$lambda$3(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/StampBasedCache$KeyData;", "", "tag", "", "stamp", "", "<init>", "(Ljava/lang/String;J)V", "getTag", "()Ljava/lang/String;", "getStamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.kubernetes"})
    private static final class KeyData {
        @NotNull
        private final String tag;
        private final long stamp;

        public KeyData(@NotNull String tag, long stamp) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.tag = tag;
            this.stamp = stamp;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public final long getStamp() {
            return this.stamp;
        }

        @NotNull
        public final String component1() {
            return this.tag;
        }

        public final long component2() {
            return this.stamp;
        }

        @NotNull
        public final KeyData copy(@NotNull String tag, long stamp) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new KeyData(tag, stamp);
        }

        public static /* synthetic */ KeyData copy$default(KeyData keyData, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = keyData.tag;
            }
            if ((n & 2) != 0) {
                l = keyData.stamp;
            }
            return keyData.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "KeyData(tag=" + this.tag + ", stamp=" + this.stamp + ")";
        }

        public int hashCode() {
            int result = this.tag.hashCode();
            result = result * 31 + Long.hashCode(this.stamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KeyData)) {
                return false;
            }
            KeyData keyData = (KeyData)other;
            if (!Intrinsics.areEqual((Object)this.tag, (Object)keyData.tag)) {
                return false;
            }
            return this.stamp == keyData.stamp;
        }
    }
}

