/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.config;

import com.intellij.codeWithMe.ClientId;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.config.KubernetesOptions;
import com.intellij.kubernetes.config.SpecSource;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@State(name="KubernetesSettings", storages={@Storage(value="kubernetes-settings.xml", deprecated=true), @Storage(value="kubernetes-ide-settings.xml", deprecated=true), @Storage(value="other.xml")}, category=SettingsCategory.TOOLS)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\b\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/config/KubernetesIdeSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/kubernetes/config/KubernetesOptions;", "<init>", "()V", "getEffectiveCrdSpecSources", "", "Lcom/intellij/kubernetes/config/SpecSource;", "resetSpecs", "", "Companion", "intellij.clouds.kubernetes"})
public final class KubernetesIdeSettings
extends SimplePersistentStateComponent<KubernetesOptions> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KubernetesIdeSettings() {
        super((BaseState)new KubernetesOptions());
    }

    @NotNull
    public final List<SpecSource> getEffectiveCrdSpecSources() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)((KubernetesOptions)this.getState()).getSpecSources())), KubernetesIdeSettings::getEffectiveCrdSpecSources$lambda$0), KubernetesIdeSettings::getEffectiveCrdSpecSources$lambda$1));
    }

    @TestOnly
    public final void resetSpecs() {
        ((KubernetesOptions)this.getState()).getSpecSources().clear();
    }

    private static final boolean getEffectiveCrdSpecSources$lambda$0(SpecSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it.getPathOrUrl();
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private static final SpecSource getEffectiveCrdSpecSources$lambda$1(SpecSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SpecSource(MiscUtilKt.toAbsolutePathOrUrl(null, it.getPathOrUrl(), true));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/config/KubernetesIdeSettings$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kubernetes/config/KubernetesIdeSettings;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesIdeSettings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,227:1\n40#2,3:228\n*S KotlinDebug\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesIdeSettings$Companion\n*L\n39#1:228,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KubernetesIdeSettings getInstance() {
            boolean $i$f$service = false;
            Class<KubernetesIdeSettings> serviceClass$iv = KubernetesIdeSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (KubernetesIdeSettings)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

