/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.mappers;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.navigation.KubernetesNamespacedResourceNavigationData;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u001b\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u000e\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J+\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0004JJ\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001c2\u0019\u0010\u001f\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010!0 \u00a2\u0006\u0002\b\"2\u0019\u0010#\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010!0 \u00a2\u0006\u0002\b\"H\u0004J3\u0010$\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\u001c2\u0019\u0010&\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010'0 \u00a2\u0006\u0002\b\"H\u0004JW\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001c2\u000b\u0010)\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000f2\u0019\u0010*\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010!0 \u00a2\u0006\u0002\b\"2\u0019\u0010#\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010!0 \u00a2\u0006\u0002\b\"H\u0004J/\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001c2\u0019\u0010,\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u000b0 \u00a2\u0006\u0002\b\"H\u0004R\u0018\u0010\n\u001a\u00020\u000b*\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006-"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesNamespacedResourceMapper;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesEntity;)V", "rootDirectoryName", "", "getRootDirectoryName", "(Lio/kubernetes/client/common/KubernetesObject;)Ljava/lang/String;", "getResourceDisplayableName", "Lorg/jetbrains/annotations/Nls;", "resource", "isAccepted", "", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "mayBeInList", "getApiModel", "Lkotlin/Function0;", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "isAcceptedFor", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;Lkotlin/jvm/functions/Function0;)Z", "addNamespaceField", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "apiModel", "addReadyField", "getReady", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getDesired", "addImagesField", "", "getPodTemplate", "Lio/kubernetes/client/openapi/models/V1PodTemplateSpec;", "addProgressField", "name", "getCurrent", "addTypeField", "getType", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesNamespacedResourceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNamespacedResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesNamespacedResourceMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor$Companion\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1#2:79\n1#2:100\n172#3,5:80\n172#3,5:85\n1617#4,9:90\n1869#4:99\n1870#4:101\n1626#4:102\n*S KotlinDebug\n*F\n+ 1 KubernetesNamespacedResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesNamespacedResourceMapper\n*L\n65#1:100\n73#1:80,5\n76#1:85,5\n65#1:90,9\n65#1:99\n65#1:101\n65#1:102\n*E\n"})
public abstract class KubernetesNamespacedResourceMapper<T extends KubernetesObject, L extends KubernetesListObject>
extends KubernetesResourceMapper<T, L> {
    public KubernetesNamespacedResourceMapper(@NotNull KubernetesEntity<T, L> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        super(entity);
    }

    @Override
    @NotNull
    public String getRootDirectoryName(@NotNull T $this$rootDirectoryName) {
        Intrinsics.checkNotNullParameter($this$rootDirectoryName, (String)"<this>");
        String string = $this$rootDirectoryName.getMetadata().getNamespace();
        if (string == null) {
            string = "undefined";
        }
        return string;
    }

    @Override
    @NotNull
    public String getResourceDisplayableName(@NotNull T resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Object[] objectArray = new Object[]{super.getResourceDisplayableName(resource), resource.getMetadata().getNamespace()};
        String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.resourceDisplayableName.template", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public boolean isAccepted(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return navigationData instanceof KubernetesNamespacedResourceNavigationData && super.isAccepted(navigationData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mayBeInList(@NotNull KubernetesResourceNavigationData navigationData, @NotNull Function0<? extends KubernetesApiModelInterface> getApiModel) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        Intrinsics.checkNotNullParameter(getApiModel, (String)"getApiModel");
        if (!(navigationData instanceof KubernetesNamespacedResourceNavigationData)) return false;
        String string = ((KubernetesNamespacedResourceNavigationData)navigationData).getNamespace();
        if (string == null) return true;
        String it = string;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)((KubernetesApiModelInterface)getApiModel.invoke()).getNamespace(), (Object)it)) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAcceptedFor(@NotNull T resource, @NotNull KubernetesResourceNavigationData navigationData, @NotNull Function0<? extends KubernetesApiModelInterface> getApiModel) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        Intrinsics.checkNotNullParameter(getApiModel, (String)"getApiModel");
        if (!super.isAcceptedFor(resource, navigationData, getApiModel)) return false;
        if (!(navigationData instanceof KubernetesNamespacedResourceNavigationData)) return false;
        String string = resource.getMetadata().getNamespace();
        String string2 = ((KubernetesNamespacedResourceNavigationData)navigationData).getNamespace();
        if (string2 == null) {
            string2 = ((KubernetesApiModelInterface)getApiModel.invoke()).getCurrentContextObject().getCurrentNamespace();
        }
        if (!Intrinsics.areEqual((Object)string, (Object)string2)) return false;
        return true;
    }

    @Nullable
    protected final KubernetesResourceMapper.ColumnDescriptor<T, ?> addNamespaceField(@NotNull KubernetesApiModelInterface apiModel) {
        KubernetesResourceMapper.ColumnDescriptor columnDescriptor;
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        if (apiModel.isAllNamespaces()) {
            String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.namespaceField.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            columnDescriptor = new KubernetesResourceMapper.ColumnDescriptor(string, Reflection.getOrCreateKotlinClass(String.class), SortOrder.ASCENDING, null, null, null, null, KubernetesNamespacedResourceMapper::addNamespaceField$lambda$1, 120, null);
        } else {
            columnDescriptor = null;
        }
        return columnDescriptor;
    }

    @NotNull
    protected final KubernetesResourceMapper.ColumnDescriptor<T, String> addReadyField(@NotNull Function1<? super T, Integer> getReady, @NotNull Function1<? super T, Integer> getDesired) {
        Intrinsics.checkNotNullParameter(getReady, (String)"getReady");
        Intrinsics.checkNotNullParameter(getDesired, (String)"getDesired");
        String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.readyField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addProgressField(string, getReady, getDesired);
    }

    @NotNull
    protected final KubernetesResourceMapper.ColumnDescriptor<T, Iterable<?>> addImagesField(@NotNull Function1<? super T, ? extends V1PodTemplateSpec> getPodTemplate) {
        Intrinsics.checkNotNullParameter(getPodTemplate, (String)"getPodTemplate");
        String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.imagesField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addMultilineField(string, arg_0 -> KubernetesNamespacedResourceMapper.addImagesField$lambda$2(getPodTemplate, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final KubernetesResourceMapper.ColumnDescriptor<T, String> addProgressField(@NotNull String name, @NotNull Function1<? super T, Integer> getCurrent, @NotNull Function1<? super T, Integer> getDesired) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(getCurrent, (String)"getCurrent");
        Intrinsics.checkNotNullParameter(getDesired, (String)"getDesired");
        KubernetesResourceMapper.ColumnDescriptor.Companion companion = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string = name;
        Function1 getValue$iv = arg_0 -> KubernetesNamespacedResourceMapper.addProgressField$lambda$3(getCurrent, getDesired, arg_0);
        boolean $i$f$simple = false;
        return new KubernetesResourceMapper.ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final KubernetesResourceMapper.ColumnDescriptor<T, String> addTypeField(@NotNull Function1<? super T, String> getType) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getType, (String)"getType");
        KubernetesResourceMapper.ColumnDescriptor.Companion companion = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.typeField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = arg_0 -> KubernetesNamespacedResourceMapper.addTypeField$lambda$4(getType, arg_0);
        boolean $i$f$simple = false;
        return new KubernetesResourceMapper.ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    private static final String addNamespaceField$lambda$1(KubernetesObject $this$ColumnDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$ColumnDescriptor, (String)"$this$ColumnDescriptor");
        return $this$ColumnDescriptor.getMetadata().getNamespace();
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable addImagesField$lambda$2(Function1 $getPodTemplate, KubernetesObject $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = (V1PodTemplateSpec)$getPodTemplate.invoke((Object)$this$addMultilineField);
        if (object != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                V1Container p0 = (V1Container)element$iv$iv;
                boolean bl2 = false;
                if (p0.getImage() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        } else {
            list2 = null;
        }
        return list2;
    }

    private static final String addProgressField$lambda$3(Function1 $getCurrent, Function1 $getDesired, KubernetesObject $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        Integer n = (Integer)$getCurrent.invoke((Object)$this$simple);
        Integer n2 = (Integer)$getDesired.invoke((Object)$this$simple);
        return (n != null ? n : 0) + " / " + (n2 != null ? n2 : 0);
    }

    private static final String addTypeField$lambda$4(Function1 $getType, KubernetesObject $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        return (String)$getType.invoke((Object)$this$simple);
    }
}

