/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.splitApi.DeprecatedMonolithActionDelegator;
import com.intellij.kubernetes.view.inEditor.KubernetesContentInEditorKt;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.nodes.KubernetesServiceViewDescriptor;
import com.intellij.kubernetes.view.ui.KubernetesResourceContent;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeleteResourceProvider;
import com.intellij.kubernetes.view.ui.actions.KubernetesRefreshModelActionKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesRefreshableModelCall;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceActionBaseKt;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0010\b\u0001\u0010\u0003 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u00020\u0006B=\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010&\u001a\u00020\u00132\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(H\u0016\u00a8\u0006*"}, d2={"Lcom/intellij/kubernetes/view/nodes/KubernetesResourceServiceViewDescriptorBase;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "C", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceContent;", "Lcom/intellij/kubernetes/view/nodes/KubernetesServiceViewDescriptor;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "resource", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "icon", "Ljavax/swing/Icon;", "<init>", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;Ljavax/swing/Icon;)V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "createCustomActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createAdditionalCustomActions", "getId", "", "getContentComponent", "Ljavax/swing/JComponent;", "isContentPartVisible", "", "handleDoubleClick", "event", "Ljava/awt/event/MouseEvent;", "getDataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "getRemover", "Ljava/lang/Runnable;", "onNodeSelected", "selectedServices", "", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceServiceViewDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceServiceViewDescriptor.kt\ncom/intellij/kubernetes/view/nodes/KubernetesResourceServiceViewDescriptorBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public abstract class KubernetesResourceServiceViewDescriptorBase<T extends KubernetesObject, C extends KubernetesResourceContent<T>>
extends KubernetesServiceViewDescriptor<T, C>
implements UiDataProvider {
    public KubernetesResourceServiceViewDescriptorBase(@NotNull T resource, @NotNull KubernetesApiModelInterface apiModel, @NotNull CoroutineScope parentCoroutineScope, @NotNull KubernetesResourceMapper<T, ?> mapper, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        String string = resource.getMetadata().getName();
        Intrinsics.checkNotNull((Object)string);
        super(string, icon, apiModel, parentCoroutineScope, resource, mapper);
    }

    public /* synthetic */ KubernetesResourceServiceViewDescriptorBase(KubernetesObject kubernetesObject, KubernetesApiModelInterface kubernetesApiModelInterface, CoroutineScope coroutineScope, KubernetesResourceMapper kubernetesResourceMapper, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            icon = null;
        }
        this(kubernetesObject, kubernetesApiModelInterface, coroutineScope, kubernetesResourceMapper, icon);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (this.getApiModel().getResource(this.getMapper().getEntity()).getUpdateIsDisabled()) {
            sink.set(KubernetesRefreshModelActionKt.getKUBERNETES_REFRESH_RESOURCE_LAMBDA(), (Object)new KubernetesRefreshableModelCall(this){
                final /* synthetic */ KubernetesResourceServiceViewDescriptorBase<T, C> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void invoke() {
                    this.this$0.getApiModel().getResource(this.this$0.getMapper().getEntity()).clear();
                }
            });
        }
    }

    @Override
    @NotNull
    protected DefaultActionGroup createCustomActions() {
        AnAction[] anActionArray = new AnAction[]{KubernetesResourceActionBaseKt.createResourceActionsGroup(), this.createAdditionalCustomActions()};
        return new DefaultActionGroup(anActionArray);
    }

    @NotNull
    protected DefaultActionGroup createAdditionalCustomActions() {
        return new DefaultActionGroup();
    }

    @Override
    @NotNull
    public String getId() {
        String namespace;
        V1ObjectMeta metadata = this.getResource().getMetadata();
        String string = metadata.getName();
        if (string == null) {
            String string2 = metadata.getUid();
            if (string2 == null) {
                string2 = String.valueOf(metadata);
            }
            return string2;
        }
        String name = string;
        String string3 = namespace = this.getMapper().getEntity().isNamespaced() ? metadata.getNamespace() : null;
        return (String)(string3 != null ? string3 + "/" : "") + name;
    }

    @Nullable
    public JComponent getContentComponent() {
        JComponent jComponent;
        JComponent it = jComponent = ((KubernetesResourceContent)this.getContent()).getComponent();
        boolean bl = false;
        return !KubernetesContentInEditorKt.getShowServiceViewContentInEditor() ? jComponent : null;
    }

    public boolean isContentPartVisible() {
        return !KubernetesContentInEditorKt.getShowServiceViewContentInEditor();
    }

    public boolean handleDoubleClick(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JComponent component2 = ((KubernetesResourceContent)this.getContent()).getComponent();
        if (!KubernetesContentInEditorKt.getShowServiceViewContentInEditor()) {
            DeprecatedMonolithActionDelegator.Companion.tryDelegateActionToBackend(component2, event);
            return true;
        }
        Project project = this.getApiModel().getProject();
        ItemPresentation itemPresentation = this.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)itemPresentation, (String)"getPresentation(...)");
        KubernetesContentInEditorKt.showContentInEditor$default(project, component2, this, itemPresentation, this.getId(), (Disposable)this, false, false, 192, null);
        return true;
    }

    @NotNull
    public DataProvider getDataProvider() {
        return KubernetesDeleteResourceProvider.dataProvider;
    }

    @Nullable
    public Runnable getRemover() {
        return null;
    }

    public void onNodeSelected(@Nullable List<Object> selectedServices) {
        if (!KubernetesContentInEditorKt.getShowServiceViewContentPreviewInEditor()) {
            return;
        }
        Project project = this.getApiModel().getProject();
        JComponent jComponent = ((KubernetesResourceContent)this.getContent()).getComponent();
        ItemPresentation itemPresentation = this.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)itemPresentation, (String)"getPresentation(...)");
        KubernetesContentInEditorKt.showContentInEditor$default(project, jComponent, this, itemPresentation, this.getId(), (Disposable)this, false, true, 64, null);
    }
}

