/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesClusterConnectionManager;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "saveClusterConnectionToSetting", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "removeClusterConnectionFromSetting", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesConnectClusterDumpAwareAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConnectClusterDumpAwareAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesConnectClusterDumpAwareActionKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,76:1\n14#2:77\n*S KotlinDebug\n*F\n+ 1 KubernetesConnectClusterDumpAwareAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesConnectClusterDumpAwareActionKt\n*L\n17#1:77\n*E\n"})
public final class KubernetesConnectClusterDumpAwareActionKt {
    @NotNull
    private static final Logger LOG;

    public static final void saveClusterConnectionToSetting(@NotNull KubernetesApiModelInterface apiModel) {
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        KubernetesApiGlobalSettings settings = KubernetesApiGlobalSettings.Companion.getInstance();
        Set<String> connectedClusters = settings.getConnectedClusters();
        settings.setConnectedClusters(SetsKt.plus(connectedClusters, (Object)apiModel.getCurrentContext()));
    }

    public static final void removeClusterConnectionFromSetting(@NotNull KubernetesApiModelInterface apiModel) {
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        KubernetesApiGlobalSettings settings = KubernetesApiGlobalSettings.Companion.getInstance();
        Set<String> connectedClusters = settings.getConnectedClusters();
        settings.setConnectedClusters(SetsKt.minus(connectedClusters, (Object)apiModel.getCurrentContext()));
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesClusterConnectionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

