/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtTransformer;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;

public class StmtStabilize
extends Stmt {
    private Stmt stmt;
    private final String[] relations;

    public StmtStabilize(List<String> relsList, Stmt stmt, Context context) {
        super(context, stmt);
        this.stmt = stmt;
        this.relations = ArrayUtil.toStringArray(relsList);
    }

    public String[] getRelations() {
        return this.relations;
    }

    @Override
    public void accept(StmtVisitor visitor2) {
        if (visitor2.visitStabilizeStart(this)) {
            this.stmt.accept(visitor2);
        }
        visitor2.visitStabilizeEnd(this);
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.stmt = this.stmt.transform(transformer);
        return transformer.transformStabilize(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        boolean changes;
        do {
            int i;
            cancellation.checkCancelled();
            IRelation[] saveRels = new IRelation[this.relations.length];
            for (i = 0; i < saveRels.length; ++i) {
                saveRels[i] = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i], cancellation), "0" + this.toString());
            }
            this.stmt.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
            changes = false;
            for (i = 0; i < saveRels.length; ++i) {
                IRelation relation = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i], cancellation), "1" + this.toString());
                saveRels[i] = saveRels[i].fastRename(relation.getDomains(), cancellation);
                changes |= !saveRels[i].equals(relation);
                saveRels[i].kill();
                relation.kill();
            }
        } while (changes);
    }

    @Override
    public String toLongString() {
        return "StmtStabilize{stmt=" + this.stmt.toLongString() + ", relations=" + Arrays.toString(this.relations) + "}";
    }
}

