/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.bdd.Predicate;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IImmutableRelation;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.DummyThreadCallback;
import com.intellij.rml.dfa.ir.ast.IrEqualityKind;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation;
import com.intellij.rml.dfa.summaries.Condition;
import com.intellij.rml.dfa.summaries.SummaryAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J_\u0010\f\u001a$\u0012 \u0012\u001e\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\r0\r0\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aJ5\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\r0\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u001e\u001a\u00020\u00112\n\u0010\u001f\u001a\u00060\u000fj\u0002`\u00102\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020!0\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/rml/dfa/impl/summaries/SummaryAttributesImpl;", "Lcom/intellij/rml/dfa/summaries/SummaryAttributes;", "provider", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;", "<init>", "(Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;)V", "getProvider", "()Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;", "relationsManager", "Lcom/intellij/rml/dfa/impl/relations/IRelationsManager;", "threadCallback", "Lcom/intellij/rml/dfa/impl/ui/DummyThreadCallback;", "getAttributes", "", "Lkotlin/Pair;", "", "Lcom/intellij/rml/dfa/summaries/Relation;", "", "relationName", "Lcom/intellij/rml/dfa/rml/dsl/lang/RmlRelation;", "projectionIndex", "", "projectionValue", "Lcom/intellij/rml/dfa/attributes/Attribute;", "contextIndex", "removeIndex", "(Lcom/intellij/rml/dfa/rml/dsl/lang/RmlRelation;Ljava/lang/Integer;Lcom/intellij/rml/dfa/attributes/Attribute;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "(Lcom/intellij/rml/dfa/rml/dsl/lang/RmlRelation;Ljava/lang/Integer;Lcom/intellij/rml/dfa/attributes/Attribute;)Ljava/util/List;", "getAttributesMap", "", "generateCondition", "context", "dependentConditions", "Lcom/intellij/rml/dfa/summaries/Condition;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nSummaryAttributesImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryAttributesImpl.kt\ncom/intellij/rml/dfa/impl/summaries/SummaryAttributesImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1563#2:80\n1634#2,3:81\n1193#2,2:84\n1267#2,4:86\n*S KotlinDebug\n*F\n+ 1 SummaryAttributesImpl.kt\ncom/intellij/rml/dfa/impl/summaries/SummaryAttributesImpl\n*L\n38#1:80\n38#1:81,3\n51#1:84,2\n51#1:86,4\n*E\n"})
public final class SummaryAttributesImpl
implements SummaryAttributes {
    @NotNull
    private final RMLInstancesProvider provider;
    @NotNull
    private final IRelationsManager relationsManager;
    @NotNull
    private final DummyThreadCallback threadCallback;

    public SummaryAttributesImpl(@NotNull RMLInstancesProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        this.relationsManager = this.provider.cloneRelationsManager();
        this.threadCallback = new DummyThreadCallback();
    }

    @NotNull
    public final RMLInstancesProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Pair<Object, List<List<String>>>> getAttributes(@NotNull RmlRelation relationName, @Nullable Integer projectionIndex, @Nullable Attribute projectionValue, @Nullable Integer contextIndex, @Nullable Integer removeIndex) {
        Domain contextDomain;
        Intrinsics.checkNotNullParameter((Object)relationName, (String)"relationName");
        IImmutableRelation iImmutableRelation = this.provider.getRelationsRepository().getRelationOrNull(relationName.getName());
        if (iImmutableRelation == null || (iImmutableRelation = iImmutableRelation.makeMutableRelation(this.relationsManager)) == null) {
            return CollectionsKt.emptyList();
        }
        IImmutableRelation relation = iImmutableRelation;
        Integer n = projectionIndex;
        Domain projectDomain = n != null ? relation.getDomain(n) : null;
        Integer n2 = removeIndex;
        Domain removeDomain = n2 != null ? relation.getDomain(n2) : null;
        Integer n3 = contextIndex;
        Domain domain = contextDomain = n3 != null ? relation.getDomain(n3) : null;
        if (projectDomain != null && projectionValue != null) {
            SymbolTable symbolTable = this.provider.getSymbolTable();
            DomainType domainType = projectDomain.getType();
            Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getType(...)");
            String string = projectionValue.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            int attributeInt = symbolTable.getAttributeInt(domainType, string);
            Domain[] domainArray = relation.getDomains();
            Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"getDomains(...)");
            IRelation iRelation = relation.project(ArraysKt.indexOf((Object[])domainArray, (Object)projectDomain), attributeInt, this.threadCallback);
            Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"project(...)");
            relation = iRelation;
        }
        if (removeDomain != null) {
            IRelation iRelation = relation.exists(removeDomain, this.threadCallback);
            Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"exists(...)");
            relation = iRelation;
        }
        Function1 attrFun2 = (Function1)new Function1<IRelation, List<? extends List<? extends String>>>(this){
            final /* synthetic */ SummaryAttributesImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<List<String>> invoke(IRelation it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Attribute[][] attributeArray = it.getAttributes(1000, this.this$0.getProvider().getSymbolTable());
                Intrinsics.checkNotNullExpressionValue((Object)attributeArray, (String)"getAttributes(...)");
                Object[] $this$map$iv = (Object[])attributeArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    void it2;
                    Attribute[] attributeArray2 = (Attribute[])item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    void $this$map$iv2 = it2;
                    boolean $i$f$map2 = false;
                    void var14_14 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(((void)$this$map$iv2).length);
                    boolean $i$f$mapTo2 = false;
                    int n = ((void)$this$mapTo$iv$iv2).length;
                    for (int i = 0; i < n; ++i) {
                        void it3;
                        void item$iv$iv2;
                        void var20_20 = item$iv$iv2 = $this$mapTo$iv$iv2[i];
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        String string = it3.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        collection2.add(string);
                    }
                    collection.add((List)destination$iv$iv2);
                }
                return (List)destination$iv$iv;
            }
        };
        if (contextDomain != null) {
            void $this$mapTo$iv$iv;
            Domain[] domainArray = relation.getDomains();
            Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"getDomains(...)");
            List<Pair<IRelation, IRelation>> list = relation.disjoin(ArraysKt.indexOf((Object[])domainArray, (Object)contextDomain), this.threadCallback);
            Intrinsics.checkNotNullExpressionValue(list, (String)"disjoin(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IRelation nonContextPart = (IRelation)pair.component1();
                IRelation contextPart = (IRelation)pair.component2();
                Intrinsics.checkNotNull((Object)nonContextPart);
                collection.add(new Pair((Object)contextPart, attrFun2.invoke((Object)nonContextPart)));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)new Pair((Object)relation, attrFun2.invoke((Object)relation)));
    }

    @NotNull
    public List<List<String>> getAttributes(@NotNull RmlRelation relationName, @Nullable Integer projectionIndex, @Nullable Attribute projectionValue) {
        Intrinsics.checkNotNullParameter((Object)relationName, (String)"relationName");
        Object object = (Pair)CollectionsKt.firstOrNull((List)SummaryAttributes.getAttributes$default((SummaryAttributes)this, (RmlRelation)relationName, (Integer)projectionIndex, (Attribute)projectionValue, null, null, (int)16, null));
        if (object == null || (object = (List)object.getSecond()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, String> getAttributesMap(@NotNull RmlRelation relationName) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)relationName, (String)"relationName");
        Iterable $this$associate$iv = SummaryAttributes.getAttributes$default((SummaryAttributes)this, (RmlRelation)relationName, null, null, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair(it.get(0), it.get(1));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public String generateCondition(@NotNull Object context, @NotNull Map<Integer, Condition> dependentConditions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(dependentConditions, (String)"dependentConditions");
        Predicate predicate = ((IRelation)context).generateCondition();
        Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"generateCondition(...)");
        return SummaryAttributesImpl.generateCondition$print$2(predicate, context, dependentConditions, 0);
    }

    private static final String generateCondition$parentheses(String expr, int upperPriority, int curPriority) {
        return upperPriority > curPriority ? "(" + expr + ")" : expr;
    }

    private static final String generateCondition$print(Condition $this$generateCondition_u24print, boolean negated) {
        String curComparison = negated ? IrEqualityKind.Companion.parse($this$generateCondition_u24print.getComparison()).invert().toString() : $this$generateCondition_u24print.getComparison();
        return $this$generateCondition_u24print.getLeft() + " " + curComparison + " " + $this$generateCondition_u24print.getRight();
    }

    private static final String generateCondition$condition(Object $context, Map<Integer, Condition> $dependentConditions, int varIdx, boolean negated) {
        String string;
        Intrinsics.checkNotNull((Object)$context, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.relations.IRelation");
        Domain[] domainArray = ((IRelation)$context).getDomains();
        Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"getDomains(...)");
        int condIdx = varIdx - ((Domain)ArraysKt.first((Object[])domainArray)).getFirstVar();
        if (condIdx == 0) {
            string = "$paramsAliased";
        } else {
            string = $dependentConditions.get(condIdx);
            if (string == null || (string = SummaryAttributesImpl.generateCondition$print((Condition)string, negated)) == null) {
                string = "";
            }
        }
        return string;
    }

    private static final String generateCondition$print$2(Predicate $this$generateCondition_u24print_u242, Object $context, Map<Integer, Condition> $dependentConditions, int priority) {
        String string;
        Predicate predicate = $this$generateCondition_u24print_u242;
        if (predicate instanceof Predicate.ConstFalse) {
            string = "false";
        } else if (predicate instanceof Predicate.ConstTrue) {
            string = "true";
        } else if (predicate instanceof Predicate.And) {
            string = SummaryAttributesImpl.generateCondition$parentheses(SummaryAttributesImpl.generateCondition$print$2(((Predicate.And)$this$generateCondition_u24print_u242).getLeft(), $context, $dependentConditions, 2) + " && " + SummaryAttributesImpl.generateCondition$print$2(((Predicate.And)$this$generateCondition_u24print_u242).getRight(), $context, $dependentConditions, 2), priority, 2);
        } else if (predicate instanceof Predicate.Or) {
            string = SummaryAttributesImpl.generateCondition$parentheses(SummaryAttributesImpl.generateCondition$print$2(((Predicate.Or)$this$generateCondition_u24print_u242).getLeft(), $context, $dependentConditions, 1) + " || " + SummaryAttributesImpl.generateCondition$print$2(((Predicate.Or)$this$generateCondition_u24print_u242).getRight(), $context, $dependentConditions, 1), priority, 1);
        } else if (predicate instanceof Predicate.If) {
            string = SummaryAttributesImpl.generateCondition$parentheses(SummaryAttributesImpl.generateCondition$condition($context, $dependentConditions, ((Predicate.If)$this$generateCondition_u24print_u242).getVariable(), false) + " ? " + SummaryAttributesImpl.generateCondition$print$2(((Predicate.If)$this$generateCondition_u24print_u242).getThenBranch(), $context, $dependentConditions, 0) + " : " + SummaryAttributesImpl.generateCondition$print$2(((Predicate.If)$this$generateCondition_u24print_u242).getElseBranch(), $context, $dependentConditions, 0), priority, 0);
        } else if (predicate instanceof Predicate.Var) {
            string = SummaryAttributesImpl.generateCondition$condition($context, $dependentConditions, ((Predicate.Var)$this$generateCondition_u24print_u242).getVariable(), ((Predicate.Var)$this$generateCondition_u24print_u242).getNegated());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

