/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.workspaceModel;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.workspaceModel.WebFacetBridgeFactory;
import com.intellij.javaee.web.workspaceModel.WebFacetConfigurationBridge;
import com.intellij.javaee.web.workspaceModel.WebSettingsEntity;
import com.intellij.javaee.web.workspaceModel.WebSettingsKt;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.workspaceModel.ide.legacyBridge.WorkspaceFacetContributor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javaee/web/workspaceModel/WebFacetContributor;", "Lcom/intellij/workspaceModel/ide/legacyBridge/WorkspaceFacetContributor;", "Lcom/intellij/javaee/web/workspaceModel/WebSettingsEntity;", "<init>", "()V", "rootEntityType", "Ljava/lang/Class;", "getRootEntityType", "()Ljava/lang/Class;", "getRootEntitiesByModuleEntity", "", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "createFacetFromEntity", "Lcom/intellij/javaee/web/facet/WebFacet;", "entity", "module", "Lcom/intellij/openapi/module/Module;", "getParentModuleEntity", "intellij.javaee.web.impl"})
public final class WebFacetContributor
implements WorkspaceFacetContributor<WebSettingsEntity> {
    public WebFacetContributor() {
        if (!WebFacetBridgeFactory.INSTANCE.getWebFacetBridgeEnabled()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    @NotNull
    public Class<WebSettingsEntity> getRootEntityType() {
        return WebSettingsEntity.class;
    }

    @NotNull
    public List<WebSettingsEntity> getRootEntitiesByModuleEntity(@NotNull ModuleEntity moduleEntity) {
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        return WebSettingsKt.getWebSettings((ModuleEntity)moduleEntity);
    }

    @NotNull
    public WebFacet createFacetFromEntity(@NotNull WebSettingsEntity entity, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        WebFacetType facetType = WebFacetType.getInstance();
        WebFacetConfigurationBridge facetConfigurationBridge = new WebFacetConfigurationBridge(entity);
        WebFacet webFacet = facetType.createFacet(module, entity.getName(), facetConfigurationBridge, null);
        Intrinsics.checkNotNullExpressionValue((Object)webFacet, (String)"createFacet(...)");
        return webFacet;
    }

    @NotNull
    public ModuleEntity getParentModuleEntity(@NotNull WebSettingsEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getModule();
    }
}

