/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.actions.test;

import com.intellij.execution.junit.JUnit4Framework;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.KtorStarterIcons;
import com.intellij.lang.Language;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ktor/actions/test/KtorTestFramework;", "Lcom/intellij/execution/junit/JUnit4Framework;", "protocol", "Lcom/intellij/ktor/actions/test/KtorTestFramework$Protocol;", "ktorMajorVersion", "", "<init>", "(Lcom/intellij/ktor/actions/test/KtorTestFramework$Protocol;I)V", "testMethodTemplateName", "", "getName", "getIcon", "Ljavax/swing/Icon;", "getLanguage", "Lcom/intellij/lang/Language;", "getTestMethodFileTemplateDescriptor", "Lcom/intellij/ide/fileTemplates/FileTemplateDescriptor;", "getTestClassFileTemplateDescriptor", "getMarkerClassFQName", "Protocol", "intellij.ktor"})
public final class KtorTestFramework
extends JUnit4Framework {
    @NotNull
    private final String testMethodTemplateName;

    public KtorTestFramework(@NotNull Protocol protocol, int ktorMajorVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        this.testMethodTemplateName = "Ktor " + Math.min(ktorMajorVersion, 2) + " " + protocol.getTemplateName() + " Test Method.kt";
    }

    @NotNull
    public String getName() {
        return KtorStarterBundle.INSTANCE.message("ktor.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = KtorStarterIcons.Ktor;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Ktor");
        return icon;
    }

    @NotNull
    public Language getLanguage() {
        Language language = Language.findLanguageByID((String)"kotlin");
        Intrinsics.checkNotNull((Object)language);
        return language;
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor(this.testMethodTemplateName);
    }

    @NotNull
    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Ktor Test Class.kt");
    }

    @NotNull
    protected String getMarkerClassFQName() {
        return "org.junit.Test";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ktor/actions/test/KtorTestFramework$Protocol;", "", "templateName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getTemplateName", "()Ljava/lang/String;", "HTTP", "WEB_SOCKET", "intellij.ktor"})
    public static final class Protocol
    extends Enum<Protocol> {
        @NotNull
        private final String templateName;
        public static final /* enum */ Protocol HTTP = new Protocol("HTTP");
        public static final /* enum */ Protocol WEB_SOCKET = new Protocol("WebSocket");
        private static final /* synthetic */ Protocol[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Protocol(String templateName) {
            this.templateName = templateName;
        }

        @NotNull
        public final String getTemplateName() {
            return this.templateName;
        }

        public static Protocol[] values() {
            return (Protocol[])$VALUES.clone();
        }

        public static Protocol valueOf(String value) {
            return Enum.valueOf(Protocol.class, value);
        }

        @NotNull
        public static EnumEntries<Protocol> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = protocolArray = new Protocol[]{Protocol.HTTP, Protocol.WEB_SOCKET};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

