/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.oas;

import com.intellij.ktor.KtorUastSearchUtilsKt;
import com.intellij.ktor.oas.ApplicationInfo;
import com.intellij.ktor.oas.KtorOasCallAnalyzer;
import com.intellij.ktor.oas.KtorOasCommentAnalyzerKt;
import com.intellij.ktor.oas.KtorOasElementsCombinationKt;
import com.intellij.ktor.oas.KtorOasVisitor;
import com.intellij.ktor.oas.KtorOasVisitorKt;
import com.intellij.ktor.oas.PartiallyKnownOasResponse;
import com.intellij.ktor.oas.TypeDescriptor;
import com.intellij.microservices.jvm.oas.JvmSwaggerUtilsKt;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasParameterIn;
import com.intellij.microservices.oas.OasRequestBody;
import com.intellij.microservices.oas.OasResponse;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ab\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\"\b\u0000\u0018\u00002\u00020\u0001:\u0001BB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0010\u00100\u001a\u00020*2\u0006\u0010+\u001a\u000201H\u0016J&\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020*07H\u0002J\u0016\u00109\u001a\u0002032\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000f0;H\u0002J \u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0018H\u0002J\u0010\u0010A\u001a\u0002032\u0006\u0010+\u001a\u00020\u001cH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010%\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006C"}, d2={"Lcom/intellij/ktor/oas/KtorOasVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "rootRoutingCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "contentTypesFromRoute", "", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Ljava/util/Set;)V", "applicationInfo", "Lcom/intellij/ktor/oas/ApplicationInfo;", "contentTypes", "responses", "", "Lcom/intellij/ktor/oas/KtorOasVisitor$ResponseDescriptor;", "Lcom/intellij/microservices/oas/OasResponse;", "getResponses", "()Ljava/util/Map;", "parameters", "", "Lcom/intellij/microservices/oas/OasParameter;", "getParameters", "()Ljava/util/List;", "knownSchemas", "Lcom/intellij/microservices/oas/OasSchema;", "getKnownSchemas", "calls", "Ljava/util/Stack;", "Lorg/jetbrains/uast/UCallExpression;", "maxExceptionDepth", "", "getMaxExceptionDepth", "()I", "callsAnalyzer", "com/intellij/ktor/oas/KtorOasVisitor$callsAnalyzer$1", "Lcom/intellij/ktor/oas/KtorOasVisitor$callsAnalyzer$1;", "requestBodyContent", "requestBody", "Lcom/intellij/microservices/oas/OasRequestBody;", "getRequestBody", "()Lcom/intellij/microservices/oas/OasRequestBody;", "visitArrayAccessExpression", "", "node", "Lorg/jetbrains/uast/UArrayAccessExpression;", "visitLocalVariable", "Lorg/jetbrains/uast/ULocalVariable;", "visitCallExpression", "visitThrowExpression", "Lorg/jetbrains/uast/UThrowExpression;", "saveStatusPagesResponses", "", "exceptionExpr", "Lorg/jetbrains/uast/UExpression;", "accept", "Lkotlin/Function1;", "Lcom/intellij/ktor/oas/TypeDescriptor;", "saveResponses", "newResponses", "", "saveParameter", "parameterName", "parameterType", "Lcom/intellij/microservices/oas/OasParameterIn;", "parameterSchema", "afterVisitCallExpression", "ResponseDescriptor", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorOasVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorOasVisitor.kt\ncom/intellij/ktor/oas/KtorOasVisitor\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,533:1\n171#2:534\n43#3:535\n1761#4,3:536\n1374#4:541\n1460#4,5:542\n1869#4,2:547\n216#5,2:539\n*S KotlinDebug\n*F\n+ 1 KtorOasVisitor.kt\ncom/intellij/ktor/oas/KtorOasVisitor\n*L\n132#1:534\n153#1:535\n167#1:536,3\n190#1:541\n190#1:542,5\n197#1:547,2\n182#1:539,2\n*E\n"})
public final class KtorOasVisitor
extends AbstractUastVisitor {
    @NotNull
    private final ApplicationInfo applicationInfo;
    @NotNull
    private final Set<String> contentTypes;
    @NotNull
    private final Map<ResponseDescriptor, OasResponse> responses;
    @NotNull
    private final List<OasParameter> parameters;
    @NotNull
    private final Map<String, OasSchema> knownSchemas;
    @NotNull
    private final Stack<UCallExpression> calls;
    @NotNull
    private final callsAnalyzer.1 callsAnalyzer;
    @NotNull
    private final Map<String, OasSchema> requestBodyContent;

    public KtorOasVisitor(@Nullable KtCallExpression rootRoutingCall, @NotNull Set<String> contentTypesFromRoute) {
        Intrinsics.checkNotNullParameter(contentTypesFromRoute, (String)"contentTypesFromRoute");
        this.applicationInfo = ApplicationInfo.Companion.getApplicationInfoByRouting(rootRoutingCall);
        this.contentTypes = SetsKt.plus(contentTypesFromRoute, (Iterable)this.applicationInfo.getContentTypes());
        this.responses = new LinkedHashMap();
        this.parameters = new ArrayList();
        this.knownSchemas = MapsKt.toMutableMap(this.applicationInfo.getKnownSchemas());
        this.calls = new Stack();
        this.callsAnalyzer = new KtorOasCallAnalyzer<OasResponse>(this){
            private final Map<String, OasSchema> knownSchemas;
            private final Stack<UCallExpression> callStack;
            final /* synthetic */ KtorOasVisitor this$0;
            {
                this.this$0 = $receiver;
                this.knownSchemas = $receiver.getKnownSchemas();
                this.callStack = KtorOasVisitor.access$getCalls$p($receiver);
            }

            public Map<String, OasSchema> getKnownSchemas() {
                return this.knownSchemas;
            }

            public Stack<UCallExpression> getCallStack() {
                return this.callStack;
            }

            /*
             * WARNING - void declaration
             */
            public List<OasResponse> transformResponses(List<PartiallyKnownOasResponse> responses) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter(responses, (String)"responses");
                Iterable $this$flatMap$iv = responses;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    PartiallyKnownOasResponse it = (PartiallyKnownOasResponse)element$iv$iv;
                    boolean bl = false;
                    if (it.getCode() == null) {
                        it.setCode("200");
                    }
                    Iterable list$iv$iv = it.evaluateInContext(null);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public void saveParameter(String name, OasParameterIn type, OasSchema schema) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                KtorOasVisitor.access$saveParameter(this.this$0, name, type, schema);
            }

            public void saveResponses(List<OasResponse> nodeResponses) {
                Intrinsics.checkNotNullParameter(nodeResponses, (String)"nodeResponses");
                KtorOasVisitor.access$saveResponses(this.this$0, nodeResponses);
            }

            public void saveRequestBody(String contentType, OasSchema requestSchema) {
                Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
                Intrinsics.checkNotNullParameter((Object)requestSchema, (String)"requestSchema");
                String string = (String)CollectionsKt.lastOrNull((Iterable)KtorOasVisitor.access$getContentTypes$p(this.this$0));
                if (string == null) {
                    string = "*/*";
                }
                String existedContentType = string;
                String c = !Intrinsics.areEqual((Object)contentType, (Object)"*/*") ? contentType : existedContentType;
                KtorOasVisitor.access$getRequestBodyContent$p(this.this$0).put(c, requestSchema);
            }

            public boolean visitThrowExpression(UThrowExpression node) {
                block9: {
                    block8: {
                        boolean bl;
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (KtorOasCommentAnalyzerKt.shouldIgnoreExceptions((UExpression)node)) break block8;
                            Iterable $this$any$iv = KtorOasVisitor.access$getCalls$p(this.this$0);
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    UExpression p0 = (UExpression)element$iv;
                                    boolean bl2 = false;
                                    if (!KtorOasCommentAnalyzerKt.shouldIgnoreExceptions(p0)) continue;
                                    bl = true;
                                    break block7;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block9;
                    }
                    return true;
                }
                this.this$0.visitThrowExpression(node);
                return true;
            }
        };
        this.requestBodyContent = new LinkedHashMap();
    }

    @NotNull
    public final Map<ResponseDescriptor, OasResponse> getResponses() {
        return this.responses;
    }

    @NotNull
    public final List<OasParameter> getParameters() {
        return this.parameters;
    }

    @NotNull
    public final Map<String, OasSchema> getKnownSchemas() {
        return this.knownSchemas;
    }

    private final int getMaxExceptionDepth() {
        return Registry.Companion.intValue("ktor.oas.visitor.depth", 20);
    }

    @Nullable
    public final OasRequestBody getRequestBody() {
        return !this.requestBodyContent.isEmpty() ? new OasRequestBody(this.requestBodyContent, true) : null;
    }

    public boolean visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
        block5: {
            OasSchemaType parameterType;
            UElement uElement;
            Object it;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (KtorUastSearchUtilsKt.inheritsParameters(node.getReceiver().getExpressionType()) && !((Collection)node.getIndices()).isEmpty()) {
                Object object = ((UExpression)node.getIndices().get(0)).evaluate();
                if (object != null) {
                    it = object;
                    boolean bl = false;
                    OasParameterIn parameterIn = KtorOasVisitorKt.access$getParameterInType(node.getReceiver());
                    UElement uElement2 = node.getUastParent();
                    UReferenceExpression uReferenceExpression = uElement2 instanceof UReferenceExpression ? (UReferenceExpression)uElement2 : null;
                    OasSchemaType parameterType2 = KtorOasVisitorKt.access$converterToSchemaType(uReferenceExpression != null && (uReferenceExpression = UastUtils.tryResolveNamed((UElement)((UElement)uReferenceExpression))) != null ? uReferenceExpression.getName() : null);
                    this.saveParameter(it.toString(), parameterIn, new OasSchema(parameterType2, null, null, null, null, null, null, null, false, false, 1020, null));
                }
            }
            if (KtorUastSearchUtilsKt.inheritsHeaders(node.getReceiver().getExpressionType()) && !((Collection)node.getIndices()).isEmpty()) {
                Object object = ((UExpression)node.getIndices().get(0)).evaluate();
                if (object != null) {
                    it = object;
                    boolean bl = false;
                    uElement = node.getUastParent();
                    UReferenceExpression uReferenceExpression = uElement instanceof UReferenceExpression ? (UReferenceExpression)uElement : null;
                    parameterType = KtorOasVisitorKt.access$converterToSchemaType(uReferenceExpression != null && (uReferenceExpression = UastUtils.tryResolveNamed((UElement)((UElement)uReferenceExpression))) != null ? uReferenceExpression.getName() : null);
                    this.saveParameter(it.toString(), OasParameterIn.HEADER, new OasSchema(parameterType, null, null, null, null, null, null, null, false, false, 1020, null));
                }
            }
            if (!KtorUastSearchUtilsKt.inheritsCookies(node.getReceiver().getExpressionType()) || !(!((Collection)node.getIndices()).isEmpty())) break block5;
            Object object = ((UExpression)node.getIndices().get(0)).evaluate();
            if (object != null) {
                it = object;
                boolean bl = false;
                uElement = node.getUastParent();
                UReferenceExpression uReferenceExpression = uElement instanceof UReferenceExpression ? (UReferenceExpression)uElement : null;
                parameterType = KtorOasVisitorKt.access$converterToSchemaType(uReferenceExpression != null && (uReferenceExpression = UastUtils.tryResolveNamed((UElement)((UElement)uReferenceExpression))) != null ? uReferenceExpression.getName() : null);
                this.saveParameter(it.toString(), OasParameterIn.COOKIE, new OasSchema(parameterType, null, null, null, null, null, null, null, false, false, 1020, null));
            }
        }
        return super.visitArrayAccessExpression(node);
    }

    public boolean visitLocalVariable(@NotNull ULocalVariable node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = node.getSourcePsi();
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        KtExpression delegateExpression = ktProperty != null ? ktProperty.getDelegateExpression() : null;
        PsiElement $this$toUElementOfType$iv = (PsiElement)delegateExpression;
        boolean $i$f$toUElementOfType = false;
        UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
        if (uExpression == null) {
            return super.visitLocalVariable(node);
        }
        UExpression uastInitializer = uExpression;
        if (KtorUastSearchUtilsKt.inheritsParameters(uastInitializer.getExpressionType())) {
            Pair pair = JvmSwaggerUtilsKt.getOasSchemaForPsiType$default((PsiType)node.getType(), (boolean)false, (int)2, null);
            if (pair == null) {
                return super.visitLocalVariable(node);
            }
            OasSchema parameterSchema = (OasSchema)pair.component1();
            String string = node.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.saveParameter(string, OasParameterIn.PATH, parameterSchema);
        }
        return super.visitLocalVariable(node);
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        boolean res;
        block4: {
            UMethod method;
            block3: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                res = this.callsAnalyzer.visitCallExpression(node);
                if (!(node instanceof KotlinUFunctionCallExpression)) {
                    return res;
                }
                if (KtorUastSearchUtilsKt.isApplicationCall(((KotlinUFunctionCallExpression)node).getReceiverType()) || KtorUastSearchUtilsKt.signatureContainsApplicationCall((KotlinUFunctionCallExpression)node) || KtorUastSearchUtilsKt.isCallPipeline(((KotlinUFunctionCallExpression)node).getReceiverType()) || KtorUastSearchUtilsKt.inheritsRoute(((KotlinUFunctionCallExpression)node).getReceiverType()) || this.calls.size() >= this.getMaxExceptionDepth()) {
                    return res;
                }
                UResolvable $this$resolveToUElementOfType$iv = (UResolvable)node;
                boolean $i$f$resolveToUElementOfType = false;
                UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                if (!(uElement instanceof UMethod)) {
                    uElement = null;
                }
                if (!KtorOasVisitorKt.access$isError(method = (UMethod)((UElement)((UMethod)uElement)))) break block3;
                this.saveStatusPagesResponses(null, (Function1<? super TypeDescriptor, Boolean>)((Function1)KtorOasVisitor::visitCallExpression$lambda$3));
                break block4;
            }
            UMethod uMethod = method;
            if (uMethod == null) break block4;
            uMethod.accept((UastVisitor)this);
        }
        return res;
    }

    public boolean visitThrowExpression(@NotNull UThrowExpression node) {
        block10: {
            block9: {
                boolean bl;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (KtorOasCommentAnalyzerKt.shouldIgnoreExceptions((UExpression)node)) break block9;
                    Iterable $this$any$iv = this.calls;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UExpression p0 = (UExpression)element$iv;
                            boolean bl2 = false;
                            if (!KtorOasCommentAnalyzerKt.shouldIgnoreExceptions(p0)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block10;
            }
            return true;
        }
        UExpression exceptionExpr = node.getThrownExpression();
        boolean bl = false;
        PsiType psiType = exceptionExpr.getExpressionType();
        if (psiType == null) {
            return true;
        }
        PsiType exceptionType = psiType;
        this.saveStatusPagesResponses(exceptionExpr, (Function1<? super TypeDescriptor, Boolean>)((Function1)arg_0 -> KtorOasVisitor.visitThrowExpression$lambda$5$lambda$4(exceptionType, arg_0)));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveStatusPagesResponses(UExpression exceptionExpr, Function1<? super TypeDescriptor, Boolean> accept) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Map<TypeDescriptor, List<PartiallyKnownOasResponse>> mapping = this.applicationInfo.getStatusPagesMapping();
        TypeDescriptor mostPreciseType = null;
        List<PartiallyKnownOasResponse> responsesForException = null;
        responsesForException = CollectionsKt.emptyList();
        Object $this$forEach$iv = mapping;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<TypeDescriptor, List<PartiallyKnownOasResponse>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TypeDescriptor, List<PartiallyKnownOasResponse>> element$iv;
            Map.Entry<TypeDescriptor, List<PartiallyKnownOasResponse>> entry = element$iv = iterator.next();
            boolean bl = false;
            TypeDescriptor type = entry.getKey();
            List<PartiallyKnownOasResponse> responses = entry.getValue();
            if (!((Boolean)accept.invoke((Object)type)).booleanValue() || mostPreciseType != null && !type.inherits(mostPreciseType)) continue;
            mostPreciseType = type;
            responsesForException = responses;
        }
        $this$forEach$iv = responsesForException;
        KtorOasVisitor ktorOasVisitor = this;
        boolean $i$f$flatMap = false;
        iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PartiallyKnownOasResponse it = (PartiallyKnownOasResponse)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.evaluateInContext(exceptionExpr);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        ktorOasVisitor.saveResponses((List)destination$iv$iv);
    }

    private final void saveResponses(List<OasResponse> newResponses) {
        Iterable $this$forEach$iv = newResponses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OasResponse newResponse = (OasResponse)element$iv;
            boolean bl = false;
            ResponseDescriptor newDescriptor = new ResponseDescriptor(newResponse.getCode(), newResponse.getDescription());
            OasResponse oldResponse = this.responses.get(newDescriptor);
            this.responses.put(newDescriptor, KtorOasElementsCombinationKt.combineRespond(newResponse, oldResponse));
        }
    }

    private final void saveParameter(String parameterName, OasParameterIn parameterType, OasSchema parameterSchema) {
        ((Collection)this.parameters).add(new OasParameter.Builder(parameterName, parameterType).build(arg_0 -> KtorOasVisitor.saveParameter$lambda$9(parameterSchema, parameterType, arg_0)));
    }

    public void afterVisitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.calls.pop();
        super.afterVisitCallExpression(node);
    }

    private static final boolean visitCallExpression$lambda$3(TypeDescriptor type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return KtorOasVisitorKt.access$getERROR_METHOD_EXCEPTION_TYPE$p().inherits(type);
    }

    private static final boolean visitThrowExpression$lambda$5$lambda$4(PsiType $exceptionType, TypeDescriptor type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return KtorUastSearchUtilsKt.inheritsFqName$default($exceptionType, type.getTypeName(), 0, 2, null);
    }

    private static final Unit saveParameter$lambda$9(OasSchema $parameterSchema, OasParameterIn $parameterType, OasParameter.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $this$build.setSchema($parameterSchema);
        if ($parameterType == OasParameterIn.PATH) {
            $this$build.setRequired(true);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Stack access$getCalls$p(KtorOasVisitor $this) {
        return $this.calls;
    }

    public static final /* synthetic */ void access$saveParameter(KtorOasVisitor $this, String parameterName, OasParameterIn parameterType, OasSchema parameterSchema) {
        $this.saveParameter(parameterName, parameterType, parameterSchema);
    }

    public static final /* synthetic */ void access$saveResponses(KtorOasVisitor $this, List newResponses) {
        $this.saveResponses(newResponses);
    }

    public static final /* synthetic */ Set access$getContentTypes$p(KtorOasVisitor $this) {
        return $this.contentTypes;
    }

    public static final /* synthetic */ Map access$getRequestBodyContent$p(KtorOasVisitor $this) {
        return $this.requestBodyContent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ktor/oas/KtorOasVisitor$ResponseDescriptor;", "", "statusCode", "", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getStatusCode", "()Ljava/lang/String;", "getDescription", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ktor"})
    public static final class ResponseDescriptor {
        @NotNull
        private final String statusCode;
        @Nullable
        private final String description;

        public ResponseDescriptor(@NotNull String statusCode, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)statusCode, (String)"statusCode");
            this.statusCode = statusCode;
            this.description = description;
        }

        @NotNull
        public final String getStatusCode() {
            return this.statusCode;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.statusCode;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final ResponseDescriptor copy(@NotNull String statusCode, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)statusCode, (String)"statusCode");
            return new ResponseDescriptor(statusCode, description);
        }

        public static /* synthetic */ ResponseDescriptor copy$default(ResponseDescriptor responseDescriptor, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = responseDescriptor.statusCode;
            }
            if ((n & 2) != 0) {
                string2 = responseDescriptor.description;
            }
            return responseDescriptor.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ResponseDescriptor(statusCode=" + this.statusCode + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = this.statusCode.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResponseDescriptor)) {
                return false;
            }
            ResponseDescriptor responseDescriptor = (ResponseDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.statusCode, (Object)responseDescriptor.statusCode)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)responseDescriptor.description);
        }
    }
}

