/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.plugins.add;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.initializr.KtorGeneratorWebAPI;
import com.intellij.ktor.initializr.json.KtorPluginDescriptor;
import com.intellij.ktor.initializr.json.KtorVersion;
import com.intellij.ktor.initializr.json.OptionalSetting;
import com.intellij.ktor.initializr.json.ProjectSettingsTemplate;
import com.intellij.ktor.utils.KtorVersionModel;
import com.intellij.ktor.utils.KtorVersionSuffix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0002J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010!\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R6\u0010\u0011\u001a*\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0014*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ktor/plugins/add/KtorPluginsService;", "", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "pluginsSerializer", "Lkotlinx/serialization/KSerializer;", "", "Lcom/intellij/ktor/initializr/json/KtorPluginDescriptor;", "cacheDirectory", "Ljava/io/File;", "lastUpdatedTime", "Ljava/util/concurrent/atomic/AtomicLong;", "UPDATE_TIME_RATE", "Lkotlin/time/Duration;", "J", "ktorPluginsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "kotlin.jvm.PlatformType", "getOrForceUpdateForVersion", "ktorVersion", "Lcom/intellij/ktor/utils/KtorVersionModel;", "checkForUpdates", "", "updateDescriptorsForVersion", "generatorApi", "Lcom/intellij/ktor/initializr/KtorGeneratorWebAPI;", "isUpdateNeeded", "", "getAllKtorVersions", "getPluginDescriptors", "updatePluginDescriptors", "descriptors", "Companion", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorPluginsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorPluginsService.kt\ncom/intellij/ktor/plugins/add/KtorPluginsService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1321#2,2:143\n1#3:145\n*S KotlinDebug\n*F\n+ 1 KtorPluginsService.kt\ncom/intellij/ktor/plugins/add/KtorPluginsService\n*L\n42#1:143,2\n*E\n"})
public final class KtorPluginsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @NotNull
    private final KSerializer<List<KtorPluginDescriptor>> pluginsSerializer = BuiltinSerializersKt.ListSerializer(KtorPluginDescriptor.Companion.serializer());
    @NotNull
    private final File cacheDirectory = new File(PathManager.getTempPath(), "ktor-mp-plugins-new/");
    @NotNull
    private AtomicLong lastUpdatedTime = new AtomicLong(this.cacheDirectory.lastModified());
    private final long UPDATE_TIME_RATE = DurationKt.toDuration((int)24, (DurationUnit)DurationUnit.HOURS);
    @NotNull
    private final ConcurrentHashMap<String, List<KtorPluginDescriptor>> ktorPluginsMap;

    /*
     * WARNING - void declaration
     */
    public KtorPluginsService() {
        void p0;
        Map $this$ktorPluginsMap_u24lambda_u242;
        Sequence sequence;
        Sequence sequence2;
        Map map;
        Map map2 = map = (Map)new LinkedHashMap();
        KtorPluginsService ktorPluginsService = this;
        boolean bl = false;
        Object[] objectArray = this.cacheDirectory.listFiles();
        if (objectArray != null && (sequence2 = ArraysKt.asSequence((Object[])objectArray)) != null && (sequence = SequencesKt.filter((Sequence)sequence2, KtorPluginsService::ktorPluginsMap$lambda$2$lambda$0)) != null) {
            void $this$forEach$iv;
            Sequence sequence3 = sequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                String ktorVersion = file.getName();
                try {
                    DeserializationStrategy deserializationStrategy = (DeserializationStrategy)this.pluginsSerializer;
                    Intrinsics.checkNotNull((Object)file);
                    List descriptor = (List)Json.Default.decodeFromString(deserializationStrategy, FilesKt.readText$default((File)file, null, (int)1, null));
                    Intrinsics.checkNotNull((Object)ktorVersion);
                    $this$ktorPluginsMap_u24lambda_u242.put(ktorVersion, descriptor);
                }
                catch (Throwable throwable) {
                }
            }
        }
        $this$ktorPluginsMap_u24lambda_u242 = map;
        boolean bl3 = false;
        ktorPluginsService.ktorPluginsMap = new ConcurrentHashMap(p0);
    }

    @NotNull
    public final List<KtorPluginDescriptor> getOrForceUpdateForVersion(@NotNull KtorVersionModel ktorVersion) {
        Intrinsics.checkNotNullParameter((Object)ktorVersion, (String)"ktorVersion");
        List<KtorPluginDescriptor> computedPlugins = this.getPluginDescriptors(ktorVersion);
        if (!((Collection)computedPlugins).isEmpty()) {
            return computedPlugins;
        }
        KtorGeneratorWebAPI ktorGenerator = KtorGeneratorWebAPI.Companion.getInstance();
        this.updateDescriptorsForVersion(ktorVersion.getBaseVersion(), ktorGenerator);
        return this.getPluginDescriptors(ktorVersion);
    }

    public final void checkForUpdates() {
        if (this.isUpdateNeeded()) {
            return;
        }
        KtorGeneratorWebAPI ktorGenerator = KtorGeneratorWebAPI.Companion.getInstance();
        Object object = ktorGenerator.getSettingsTemplate();
        if (object == null || (object = ((ProjectSettingsTemplate)object).getKtorVersion()) == null || (object = ((OptionalSetting)object).getOptions()) == null) {
            return;
        }
        List allKtorVersions = object;
        for (KtorVersion ktorVersion : allKtorVersions) {
            this.updateDescriptorsForVersion(ktorVersion.getId(), ktorGenerator);
        }
    }

    private final void updateDescriptorsForVersion(String ktorVersion, KtorGeneratorWebAPI generatorApi) {
        List<KtorPluginDescriptor> descriptors = generatorApi.getPluginDescriptors(ktorVersion);
        this.updatePluginDescriptors(ktorVersion, descriptors);
    }

    private final boolean isUpdateNeeded() {
        long lastUpdatedValue = this.lastUpdatedTime.get();
        if (System.currentTimeMillis() - lastUpdatedValue < Duration.getInWholeMilliseconds-impl((long)this.UPDATE_TIME_RATE)) {
            return true;
        }
        return !this.lastUpdatedTime.compareAndSet(lastUpdatedValue, System.currentTimeMillis());
    }

    private final List<String> getAllKtorVersions() {
        Enumeration<String> enumeration = this.ktorPluginsMap.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        ArrayList<String> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<KtorPluginDescriptor> getPluginDescriptors(@NotNull KtorVersionModel ktorVersion) {
        List list;
        Intrinsics.checkNotNullParameter((Object)ktorVersion, (String)"ktorVersion");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            List list2 = this.ktorPluginsMap.get(ktorVersion.toString());
            if (list2 == null) {
                Object v3;
                block6: {
                    Set<Map.Entry<String, List<KtorPluginDescriptor>>> set = this.ktorPluginsMap.entrySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                    Iterable iterable = set;
                    for (Object t : iterable) {
                        Map.Entry entry = (Map.Entry)t;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)entry);
                        String version = (String)entry.getKey();
                        Intrinsics.checkNotNull((Object)version);
                        KtorVersionModel ktorVersionModel = KtorVersionModel.Companion.parseVersion$default(KtorVersionModel.Companion, version, false, 2, null);
                        if (!Intrinsics.areEqual((Object)(ktorVersionModel != null ? ktorVersionModel.getBaseVersion() : null), (Object)ktorVersion.getBaseVersion())) continue;
                        v3 = t;
                        break block6;
                    }
                    v3 = null;
                }
                Map.Entry entry = v3;
                list2 = entry != null ? (List)entry.getValue() : null;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
            }
            list = list2;
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updatePluginDescriptors(@NotNull String ktorVersion, @NotNull List<KtorPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter((Object)ktorVersion, (String)"ktorVersion");
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            ((Map)this.ktorPluginsMap).put(ktorVersion, descriptors);
            File pluginsFile = new File(this.cacheDirectory, ktorVersion);
            String pluginsJson = Json.Default.encodeToString((SerializationStrategy)this.pluginsSerializer, descriptors);
            FileUtilRt.createParentDirs((File)pluginsFile);
            Closeable closeable = Files.newBufferedWriter(pluginsFile.toPath(), new OpenOption[0]);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl2 = false;
                writer.write(pluginsJson);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private static final boolean ktorPluginsMap$lambda$2$lambda$0(File it) {
        return it.canRead();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ktor/plugins/add/KtorPluginsService$Companion;", "", "<init>", "()V", "getPluginDescriptors", "", "Lcom/intellij/ktor/initializr/json/KtorPluginDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "getMaxAvailableKtorVersion", "Lcom/intellij/ktor/utils/KtorVersionModel;", "getInstance", "Lcom/intellij/ktor/plugins/add/KtorPluginsService;", "intellij.ktor"})
    @SourceDebugExtension(value={"SMAP\nKtorPluginsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorPluginsService.kt\ncom/intellij/ktor/plugins/add/KtorPluginsService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,142:1\n1617#2,9:143\n1869#2:152\n1870#2:154\n1626#2:155\n774#2:156\n865#2,2:157\n1#3:153\n40#4,3:159\n*S KotlinDebug\n*F\n+ 1 KtorPluginsService.kt\ncom/intellij/ktor/plugins/add/KtorPluginsService$Companion\n*L\n136#1:143,9\n136#1:152\n136#1:154\n136#1:155\n137#1:156\n137#1:157,2\n136#1:153\n140#1:159,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KtorPluginDescriptor> getPluginDescriptors(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            KtorVersionModel ktorVersionModel = KtorLibraryUtilKt.getKtorServerOrClientVersion(module);
            if (ktorVersionModel == null) {
                return CollectionsKt.emptyList();
            }
            KtorVersionModel ktorVersion = ktorVersionModel;
            return this.getInstance().getPluginDescriptors(ktorVersion);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final KtorVersionModel getMaxAvailableKtorVersion() {
            void $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = this.getInstance().getAllKtorVersions();
            KtorVersionModel.Companion companion = KtorVersionModel.Companion;
            boolean $i$f$mapNotNull22 = false;
            void var4_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KtorVersionModel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String p0 = (String)element$iv$iv;
                boolean bl2 = false;
                if (KtorVersionModel.Companion.parseVersion$default(companion, p0, false, 2, null) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            Iterable $i$f$mapNotNull22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtorVersionModel it = (KtorVersionModel)element$iv$iv;
                boolean bl = false;
                if (!(it.getSuffix().getKind() == KtorVersionSuffix.Kind.Release)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            return (KtorVersionModel)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        }

        @NotNull
        public final KtorPluginsService getInstance() {
            boolean $i$f$service = false;
            Class<KtorPluginsService> serviceClass$iv = KtorPluginsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (KtorPluginsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

