/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.plugins.add.starters.dialog;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ktor.initializr.json.BuildSystemDependency;
import com.intellij.ktor.initializr.json.KtorPluginDescriptor;
import com.intellij.ktor.initializr.json.KtorPluginSearchResult;
import com.intellij.ktor.initializr.plugins.AbstractKtorPluginsStep;
import com.intellij.ktor.plugins.add.KtorPluginsService;
import com.intellij.ktor.plugins.add.starters.dialog.KtorModuleAddPluginsInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0014J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\rH\u0002J\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\rH\u0002J\u0014\u0010\u001c\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ktor/plugins/add/starters/dialog/KtorAddPluginsStep;", "Lcom/intellij/ktor/initializr/plugins/AbstractKtorPluginsStep;", "module", "Lcom/intellij/openapi/module/Module;", "moduleInfoMinimal", "Lcom/intellij/ktor/plugins/add/starters/dialog/KtorModuleAddPluginsInfo;", "wizardContext", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/ktor/plugins/add/starters/dialog/KtorModuleAddPluginsInfo;Lcom/intellij/ide/util/projectWizard/WizardContext;)V", "getModuleInfoMinimal", "()Lcom/intellij/ktor/plugins/add/starters/dialog/KtorModuleAddPluginsInfo;", "getPluginsDescriptors", "", "Lcom/intellij/ktor/initializr/json/KtorPluginDescriptor;", "getPluginsList", "Lcom/intellij/ktor/initializr/json/KtorPluginSearchResult;", "findAndUpdateAlreadyExistPlugins", "", "plugins", "pluginAlreadyExists", "", "plugin", "declaredDependencies", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "dependencyAlreadyExists", "dependency", "Lcom/intellij/ktor/initializr/json/BuildSystemDependency;", "toPluginSearchResult", "isRemovable", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorAddPluginsStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorAddPluginsStep.kt\ncom/intellij/ktor/plugins/add/starters/dialog/KtorAddPluginsStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1563#2:62\n1634#2,3:63\n1563#2:66\n1634#2,3:67\n774#2:70\n865#2,2:71\n1563#2:73\n1634#2,3:74\n1740#2,3:77\n1761#2,3:80\n*S KotlinDebug\n*F\n+ 1 KtorAddPluginsStep.kt\ncom/intellij/ktor/plugins/add/starters/dialog/KtorAddPluginsStep\n*L\n27#1:62\n27#1:63,3\n34#1:66\n34#1:67,3\n36#1:70\n36#1:71,2\n36#1:73\n36#1:74,3\n40#1:77,3\n44#1:80,3\n*E\n"})
public final class KtorAddPluginsStep
extends AbstractKtorPluginsStep {
    @NotNull
    private final Module module;
    @NotNull
    private final KtorModuleAddPluginsInfo moduleInfoMinimal;

    public KtorAddPluginsStep(@NotNull Module module, @NotNull KtorModuleAddPluginsInfo moduleInfoMinimal, @NotNull WizardContext wizardContext) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleInfoMinimal, (String)"moduleInfoMinimal");
        Intrinsics.checkNotNullParameter((Object)wizardContext, (String)"wizardContext");
        super(moduleInfoMinimal, wizardContext);
        this.module = module;
        this.moduleInfoMinimal = moduleInfoMinimal;
    }

    @Override
    @NotNull
    protected KtorModuleAddPluginsInfo getModuleInfoMinimal() {
        return this.moduleInfoMinimal;
    }

    private final List<KtorPluginDescriptor> getPluginsDescriptors() {
        return KtorPluginsService.Companion.getInstance().getOrForceUpdateForVersion(this.getModuleInfoMinimal().getKtorVersionModel());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<KtorPluginSearchResult> getPluginsList() {
        void $this$mapTo$iv$iv;
        List<KtorPluginDescriptor> plugins = this.getPluginsDescriptors();
        List<String> nonRemovablePluginIds = this.findAndUpdateAlreadyExistPlugins(plugins);
        Iterable $this$map$iv = plugins;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtorPluginDescriptor ktorPluginDescriptor = (KtorPluginDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toPluginSearchResult((KtorPluginDescriptor)it, !nonRemovablePluginIds.contains(it.getPluginId())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findAndUpdateAlreadyExistPlugins(List<KtorPluginDescriptor> plugins) {
        KtorPluginDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$map$iv = DependencyModifierService.Companion.getInstance(project).declaredDependencies(this.module);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DeclaredDependency declaredDependency = (DeclaredDependency)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getUnifiedDependency());
        }
        List declaredDependencies = (List)destination$iv$iv;
        Iterable $this$filter$iv = plugins;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtorPluginDescriptor)element$iv$iv;
            boolean bl = false;
            if (!this.pluginAlreadyExists(it, declaredDependencies)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtorPluginDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPluginId());
        }
        return (List)destination$iv$iv;
    }

    private final boolean pluginAlreadyExists(KtorPluginDescriptor plugin, List<UnifiedDependency> declaredDependencies) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = plugin.getDependencies();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BuildSystemDependency it = (BuildSystemDependency)element$iv;
                    boolean bl2 = false;
                    if (this.dependencyAlreadyExists(it, declaredDependencies)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean dependencyAlreadyExists(BuildSystemDependency dependency, List<UnifiedDependency> declaredDependencies) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = declaredDependencies;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UnifiedDependency it = (UnifiedDependency)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getCoordinates().getGroupId(), (Object)dependency.getGroup()) && Intrinsics.areEqual((Object)it.getCoordinates().getArtifactId(), (Object)dependency.getArtifact()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final KtorPluginSearchResult toPluginSearchResult(KtorPluginDescriptor $this$toPluginSearchResult, boolean isRemovable) {
        String string = $this$toPluginSearchResult.getPluginId();
        String string2 = $this$toPluginSearchResult.getPluginName();
        String string3 = $this$toPluginSearchResult.getGroup();
        if (string3 == null) {
            string3 = "Default";
        }
        return new KtorPluginSearchResult(string, string2, string3, $this$toPluginSearchResult.getShortDescription(), $this$toPluginSearchResult.getGithub(), $this$toPluginSearchResult.getVendor().getName(), $this$toPluginSearchResult.getVendor().getVendorUrl(), this.getModuleInfoMinimal().getKtorVersion(), $this$toPluginSearchResult.getRequiredFeatures(), isRemovable);
    }
}

