/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.ArrayCreateNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@ImportStatic(value={JSRuntime.class, Integer.class})
public abstract class ArrayCreateNode
extends JavaScriptBaseNode {
    private final JSContext context;

    protected ArrayCreateNode(JSContext context) {
        this.context = context;
    }

    @NeverDefault
    public static ArrayCreateNode create(JSContext context) {
        return ArrayCreateNodeGen.create(context);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length <= MAX_VALUE"})
    protected final JSArrayObject doDefault(long length, JSRealm realm, JSDynamicObject proto) {
        return JSArray.createEmptyChecked(this.context, realm, proto, length);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length > MAX_VALUE"})
    protected final JSArrayObject doLargeLength(long length, JSRealm realm, JSDynamicObject proto) {
        return JSArray.createSparseArray(this.context, realm, proto, length);
    }

    @Specialization(guards={"!isValidArrayLength(length)"})
    protected final JSArrayObject doInvalidLength(long length, JSRealm realm, JSDynamicObject proto) {
        throw Errors.createRangeErrorInvalidArrayLength(this);
    }

    public final JSArrayObject execute(long length) {
        JSRealm realm = this.getRealm();
        return this.execute(length, realm, realm.getArrayPrototype());
    }

    public abstract JSArrayObject execute(long var1, JSRealm var3, JSDynamicObject var4);
}

