/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntArrayBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.MultiCharacterCaseFolding;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBFlags;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBRegexLexer;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.List;
import org.graalvm.collections.Pair;

public final class OracleDBRegexParser
implements RegexParser {
    private final RegexSource source;
    private final OracleDBFlags flags;
    private final OracleDBRegexLexer lexer;
    private final RegexASTBuilder astBuilder;
    private CodePointSetAccumulator curCharClass = new CodePointSetAccumulator();
    private CodePointSetAccumulator curCharClassPosixEquivalenceClasses = new CodePointSetAccumulator();
    private CodePointSetAccumulator charClassTmp = new CodePointSetAccumulator();

    @CompilerDirectives.TruffleBoundary
    public OracleDBRegexParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        this(language, source, compilationBuffer, source);
    }

    public OracleDBRegexParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer, RegexSource originalSource) throws RegexSyntaxException {
        this.source = source;
        this.flags = OracleDBFlags.parseFlags(source);
        this.lexer = new OracleDBRegexLexer(source, this.flags, compilationBuffer);
        this.astBuilder = new RegexASTBuilder(language, originalSource, RegexFlags.builder().dotAll(this.flags.isDotAll()).ignoreCase(this.flags.isIgnoreCase()).multiline(this.flags.isMultiline()).build(), false, compilationBuffer);
    }

    @Override
    public OracleDBFlags getFlags() {
        return this.flags;
    }

    @Override
    public AbstractRegexObject getNamedCaptureGroups() {
        return AbstractRegexObject.createNamedCaptureGroupMapInt(this.lexer.getNamedCaptureGroups());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public RegexAST parse() throws RegexSyntaxException {
        IntArrayBuffer literalStringBuffer = new IntArrayBuffer();
        this.astBuilder.pushRootGroup();
        Token token = null;
        block15: while (this.lexer.hasNext()) {
            Token.Kind prevKind = token == null ? null : token.kind;
            token = this.lexer.next();
            if (token.kind != Token.Kind.literalChar && !literalStringBuffer.isEmpty()) {
                int last = -1;
                if (token.kind == Token.Kind.quantifier) {
                    last = literalStringBuffer.get(literalStringBuffer.length() - 1);
                    literalStringBuffer.setLength(literalStringBuffer.length() - 1);
                }
                this.addLiteralString(literalStringBuffer);
                if (last >= 0) {
                    assert (literalStringBuffer.isEmpty());
                    literalStringBuffer.add(last);
                    this.addLiteralString(literalStringBuffer);
                }
            }
            switch (token.kind) {
                case A: 
                case z: {
                    this.astBuilder.addPositionAssertion(token);
                    continue block15;
                }
                case caret: {
                    if (prevKind == Token.Kind.caret) continue block15;
                    if (this.flags.isMultiline()) {
                        this.astBuilder.pushGroup();
                        this.astBuilder.addCaret();
                        this.astBuilder.nextSequence();
                        this.astBuilder.pushLookBehindAssertion(false);
                        this.astBuilder.addCharClass(CodePointSet.create(10));
                        this.astBuilder.popGroup();
                        this.astBuilder.popGroup();
                        continue block15;
                    }
                    this.astBuilder.addPositionAssertion(token);
                    continue block15;
                }
                case dollar: 
                case Z: {
                    if (prevKind == Token.Kind.dollar) continue block15;
                    this.astBuilder.pushGroup();
                    this.astBuilder.addDollar();
                    this.astBuilder.nextSequence();
                    this.astBuilder.pushLookAheadAssertion(false);
                    this.astBuilder.addCharClass(CodePointSet.create(10));
                    if (token.kind == Token.Kind.Z || !this.flags.isMultiline()) {
                        this.astBuilder.addDollar();
                    }
                    this.astBuilder.popGroup();
                    this.astBuilder.popGroup();
                    continue block15;
                }
                case backReference: {
                    this.astBuilder.addBackReference((Token.BackReference)token, this.flags.isIgnoreCase());
                    continue block15;
                }
                case quantifier: {
                    if (this.astBuilder.getCurTerm() == null || prevKind == Token.Kind.captureGroupBegin) continue block15;
                    Token.Quantifier quantifier = (Token.Quantifier)token;
                    if (this.astBuilder.getCurTerm().isQuantifiableTerm() && this.astBuilder.getCurTerm().asQuantifiableTerm().hasQuantifier()) {
                        Token.Quantifier existingQuantifier = this.astBuilder.getCurTerm().asQuantifiableTerm().getQuantifier();
                        if (existingQuantifier.getMin() > 1) {
                            this.astBuilder.wrapCurTermInGroup();
                        } else {
                            this.astBuilder.addQuantifier(Token.createQuantifier(Math.max(quantifier.getMin(), existingQuantifier.getMin()), (int)Math.max(Integer.toUnsignedLong(quantifier.getMax()), Integer.toUnsignedLong(existingQuantifier.getMax())), quantifier.isGreedy() && existingQuantifier.isGreedy()));
                            continue block15;
                        }
                    }
                    this.astBuilder.addQuantifier(quantifier);
                    continue block15;
                }
                case alternation: {
                    this.astBuilder.nextSequence();
                    continue block15;
                }
                case captureGroupBegin: {
                    if (this.lexer.numberOfCaptureGroupsSoFar() <= 10) {
                        this.astBuilder.pushCaptureGroup(token);
                        continue block15;
                    }
                    this.astBuilder.pushGroup(token);
                    continue block15;
                }
                case groupEnd: {
                    if (this.astBuilder.getCurGroup().getParent() instanceof RegexASTRootNode) {
                        throw this.syntaxError("unmatched parentheses in regular expression");
                    }
                    this.astBuilder.popGroup(token);
                    continue block15;
                }
                case literalChar: {
                    literalStringBuffer.add(((Token.LiteralCharacter)token).getCodePoint());
                    continue block15;
                }
                case charClass: {
                    this.astBuilder.addCharClass((Token.CharacterClass)token);
                    continue block15;
                }
                case charClassBegin: {
                    this.curCharClass.clear();
                    this.curCharClassPosixEquivalenceClasses.clear();
                    continue block15;
                }
                case charClassAtom: {
                    CodePointSet contents = ((Token.CharacterClassAtom)token).getContents();
                    if (((Token.CharacterClassAtom)token).isPosixCollationEquivalenceClass()) {
                        this.curCharClassPosixEquivalenceClasses.addSet(contents);
                        continue block15;
                    }
                    this.curCharClass.addSet(contents);
                    continue block15;
                }
                case charClassEnd: {
                    this.addCharClass();
                    continue block15;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (!this.astBuilder.curGroupIsRoot()) {
            throw this.syntaxError("unmatched parentheses in regular expression");
        }
        if (!literalStringBuffer.isEmpty()) {
            this.addLiteralString(literalStringBuffer);
        }
        return this.astBuilder.popRootGroup();
    }

    private void addCharClass() {
        boolean wasSingleChar;
        boolean bl = wasSingleChar = !this.lexer.isCurCharClassInverted() && this.curCharClass.matchesSingleChar() && this.curCharClassPosixEquivalenceClasses.isEmpty();
        if (this.flags.isIgnoreCase()) {
            MultiCharacterCaseFolding.caseClosure(CaseFoldData.CaseFoldAlgorithm.OracleDB, this.curCharClass, this.charClassTmp, (a, b) -> true, Encodings.UTF_8.getFullSet());
        }
        MultiCharacterCaseFolding.caseClosure(CaseFoldData.CaseFoldAlgorithm.OracleDBAI, this.curCharClassPosixEquivalenceClasses, this.charClassTmp, (a, b) -> true, Encodings.UTF_8.getFullSet());
        this.curCharClass.addSet(this.curCharClassPosixEquivalenceClasses.get());
        if (this.lexer.isCurCharClassInverted()) {
            this.curCharClass.invert(Encodings.UTF_8);
        }
        if (this.flags.isIgnoreCase()) {
            List<Pair<Integer, int[]>> multiCodePointExpansions = MultiCharacterCaseFolding.caseClosureMultiCodePoint(CaseFoldData.CaseFoldAlgorithm.OracleDB, this.curCharClass);
            List<Pair<Integer, int[]>> multiCodePointExpansionsPEC = MultiCharacterCaseFolding.caseClosureMultiCodePoint(CaseFoldData.CaseFoldAlgorithm.OracleDBAI, this.curCharClassPosixEquivalenceClasses);
            if (!multiCodePointExpansions.isEmpty() || !multiCodePointExpansionsPEC.isEmpty()) {
                this.astBuilder.pushGroup();
                this.astBuilder.addCharClass(this.curCharClass.toCodePointSet());
                this.addMultiCodePointExpansions(multiCodePointExpansions, CaseFoldData.CaseFoldAlgorithm.OracleDB);
                this.addMultiCodePointExpansions(multiCodePointExpansionsPEC, CaseFoldData.CaseFoldAlgorithm.OracleDBAI);
                this.astBuilder.popGroup();
            } else {
                this.astBuilder.addCharClass(this.curCharClass.toCodePointSet(), wasSingleChar);
            }
        } else if (!this.curCharClassPosixEquivalenceClasses.isEmpty()) {
            List<Pair<Integer, int[]>> multiCodePointExpansionsPEC = MultiCharacterCaseFolding.caseClosureMultiCodePoint(CaseFoldData.CaseFoldAlgorithm.OracleDBAI, this.curCharClassPosixEquivalenceClasses);
            if (!multiCodePointExpansionsPEC.isEmpty()) {
                this.astBuilder.pushGroup();
                this.astBuilder.addCharClass(this.curCharClass.toCodePointSet());
                this.addMultiCodePointExpansions(multiCodePointExpansionsPEC, CaseFoldData.CaseFoldAlgorithm.OracleDBAI);
                this.astBuilder.popGroup();
            } else {
                this.astBuilder.addCharClass(this.curCharClass.toCodePointSet(), wasSingleChar);
            }
        } else {
            this.astBuilder.addCharClass(this.curCharClass.toCodePointSet(), wasSingleChar);
        }
    }

    private void addMultiCodePointExpansions(List<Pair<Integer, int[]>> multiCodePointExpansions, CaseFoldData.CaseFoldAlgorithm algorithm) {
        for (Pair<Integer, int[]> pair : multiCodePointExpansions) {
            this.astBuilder.nextSequence();
            int[] to = pair.getRight();
            boolean dropAsciiOnStart = false;
            MultiCharacterCaseFolding.caseFoldUnfoldString(algorithm, to, Encodings.UTF_8.getFullSet(), dropAsciiOnStart, this.astBuilder);
        }
    }

    private void addLiteralString(IntArrayBuffer literalStringBuffer) {
        if (this.flags.isIgnoreCase()) {
            MultiCharacterCaseFolding.caseFoldUnfoldString(CaseFoldData.CaseFoldAlgorithm.OracleDB, literalStringBuffer.toArray(), Encodings.UTF_8.getFullSet(), this.astBuilder);
        } else {
            for (int i = 0; i < literalStringBuffer.length(); ++i) {
                this.astBuilder.addCharClass(CodePointSet.create(literalStringBuffer.get(i)), true);
            }
        }
        literalStringBuffer.clear();
    }

    private RegexSyntaxException syntaxError(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.lexer.getLastTokenPosition());
    }
}

