/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.client;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.jupyter.connections.client.JupyterClientImpl;
import com.intellij.jupyter.core.jupyter.connections.client.JupyterConnectionHealthChecker;
import com.intellij.jupyter.core.jupyter.connections.client.status.JupyterConnectionStatus;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterConnectionHealthChecker;", "Lcom/intellij/openapi/Disposable;", "client", "Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterClientImpl;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterClientImpl;)V", "getClient", "()Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterClientImpl;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "asyncTask", "Lkotlinx/coroutines/Deferred;", "", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "dispose", "onStatusChange", "status", "Lcom/intellij/jupyter/core/jupyter/connections/client/status/JupyterConnectionStatus;", "(Lcom/intellij/jupyter/core/jupyter/connections/client/status/JupyterConnectionStatus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startCheck", "stopCheck", "checkConnectionHealth", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterConnectionHealthChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConnectionHealthChecker.kt\ncom/intellij/jupyter/core/jupyter/connections/client/JupyterConnectionHealthChecker\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,60:1\n40#2,3:61\n116#3,11:64\n*S KotlinDebug\n*F\n+ 1 JupyterConnectionHealthChecker.kt\ncom/intellij/jupyter/core/jupyter/connections/client/JupyterConnectionHealthChecker\n*L\n17#1:61,3\n25#1:64,11\n*E\n"})
public final class JupyterConnectionHealthChecker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterClientImpl client;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Deferred<Unit> asyncTask;
    @NotNull
    private final Mutex mutex;

    public JupyterConnectionHealthChecker(@NotNull JupyterClientImpl client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        boolean $i$f$service = false;
        Class<JupyterCoroutine> serviceClass$iv = JupyterCoroutine.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)((JupyterCoroutine)object).getCoroutineScope(), (String)(this.client.getUri() + " health checker"), null, (boolean)false, (int)6, null);
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @NotNull
    public final JupyterClientImpl getClient() {
        return this.client;
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object onStatusChange(@NotNull JupyterConnectionStatus status, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof onStatusChange.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ JupyterConnectionHealthChecker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.onStatusChange(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = status;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                status = (JupyterConnectionStatus)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-JupyterConnectionHealthChecker$onStatusChange$2 = false;
                    var7_11 = status;
                    if (var7_11 instanceof JupyterConnectionStatus.Failed) {
                        this.stopCheck();
                    } else if (var7_11 instanceof JupyterConnectionStatus.NotStarted) {
                        this.stopCheck();
                    } else if (var7_11 instanceof JupyterConnectionStatus.Success) {
                        this.startCheck();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    var8_12 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var8_12;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void startCheck() {
        Deferred<Unit> deferred = this.asyncTask;
        if (deferred != null) {
            Job.DefaultImpls.cancel$default((Job)((Job)deferred), null, (int)1, null);
        }
        this.asyncTask = BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterConnectionHealthChecker this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)com.intellij.jupyter.core.jupyter.connections.client.JupyterConnectionHealthChecker$Companion.access$getHealthCheckIntervalMs(JupyterConnectionHealthChecker.Companion), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        this.label = 2;
                        v1 = JupyterConnectionHealthChecker.access$checkConnectionHealth(this.this$0, (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void stopCheck() {
        Deferred<Unit> deferred = this.asyncTask;
        if (deferred != null) {
            Job.DefaultImpls.cancel$default((Job)((Job)deferred), null, (int)1, null);
        }
        this.asyncTask = null;
    }

    private final Object checkConnectionHealth(Continuation<? super Unit> $completion) {
        JupyterConnectionStatus jupyterConnectionStatus = this.client.getCachedConnectionStatus();
        if (!(jupyterConnectionStatus instanceof JupyterConnectionStatus.Failed) && !Intrinsics.areEqual((Object)jupyterConnectionStatus, (Object)JupyterConnectionStatus.NotStarted.INSTANCE)) {
            if (jupyterConnectionStatus instanceof JupyterConnectionStatus.Success) {
                Object object = this.client.checkConnection($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$checkConnectionHealth(JupyterConnectionHealthChecker $this, Continuation $completion) {
        return $this.checkConnectionHealth((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterConnectionHealthChecker$Companion;", "", "<init>", "()V", "healthCheckIntervalMs", "", "getHealthCheckIntervalMs", "()J", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        private final long getHealthCheckIntervalMs() {
            return Registry.Companion.get("jupyter.health.check.ms").asInteger();
        }

        public static final /* synthetic */ long access$getHealthCheckIntervalMs(Companion $this) {
            return $this.getHealthCheckIntervalMs();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

