/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression.FirExpressionJavaNullabilityWarningCheckersKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute;
import org.jetbrains.kotlin.fir.expressions.ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttributeKt;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedTypeForWarningAttributeKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirQualifiedAccessJavaNullabilityWarningChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "willBeMarkedNullableInFuture", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirExpressionJavaNullabilityWarningCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionJavaNullabilityWarningCheckers.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirQualifiedAccessJavaNullabilityWarningChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,197:1\n1#2:198\n60#3,4:199\n216#4,2:203\n*S KotlinDebug\n*F\n+ 1 FirExpressionJavaNullabilityWarningCheckers.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirQualifiedAccessJavaNullabilityWarningChecker\n*L\n58#1:199,4\n58#1:203,2\n*E\n"})
public final class FirQualifiedAccessJavaNullabilityWarningChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirQualifiedAccessJavaNullabilityWarningChecker INSTANCE = new FirQualifiedAccessJavaNullabilityWarningChecker();

    private FirQualifiedAccessJavaNullabilityWarningChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        block9: {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(expression2, "expression");
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> symbol = firCallableSymbol;
            ConeSubstitutor substitutor2 = SubstitutionUtilsKt.createConeSubstitutorFromTypeArguments$default(expression2, symbol, context2.getSession(), false, false, 12, null);
            if (symbol.getDispatchReceiverType() != null) {
                FirExpression firExpression;
                Object object = expression2.getDispatchReceiver();
                boolean bl = object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? this.willBeMarkedNullableInFuture((ConeKotlinType)object) : false;
                if (bl && (firExpression = expression2.getDispatchReceiver()) != null) {
                    FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(reporter, context2, firExpression, symbol.getDispatchReceiverType(), FirJvmErrors.INSTANCE.getRECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
                }
            }
            ConeKotlinType receiverType = symbol.getResolvedReceiverType();
            FirExpression firExpression = expression2.getExtensionReceiver();
            if (firExpression != null) {
                ConeKotlinType coneKotlinType;
                DiagnosticReporter diagnosticReporter = reporter;
                CheckerContext checkerContext = context2;
                FirExpression firExpression2 = firExpression;
                ConeKotlinType coneKotlinType2 = receiverType;
                if (coneKotlinType2 != null) {
                    void p0;
                    ConeKotlinType coneKotlinType3 = coneKotlinType2;
                    FirExpression firExpression3 = firExpression2;
                    CheckerContext checkerContext2 = checkerContext;
                    DiagnosticReporter diagnosticReporter2 = diagnosticReporter;
                    boolean bl = false;
                    ConeKotlinType coneKotlinType4 = substitutor2.substituteOrSelf((ConeKotlinType)p0);
                    diagnosticReporter = diagnosticReporter2;
                    checkerContext = checkerContext2;
                    firExpression2 = firExpression3;
                    coneKotlinType = coneKotlinType4;
                } else {
                    coneKotlinType = null;
                }
                FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(diagnosticReporter, checkerContext, firExpression2, coneKotlinType, FirJvmErrors.INSTANCE.getRECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
            }
            for (Pair pair : CollectionsKt.zip((Iterable)expression2.getContextArguments(), (Iterable)symbol.getContextParameterSymbols())) {
                FirExpression contextArgument = (FirExpression)pair.component1();
                FirValueParameterSymbol contextParameter = (FirValueParameterSymbol)pair.component2();
                FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(reporter, context2, contextArgument, substitutor2.substituteOrSelf(contextParameter.getResolvedReturnType()), FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
            }
            if (!(expression2 instanceof FirFunctionCall)) break block9;
            FirCall firCall = (FirCall)((Object)expression2);
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = firCall.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap != null) {
                Map map = linkedHashMap;
                boolean $i$f$forEach = false;
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    FirExpression argument = (FirExpression)entry.getKey();
                    FirValueParameter parameter = (FirValueParameter)entry.getValue();
                    FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(reporter, context2, argument, substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())), FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean willBeMarkedNullableInFuture(ConeKotlinType $this$willBeMarkedNullableInFuture) {
        boolean bl;
        ConeKotlinType coneKotlinType = EnhancedTypeForWarningAttributeKt.getEnhancedTypeForWarning($this$willBeMarkedNullableInFuture);
        if (coneKotlinType != null) {
            if (ConeTypeUtilsKt.isMarkedNullable(coneKotlinType)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute explicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute = ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttributeKt.getExplicitTypeArgumentIfMadeFlexibleSynthetically($this$willBeMarkedNullableInFuture.getAttributes());
        if (explicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute == null) return false;
        ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute it = explicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute;
        boolean bl2 = false;
        if (!ConeTypeUtilsKt.isMarkedNullable(it.getConeType())) return false;
        if (it.getRelevantFeature() != LanguageFeature.DontMakeExplicitJavaTypeArgumentsFlexible) return false;
        return true;
    }
}

