/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.liquibase.common.JavaType;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.ddl.DbMappingSettings;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import liquibase.structure.core.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/liquibase/common/ColumnDefinitionType;", "Lcom/intellij/liquibase/common/JavaType;", "columnDefinition", "", "<init>", "(Ljava/lang/String;)V", "getColumnDefinition", "()Ljava/lang/String;", "id", "getId", "type", "getType", "defaultValue", "getDefaultValue", "isNotNull", "", "()Z", "toLiquibaseDataType", "Lliquibase/structure/core/DataType;", "context", "Lcom/intellij/liquibase/common/LiquibaseGenerationContext;", "isTypeChanged", "liquibaseType", "isValid", "isConvertibleType", "liquibaseTypeName", "Companion", "intellij.liquibase.common"})
public final class ColumnDefinitionType
implements JavaType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String columnDefinition;
    @NotNull
    private final String id;
    @NotNull
    private final String type;
    @Nullable
    private final String defaultValue;
    private final boolean isNotNull;
    @NotNull
    public static final String DEFAULT_VALUE = "DEFAULT";

    public ColumnDefinitionType(@NotNull String columnDefinition) {
        Intrinsics.checkNotNullParameter((Object)columnDefinition, (String)"columnDefinition");
        this.columnDefinition = columnDefinition;
        this.id = "columnDefinitionType." + this.columnDefinition;
        String processedDefinition = StringsKt.replace((String)this.columnDefinition, (String)" not null", (String)"", (boolean)true);
        this.isNotNull = !Intrinsics.areEqual((Object)processedDefinition, (Object)this.columnDefinition);
        int defaultValueIdx = StringsKt.indexOf((CharSequence)processedDefinition, (String)DEFAULT_VALUE, (int)0, (boolean)true);
        if (defaultValueIdx != -1) {
            String string = processedDefinition.substring(defaultValueIdx + 7, processedDefinition.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.defaultValue = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string2 = processedDefinition.substring(0, defaultValueIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            processedDefinition = string2;
        } else {
            this.defaultValue = null;
        }
        this.type = ((Object)StringsKt.trim((CharSequence)processedDefinition)).toString();
    }

    @NotNull
    public final String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @Nullable
    public final String getDefaultValue() {
        return this.defaultValue;
    }

    public final boolean isNotNull() {
        return this.isNotNull;
    }

    @Override
    @NotNull
    public DataType toLiquibaseDataType(@NotNull LiquibaseGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new DataType(this.type);
    }

    @Override
    public boolean isTypeChanged(@NotNull DataType liquibaseType, @NotNull LiquibaseGenerationContext context) {
        String typeWithoutParams;
        String columnSizeUnitTemplate;
        Intrinsics.checkNotNullParameter((Object)liquibaseType, (String)"liquibaseType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DbMappingSettings mappingSettings = context.getMappingSettings(context.getMainDbType());
        String string = liquibaseType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String liquibaseTypeValue = string;
        if (!StringsKt.contains$default((CharSequence)this.type, (CharSequence)"(", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)liquibaseTypeValue, (CharSequence)"(", (boolean)false, (int)2, null)) {
            String string2 = liquibaseType.getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeName(...)");
            liquibaseTypeValue = string2;
        }
        if (StringsKt.contains$default((CharSequence)liquibaseTypeValue, (CharSequence)"(", (boolean)false, (int)2, null) && liquibaseType.getColumnSizeUnit() != null && !StringsKt.contains((CharSequence)this.type, (CharSequence)(columnSizeUnitTemplate = " " + liquibaseType.getColumnSizeUnit()), (boolean)true)) {
            liquibaseTypeValue = StringsKt.replace((String)liquibaseTypeValue, (String)columnSizeUnitTemplate, (String)"", (boolean)true);
        }
        String string3 = typeWithoutParams = StringsKt.contains$default((CharSequence)this.type, (CharSequence)"(", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)this.type, (String)"(", null, (int)2, null) + StringsKt.substringAfter$default((String)this.type, (String)")", null, (int)2, null) : this.type;
        if (mappingSettings.isConvertibleType(typeWithoutParams, liquibaseTypeValue)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)typeWithoutParams, (Object)this.type)) {
            String string4 = liquibaseType.getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getTypeName(...)");
            if (mappingSettings.isConvertibleType(string4, typeWithoutParams)) {
                String length = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)this.type, (String)"(", null, (int)2, null), (String)")", null, (int)2, null);
                Integer n = liquibaseType.getColumnSize();
                if (Intrinsics.areEqual((Object)length, (Object)(n != null ? n.toString() : null))) {
                    return false;
                }
            }
        }
        if (!StringsKt.contains$default((CharSequence)liquibaseTypeValue, (CharSequence)"(", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)this.type, (CharSequence)")", (boolean)false, (int)2, null)) {
            return true;
        }
        String liquibaseTypeName = liquibaseType.getTypeName();
        Intrinsics.checkNotNull((Object)liquibaseTypeName);
        Collection<String> sqlTypeSynonyms = mappingSettings.getSqlTypeSynonyms(liquibaseTypeName);
        for (String typeSynonym : sqlTypeSynonyms) {
            String newLiquibaseTypeValue = typeSynonym + "(" + StringsKt.substringAfter$default((String)liquibaseTypeValue, (char)'(', null, (int)2, null);
            if (!mappingSettings.isConvertibleType(this.type, newLiquibaseTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(@NotNull LiquibaseGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Override
    public boolean isConvertibleType(@NotNull String liquibaseTypeName, @NotNull LiquibaseGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)liquibaseTypeName, (String)"liquibaseTypeName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/liquibase/common/ColumnDefinitionType$Companion;", "", "<init>", "()V", "DEFAULT_VALUE", "", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

