/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.ide.BrowserUtil;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.dbdrivers.DbDriversManager;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.ui.dialog.HDialogWrapper;
import com.intellij.jpa.jpb.model.util.DbUtils;
import com.intellij.liquibase.common.StackTraceDialog;
import com.intellij.liquibase.common.config.DatabaseInfo;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.liquibase.common.config.MappingType;
import com.intellij.liquibase.common.gui.settings.db.MappingTypeEditor;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.common.util.NotificationUtilsKt;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0002J\b\u0010\u0018\u001a\u00020\nH\u0003R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/intellij/liquibase/common/DiffGeneratorErrorDialog;", "Lcom/intellij/jpa/jpb/model/ui/dialog/HDialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "dialogTitle", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Exception;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;Ljava/lang/String;)V", "getException", "()Ljava/lang/Exception;", "getDbType", "()Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "getDialogTitle", "()Ljava/lang/String;", "createCenterPanel", "Ljavax/swing/JComponent;", "showAttrNotFoundNotification", "", "attrPath", "convertExceptionTextToPresentation", "Companion", "MyHyperlinkListener", "intellij.liquibase.common"})
public final class DiffGeneratorErrorDialog
extends HDialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Exception exception;
    @Nullable
    private final DbType dbType;
    @NotNull
    private final String dialogTitle;
    @NotNull
    public static final String DB_MIGRATION_SETTINGS_URL = "#db_migration_settings";
    @NotNull
    public static final String SHOW_STACK_TRACE = "#show_stack_trace";
    @NotNull
    public static final String SEND_EXCEPTION_REPORT = "#send_exception_report";
    @NotNull
    public static final String ATTR_PATH_SEPARATOR = "?attrPath=";

    private DiffGeneratorErrorDialog(Project project, Exception exception, DbType dbType, @NlsContexts.DialogTitle String dialogTitle) {
        super(project);
        this.exception = exception;
        this.dbType = dbType;
        this.dialogTitle = dialogTitle;
        this.setTitle(this.dialogTitle);
        this.init();
    }

    @NotNull
    public final Exception getException() {
        return this.exception;
    }

    @Nullable
    public final DbType getDbType() {
        return this.dbType;
    }

    @NotNull
    public final String getDialogTitle() {
        return this.dialogTitle;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JEditorPane jEditorPane;
        JEditorPane $this$createCenterPanel_u24lambda_u240 = jEditorPane = new JEditorPane();
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
        $this$createCenterPanel_u24lambda_u240.setEditable(false);
        $this$createCenterPanel_u24lambda_u240.setOpaque(false);
        $this$createCenterPanel_u24lambda_u240.setBorder(null);
        $this$createCenterPanel_u24lambda_u240.setMargin((Insets)JBUI.emptyInsets());
        $this$createCenterPanel_u24lambda_u240.setText(this.convertExceptionTextToPresentation());
        $this$createCenterPanel_u24lambda_u240.addHyperlinkListener(new MyHyperlinkListener());
        JEditorPane messagePane = jEditorPane;
        messagePane.setPreferredSize((Dimension)JBUI.size((int)600, (int)100));
        return messagePane;
    }

    private final void showAttrNotFoundNotification(String attrPath) {
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object[] objectArray = new Object[]{attrPath};
        NotificationUtilsKt.showDiffGenerationGroupNotification$default(project, LiquibaseResourceBundle.message("attribute.not.found", objectArray), null, 4, null);
    }

    @NlsSafe
    private final String convertExceptionTextToPresentation() {
        Throwable throwable = ExceptionUtil.getRootCause((Throwable)this.exception);
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getRootCause(...)");
        Throwable rootCause = throwable;
        String string = rootCause.getMessage();
        if (string == null && (string = this.exception.getMessage()) == null) {
            String string2 = ExceptionUtil.getNonEmptyMessage((Throwable)this.exception, (String)this.exception.toString());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNonEmptyMessage(...)");
        }
        Object text = string;
        String string3 = XmlStringUtil.convertToHtmlContent((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"convertToHtmlContent(...)");
        text = string3;
        text = StringsKt.replace$default((String)text, (String)"\n", (String)"<br>", (boolean)false, (int)4, null);
        String string4 = LiquibaseResourceBundle.messageWithColon("cannot.map.sql.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"messageWithColon(...)");
        boolean isCannotMapType = StringsKt.startsWith$default((String)text, (String)string4, (boolean)false, (int)2, null);
        if (isCannotMapType) {
            String attrPath = StringsKt.substringAfterLast$default((String)((Object)StringsKt.trim((CharSequence)((CharSequence)text))).toString(), (String)" ", null, (int)2, null);
            String string5 = ((String)text).substring(0, ((String)text).length() - attrPath.length());
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            text = string5 + "<a href='" + attrPath + "'>" + attrPath + "</a>";
            Object[] objectArray = new Object[]{"#db_migration_settings?attrPath=" + attrPath};
            text = (String)text + "<br><br>" + LiquibaseResourceBundle.message("explicitly.specify.map.sql.type", objectArray);
        } else if (SystemInfo.isWindows && StringsKt.contains((CharSequence)((CharSequence)text), (CharSequence)"Connection could not be created to jdbc:sqlserver://", (boolean)true)) {
            String string6;
            if (StringsKt.contains$default((CharSequence)((CharSequence)text), (CharSequence)"unable to find valid certification path", (boolean)false, (int)2, null)) {
                string6 = "<br><br>" + LiquibaseResourceBundle.message("trustServerCertificateInstructionForIdeaUltimate", new Object[0]);
            } else {
                Object[] objectArray = new Object[]{DbDriversManager.Companion.getMssqlAuthLibUrl(), DbUtils.NATIVE_LIBS_ROOT};
                string6 = "<br><br>" + LiquibaseResourceBundle.message("integratedSecurityInstructionForIdeaUltimate", objectArray);
            }
            text = (String)text + string6;
        }
        text = (String)text + "<br><br><a href='#show_stack_trace'>Show stack trace</a>";
        if (!isCannotMapType) {
            text = (String)text + "<br><a href='#send_exception_report'>Send exception report</a>";
        }
        return "<html>" + (String)text + "</html>";
    }

    public /* synthetic */ DiffGeneratorErrorDialog(Project project, Exception exception, DbType dbType, String dialogTitle, DefaultConstructorMarker $constructor_marker) {
        this(project, exception, dbType, dialogTitle);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0003\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/liquibase/common/DiffGeneratorErrorDialog$Companion;", "", "<init>", "()V", "DB_MIGRATION_SETTINGS_URL", "", "SHOW_STACK_TRACE", "SEND_EXCEPTION_REPORT", "ATTR_PATH_SEPARATOR", "show", "", "project", "Lcom/intellij/openapi/project/Project;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "dialogTitle", "intellij.liquibase.common"})
    @SourceDebugExtension(value={"SMAP\nDiffGeneratorErrorDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffGeneratorErrorDialog.kt\ncom/intellij/liquibase/common/DiffGeneratorErrorDialog$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,222:1\n14#2:223\n*S KotlinDebug\n*F\n+ 1 DiffGeneratorErrorDialog.kt\ncom/intellij/liquibase/common/DiffGeneratorErrorDialog$Companion\n*L\n64#1:223\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void show(@NotNull Project project, @NotNull Exception exception, @Nullable DbType dbType, @NlsContexts.DialogTitle @NotNull String dialogTitle) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
            Throwable throwable = ExceptionUtil.getRootCause((Throwable)exception);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getRootCause(...)");
            Throwable rootCause = throwable;
            if (rootCause instanceof ProcessCanceledException) {
                return;
            }
            if (exception instanceof CancellationException || rootCause instanceof CancellationException) {
                NotificationUtilsKt.showDiffGenerationGroupNotification(project, LiquibaseResourceBundle.message("generating.snapshot.canceled", new Object[0]), NotificationType.WARNING);
                return;
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DiffGeneratorErrorDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Exception when generating diff changes", (Throwable)exception);
            new DiffGeneratorErrorDialog(project, exception, dbType, dialogTitle, null).show();
        }

        public static /* synthetic */ void show$default(Companion companion, Project project, Exception exception, DbType dbType, String string, int n, Object object) {
            if ((n & 8) != 0) {
                String string2 = LiquibaseResourceBundle.message("diff.changes.generator.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                string = string2;
            }
            companion.show(project, exception, dbType, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0005H\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/common/DiffGeneratorErrorDialog$MyHyperlinkListener;", "Ljavax/swing/event/HyperlinkListener;", "<init>", "(Lcom/intellij/liquibase/common/DiffGeneratorErrorDialog;)V", "hyperlinkUpdate", "", "e", "Ljavax/swing/event/HyperlinkEvent;", "showMappingSettingsDialog", "linkDescription", "", "getAttrTypeFqn", "findAttributeByPath", "Lcom/intellij/psi/PsiField;", "path", "showStackTrace", "sendExceptionReport", "intellij.liquibase.common"})
    @SourceDebugExtension(value={"SMAP\nDiffGeneratorErrorDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffGeneratorErrorDialog.kt\ncom/intellij/liquibase/common/DiffGeneratorErrorDialog$MyHyperlinkListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
    public final class MyHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                return;
            }
            String linkDescription = e.getDescription();
            Intrinsics.checkNotNull((Object)linkDescription);
            if (StringsKt.startsWith$default((String)linkDescription, (String)DiffGeneratorErrorDialog.DB_MIGRATION_SETTINGS_URL, (boolean)false, (int)2, null)) {
                this.showMappingSettingsDialog(linkDescription);
            } else if (Intrinsics.areEqual((Object)linkDescription, (Object)DiffGeneratorErrorDialog.SHOW_STACK_TRACE)) {
                this.showStackTrace();
            } else if (Intrinsics.areEqual((Object)linkDescription, (Object)DiffGeneratorErrorDialog.SEND_EXCEPTION_REPORT)) {
                this.sendExceptionReport();
            } else if (StringsKt.startsWith$default((String)linkDescription, (String)"https://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)linkDescription, (String)"http://", (boolean)false, (int)2, null)) {
                BrowserUtil.browse((String)linkDescription);
            } else {
                PsiField foundAttr = this.findAttributeByPath(linkDescription);
                if (foundAttr == null) {
                    DiffGeneratorErrorDialog.this.showAttrNotFoundNotification(linkDescription);
                    return;
                }
                PsiNavigateUtil.navigate((PsiElement)((PsiElement)foundAttr));
                DiffGeneratorErrorDialog.this.close(1);
            }
        }

        private final void showMappingSettingsDialog(String linkDescription) {
            DatabaseInfo databaseInfo;
            Object object;
            Project project = DiffGeneratorErrorDialog.this.project;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getProject$p$s1548181602(...)");
            DatabaseMigrationState databaseMigrationState = DatabaseMigrationConfig.Companion.getInstance(project).getState();
            if (DiffGeneratorErrorDialog.this.getDbType() == null) {
                v1 = null;
            } else {
                Object v2;
                String dbTypeId;
                block7: {
                    dbTypeId = DbType.Companion.getMainType(DiffGeneratorErrorDialog.this.getDbType()).getId();
                    Iterable iterable = databaseMigrationState.getDatabaseInfos();
                    for (Object t : iterable) {
                        DatabaseInfo it = (DatabaseInfo)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)dbTypeId, (Object)it.getDbmsId())) continue;
                        v2 = t;
                        break block7;
                    }
                    v2 = null;
                }
                Object foundDatabaseInfo = v2;
                if (foundDatabaseInfo == null) {
                    Object $this$showMappingSettingsDialog_u24lambda_u241 = object = new DatabaseInfo();
                    boolean bl = false;
                    ((DatabaseInfo)$this$showMappingSettingsDialog_u24lambda_u241).setDbmsId(dbTypeId);
                    foundDatabaseInfo = object;
                    databaseMigrationState.getDatabaseInfos().add((DatabaseInfo)foundDatabaseInfo);
                }
                v1 = databaseInfo = foundDatabaseInfo;
            }
            if (databaseInfo == null) {
                ShowSettingsUtil.getInstance().showSettingsDialog(DiffGeneratorErrorDialog.this.project, LiquibaseResourceBundle.message("typeMappings.configurable.title", new Object[0]));
                DiffGeneratorErrorDialog.this.close(1);
            } else {
                String attrTypeFqn = this.getAttrTypeFqn(linkDescription);
                object = new MappingType();
                MappingType it = object;
                boolean bl = false;
                it.setJavaClass(attrTypeFqn);
                MappingType newMappingType = object;
                Project project2 = DiffGeneratorErrorDialog.this.project;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"access$getProject$p$s1548181602(...)");
                MappingTypeEditor mappingTypeEditor = new MappingTypeEditor(project2, databaseInfo, newMappingType);
                if (mappingTypeEditor.showAndGet()) {
                    databaseInfo.getMappingTypes().add(newMappingType);
                }
            }
        }

        private final String getAttrTypeFqn(String linkDescription) {
            String attrPath = StringsKt.substringAfter$default((String)linkDescription, (String)DiffGeneratorErrorDialog.ATTR_PATH_SEPARATOR, null, (int)2, null);
            PsiField psiField = this.findAttributeByPath(attrPath);
            if (psiField == null) {
                return null;
            }
            PsiField foundAttr = psiField;
            EntityAttributePsi attributePsi = EntityAttributePsi.getInstance((PsiMember)((PsiMember)foundAttr));
            Object object = attributePsi.getConverter();
            if (object == null || (object = object.getTypeClass()) == null || (object = object.getQualifiedName()) == null) {
                object = attributePsi.getType().getFqn();
            }
            return object;
        }

        private final PsiField findAttributeByPath(String path) {
            String[] stringArray = new String[]{"#"};
            List entityAndAttr = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (entityAndAttr.size() != 2) {
                return null;
            }
            String entityFqn = (String)entityAndAttr.get(0);
            String attrName = (String)entityAndAttr.get(1);
            PsiClass psiClass = EntitySearch.getInstance((Project)DiffGeneratorErrorDialog.this.project).findByQualifiedName(entityFqn);
            if (psiClass == null) {
                return null;
            }
            PsiClass entityClass = psiClass;
            return entityClass.findFieldByName(attrName, true);
        }

        private final void showStackTrace() {
            String string = ExceptionUtil.getThrowableText((Throwable)DiffGeneratorErrorDialog.this.getException());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getThrowableText(...)");
            String stackTrace = string;
            Project project = DiffGeneratorErrorDialog.this.project;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getProject$p$s1548181602(...)");
            new StackTraceDialog(project, stackTrace, DiffGeneratorErrorDialog.this.getDialogTitle()).show();
        }

        private final void sendExceptionReport() {
        }
    }
}

