/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.liquibase.common.ChangeLogCreationResult;
import com.intellij.liquibase.common.ChangeLogDeserializerWriter;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.liquibase.common.PropertyModel;
import com.intellij.liquibase.common.gui.ChangeLogModel;
import com.intellij.liquibase.common.gui.IncludeInfo;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.core.json.JsonChangeLogSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0014J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0014J\u001e\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00122\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$H\u0002J\u001c\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010*\u001a\u00020+H\u0002J\f\u0010,\u001a\u00020\"*\u00020-H\u0002J\u001c\u0010.\u001a\u00020/*\u00020)2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020+H\u0002J\u001c\u0010.\u001a\u00020/*\u00020\"2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020+H\u0002J6\u0010.\u001a\u00020/*\u0002012\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020+2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0\u001204H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00066"}, d2={"Lcom/intellij/liquibase/common/JsonChangeLogWriter;", "Lcom/intellij/liquibase/common/ChangeLogDeserializerWriter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "generator", "Lcom/intellij/json/psi/JsonElementGenerator;", "getGenerator", "()Lcom/intellij/json/psi/JsonElementGenerator;", "writeToFile", "Lcom/intellij/liquibase/common/ChangeLogCreationResult;", "existingFile", "Lcom/intellij/psi/PsiFile;", "changeLogModel", "Lcom/intellij/liquibase/common/gui/ChangeLogModel;", "newFile", "propertyTags", "", "Lcom/intellij/psi/xml/XmlTag;", "changeSource", "", "createFileFromContent", "content", "getChangeLogSerializer", "Lliquibase/serializer/ChangeLogSerializer;", "supportedFileType", "Lcom/intellij/liquibase/common/LiquibaseFileType;", "unwrapChangesetFromChangelog", "changelogText", "unwrapChangeFromChangelog", "addProperties", "", "objects", "Lcom/intellij/json/psi/JsonObject;", "file", "Lcom/intellij/json/psi/JsonFile;", "addChangeSetsToExistingFile", "from", "to", "getChangeLogArrayValue", "Lcom/intellij/json/psi/JsonArray;", "create", "", "toPropertyNode", "Lcom/intellij/liquibase/common/PropertyModel;", "addChild", "Lcom/intellij/psi/PsiElement;", "property", "Lcom/intellij/json/psi/JsonElement;", "first", "itemsGetter", "Lkotlin/Function1;", "JsonChangeLogCreationResult", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nJsonChangeLogWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonChangeLogWriter.kt\ncom/intellij/liquibase/common/JsonChangeLogWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,134:1\n1869#2,2:135\n1869#2,2:137\n1563#2:145\n1634#2,3:146\n77#3:139\n97#3,5:140\n*S KotlinDebug\n*F\n+ 1 JsonChangeLogWriter.kt\ncom/intellij/liquibase/common/JsonChangeLogWriter\n*L\n70#1:135,2\n76#1:137,2\n31#1:145\n31#1:146,3\n30#1:139\n30#1:140,5\n*E\n"})
public final class JsonChangeLogWriter
extends ChangeLogDeserializerWriter {
    @NotNull
    private final JsonElementGenerator generator;

    public JsonChangeLogWriter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.generator = new JsonElementGenerator(project);
    }

    @NotNull
    public final JsonElementGenerator getGenerator() {
        return this.generator;
    }

    @Override
    @NotNull
    public ChangeLogCreationResult<?> writeToFile(@Nullable PsiFile existingFile, @NotNull ChangeLogModel changeLogModel, @NotNull PsiFile newFile, @NotNull List<? extends XmlTag> propertyTags, @NotNull String changeSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeLogModel), (String)"changeLogModel");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Intrinsics.checkNotNullParameter(propertyTags, (String)"propertyTags");
        Intrinsics.checkNotNullParameter((Object)changeSource, (String)"changeSource");
        JsonChangeLogCreationResult result = new JsonChangeLogCreationResult(null, null, 3, null);
        Object object = WriteCommandAction.writeCommandAction((Project)this.getProject()).withName(LiquibaseResourceBundle.message("command.name.writing.changelog.file", new Object[0])).compute(() -> JsonChangeLogWriter.writeToFile$lambda$2(this, propertyTags, changeSource, result, existingFile, newFile, changeLogModel));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (ChangeLogCreationResult)object;
    }

    @Override
    @NotNull
    public PsiFile createFileFromContent(@NotNull ChangeLogModel changeLogModel, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeLogModel), (String)"changeLogModel");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(changeLogModel.getFileName() + ".json", (Language)JsonLanguage.INSTANCE, (CharSequence)content);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        return psiFile;
    }

    @Override
    @NotNull
    public ChangeLogSerializer getChangeLogSerializer() {
        return (ChangeLogSerializer)new JsonChangeLogSerializer();
    }

    @Override
    @NotNull
    public LiquibaseFileType supportedFileType() {
        return LiquibaseFileType.JSON;
    }

    @Override
    @NotNull
    protected String unwrapChangesetFromChangelog(@NotNull String changelogText) {
        Intrinsics.checkNotNullParameter((Object)changelogText, (String)"changelogText");
        return "{" + ((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)changelogText, (String)"{", null, (int)2, null), (String)"{", null, (int)2, null), (String)"}", null, (int)2, null), (String)"}", null, (int)2, null)))).toString() + "}";
    }

    @Override
    @NotNull
    protected String unwrapChangeFromChangelog(@NotNull String changelogText) {
        Intrinsics.checkNotNullParameter((Object)changelogText, (String)"changelogText");
        return "{" + ((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)changelogText, (String)"{", null, (int)2, null), (String)"{", null, (int)2, null), (String)"{", null, (int)2, null), (String)"{", null, (int)2, null), (String)"}", null, (int)2, null), (String)"}", null, (int)2, null), (String)"}", null, (int)2, null), (String)"}", null, (int)2, null)))).toString() + "}";
    }

    private final void addProperties(List<? extends JsonObject> objects, JsonFile file) {
        JsonArray jsonArray = JsonChangeLogWriter.getChangeLogArrayValue$default(this, file, false, 2, null);
        Iterable $this$forEach$iv = objects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonObject it = (JsonObject)element$iv;
            boolean bl = false;
            JsonArray jsonArray2 = jsonArray;
            Intrinsics.checkNotNull((Object)jsonArray2);
            this.addChild(jsonArray2, (JsonElement)it, true);
        }
    }

    private final void addChangeSetsToExistingFile(JsonFile from, JsonFile to) {
        block1: {
            JsonArray fromArray = this.getChangeLogArrayValue(from, false);
            JsonArray jsonArray = JsonChangeLogWriter.getChangeLogArrayValue$default(this, to, false, 2, null);
            Intrinsics.checkNotNull((Object)jsonArray);
            JsonArray toArray = jsonArray;
            Object object = fromArray;
            if (object == null || (object = object.getValueList()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonValue it = (JsonValue)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.addChild(toArray, (JsonElement)it, false);
            }
        }
    }

    private final JsonArray getChangeLogArrayValue(JsonFile file, boolean create) {
        JsonProperty changeLogSection;
        JsonObject topLevelValue = (JsonObject)file.getTopLevelValue();
        if (topLevelValue == null && create) {
            JsonObject jsonObject = this.generator.createObject("\"databaseChangeLog\": []");
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"createObject(...)");
            JsonObject tempObject = jsonObject;
            PsiElement psiElement = file.add((PsiElement)tempObject);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
            topLevelValue = (JsonObject)psiElement;
        }
        JsonObject jsonObject = topLevelValue;
        Object object = changeLogSection = jsonObject != null ? jsonObject.findProperty("databaseChangeLog") : null;
        if (changeLogSection == null && create) {
            JsonProperty jsonProperty = this.generator.createProperty("databaseChangeLog", "[]");
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty, (String)"createProperty(...)");
            JsonProperty property = jsonProperty;
            JsonObject jsonObject2 = topLevelValue;
            Intrinsics.checkNotNull((Object)jsonObject2);
            PsiElement psiElement = this.addChild(jsonObject2, (JsonElement)property, true);
            changeLogSection = psiElement instanceof JsonProperty ? (JsonProperty)psiElement : null;
        }
        JsonProperty jsonProperty = changeLogSection;
        JsonValue jsonValue = jsonProperty != null ? jsonProperty.getValue() : null;
        return jsonValue instanceof JsonArray ? (JsonArray)jsonValue : null;
    }

    static /* synthetic */ JsonArray getChangeLogArrayValue$default(JsonChangeLogWriter jsonChangeLogWriter, JsonFile jsonFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return jsonChangeLogWriter.getChangeLogArrayValue(jsonFile, bl);
    }

    private final JsonObject toPropertyNode(PropertyModel $this$toPropertyNode) {
        JsonProperty jsonProperty = this.generator.createProperty("property", StringsKt.trimIndent((String)("\n            {\n                \"name\": \"" + $this$toPropertyNode.getName() + "\",\n                \"value\": \"" + $this$toPropertyNode.getValue() + "\"\n            }\n        ")));
        Intrinsics.checkNotNullExpressionValue((Object)jsonProperty, (String)"createProperty(...)");
        JsonProperty property = jsonProperty;
        if ($this$toPropertyNode.getDmbs() != null) {
            JsonValue jsonValue = property.getValue();
            Intrinsics.checkNotNull((Object)jsonValue, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
            JsonPsiUtil.addProperty((JsonObject)((JsonObject)jsonValue), (JsonProperty)this.generator.createProperty("dbms", "\"" + $this$toPropertyNode.getDmbs() + "\""), (boolean)false);
        }
        JsonObject jsonObject = this.generator.createObject(property.getText());
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"createObject(...)");
        return jsonObject;
    }

    private final PsiElement addChild(JsonArray $this$addChild, JsonElement property, boolean first) {
        return this.addChild((JsonElement)$this$addChild, property, first, (Function1<? super JsonElement, ? extends List<? extends PsiElement>>)((Function1)arg_0 -> JsonChangeLogWriter.addChild$lambda$5($this$addChild, arg_0)));
    }

    private final PsiElement addChild(JsonObject $this$addChild, JsonElement property, boolean first) {
        return this.addChild((JsonElement)$this$addChild, property, first, (Function1<? super JsonElement, ? extends List<? extends PsiElement>>)((Function1)arg_0 -> JsonChangeLogWriter.addChild$lambda$6($this$addChild, arg_0)));
    }

    private final PsiElement addChild(JsonElement $this$addChild, JsonElement property, boolean first, Function1<? super JsonElement, ? extends List<? extends PsiElement>> itemsGetter) {
        PsiElement lastProperty;
        List propertyList = (List)itemsGetter.invoke((Object)$this$addChild);
        if (!first && (lastProperty = (PsiElement)CollectionsKt.lastOrNull((List)propertyList)) != null) {
            PsiElement addedProperty = $this$addChild.addAfter((PsiElement)property, lastProperty);
            $this$addChild.addBefore(new JsonElementGenerator($this$addChild.getProject()).createComma(), addedProperty);
            Intrinsics.checkNotNull((Object)addedProperty);
            return addedProperty;
        }
        PsiElement leftBrace = $this$addChild.getFirstChild();
        PsiElement addedProperty = $this$addChild.addAfter((PsiElement)property, leftBrace);
        if (!((Collection)propertyList).isEmpty()) {
            $this$addChild.addAfter(new JsonElementGenerator($this$addChild.getProject()).createComma(), addedProperty);
        }
        Intrinsics.checkNotNull((Object)addedProperty);
        return addedProperty;
    }

    /*
     * WARNING - void declaration
     */
    private static final ChangeLogCreationResult writeToFile$lambda$2(JsonChangeLogWriter this$0, List $propertyTags, String $changeSource, JsonChangeLogCreationResult $result, PsiFile $existingFile, PsiFile $newFile, ChangeLogModel $changeLogModel) {
        PsiElement psiElement;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable list$iv$iv;
        Map.Entry it;
        void $this$flatMapTo$iv$iv;
        Object $this$flatMap$iv = this$0.getExistingPropertyTags($propertyTags, $changeSource);
        boolean $i$f$flatMap = false;
        Map<String, List<XmlTag>> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (XmlTag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.toPropertyNode(this$0.getPropertyModel((XmlTag)it)));
        }
        List propertyItems = (List)destination$iv$iv;
        if ($existingFile == null) {
            Intrinsics.checkNotNull((Object)$newFile, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonFile");
            this$0.addProperties(propertyItems, (JsonFile)$newFile);
            psiElement = (PsiElement)this$0.storeFile($changeLogModel, $newFile);
        } else {
            JsonFile jsonFile = (JsonFile)$existingFile;
            this$0.addProperties(propertyItems, jsonFile);
            Intrinsics.checkNotNull((Object)$newFile, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonFile");
            this$0.addChangeSetsToExistingFile((JsonFile)$newFile, jsonFile);
            psiElement = this$0.reformat((PsiElement)$existingFile);
        }
        PsiElement psiElement2 = psiElement;
        $result.setFile(psiElement2 instanceof JsonFile ? (JsonFile)psiElement2 : null);
        return $result;
    }

    private static final List addChild$lambda$5(JsonArray $this_addChild, JsonElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = $this_addChild.getValueList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueList(...)");
        return list;
    }

    private static final List addChild$lambda$6(JsonObject $this_addChild, JsonElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = $this_addChild.getPropertyList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyList(...)");
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/common/JsonChangeLogWriter$JsonChangeLogCreationResult;", "Lcom/intellij/liquibase/common/ChangeLogCreationResult;", "Lcom/intellij/json/psi/JsonFile;", "file", "includeInfo", "Lcom/intellij/liquibase/common/gui/IncludeInfo;", "<init>", "(Lcom/intellij/json/psi/JsonFile;Lcom/intellij/liquibase/common/gui/IncludeInfo;)V", "getFile", "()Lcom/intellij/json/psi/JsonFile;", "setFile", "(Lcom/intellij/json/psi/JsonFile;)V", "getIncludeInfo", "()Lcom/intellij/liquibase/common/gui/IncludeInfo;", "setIncludeInfo", "(Lcom/intellij/liquibase/common/gui/IncludeInfo;)V", "intellij.liquibase.common"})
    public static final class JsonChangeLogCreationResult
    implements ChangeLogCreationResult<JsonFile> {
        @Nullable
        private JsonFile file;
        @Nullable
        private IncludeInfo includeInfo;

        public JsonChangeLogCreationResult(@Nullable JsonFile file, @Nullable IncludeInfo includeInfo) {
            this.file = file;
            this.includeInfo = includeInfo;
        }

        public /* synthetic */ JsonChangeLogCreationResult(JsonFile jsonFile, IncludeInfo includeInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                jsonFile = null;
            }
            if ((n & 2) != 0) {
                includeInfo = null;
            }
            this(jsonFile, includeInfo);
        }

        @Override
        @Nullable
        public JsonFile getFile() {
            return this.file;
        }

        @Override
        public void setFile(@Nullable JsonFile jsonFile) {
            this.file = jsonFile;
        }

        @Override
        @Nullable
        public IncludeInfo getIncludeInfo() {
            return this.includeInfo;
        }

        @Override
        public void setIncludeInfo(@Nullable IncludeInfo includeInfo) {
            this.includeInfo = includeInfo;
        }

        public JsonChangeLogCreationResult() {
            this(null, null, 3, null);
        }
    }
}

