/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.liquibase.common.LiquibaseCommandManager;
import com.intellij.liquibase.common.LiquibaseCreator;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.SemVer;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0000\u00a8\u0006\u000b"}, d2={"getJ2EETemplateWithProps", "Lkotlin/Pair;", "Ljava/util/Properties;", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "project", "Lcom/intellij/openapi/project/Project;", "changeSource", "", "quotingStrategy", "Lcom/intellij/liquibase/common/LiquibaseCreator$ObjectQuotingStrategy;", "templateName", "intellij.liquibase.common"})
public final class LiquibaseCreatorKt {
    @NotNull
    public static final Pair<Properties, FileTemplate> getJ2EETemplateWithProps(@NotNull Project project, @NotNull String changeSource, @NotNull LiquibaseCreator.ObjectQuotingStrategy quotingStrategy, @NotNull String templateName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)changeSource, (String)"changeSource");
        Intrinsics.checkNotNullParameter((Object)((Object)quotingStrategy), (String)"quotingStrategy");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
        Properties properties2 = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"getDefaultProperties(...)");
        Properties props = properties2;
        SemVer liquibaseVersion = LiquibaseCommandManager.Companion.getInstance(project).getLiquibaseVersion();
        props.setProperty("LIQUIBASE_VERSION", liquibaseVersion.getMajor() + "." + liquibaseVersion.getMinor());
        props.setProperty("CHANGE_SOURCE", changeSource);
        props.setProperty("QUOTING_STRATEGY", quotingStrategy.name());
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(templateName);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        return new Pair((Object)props, (Object)template);
    }
}

