/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.jpa.jpb.model.core.util.FileUtils;
import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.liquibase.common.ChangeLogCreationResult;
import com.intellij.liquibase.common.ChangeLogWriterEP;
import com.intellij.liquibase.common.ErrorChangeLogCreationResult;
import com.intellij.liquibase.common.LiquibaseCommandManager;
import com.intellij.liquibase.common.LiquibaseCreator;
import com.intellij.liquibase.common.LiquibaseCreatorKt;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.liquibase.common.LiquibaseManager;
import com.intellij.liquibase.common.XmlChangeLogCreationResult;
import com.intellij.liquibase.common.dom.DatabaseChangeLog;
import com.intellij.liquibase.common.gui.ChangeLogModel;
import com.intellij.liquibase.common.gui.ChangeLogTreeKt;
import com.intellij.liquibase.common.gui.ChangeModel;
import com.intellij.liquibase.common.gui.ChangeSetModel;
import com.intellij.liquibase.common.gui.IncludeInfo;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.SemVer;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.database.Database;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J<\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J&\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J&\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0016\u0010 \u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012J*\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0&H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0015H\u0002J*\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u001400H\u0002J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020.2\u0006\u00104\u001a\u00020.H\u0002J(\u00105\u001a\u0002062\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020(H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/liquibase/common/XmlChangeLogWriter;", "Lcom/intellij/liquibase/common/ChangeLogWriterEP;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "domManager", "Lcom/intellij/util/xml/DomManager;", "templateName", "", "supportedFileType", "Lcom/intellij/liquibase/common/LiquibaseFileType;", "writeChangeLogIntoFile", "Lcom/intellij/liquibase/common/ChangeLogCreationResult;", "changeLogModel", "Lcom/intellij/liquibase/common/gui/ChangeLogModel;", "changeSource", "quotingStrategy", "Lcom/intellij/liquibase/common/LiquibaseCreator$ObjectQuotingStrategy;", "propertyTags", "", "Lcom/intellij/psi/xml/XmlTag;", "database", "Lliquibase/database/Database;", "collectChangeSetSource", "changeSetNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "liquibaseVersion", "Lcom/intellij/util/text/SemVer;", "collectChangeSource", "model", "Lcom/intellij/liquibase/common/gui/ChangeModel;", "getChangeLogText", "addIncludeChangeLog", "", "includeInfo", "Lcom/intellij/liquibase/common/gui/IncludeInfo;", "mainChangeLogToDirMap", "", "", "Lcom/intellij/psi/PsiDirectory;", "getLastIncludeTag", "Lcom/intellij/psi/PsiElement;", "dbChangeLogTag", "addPropertyTags", "lastDbChangeLogFile", "Lcom/intellij/psi/xml/XmlFile;", "toCreatePropertyTags", "", "isNeedIncludeChangeLog", "", "mainChangeLogFile", "changeLogFile", "writeIntoFile", "Lcom/intellij/psi/PsiFile;", "fileName", "targetDirectory", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nChangeLogWriterEP.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeLogWriterEP.kt\ncom/intellij/liquibase/common/XmlChangeLogWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,373:1\n1617#2,9:374\n1869#2:383\n1870#2:385\n1626#2:386\n1869#2,2:387\n1999#2,14:396\n2746#2,3:410\n1869#2,2:417\n1#3:384\n382#4,7:389\n13472#5,2:413\n19652#5,2:415\n*S KotlinDebug\n*F\n+ 1 ChangeLogWriterEP.kt\ncom/intellij/liquibase/common/XmlChangeLogWriter\n*L\n239#1:374,9\n239#1:383\n239#1:385\n239#1:386\n240#1:387,2\n315#1:396,14\n340#1:410,3\n325#1:417,2\n239#1:384\n283#1:389,7\n198#1:413,2\n324#1:415,2\n*E\n"})
public final class XmlChangeLogWriter
extends ChangeLogWriterEP {
    @NotNull
    private final DomManager domManager;
    @NotNull
    private final String templateName;

    public XmlChangeLogWriter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        DomManager domManager = DomManager.getDomManager((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)domManager, (String)"getDomManager(...)");
        this.domManager = domManager;
        this.templateName = "com.intellij.jpb.JpaLiquibaseChangeLog.xml";
    }

    @Override
    @NotNull
    public LiquibaseFileType supportedFileType() {
        return LiquibaseFileType.XML;
    }

    @Override
    @NotNull
    public ChangeLogCreationResult<?> writeChangeLogIntoFile(@NotNull ChangeLogModel changeLogModel, @NotNull String changeSource, @NotNull LiquibaseCreator.ObjectQuotingStrategy quotingStrategy, @NotNull List<? extends XmlTag> propertyTags, @Nullable Database database) {
        XmlFile includeChangeLogFile;
        XmlFile xmlFile;
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)((Object)changeLogModel), (String)"changeLogModel");
        Intrinsics.checkNotNullParameter((Object)changeSource, (String)"changeSource");
        Intrinsics.checkNotNullParameter((Object)((Object)quotingStrategy), (String)"quotingStrategy");
        Intrinsics.checkNotNullParameter(propertyTags, (String)"propertyTags");
        Map<String, List<XmlTag>> toCreatePropertyTags = this.getExistingPropertyTags(propertyTags, changeSource);
        PsiFile changeLogFile = this.getExistingFile(changeLogModel);
        XmlChangeLogCreationResult result = new XmlChangeLogCreationResult(null, null, 3, null);
        if (changeLogFile == null) {
            PsiFile newDbChangeLogFile;
            psiFile = this.getFileExt();
            String fileName = FileUtils.Companion.getFileNameWithoutExt(changeLogModel.getFileName(), Arrays.copyOf(psiFile, ((String[])psiFile).length));
            PsiDirectory psiDirectory = FileUtils.Companion.getOrCreateDir(changeLogModel.getDirectoryAbsolutePath(this.getProject()), this.getProject());
            if (psiDirectory == null) {
                return new ErrorChangeLogCreationResult(new IllegalStateException("Could not find or create changelog file: " + changeLogModel.getDirectory()));
            }
            PsiDirectory changeLogDir = psiDirectory;
            try {
                newDbChangeLogFile = this.writeIntoFile(changeSource, quotingStrategy, fileName, changeLogDir);
                Intrinsics.checkNotNull((Object)newDbChangeLogFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
                result.setFile((XmlFile)newDbChangeLogFile);
                WriteCommandAction.writeCommandAction((Project)this.getProject()).withName(LiquibaseResourceBundle.message("command.name.create.changelog.file", new Object[0])).run(() -> XmlChangeLogWriter.writeChangeLogIntoFile$lambda$0(this, newDbChangeLogFile));
                newDbChangeLogFile = (XmlFile)newDbChangeLogFile;
            }
            catch (Exception e) {
                new ExceptionEvent((Object)("Exception while trying to create liquibase changelog file: '" + fileName + "'"), (Throwable)e).post(this.getProject());
                return new ErrorChangeLogCreationResult(e);
            }
            xmlFile = newDbChangeLogFile;
        } else {
            XmlFile existingChangeLogFile = (XmlFile)changeLogFile;
            if (!StringsKt.isBlank((CharSequence)changeSource)) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                Document document = documentManager.getDocument((PsiFile)existingChangeLogFile);
                XmlTag xmlTag = existingChangeLogFile.getRootTag();
                if (xmlTag == null) {
                    return new ErrorChangeLogCreationResult(null, 1, null);
                }
                XmlTag dbChangeLogRootTag = xmlTag;
                XmlElementFactory xmlElementFactory = XmlElementFactory.getInstance((Project)this.getProject());
                XmlTag xmlTag2 = xmlElementFactory.createTagFromText((CharSequence)("<fake-root>" + changeSource + "</fake-root>"));
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag2, (String)"createTagFromText(...)");
                XmlTag fakeRootTag = xmlTag2;
                WriteCommandAction.writeCommandAction((Project)this.getProject()).withName(LiquibaseResourceBundle.message("command.name.append.changes.to.exists.changelog.file", new Object[0])).run(() -> XmlChangeLogWriter.writeChangeLogIntoFile$lambda$3(document, fakeRootTag, this, existingChangeLogFile, documentManager, changeSource, dbChangeLogRootTag));
            }
            result.setFile(existingChangeLogFile);
            xmlFile = existingChangeLogFile;
        }
        XmlFile dbChangeLogFile = xmlFile;
        psiFile = changeLogModel.getIncludeChangeLogFile(this.getProject());
        XmlFile xmlFile2 = includeChangeLogFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (includeChangeLogFile != null && this.isNeedIncludeChangeLog(includeChangeLogFile, dbChangeLogFile)) {
            result.setIncludeInfo(new IncludeInfo((PsiFile)includeChangeLogFile, (PsiFile)dbChangeLogFile, changeLogModel.getIncludeContext(), changeLogModel.getIncludeAsFolder()));
        }
        this.addPropertyTags(dbChangeLogFile, toCreatePropertyTags);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String collectChangeSetSource(@NotNull DefaultMutableTreeNode changeSetNode, @Nullable Database database, @Nullable SemVer liquibaseVersion) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)changeSetNode, (String)"changeSetNode");
        Collection changeNodes = ChangeLogTreeKt.getChildrenNodeByUserObjectType$default(changeSetNode, ChangeModel.class, false, 2, null);
        if (changeNodes.isEmpty()) {
            return null;
        }
        Object object = changeSetNode.getUserObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.liquibase.common.gui.ChangeSetModel");
        ChangeSetModel changeSetModel = (ChangeSetModel)((Object)object);
        StringBuilder source = new StringBuilder();
        source.append("<changeSet id=\"" + changeSetModel.getId() + "\" author=\"" + changeSetModel.getAuthor() + "\"");
        CharSequence charSequence = changeSetModel.getContext();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            source.append(" context=\"" + changeSetModel.getContext() + "\"");
        }
        if (!((charSequence = (CharSequence)changeSetModel.getLabels()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            source.append(" labels=\"" + changeSetModel.getLabels() + "\"");
        }
        if (!((charSequence = (CharSequence)changeSetModel.getDbms()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            source.append(" dbms=\"" + changeSetModel.getDbms() + "\"");
        }
        source.append(">");
        Iterable $this$mapNotNull$iv = changeNodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            XmlTag it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv$iv;
            boolean bl2 = false;
            Object object2 = it.getUserObject();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.liquibase.common.gui.ChangeModel");
            if (((ChangeModel)object2).getXmlTag() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List changeTags = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $this$forEach$iv = this.getProcessedChangeTags(changeTags);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            XmlTag changeTag = (XmlTag)element$iv;
            boolean bl = false;
            source.append("\n" + changeTag.getText() + "\n");
        }
        source.append("</changeSet>\n");
        return source.toString();
    }

    @Override
    @Nullable
    public String collectChangeSource(@NotNull ChangeModel model2, @Nullable Database database, @Nullable SemVer liquibaseVersion) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        XmlTag xmlTag = model2.getXmlTag();
        return xmlTag != null ? xmlTag.getText() : null;
    }

    @NotNull
    public final String getChangeLogText(@NotNull String changeSource, @NotNull LiquibaseCreator.ObjectQuotingStrategy quotingStrategy) {
        Intrinsics.checkNotNullParameter((Object)changeSource, (String)"changeSource");
        Intrinsics.checkNotNullParameter((Object)((Object)quotingStrategy), (String)"quotingStrategy");
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.getProject());
        Properties properties2 = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"getDefaultProperties(...)");
        Properties props = properties2;
        SemVer liquibaseVersion = LiquibaseCommandManager.Companion.getInstance(this.getProject()).getLiquibaseSupportedVersion();
        props.setProperty("LIQUIBASE_VERSION", liquibaseVersion.getMajor() + "." + liquibaseVersion.getMinor());
        props.setProperty("CHANGE_SOURCE", changeSource);
        props.setProperty("QUOTING_STRATEGY", quotingStrategy.name());
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(this.templateName);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        String string = template.getText(props);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addIncludeChangeLog(@NotNull IncludeInfo includeInfo, @NotNull Map<String, Set<PsiDirectory>> mainChangeLogToDirMap) {
        block12: {
            XmlTag xmlTag;
            String string;
            Intrinsics.checkNotNullParameter((Object)includeInfo, (String)"includeInfo");
            Intrinsics.checkNotNullParameter(mainChangeLogToDirMap, (String)"mainChangeLogToDirMap");
            PsiFile mainChangeLogFile = includeInfo.getMainChangeLog();
            Intrinsics.checkNotNull((Object)mainChangeLogFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
            Object object = this.domManager.getFileElement((XmlFile)mainChangeLogFile, DatabaseChangeLog.class);
            if (object == null || (object = (DatabaseChangeLog)object.getRootElement()) == null) {
                return;
            }
            Object databaseChangeLog = object;
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.getProject());
            Document document = manager.getCachedDocument(mainChangeLogFile);
            if (document != null) {
                Document it = document;
                boolean bl2 = false;
                if (manager.isUncommited(it)) {
                    manager.commitDocument(it);
                }
            }
            String string2 = ((XmlFile)mainChangeLogFile).getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String mainChangeLogPath = string2;
            PsiDirectory changeLogDir = includeInfo.getToIncludeChangeLog().getContainingDirectory();
            Set<PsiDirectory> set = mainChangeLogToDirMap.get(mainChangeLogPath);
            boolean bl = set != null ? set.contains(changeLogDir) : false;
            if (bl) {
                return;
            }
            if (includeInfo.getIncludeAsFolder()) {
                Object object2;
                void $this$getOrPut$iv;
                Map<String, Set<PsiDirectory>> bl2 = mainChangeLogToDirMap;
                String key$iv = mainChangeLogPath;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                Set set2 = (Set)object2;
                Intrinsics.checkNotNull((Object)changeLogDir);
                set2.add(changeLogDir);
                string = HPsiUtil.getClassPathRelativePath$default((PsiFileSystemItem)((PsiFileSystemItem)changeLogDir), (char)'\u0000', (int)1, null);
            } else {
                string = HPsiUtil.getClassPathRelativePath$default((PsiFileSystemItem)((PsiFileSystemItem)includeInfo.getToIncludeChangeLog()), (char)'\u0000', (int)1, null);
            }
            String includeFilePath = string;
            CharSequence charSequence = includeFilePath;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return;
            }
            XmlTag xmlTag2 = databaseChangeLog.getXmlTag();
            if (xmlTag2 == null) break block12;
            XmlTag dbChangeLogTag = xmlTag2;
            boolean bl4 = false;
            PsiElement lastIncludeTag = this.getLastIncludeTag(dbChangeLogTag);
            String includeTagName = includeInfo.getIncludeAsFolder() ? "includeAll" : "include";
            XmlTag newIncludeTag = dbChangeLogTag.createChildTag(includeTagName, null, null, false);
            if (lastIncludeTag != null) {
                PsiElement psiElement = dbChangeLogTag.addAfter((PsiElement)newIncludeTag, lastIncludeTag);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
                xmlTag = (XmlTag)psiElement;
            } else {
                xmlTag = dbChangeLogTag.addSubTag(newIncludeTag, false);
            }
            XmlTag addedIncludeTag = xmlTag;
            String pathAttrName = includeInfo.getIncludeAsFolder() ? "path" : "file";
            addedIncludeTag.setAttribute(pathAttrName, StringUtil.escapeXmlEntities((String)includeFilePath));
            String string3 = includeInfo.getContext();
            if (string3 != null) {
                String it = string3;
                boolean bl5 = false;
                addedIncludeTag.setAttribute("context", it);
            }
        }
    }

    private final PsiElement getLastIncludeTag(XmlTag dbChangeLogTag) {
        Object v3;
        XmlTag[] xmlTagArray = dbChangeLogTag.findSubTags("include");
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"findSubTags(...)");
        Object[] objectArray = xmlTagArray;
        XmlTag[] xmlTagArray2 = dbChangeLogTag.findSubTags("includeAll");
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray2, (String)"findSubTags(...)");
        Iterable $this$maxByOrNull$iv = ArraysKt.union((Object[])objectArray, (Iterable)ArraysKt.toList((Object[])xmlTagArray2));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = maxElem$iv;
            } else {
                XmlTag xmlTag = (XmlTag)maxElem$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)xmlTag);
                int maxValue$iv = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)xmlTag));
                do {
                    Object e$iv = iterator$iv.next();
                    XmlTag xmlTag2 = (XmlTag)e$iv;
                    $i$a$-maxByOrNull-XmlChangeLogWriter$getLastIncludeTag$1 = false;
                    Intrinsics.checkNotNull((Object)xmlTag2);
                    int v$iv = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)xmlTag2));
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = maxElem$iv;
            }
        }
        return v3;
    }

    private final void addPropertyTags(XmlFile lastDbChangeLogFile, Map<String, ? extends List<? extends XmlTag>> toCreatePropertyTags) {
        XmlTag xmlTag = lastDbChangeLogFile.getRootTag();
        if (xmlTag == null) {
            return;
        }
        XmlTag changeLogRootTag = xmlTag;
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), null, null, () -> XmlChangeLogWriter.addPropertyTags$lambda$13(toCreatePropertyTags, changeLogRootTag), (PsiFile[])new PsiFile[0]);
    }

    private final boolean isNeedIncludeChangeLog(XmlFile mainChangeLogFile, XmlFile changeLogFile) {
        boolean bl;
        block5: {
            if (DumbService.Companion.isDumb(this.getProject()) || Intrinsics.areEqual((Object)mainChangeLogFile, (Object)changeLogFile)) {
                return false;
            }
            Object object = this.domManager.getFileElement(mainChangeLogFile, DatabaseChangeLog.class);
            if (object == null || (object = (DatabaseChangeLog)object.getRootElement()) == null) {
                return false;
            }
            Object databaseChangeLog = object;
            Map<DatabaseChangeLog, List<DatabaseChangeLog>> allChangeLogs = LiquibaseManager.Companion.getInstance(this.getProject()).collectAllChangeLogs(CollectionsKt.listOf((Object)databaseChangeLog));
            Iterable $this$none$iv = CollectionsKt.flatten((Iterable)allChangeLogs.values());
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    DatabaseChangeLog it = (DatabaseChangeLog)element$iv;
                    boolean bl2 = false;
                    XmlElement xmlElement = it.getXmlElement();
                    if (!Intrinsics.areEqual((Object)(xmlElement != null ? xmlElement.getContainingFile() : null), (Object)changeLogFile)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final PsiFile writeIntoFile(String changeSource, LiquibaseCreator.ObjectQuotingStrategy quotingStrategy, String fileName, PsiDirectory targetDirectory) {
        Pair<Properties, FileTemplate> pair = LiquibaseCreatorKt.getJ2EETemplateWithProps(this.getProject(), changeSource, quotingStrategy, this.templateName);
        Properties props = (Properties)pair.component1();
        FileTemplate template = (FileTemplate)pair.component2();
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)props, (PsiDirectory)targetDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
        PsiElement element = psiElement;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        return (PsiFile)((XmlFile)psiFile);
    }

    private static final void writeChangeLogIntoFile$lambda$0(XmlChangeLogWriter this$0, PsiFile $newDbChangeLogFile) {
        CodeStyleManager.getInstance((Project)this$0.getProject()).reformat((PsiElement)$newDbChangeLogFile);
    }

    private static final void writeChangeLogIntoFile$lambda$3(Document $document, XmlTag $fakeRootTag, XmlChangeLogWriter this$0, XmlFile $existingChangeLogFile, PsiDocumentManager $documentManager, String $changeSource, XmlTag $dbChangeLogRootTag) {
        Document document = $document;
        if (document != null) {
            Document it = document;
            boolean bl = false;
            $documentManager.commitDocument(it);
            if (it instanceof DocumentImpl && !((DocumentImpl)it).acceptsSlashR() && StringsKt.contains$default((CharSequence)$changeSource, (char)'\r', (boolean)false, (int)2, null)) {
                ((DocumentImpl)it).setAcceptSlashR(true);
            }
        }
        XmlTag[] xmlTagArray = $fakeRootTag.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"getSubTags(...)");
        Object[] $this$forEach$iv = xmlTagArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XmlTag changeSetTag = (XmlTag)element$iv;
            boolean bl = false;
            $dbChangeLogRootTag.addSubTag(changeSetTag, false);
        }
        CodeStyleManager.getInstance((Project)this$0.getProject()).reformat((PsiElement)$existingChangeLogFile);
    }

    private static final void addPropertyTags$lambda$13(Map $toCreatePropertyTags, XmlTag $changeLogRootTag) {
        for (Map.Entry property : $toCreatePropertyTags.entrySet()) {
            boolean bl;
            block3: {
                XmlTag[] existPropertyTags;
                Intrinsics.checkNotNullExpressionValue((Object)$changeLogRootTag.findSubTags("property"), (String)"findSubTags(...)");
                XmlTag[] $this$none$iv = existPropertyTags;
                boolean $i$f$none = false;
                int n = $this$none$iv.length;
                for (int i = 0; i < n; ++i) {
                    XmlTag element$iv;
                    XmlTag it = element$iv = $this$none$iv[i];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getAttributeValue("name"), property.getKey())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (!bl) continue;
            Iterable $this$forEach$iv = (Iterable)property.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XmlTag propertyTag = (XmlTag)element$iv;
                boolean bl3 = false;
                PsiElement psiElement = propertyTag.copy();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
                $changeLogRootTag.addSubTag((XmlTag)psiElement, true);
            }
        }
    }
}

