/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.action;

import com.intellij.jpa.jpb.model.action.ActionUtilsKt;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.ui.dialog.HDialogWrapper;
import com.intellij.liquibase.common.DbTypeExtKt;
import com.intellij.liquibase.common.DiffGeneratorErrorDialog;
import com.intellij.liquibase.common.LiquibaseCommandManager;
import com.intellij.liquibase.common.LiquibaseIntellijDiffGenerationHandler;
import com.intellij.liquibase.common.action.CreateChangeLogAction;
import com.intellij.liquibase.common.action.DiffGeneratorHandler;
import com.intellij.liquibase.common.config.ChangelogDiffType;
import com.intellij.liquibase.common.config.DatabaseInfo;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.liquibase.common.gui.ChangeLogCreationInfo;
import com.intellij.liquibase.common.gui.ChangeLogPreviewDialog;
import com.intellij.liquibase.common.gui.DbTypeSelectionDialog;
import com.intellij.liquibase.common.gui.DefaultChangeLogTreeBuilder;
import com.intellij.liquibase.common.gui.DiffChangeLogCreationDialog;
import com.intellij.liquibase.common.gui.DiffScope;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.liquibase.common.util.NotificationUtilsKt;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import liquibase.database.Database;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0004J\b\u0010\u0014\u001a\u00020\bH\u0014J4\u0010\u0015\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/intellij/liquibase/common/action/CreateDiffChangeLogAction;", "Lcom/intellij/liquibase/common/action/CreateChangeLogAction;", "<init>", "()V", "isCrossDbmsSupport", "", "()Z", "getDiffDialogTitle", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "customUpdate", "", "project", "Lcom/intellij/openapi/project/Project;", "doActionPerformed", "createDiffChangeLogDialog", "Lcom/intellij/liquibase/common/gui/ChangeLogCreationInfo;", "chooseDbTypes", "getChangeLogFileName", "getFileExt", "showChangeLogPreviewDialog", "changeLogTag", "Lcom/intellij/psi/xml/XmlTag;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "persistenceUnitName", "MyDiffGeneratorHandler", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nCreateDiffChangeLogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateDiffChangeLogAction.kt\ncom/intellij/liquibase/common/action/CreateDiffChangeLogAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1563#2:195\n1634#2,3:196\n2746#2,3:199\n*S KotlinDebug\n*F\n+ 1 CreateDiffChangeLogAction.kt\ncom/intellij/liquibase/common/action/CreateDiffChangeLogAction\n*L\n101#1:195\n101#1:196,3\n109#1:199,3\n*E\n"})
public class CreateDiffChangeLogAction
extends CreateChangeLogAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isCrossDbmsSupport;
    @NotNull
    public static final String ID = "CreateDiffLiquibaseChangeLog";
    @NotNull
    public static final String ACTION_GROUP = "LiquibasePreviewDialogActionGroup";
    @NotNull
    public static final String CHANGELOG_QUICK_FIX = "JpaChangelogQuickFixAction";

    public CreateDiffChangeLogAction() {
        this.isCrossDbmsSupport = true;
    }

    protected boolean isCrossDbmsSupport() {
        return this.isCrossDbmsSupport;
    }

    @NotNull
    protected String getDiffDialogTitle(@Nullable AnActionEvent e) {
        String string = LiquibaseResourceBundle.message("diff.liquibase.changelog", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public void customUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.liquibaseActionUpdate(e, project);
    }

    @Override
    protected void doActionPerformed(@NotNull AnActionEvent e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ChangeLogCreationInfo creationDialog = this.createDiffChangeLogDialog(project, e);
        HDialogWrapper hDialogWrapper = creationDialog instanceof HDialogWrapper ? (HDialogWrapper)creationDialog : null;
        if (!(hDialogWrapper != null ? hDialogWrapper.showAndGet() : false)) {
            return;
        }
        try {
            OrmUnit persistenceUnit;
            FileDocumentManager.getInstance().saveAllDocuments();
            ChangelogDiffType sourceDiffType = creationDialog.getSourceDiffType();
            DbProperties dbProperties = creationDialog.getTargetDbProperties();
            if (dbProperties == null) {
                return;
            }
            DbProperties targetDbProperties = dbProperties;
            MyDiffGeneratorHandler diffGenerator = new MyDiffGeneratorHandler(e, project, targetDbProperties);
            OrmUnit ormUnit = persistenceUnit = creationDialog.getPersistenceUnit();
            diffGenerator.setPersistenceUnitName(ormUnit != null ? ormUnit.getName() : null);
            if (sourceDiffType == ChangelogDiffType.MODEL) {
                DiffScope diffScope = creationDialog.getDiffScope();
                diffGenerator.diffAndShow((Function0<? extends XmlTag>)((Function0)() -> CreateDiffChangeLogAction.doActionPerformed$lambda$0(project, targetDbProperties, persistenceUnit, diffScope, this)));
            } else {
                DbProperties dbProperties2 = creationDialog.getSourceDbProperties();
                if (dbProperties2 == null) {
                    return;
                }
                DbProperties sourceDbProperties = dbProperties2;
                boolean isInit = creationDialog.isInit();
                diffGenerator.diffAndShow((Function0<? extends XmlTag>)((Function0)() -> CreateDiffChangeLogAction.doActionPerformed$lambda$1(isInit, project, sourceDbProperties, targetDbProperties)));
            }
        }
        catch (CancellationException e2) {
            NotificationUtilsKt.showDiffGenerationGroupNotification(project, LiquibaseResourceBundle.message("generating.diff.canceled", new Object[0]), NotificationType.WARNING);
        }
        catch (Exception e3) {
            DbProperties dbProperties = creationDialog.getTargetDbProperties();
            DiffGeneratorErrorDialog.Companion.show$default(DiffGeneratorErrorDialog.Companion, project, e3, (DbType)(dbProperties != null ? dbProperties.getType() : null), null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected ChangeLogCreationInfo createDiffChangeLogDialog(@NotNull Project project, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DiffChangeLogCreationDialog dialog = new DiffChangeLogCreationDialog(project);
        List entityClasses = ActionUtilsKt.getActionEntityClasses$default((AnActionEvent)e, OrmDiffModelProvider.Companion.getSupportedFrameworks(project), (boolean)false, (int)4, null);
        if (!((Collection)entityClasses).isEmpty()) {
            Collection<EntityPsi> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = entityClasses;
            DiffScope diffScope = DiffScope.SelectedEntities;
            DiffChangeLogCreationDialog diffChangeLogCreationDialog = dialog;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PsiClass psiClass = (PsiClass)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(EntityPsi.getInstance((PsiClass)p0));
            }
            collection = (List)destination$iv$iv;
            diffChangeLogCreationDialog.setSearchScope(diffScope, (List<? extends EntityPsi>)collection);
        }
        dialog.initByActionEvent(e);
        return dialog;
    }

    protected boolean chooseDbTypes(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DatabaseMigrationState migrationState = DatabaseMigrationConfig.Companion.getInstance(project).getState();
            Iterable $this$none$iv = migrationState.getDatabaseInfos();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    DatabaseInfo it = (DatabaseInfo)element$iv;
                    boolean bl2 = false;
                    if (!it.isEnabled()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return !bl || new DbTypeSelectionDialog(project).showAndGet();
    }

    @Nullable
    protected final String getChangeLogFileName(@Nullable AnActionEvent e) {
        if (e == null) {
            return null;
        }
        if (this.isActionInPlace(e, "JpaStructureToolBar")) {
            return null;
        }
        Project project = e.getProject();
        if (this.isActionInPlace(e, CHANGELOG_QUICK_FIX)) {
            return (String)e.getData(CreateChangeLogAction.Companion.getINIT_FILE_NAME());
        }
        if (project != null && this.isActionInPlace(e, "JpaPaletteDiffAction")) {
            VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
            VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
            return virtualFile != null ? virtualFile.getName() : null;
        }
        VirtualFile virtualFile = (VirtualFile)e.getData(LangDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return Intrinsics.areEqual((Object)virtualFile2.getExtension(), (Object)this.getFileExt()) && !this.isActionInPlace(e, "DatabaseViewPopup") ? virtualFile2.getName() : null;
    }

    @NotNull
    protected String getFileExt() {
        return "xml";
    }

    protected void showChangeLogPreviewDialog(@Nullable AnActionEvent e, @NotNull Project project, @NotNull XmlTag changeLogTag, @NotNull DbProperties dbProperties, @Nullable String persistenceUnitName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)changeLogTag, (String)"changeLogTag");
        Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
        Object object = this.getSelectedDirectory(e);
        if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
            AnActionEvent anActionEvent = e;
            object = anActionEvent != null ? (String)anActionEvent.getData(CreateChangeLogAction.Companion.getINIT_DIRECTORY_NAME()) : null;
        }
        AnActionEvent anActionEvent = e;
        DefaultChangeLogTreeBuilder treeBuilder = new DefaultChangeLogTreeBuilder(project, persistenceUnitName, (String)object, this.getChangeLogFileName(e), (anActionEvent != null ? (String)anActionEvent.getData(CreateChangeLogAction.Companion.getINIT_DIRECTORY_NAME()) : null) == null || e.getData(CreateChangeLogAction.Companion.getINIT_FILE_NAME()) == null, null, 32, null);
        Map map = MapsKt.mapOf((Pair)TuplesKt.to(null, (Object)changeLogTag));
        AnActionEvent anActionEvent2 = e;
        if (anActionEvent2 != null) {
            AnActionEvent it = anActionEvent2;
            boolean bl2 = false;
            bl = this.isActionInPlace(it, "JpaPaletteDiffAction") || this.isActionInPlace(it, CHANGELOG_QUICK_FIX);
        } else {
            bl = false;
        }
        boolean bl3 = bl;
        DbType dbType = dbProperties.getType();
        Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
        Database database = DbTypeExtKt.toDatabase(dbType);
        ChangeLogPreviewDialog changeLogPreviewDialog = new ChangeLogPreviewDialog(project, map, persistenceUnitName, null, null, treeBuilder, ACTION_GROUP, bl3, database, null, null, 1560, null);
        if (changeLogPreviewDialog.showAndGet()) {
            changeLogPreviewDialog.saveToChangeLogs();
        }
    }

    private static final XmlTag doActionPerformed$lambda$0(Project $project, DbProperties $targetDbProperties, OrmUnit $persistenceUnit, DiffScope $diffScope, CreateDiffChangeLogAction this$0) {
        OrmUnit ormUnit = $persistenceUnit;
        String string = ormUnit != null ? ormUnit.getName() : null;
        OrmUnit ormUnit2 = $persistenceUnit;
        if (ormUnit2 == null || (ormUnit2 = ormUnit2.getOrmFramework()) == null) {
            ormUnit2 = (OrmFramework)JpaOrmFramework.INSTANCE;
        }
        return new LiquibaseIntellijDiffGenerationHandler($project, $targetDbProperties, string, (OrmFramework)ormUnit2, $diffScope, new String[0], this$0.isCrossDbmsSupport()).run();
    }

    private static final XmlTag doActionPerformed$lambda$1(boolean $isInit, Project $project, DbProperties $sourceDbProperties, DbProperties $targetDbProperties) {
        return $isInit ? LiquibaseCommandManager.Companion.getInstance($project).generateInitChangeLogTag($sourceDbProperties) : LiquibaseCommandManager.Companion.getInstance($project).generateDiffChangeLogTag($sourceDbProperties, $targetDbProperties);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/common/action/CreateDiffChangeLogAction$Companion;", "", "<init>", "()V", "ID", "", "ACTION_GROUP", "CHANGELOG_QUICK_FIX", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ4\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/liquibase/common/action/CreateDiffChangeLogAction$MyDiffGeneratorHandler;", "Lcom/intellij/liquibase/common/action/DiffGeneratorHandler;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "<init>", "(Lcom/intellij/liquibase/common/action/CreateDiffChangeLogAction;Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;)V", "diffDialogTitle", "", "getDiffDialogTitle", "()Ljava/lang/String;", "showChangeLogPreviewDialog", "", "changeLogTag", "Lcom/intellij/psi/xml/XmlTag;", "persistenceUnitName", "intellij.liquibase.common"})
    private final class MyDiffGeneratorHandler
    extends DiffGeneratorHandler {
        @NotNull
        private final String diffDialogTitle;

        public MyDiffGeneratorHandler(@NotNull AnActionEvent e, @NotNull Project project, DbProperties dbProperties) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
            super(e, project, dbProperties);
            this.diffDialogTitle = CreateDiffChangeLogAction.this.getDiffDialogTitle(e);
        }

        @Override
        @NotNull
        protected String getDiffDialogTitle() {
            return this.diffDialogTitle;
        }

        @Override
        protected void showChangeLogPreviewDialog(@Nullable AnActionEvent e, @NotNull Project project, @NotNull XmlTag changeLogTag, @NotNull DbProperties dbProperties, @Nullable String persistenceUnitName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)changeLogTag, (String)"changeLogTag");
            Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
            CreateDiffChangeLogAction.this.showChangeLogPreviewDialog(e, project, changeLogTag, dbProperties, persistenceUnitName);
        }
    }
}

