/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.action;

import com.intellij.jpa.jpb.model.action.ActionUtilsKt;
import com.intellij.jpa.jpb.model.action.StructureKeys;
import com.intellij.jpa.jpb.model.action.creation.EventDataProviderEP;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbprop.OfflineDbProperties;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.liquibase.common.DiffGeneratorErrorDialog;
import com.intellij.liquibase.common.LiquibaseCommandManager;
import com.intellij.liquibase.common.LiquibaseGenerateModelSnapshotHandler;
import com.intellij.liquibase.common.action.CreateChangeLogAction;
import com.intellij.liquibase.common.gui.SnapshotCreationDialog;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.common.orm.LiquibaseOrmFramework;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/common/action/GenerateSnapshotAction;", "Lcom/intellij/liquibase/common/action/CreateChangeLogAction;", "<init>", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "doActionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "customUpdate", "Companion", "intellij.liquibase.common"})
public class GenerateSnapshotAction
extends CreateChangeLogAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "CreateLiquibaseSnapshot";

    @NotNull
    public String getDialogTitle() {
        String string = LiquibaseResourceBundle.message("json.snapshot", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected void doActionPerformed(@NotNull AnActionEvent e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SnapshotCreationDialog creationDialog = new SnapshotCreationDialog(project, this.getSelectedDirectory(e));
        creationDialog.setTitle(this.getDialogTitle());
        if (!creationDialog.showAndGet()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().invokeLater(() -> GenerateSnapshotAction.doActionPerformed$lambda$4(creationDialog, e, project));
    }

    @Override
    public void customUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (EventDataProviderEP.Companion.getAGGREGATOR().isGlobalActionPlace(e)) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        String[] stringArray = new String[]{"GoToAction", "ToolwindowTitle"};
        if (this.isActionInPlaces(e, stringArray)) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        OrmFramework ormFramework = (OrmFramework)e.getData(StructureKeys.ORM_FRAMEWORK);
        if (ormFramework != null) {
            e.getPresentation().setEnabledAndVisible(ormFramework instanceof JpaOrmFramework || ormFramework instanceof LiquibaseOrmFramework);
            return;
        }
        Presentation presentation = e.getPresentation();
        JpsModuleSourceRootType[] jpsModuleSourceRootTypeArray = new JpsModuleSourceRootType[2];
        Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.RESOURCE, (String)"RESOURCE");
        Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.TEST_RESOURCE, (String)"TEST_RESOURCE");
        presentation.setEnabledAndVisible(ActionUtilsKt.isUnderSourceRootOfType((AnActionEvent)e, (JpsModuleSourceRootType[])jpsModuleSourceRootTypeArray));
    }

    private static final PsiFile doActionPerformed$lambda$4$lambda$3$lambda$0(Project $project, VirtualFile $it) {
        return PsiManager.getInstance((Project)$project).findFile($it);
    }

    private static final Unit doActionPerformed$lambda$4$lambda$3$lambda$1(PsiFile psiFile) {
        block0: {
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) break block0;
            psiFile2.navigate(true);
        }
        return Unit.INSTANCE;
    }

    private static final void doActionPerformed$lambda$4$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void doActionPerformed$lambda$4(SnapshotCreationDialog $creationDialog, AnActionEvent $e, Project $project) {
        DbProperties dbProperties = $creationDialog.getSourceDbProperties();
        try {
            String outputFile = $creationDialog.getSnapshotFilePath();
            if (dbProperties instanceof OfflineDbProperties) {
                OrmFramework ormFramework = OrmUtil.INSTANCE.getOrmFrameworkByEvent($e);
                if (ormFramework == null) {
                    ormFramework = (OrmFramework)JpaOrmFramework.INSTANCE;
                }
                OrmFramework ormFramework2 = ormFramework;
                LiquibaseGenerateModelSnapshotHandler.Companion.fromOfflineDbProperties($project, ormFramework2, (OfflineDbProperties)dbProperties, outputFile).run();
            } else {
                LiquibaseCommandManager.Companion.getInstance($project).generateSnapshot(outputFile, dbProperties);
            }
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(outputFile), (boolean)true);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                ReadAction.nonBlocking(() -> GenerateSnapshotAction.doActionPerformed$lambda$4$lambda$3$lambda$0($project, it)).inSmartMode($project).finishOnUiThread(ModalityState.nonModal(), arg_0 -> GenerateSnapshotAction.doActionPerformed$lambda$4$lambda$3$lambda$2(GenerateSnapshotAction::doActionPerformed$lambda$4$lambda$3$lambda$1, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        }
        catch (Exception e) {
            DiffGeneratorErrorDialog.Companion.show$default(DiffGeneratorErrorDialog.Companion, $project, e, dbProperties.getType(), null, 8, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/liquibase/common/action/GenerateSnapshotAction$Companion;", "", "<init>", "()V", "ID", "", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

