/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JJ\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\"\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0012`\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/liquibase/inspection/DuplicateChangesetIdAndAuthorInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "getGroupDisplayName", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "processChangeSets", "", "rootTag", "Lcom/intellij/psi/xml/XmlTag;", "changeSetIdsAndAuthors", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "visited", "", "intellij.liquibase"})
public final class DuplicateChangesetIdAndAuthorInspection
extends LocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = LiquibaseResourceBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ DuplicateChangesetIdAndAuthorInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFile(PsiFile psiFile) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                if (psiFile instanceof XmlFile) {
                    HashMap<K, V> changeSetIdsAndAuthors = new HashMap<K, V>();
                    XmlTag rootTag = ((XmlFile)psiFile).getRootTag();
                    if (rootTag != null) {
                        DuplicateChangesetIdAndAuthorInspection.access$processChangeSets(this.this$0, rootTag, this.$holder, changeSetIdsAndAuthors, new LinkedHashSet<E>());
                    }
                }
                super.visitFile(psiFile);
            }
        };
    }

    private final void processChangeSets(XmlTag rootTag, ProblemsHolder holder, HashMap<String, Integer> changeSetIdsAndAuthors, Set<XmlTag> visited) {
        if (!visited.add(rootTag)) {
            return;
        }
        for (XmlTag changeSetTag : rootTag.findSubTags("changeSet")) {
            TextRange authorChangeRange;
            TextRange idTextRange;
            XmlAttribute idAttribute = changeSetTag.getAttribute("id");
            XmlAttribute authorAttribute = changeSetTag.getAttribute("author");
            if (idAttribute == null || authorAttribute == null) continue;
            String changeSetId = idAttribute.getValue();
            String changeSetAuthor = authorAttribute.getValue();
            CharSequence charSequence = changeSetId;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)changeSetAuthor) == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            String pair = changeSetId + changeSetAuthor;
            Integer n = changeSetIdsAndAuthors.getOrDefault(pair, 0);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
            int count = ((Number)n).intValue();
            ((Map)changeSetIdsAndAuthors).put(pair, count + 1);
            Integer n2 = changeSetIdsAndAuthors.get(pair);
            Intrinsics.checkNotNull((Object)n2);
            if (((Number)n2).intValue() <= 1) continue;
            Intrinsics.checkNotNullExpressionValue((Object)idAttribute.getValueTextRange().shiftRight(3), (String)"shiftRight(...)");
            holder.registerProblem((PsiElement)idAttribute, idTextRange, LiquibaseResourceBundle.message("inspection.DuplicateChangeSetIdInspection", new Object[0]), new LocalQuickFix[0]);
            Intrinsics.checkNotNullExpressionValue((Object)authorAttribute.getValueTextRange().shiftRight(7), (String)"shiftRight(...)");
            holder.registerProblem((PsiElement)authorAttribute, authorChangeRange, LiquibaseResourceBundle.message("inspection.DuplicateChangeSetIdInspection", new Object[0]), new LocalQuickFix[0]);
        }
        for (XmlTag subTag : rootTag.getSubTags()) {
            Intrinsics.checkNotNull((Object)subTag);
            this.processChangeSets(subTag, holder, changeSetIdsAndAuthors, visited);
        }
    }

    public static final /* synthetic */ void access$processChangeSets(DuplicateChangesetIdAndAuthorInspection $this, XmlTag rootTag, ProblemsHolder holder, HashMap changeSetIdsAndAuthors, Set visited) {
        $this.processChangeSets(rootTag, holder, changeSetIdsAndAuthors, visited);
    }
}

