/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.jpa;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jpa.DataSourceRelatedReferenceFixProvider;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.jpb.model.backend.ds.DataSourceLoader;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.liquibase.common.LiquibaseHelper;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.liquibase.jpa.CreateDiffChangeLogActionFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/liquibase/jpa/LiquibaseUnresolvedColumnFixProvider;", "Lcom/intellij/jpa/DataSourceRelatedReferenceFixProvider;", "<init>", "()V", "getQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "reference", "Lcom/intellij/jpa/ORMReferencesUtil$DataSourceRelatedReference;", "(Lcom/intellij/jpa/ORMReferencesUtil$DataSourceRelatedReference;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.liquibase.jpa"})
public final class LiquibaseUnresolvedColumnFixProvider
implements DataSourceRelatedReferenceFixProvider {
    @NotNull
    public LocalQuickFix[] getQuickFixes(@NotNull ORMReferencesUtil.DataSourceRelatedReference<?> reference) {
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        OrmFramework ormFramework = reference.getOrmFramework();
        Intrinsics.checkNotNullExpressionValue((Object)ormFramework, (String)"getOrmFramework(...)");
        if (OrmDiffModelProvider.Companion.findForFramework(ormFramework) == null) {
            return new LocalQuickFix[0];
        }
        Project project = reference.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)reference.getElement());
        if (!LiquibaseHelper.Companion.getInstance(project2).isLiquibaseSupported(project2, module)) {
            return new LocalQuickFix[0];
        }
        DataSourceLoader dataSourceLoader = DataSourceLoader.Companion.getInstance(project2);
        OrmFramework ormFramework2 = reference.getOrmFramework();
        Intrinsics.checkNotNullExpressionValue((Object)ormFramework2, (String)"getOrmFramework(...)");
        if (dataSourceLoader.getReverseEngineeringDataStores(ormFramework2).isEmpty()) {
            return new LocalQuickFix[0];
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new CreateDiffChangeLogActionFix(reference)};
        return localQuickFixArray;
    }
}

