/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.jpa.orm;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.JpaConverterModel;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MysqlType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.VladmihalceaHibernateTypes;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EnumType;
import com.intellij.jpa.jpb.model.model.audit.AuditEntityAttribute;
import com.intellij.jpa.jpb.model.model.constraint.Constraint;
import com.intellij.jpa.jpb.model.model.constraint.SizeConstraint;
import com.intellij.jpa.jpb.model.service.JpabGeneratorManager;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.liquibase.common.ColumnDefinitionType;
import com.intellij.liquibase.common.DatatypeJavaType;
import com.intellij.liquibase.common.JavaType;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.UnknownType;
import com.intellij.liquibase.common.config.MappingType;
import com.intellij.liquibase.common.ddl.DbMappingSettings;
import com.intellij.liquibase.jpa.orm.JpaLiquibaseAttributesHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JpaLiquibaseTypesHelper {
    private final LiquibaseGenerationContext context;
    private final DbType dbType;
    private final JpabGeneratorManager ddlGeneratorManager;

    JpaLiquibaseTypesHelper(LiquibaseGenerationContext context) {
        this.context = context;
        this.dbType = context.getMainDbType();
        this.ddlGeneratorManager = JpabGeneratorManager.getInstance((Project)context.getProject());
    }

    public JavaType getJavaType(@Nullable Entity entity, @NotNull EntityAttribute attribute) {
        JavaType javaType;
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(0);
        }
        if ((javaType = this._getJavaType(entity, attribute)).isValid(this.context)) {
            return javaType;
        }
        EntityAttribute extractedAttr = JpaLiquibaseAttributesHelper.tryToExtractGenericAttribute(this.context.getProject(), entity, attribute);
        if (extractedAttr != null && (javaType = this._getJavaType(entity, extractedAttr)).isValid(this.context)) {
            return javaType;
        }
        Datatype type = attribute.getType();
        if (type instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)type).isSerializable()) {
            return new DatatypeJavaType((Datatype)Datatypes.BasicDatatype.ByteArray, null, null, false, JpaLiquibaseTypesHelper.getJdbcTypeCode(attribute));
        }
        return new UnknownType(attribute);
    }

    @NotNull
    private EntityAttribute getPrimaryKeyAttribute(@NotNull EntityAttribute attribute) {
        EntityAttribute extractedGenericAttr;
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(1);
        }
        if (!attribute.isClass()) {
            EntityAttribute entityAttribute = attribute;
            if (entityAttribute == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(2);
            }
            return entityAttribute;
        }
        Entity attrType = (Entity)attribute.getType();
        EntityAttribute idAttribute = attrType.getIdAttribute();
        Datatype idAttrType = idAttribute.getType();
        if (idAttrType instanceof Datatypes.BasicDatatype && Datatypes.BasicDatatype.getInstanceStrict((String)idAttrType.getFqn()) == null && (extractedGenericAttr = JpaLiquibaseAttributesHelper.tryToExtractGenericAttribute(this.context.getProject(), attrType, idAttribute)) != null) {
            EntityAttribute entityAttribute = extractedGenericAttr;
            if (entityAttribute == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(3);
            }
            return entityAttribute;
        }
        EntityAttribute entityAttribute = idAttribute;
        if (entityAttribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(4);
        }
        return entityAttribute;
    }

    @NotNull
    private JavaType _getJavaType(@Nullable Entity entity, @NotNull EntityAttribute attribute) {
        String columnDefinition;
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)(columnDefinition = attribute.getColumnDefinition(entity)))) {
            return new ColumnDefinitionType(columnDefinition);
        }
        Datatype attrType = attribute.getType();
        CustomTypeModel converter = attribute.getConverter();
        if (converter != null) {
            Datatypes.BasicDatatype datatype;
            DatatypeJavaType javaType;
            String qualifiedName;
            PsiClass converterClass = converter.getTypeClass();
            if (converterClass != null && (qualifiedName = converterClass.getQualifiedName()) != null && (javaType = this.createDatatypeJavaType(entity, attribute, (Datatype)(datatype = Datatypes.BasicDatatype.getInstance((String)qualifiedName)), true, true)).isValid(this.context)) {
                DatatypeJavaType datatypeJavaType = javaType;
                if (datatypeJavaType == null) {
                    JpaLiquibaseTypesHelper.$$$reportNull$$$0(6);
                }
                return datatypeJavaType;
            }
            if (converter instanceof JpaConverterModel) {
                DatatypeJavaType datatypeJavaType = this.getJpaConverterDatatype(entity, attribute, (JpaConverterModel)converter);
                if (datatypeJavaType == null) {
                    JpaLiquibaseTypesHelper.$$$reportNull$$$0(7);
                }
                return datatypeJavaType;
            }
        }
        if (attribute.isClass() || attribute.isId()) {
            EntityAttribute referencedAttribute;
            String referencedColumnName;
            EntityAttribute pkAttr = this.getPrimaryKeyAttribute(attribute);
            if (attribute.isClass() && (referencedColumnName = attribute.getReferencedColumnName()) != null && (referencedAttribute = this.getAttributeByColumnName((Entity)attribute.getType(), referencedColumnName)) != null) {
                pkAttr = referencedAttribute;
            }
            if (StringUtil.isNotEmpty((String)(columnDefinition = pkAttr.getColumnDefinition(entity)))) {
                return new ColumnDefinitionType(columnDefinition);
            }
            Datatype pkAttrType = pkAttr.getType();
            if (pkAttrType instanceof EnumType) {
                DatatypeJavaType datatypeJavaType = this.createEnumDatatype(entity, pkAttr, (EnumType)pkAttrType);
                if (datatypeJavaType == null) {
                    JpaLiquibaseTypesHelper.$$$reportNull$$$0(8);
                }
                return datatypeJavaType;
            }
            DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, pkAttrType, true, true);
            if (datatypeJavaType == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(9);
            }
            return datatypeJavaType;
        }
        EntityAttribute.TemporalType temporalType = attribute.getTemporalType();
        if (temporalType == EntityAttribute.TemporalType.DATE) {
            DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.SqlDate, false, false);
            if (datatypeJavaType == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(10);
            }
            return datatypeJavaType;
        }
        if (temporalType == EntityAttribute.TemporalType.TIME) {
            DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.SqlTime, true, false);
            if (datatypeJavaType == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(11);
            }
            return datatypeJavaType;
        }
        if (temporalType == EntityAttribute.TemporalType.TIMESTAMP) {
            DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.SqlTimestamp, true, false);
            if (datatypeJavaType == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(12);
            }
            return datatypeJavaType;
        }
        if (attrType == Datatypes.BasicDatatype.OffsetTime || attrType == Datatypes.BasicDatatype.OffsetDateTime || attrType == Datatypes.BasicDatatype.ZonedDateTime) {
            DatatypeJavaType datatypeJavaType = this.createZonedDateTimeDatatype(entity, attribute, attrType);
            if (datatypeJavaType == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(13);
            }
            return datatypeJavaType;
        }
        if (attrType instanceof EnumType) {
            DatatypeJavaType datatypeJavaType = this.createEnumDatatype(entity, attribute, (EnumType)attrType);
            if (datatypeJavaType == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(14);
            }
            return datatypeJavaType;
        }
        if (attribute.isDatatype()) {
            if (JpaLiquibaseTypesHelper.isLobStringDatatype(attribute, attrType)) {
                DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.LobString, false, false);
                if (datatypeJavaType == null) {
                    JpaLiquibaseTypesHelper.$$$reportNull$$$0(15);
                }
                return datatypeJavaType;
            }
            if (Datatypes.BasicDatatype.ByteArray.equalsWithPrimitive(attrType) && attribute.isLob()) {
                DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.Blob, false, false);
                if (datatypeJavaType == null) {
                    JpaLiquibaseTypesHelper.$$$reportNull$$$0(16);
                }
                return datatypeJavaType;
            }
        }
        DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, attrType, true, true);
        if (datatypeJavaType == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(17);
        }
        return datatypeJavaType;
    }

    private DatatypeJavaType createZonedDateTimeDatatype(@Nullable Entity entity, @NotNull EntityAttribute attribute, Datatype attrType) {
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(18);
        }
        EntityAttribute.TimeZoneStorageType timeZoneStorageType = attribute.getTimeZoneStorageType();
        DatatypeJavaType type = this.createDatatypeJavaType(entity, attribute, attrType, true, true);
        if (timeZoneStorageType == null || timeZoneStorageType == EntityAttribute.TimeZoneStorageType.NORMALIZE || timeZoneStorageType == EntityAttribute.TimeZoneStorageType.NORMALIZE_UTC) {
            return type;
        }
        if (attrType == Datatypes.BasicDatatype.OffsetTime) {
            return new DatatypeJavaType(type.getDatatype(), type.getLength(), null, false, 2013);
        }
        return new DatatypeJavaType(type.getDatatype(), type.getLength(), null, false, 2014);
    }

    private DatatypeJavaType createEnumDatatype(@Nullable Entity entity, @NotNull EntityAttribute attribute, EnumType attrType) {
        EntityAttribute.EnumType enumType;
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(19);
        }
        if ((enumType = attribute.getEnumType()) == EntityAttribute.EnumType.STRING) {
            return this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.String, true, false);
        }
        if (enumType == EntityAttribute.EnumType.ORDINAL) {
            if (JpaUtils.isHibernate6Project((Project)this.context.getProject(), null)) {
                return this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.Short, true, false);
            }
            return this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.Integer, true, false);
        }
        return this.createDatatypeJavaType(entity, attribute, (Datatype)attrType, true, true);
    }

    protected DatatypeJavaType createDatatypeJavaType(@Nullable Entity entity, @NotNull EntityAttribute attribute, @NotNull Datatype completedAttrType, boolean isCalculateColumnSize, boolean isCalculateDecimalDigits) {
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(20);
        }
        if (completedAttrType == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(21);
        }
        return new DatatypeJavaType(completedAttrType, isCalculateColumnSize ? this.getColumnSize(entity, attribute, completedAttrType) : null, isCalculateDecimalDigits ? this.getDecimalDigits(entity, attribute, completedAttrType) : null, attribute.isNationalized(), JpaLiquibaseTypesHelper.getJdbcTypeCode(attribute));
    }

    @NotNull
    protected DatatypeJavaType getJpaConverterDatatype(@Nullable Entity entity, @NotNull EntityAttribute attribute, JpaConverterModel converter) {
        Datatypes.BasicDatatype datatype;
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(22);
        }
        if (JpaLiquibaseTypesHelper.isLobStringDatatype(attribute, (Datatype)(datatype = Datatypes.BasicDatatype.getInstance((String)converter.getDbTypeFqn())))) {
            DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, (Datatype)Datatypes.BasicDatatype.LobString, false, false);
            if (datatypeJavaType == null) {
                JpaLiquibaseTypesHelper.$$$reportNull$$$0(23);
            }
            return datatypeJavaType;
        }
        DatatypeJavaType datatypeJavaType = this.createDatatypeJavaType(entity, attribute, (Datatype)datatype, true, true);
        if (datatypeJavaType == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(24);
        }
        return datatypeJavaType;
    }

    private static boolean isLobStringDatatype(@NotNull EntityAttribute attribute, Datatype attrType) {
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(25);
        }
        return attrType == Datatypes.BasicDatatype.String && Strings.isEmpty((String)attribute.getLength());
    }

    private Integer getColumnSize(@Nullable Entity entity, EntityAttribute attribute, @NotNull Datatype completedAttrType) {
        int precision;
        String columnDefinition;
        if (completedAttrType == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(26);
        }
        AttributeOverride attributeOverride = entity == null ? null : entity.getAttributeOverrideEx(attribute.getName());
        String string = columnDefinition = attributeOverride == null ? attribute.getColumnDefinition() : attributeOverride.getColumnDefinition();
        if (StringUtil.isNotEmpty((String)columnDefinition)) {
            return null;
        }
        CustomTypeModel converter = attribute.getConverter();
        if ((attribute.isId() || attribute.isClass()) && converter == null) {
            return this.getPrimaryKeyDefinitionColumnSize(attribute);
        }
        MappingType.SqlTypeParameter sqlTypeParameter = this.context.getSqlTypeParameter(completedAttrType, this.dbType, JpaLiquibaseTypesHelper.getJdbcTypeCode(attribute));
        int n = precision = attributeOverride == null ? attribute.getPrecision() : attributeOverride.getPrecision();
        if (sqlTypeParameter == null) {
            Datatype attributeType = attribute.getType();
            if (StringUtil.isNotEmpty((String)attribute.getLength()) && this.isCompatibleStringType(attribute)) {
                return this.getColumnLength(attribute, attributeOverride);
            }
            if (attribute.isEnum()) {
                return JpaLiquibaseTypesHelper.getEnumAttributeLength(attribute);
            }
            if (Datatypes.BasicDatatype.BigDecimal.equals((Object)attributeType) || Datatypes.BasicDatatype.BigInteger.equals((Object)attributeType) || JpaLiquibaseTypesHelper.hasDecimalJdbcCode(attribute)) {
                return JpaLiquibaseTypesHelper.processPrecisionOrScaleValue(precision);
            }
        } else {
            if (sqlTypeParameter == MappingType.SqlTypeParameter.LENGTH) {
                return this.getColumnLength(attribute, attributeOverride);
            }
            if (sqlTypeParameter == MappingType.SqlTypeParameter.PRECISION_AND_SCALE) {
                return JpaLiquibaseTypesHelper.processPrecisionOrScaleValue(precision);
            }
        }
        return null;
    }

    @Nullable
    public Integer getColumnLength(EntityAttribute attribute, @Nullable AttributeOverride attributeOverride) {
        Integer max;
        Integer specificLength;
        Integer jdbcTypeCode = JpaLiquibaseTypesHelper.getJdbcTypeCode(attribute);
        if (jdbcTypeCode != null && (specificLength = this.context.getMappingSettings(this.dbType).getSpecificLengthByJdbcTypeCode(jdbcTypeCode)) != null) {
            return specificLength;
        }
        if (attributeOverride != null) {
            return attributeOverride.getLength();
        }
        Constraint sizeConstraint = (Constraint)ContainerUtil.find((Iterable)attribute.getConstraints(), constraint -> constraint.isEnabled() && constraint instanceof SizeConstraint);
        if (sizeConstraint instanceof SizeConstraint && (max = ((SizeConstraint)sizeConstraint).getMax()) != null && max != Integer.MAX_VALUE) {
            return max;
        }
        Integer processedLength = attribute.getProcessedLength();
        if (Objects.equals(processedLength, 255)) {
            Datatype type = attribute.getType();
            if (Datatypes.BasicDatatype.ZoneOffset.equals((Object)type)) {
                return 6;
            }
            if (Datatypes.BasicDatatype.InetAddress.equals((Object)type)) {
                return 19;
            }
        }
        return processedLength;
    }

    private boolean isCompatibleStringType(@NotNull EntityAttribute attribute) {
        if (attribute == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(27);
        }
        Integer jdbcTypeCode = JpaLiquibaseTypesHelper.getJdbcTypeCode(attribute);
        DbMappingSettings mappingSettings = this.context.getMappingSettings(this.dbType);
        if (jdbcTypeCode != null) {
            return mappingSettings.isJdbcTypeCodeLengthAvailable(jdbcTypeCode);
        }
        Datatype attrType = attribute.getType();
        if (this.isCompatibleStringType(mappingSettings, attrType)) {
            return true;
        }
        CustomTypeModel converter = attribute.getConverter();
        if (converter instanceof JpaConverterModel) {
            String dbTypeFqn = ((JpaConverterModel)converter).getDbTypeFqn();
            return this.isCompatibleStringType(mappingSettings, (Datatype)Datatypes.BasicDatatype.getInstance((String)dbTypeFqn));
        }
        return converter != null && this.isCompatibleStringByConverter(converter);
    }

    private Integer getDecimalDigits(@Nullable Entity entity, EntityAttribute attribute, @NotNull Datatype completedAttrType) {
        String columnDefinition;
        if (completedAttrType == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(28);
        }
        AttributeOverride attributeOverride = entity == null ? null : entity.getAttributeOverrideEx(attribute.getName());
        String string = columnDefinition = attributeOverride == null ? attribute.getColumnDefinition() : attributeOverride.getColumnDefinition();
        if (StringUtil.isNotEmpty((String)columnDefinition)) {
            return null;
        }
        MappingType.SqlTypeParameter sqlTypeParameter = this.context.getSqlTypeParameter(completedAttrType, this.dbType, JpaLiquibaseTypesHelper.getJdbcTypeCode(attribute));
        if (sqlTypeParameter == null && (Datatypes.BasicDatatype.BigDecimal.equals((Object)attribute.getType()) || JpaLiquibaseTypesHelper.hasDecimalJdbcCode(attribute)) || sqlTypeParameter == MappingType.SqlTypeParameter.PRECISION_AND_SCALE) {
            int scale = attributeOverride == null ? attribute.getScale() : attributeOverride.getScale();
            return JpaLiquibaseTypesHelper.processPrecisionOrScaleValue(scale);
        }
        return null;
    }

    private static Integer processPrecisionOrScaleValue(int value) {
        return value <= 0 ? null : Integer.valueOf(value);
    }

    @Nullable
    private Integer getPrimaryKeyDefinitionColumnSize(EntityAttribute attribute) {
        EntityAttribute pkAttr = this.getPrimaryKeyAttribute(attribute);
        Datatype pkAttrType = pkAttr.getType();
        if (Datatypes.BasicDatatype.String.equals((Object)pkAttrType) || pkAttrType instanceof EnumType && pkAttr.getEnumType() == EntityAttribute.EnumType.STRING) {
            return pkAttr.getProcessedLength();
        }
        return null;
    }

    private static Integer getJdbcTypeCode(EntityAttribute entityAttribute) {
        Integer jdbcTypeCode = entityAttribute.getJdbcTypeCode();
        if (jdbcTypeCode != null || !(entityAttribute instanceof EntityAttributePsi) && !(entityAttribute instanceof AuditEntityAttribute)) {
            return jdbcTypeCode;
        }
        return Optional.ofNullable((PsiMember)entityAttribute.getPsiElement()).map(it -> AnnotationUtil.findAnnotation((PsiModifierListOwner)it, (String[])new String[]{"org.hibernate.annotations.JdbcType"})).map(it -> StudioAnnotationUtil.getDeclaredReferenceFqnStringValue((PsiAnnotation)it, (String)"value")).map(HibernateSqlType::findByJdbcTypeFqn).map(HibernateSqlType::getSqlCode).orElse(null);
    }

    private static boolean hasDecimalJdbcCode(EntityAttribute attribute) {
        Integer jdbcTypeCode = JpaLiquibaseTypesHelper.getJdbcTypeCode(attribute);
        return HibernateSqlType.DECIMAL.equalsByCode(jdbcTypeCode) || HibernateSqlType.NUMERIC.equalsByCode(jdbcTypeCode);
    }

    @Nullable
    private EntityAttribute getAttributeByColumnName(Entity entity, String columnName) {
        List attributes = this.ddlGeneratorManager.getTableAttributes(entity, this.dbType);
        return this.ddlGeneratorManager.findAttributeByColumnName(entity, (Collection)attributes, columnName);
    }

    protected boolean isCompatibleStringByConverter(@NotNull CustomTypeModel converter) {
        if (converter == null) {
            JpaLiquibaseTypesHelper.$$$reportNull$$$0(29);
        }
        if (this.dbType instanceof MysqlType || this.dbType == DbType.MARIA) {
            return false;
        }
        PsiClass typeClass = converter.getTypeClass();
        return typeClass != null && Objects.equals(typeClass.getQualifiedName(), VladmihalceaHibernateTypes.getInstance((Project)this.context.getProject()).JsonStringType.getFqn());
    }

    private boolean isCompatibleStringType(DbMappingSettings mappingSettings, Datatype attrType) {
        return attrType instanceof Datatypes.BasicDatatype && (((Datatypes.BasicDatatype)attrType).isString() || mappingSettings.isCompatibleStringType(attrType)) || attrType.equals(VladmihalceaHibernateTypes.getInstance((Project)this.context.getProject()).ZoneId);
    }

    private static Integer getEnumAttributeLength(EntityAttribute attribute) {
        if (attribute.getEnumType() == EntityAttribute.EnumType.STRING) {
            return Optional.ofNullable(attribute.getProcessedLength()).orElse(255);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/liquibase/jpa/orm/JpaLiquibaseTypesHelper";
                break;
            }
            case 21: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completedAttrType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/liquibase/jpa/orm/JpaLiquibaseTypesHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryKeyAttribute";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "_getJavaType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getJpaConverterDatatype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJavaType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryKeyAttribute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "_getJavaType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createZonedDateTimeDatatype";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createEnumDatatype";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDatatypeJavaType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getJpaConverterDatatype";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isLobStringDatatype";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getColumnSize";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleStringType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDecimalDigits";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleStringByConverter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 23, 24 -> new IllegalStateException(string);
        };
    }
}

