/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.config.JBossBindingConfig;
import com.intellij.javaee.oss.jboss.config.JBossBindingGetter;
import com.intellij.javaee.oss.jboss.config.JBossBindingProvider;
import com.intellij.javaee.oss.jboss.config.JBossBindingProviderSet;
import com.intellij.javaee.oss.jboss.config.JBossBindingSet;
import com.intellij.javaee.oss.jboss.config.JBossConfigFileProvider;
import com.intellij.javaee.oss.jboss.config.JBossPortHandler;
import com.intellij.javaee.oss.jboss.config.JBossPortProvider;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.server.JavaeePortConfig;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.javaee.oss.util.ConfigFileWrapper;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBossPortConfig
extends JavaeePortConfig {
    private static final Pattern PORT_PATTERN = Pattern.compile(Pattern.quote("${") + "(.+?)(" + Pattern.quote(":") + "(\\d+))?" + Pattern.quote("}"));
    private static final JavaeePortConfig.Factory<JBossLocalModel> DEFAULT_FACTORY = new JBossFactoryBase("Default"){

        @Override
        public JBossPortHandler getPortHandler(JavaeeServerModel model) {
            return new DefaultPortHandler();
        }
    };
    private static final JavaeePortConfig.Factory<JBossLocalModel> SHUTDOWN_FACTORY = new JBossFactoryBase("Shutdown"){

        @Override
        public JBossPortHandler getPortHandler(JavaeeServerModel model) {
            Version version = new Version(model.getVersion());
            return version.getMajor() >= 6 ? new Version6OrAboveShutdownPortHandler() : new DefaultPortHandler();
        }
    };
    private static final JavaeePortConfig.Factory<JBossLocalModel> HTTP_FACTORY = new JBossFactoryBase("Http"){

        @Override
        public JBossPortHandler getPortHandler(JavaeeServerModel model) {
            return new HttpPortHandler();
        }
    };
    private final PortHandlerProvider myPortHandlerProvider;
    private final JBossConfigFileProvider myFileProvider;
    private final File config;
    private final File naming1;
    private final File naming2;
    private final File binding1;
    private File bindings;
    private final JBossBindingProviderSet myBindingProviderSet;
    private final String myServer;

    private JBossPortConfig(String home, String server, PortHandlerProvider provider) {
        this.myServer = server;
        this.myPortHandlerProvider = provider;
        this.myFileProvider = new JBossConfigFileProvider(home, server);
        this.myBindingProviderSet = new JBossBindingProviderSet(this.myFileProvider);
        this.config = this.myFileProvider.getConfigFile("conf/jboss-service.xml");
        this.naming1 = this.myFileProvider.getConfigFile("deploy/naming-service.xml");
        this.naming2 = this.myFileProvider.getConfigFile("deploy/naming.sar/META-INF/jboss-service.xml");
        this.binding1 = this.myFileProvider.getConfigFile("deploy/binding-service.xml");
    }

    protected long getStamp(JavaeeServerModel data) {
        LinkedHashSet<File> configFiles = new LinkedHashSet<File>();
        for (JBossPortProvider provider : this.getBindingProviders(data)) {
            configFiles.add(provider.getConfigFile());
        }
        for (JBossPortProvider provider : this.getNonBindingProviders(data)) {
            configFiles.add(provider.getConfigFile());
        }
        long stamp = this.myBindingProviderSet.getStamp();
        stamp ^= (long)JBossPortConfig.getOffset(data);
        for (File nextFile : configFiles) {
            stamp ^= JBossPortConfig.getStamp((File)nextFile);
        }
        return stamp ^= JBossPortConfig.getStamp((File)this.bindings);
    }

    protected int getPort(final JavaeeServerModel model) {
        int nonBindingPort = JBossPortConfig.doGetPort(this.getNonBindingProviders(model));
        if (nonBindingPort != Integer.MAX_VALUE && nonBindingPort != model.getDefaultPort()) {
            return nonBindingPort;
        }
        ArrayList<JBossPortProvider> providers = new ArrayList<JBossPortProvider>();
        providers.add(new JBossBindingPortProvider(model, null){

            @Override
            public Integer getPort() {
                return JBossPortConfig.this.myBindingProviderSet.get(new JBossBindingGetter<Integer>(){

                    @Override
                    public Integer get(JBossBindingProvider provider) {
                        return provider.getPort(JBossPortConfig.this.myPortHandlerProvider.getPortHandler(model), model);
                    }
                });
            }
        });
        providers.addAll(this.getBindingProviders(model));
        int bindingPort = JBossPortConfig.doGetPort(providers);
        if (bindingPort == Integer.MAX_VALUE) {
            return nonBindingPort;
        }
        int portOffset = JBossPortConfig.getOffset(model);
        return portOffset == Integer.MAX_VALUE ? Integer.MAX_VALUE : bindingPort + portOffset;
    }

    private static int doGetPort(List<JBossPortProvider> providers) {
        for (JBossPortProvider provider : providers) {
            Integer result = provider.getPort();
            if (result == null) continue;
            return result;
        }
        return Integer.MAX_VALUE;
    }

    public static Integer parsePort(String port, JavaeeServerModel model) {
        return JBossPortConfig.parsePort(port, model, (Ref<String>)new Ref());
    }

    public static Integer parsePort(String port, JavaeeServerModel model, Ref<String> vmArgName) {
        Matcher matcher = PORT_PATTERN.matcher(port);
        if (matcher.matches()) {
            vmArgName.set((Object)matcher.group(1));
            Integer vmArg = JBossPortConfig.safeParseInt((String)model.getVmArgument((String)vmArgName.get()));
            if (vmArg != null) {
                return vmArg;
            }
            port = matcher.group(3);
        }
        return JBossPortConfig.safeParseInt((String)port);
    }

    public static int getDefault(JBossLocalModel model) {
        return JBossPortConfig.get(DEFAULT_FACTORY, (JavaeeServerModel)model, (int)Integer.MAX_VALUE);
    }

    public static int getShutdown(JBossLocalModel model) {
        return JBossPortConfig.get(SHUTDOWN_FACTORY, (JavaeeServerModel)model, (int)Integer.MAX_VALUE);
    }

    public static int getHttp(JBossLocalModel model) {
        return JBossPortConfig.get(HTTP_FACTORY, (JavaeeServerModel)model, (int)Integer.MAX_VALUE);
    }

    public static int checkOffset(JBossLocalModel model) throws RuntimeConfigurationError {
        String bindingSetName = model.BINDING_SET_NAME;
        if (StringUtil.isEmpty((String)bindingSetName)) {
            bindingSetName = JBossBindingConfig.getCurrentBindingSetName(model);
        }
        if (!StringUtil.isEmpty((String)bindingSetName)) {
            List<JBossBindingSet> bindingSets = JBossBindingConfig.getBindingSets(model);
            if (bindingSets == null) {
                throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.binding", new Object[0]));
            }
            for (JBossBindingSet bindingSet : bindingSets) {
                if (!bindingSet.getName().equals(bindingSetName)) continue;
                return bindingSet.getPortsOffset();
            }
            throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.binding", new Object[0]));
        }
        return 0;
    }

    private static int getOffset(JavaeeServerModel model) {
        try {
            return JBossPortConfig.checkOffset((JBossLocalModel)model);
        }
        catch (RuntimeConfigurationError error) {
            return Integer.MAX_VALUE;
        }
    }

    private List<JBossPortProvider> getBindingProviders(JavaeeServerModel model) {
        return Arrays.asList(new JBossManagerBindingPortProvider(model, this.config), new JBossServiceNameBindingPortProvider(model, this.config), new JBossManagerBindingPortProvider(model, this.binding1), new JBossServiceNameBindingPortProvider(model, this.naming1), new JBossServiceNameBindingPortProvider(model, this.naming2));
    }

    private List<JBossPortProvider> getNonBindingProviders(JavaeeServerModel model) {
        return this.myPortHandlerProvider.getPortHandler(model).getPortProviders(this, model);
    }

    private String getServiceName(JavaeeServerModel model) {
        return this.myPortHandlerProvider.getPortHandler(model).getServiceName();
    }

    private static interface PortHandlerProvider {
        public JBossPortHandler getPortHandler(JavaeeServerModel var1);
    }

    private final class JBossManagerBindingPortProvider
    extends JBossBindingPortProvider {
        private JBossManagerBindingPortProvider(JavaeeServerModel model, File configFile) {
            super(model, configFile);
        }

        @Override
        @Nullable
        public Integer getPort() {
            return (Integer)new ConfigFileWrapper<Integer>(){

                protected Integer doGet(Element rootElement) {
                    Element attribute;
                    Element bean = 1.getChild((Element)rootElement, (String)"mbean", (String)"name", (String)"jboss.system:service=ServiceBindingManager");
                    if (bean != null && (attribute = 1.getChild((Element)bean, (String)"attribute", (String)"name", (String)"StoreURL")) != null) {
                        JBossPortConfig.this.bindings = new File(attribute.getTextTrim().replace("${jboss.home.url}", JBossPortConfig.this.myFileProvider.getHome()));
                        Element name = 1.getChild((Element)bean, (String)"attribute", (String)"name", (String)"ServerName");
                        if (JBossPortConfig.this.bindings.exists() && name != null) {
                            return JBossManagerBindingPortProvider.this.doGetPort(JBossPortConfig.this.bindings, name.getTextTrim().replace("${jboss.server.name}", JBossPortConfig.this.myServer));
                        }
                    }
                    return null;
                }
            }.get(this.getConfigFile());
        }

        @Nullable
        private Integer doGetPort(File file, final @NonNls String name) {
            return (Integer)new ConfigFileWrapper<Integer>(){

                protected Integer doGet(Element rootElement) {
                    Element service;
                    Element server = 2.getChild((Element)rootElement, (String)"server", (String)"name", (String)name);
                    if (server != null && (service = 2.getChild((Element)server, (String)"service-config", (String)"name", (String)JBossManagerBindingPortProvider.this.getServiceName())) != null) {
                        return JBossManagerBindingPortProvider.this.parse(service.getChild("binding").getAttributeValue("port"));
                    }
                    return null;
                }
            }.get(file);
        }
    }

    private final class JBossServiceNameBindingPortProvider
    extends JBossBindingPortProvider {
        private JBossServiceNameBindingPortProvider(JavaeeServerModel model, File configFile) {
            super(model, configFile);
        }

        @Override
        @Nullable
        public Integer getPort() {
            return (Integer)new ConfigFileWrapper<Integer>(){

                protected Integer doGet(Element rootElement) {
                    Element attribute;
                    Element bean = 1.getChild((Element)rootElement, (String)"mbean", (String)"name", (String)JBossServiceNameBindingPortProvider.this.getServiceName());
                    if (bean != null && (attribute = 1.getChild((Element)bean, (String)"attribute", (String)"name", (String)"Port")) != null) {
                        return JBossServiceNameBindingPortProvider.this.parse(attribute.getTextTrim());
                    }
                    return null;
                }
            }.get(this.getConfigFile());
        }
    }

    private abstract class JBossBindingPortProvider
    extends JBossPortProviderBase {
        private final File myConfigFile;

        private JBossBindingPortProvider(JavaeeServerModel model, File configFile) {
            super(JBossPortConfig.this, model);
            this.myConfigFile = configFile;
        }

        @Override
        public File getConfigFile() {
            return this.myConfigFile;
        }
    }

    private static class JBossHttpPortProvider
    extends JBossPortProviderBase {
        private final String myConfigArtifactName;
        private final String myProtocolCondition;

        JBossHttpPortProvider(JBossPortConfig portConfig, JavaeeServerModel model, String configArtifactName, String protocolCondition) {
            super(portConfig, model);
            this.myConfigArtifactName = configArtifactName;
            this.myProtocolCondition = protocolCondition;
        }

        @Override
        public Integer getPort() {
            return (Integer)new ConfigFileWrapper<Integer>(){

                protected Integer doGet(Element rootElement) throws JDOMException {
                    String xPathText = "/Server/Service[@name='jboss.web']/Connector[" + myProtocolCondition + " and not(@secure)]/@port";
                    XPath xPath = XPath.newInstance((String)xPathText);
                    String port = xPath.valueOf((Object)rootElement.getDocument());
                    return this.parse(port);
                }
            }.get(this.getConfigFile());
        }

        @Override
        public File getConfigFile() {
            String configFilePath = "deploy/" + this.myConfigArtifactName + "/server.xml";
            return this.getPortConfig().myFileProvider.getConfigFile(configFilePath);
        }
    }

    private static abstract class JBossPortProviderBase
    implements JBossPortProvider {
        private final JBossPortConfig myPortConfig;
        private final JavaeeServerModel myModel;

        protected JBossPortProviderBase(JBossPortConfig portConfig, JavaeeServerModel model) {
            this.myPortConfig = portConfig;
            this.myModel = model;
        }

        public JBossPortConfig getPortConfig() {
            return this.myPortConfig;
        }

        protected Integer parse(String value) {
            return JBossPortConfig.parsePort(value, this.myModel);
        }

        protected String getServiceName() {
            return this.getPortConfig().getServiceName(this.myModel);
        }
    }

    private static final class HttpPortHandler
    implements JBossPortHandler {
        private HttpPortHandler() {
        }

        @Override
        public String getServiceName() {
            return "jboss.web:service=WebServer";
        }

        @Override
        public boolean checkBindingName() {
            return false;
        }

        @Override
        public List<JBossPortProvider> getPortProviders(JBossPortConfig portConfig, JavaeeServerModel model) {
            String protocol1dot1 = "@protocol='HTTP/1.1'";
            String noProtocol = "not(@protocol)";
            return Arrays.asList(new JBossHttpPortProvider(portConfig, model, "jbossweb.sar", "@protocol='HTTP/1.1'"), new JBossHttpPortProvider(portConfig, model, "jboss-web.deployer", "@protocol='HTTP/1.1'"), new JBossHttpPortProvider(portConfig, model, "jbossweb-tomcat55.sar", "not(@protocol)"));
        }
    }

    private static final class Version6OrAboveShutdownPortHandler
    implements JBossPortHandler {
        private Version6OrAboveShutdownPortHandler() {
        }

        @Override
        public String getServiceName() {
            return "jboss.remoting:service=JMXConnectorServer,protocol=rmi";
        }

        @Override
        public boolean checkBindingName() {
            return false;
        }

        @Override
        public List<JBossPortProvider> getPortProviders(JBossPortConfig portConfig, JavaeeServerModel model) {
            return Collections.emptyList();
        }
    }

    private static class DefaultPortHandler
    implements JBossPortHandler {
        private DefaultPortHandler() {
        }

        @Override
        public String getServiceName() {
            return "jboss:service=Naming";
        }

        @Override
        public boolean checkBindingName() {
            return true;
        }

        @Override
        public List<JBossPortProvider> getPortProviders(JBossPortConfig portConfig, JavaeeServerModel model) {
            return Collections.emptyList();
        }
    }

    private static abstract class JBossFactoryBase
    implements JavaeePortConfig.Factory<JBossLocalModel>,
    PortHandlerProvider {
        private final String myPortKindKey;

        protected JBossFactoryBase(String portKindKey) {
            this.myPortKindKey = portKindKey;
        }

        @NotNull
        public CachedConfig.Key createKey(JBossLocalModel data) {
            return new CachedConfig.Key(new String[]{data.getHome(), data.SERVER, this.myPortKindKey, "VM:" + data.getVmArguments()});
        }

        @NotNull
        public JavaeePortConfig createConfig(JBossLocalModel data) {
            return new JBossPortConfig(data.getHome(), data.SERVER, this);
        }
    }
}

