/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.version;

import com.intellij.javaee.oss.jboss.version.JBossVersionHandlerBase;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class JBossVersion6Handler
extends JBossVersionHandlerBase {
    public static final String ID = JBossVersion6Handler.class.getName();

    public JBossVersion6Handler(String home) {
        super(home);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected JavaeeServerVersionDescriptor doDetect() throws IOException {
        Path runJar = this.findFileUnderHome("bin/run.jar");
        String version = JarVersionDetectionUtil.getImplementationVersion((Path)runJar);
        if (version == null) {
            throw new IOException("Can't read version from jar: " + String.valueOf(runJar));
        }
        return new JavaeeServerVersionDescriptor(version.split(" ")[0], runJar);
    }

    @Override
    public void validate() throws IOException {
        this.findFileUnderHome("client/jbossall-client.jar");
    }

    @Override
    public List<File> getSchemas() {
        return null;
    }
}

