/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class CallTransformer {
    private CallTransformer() {
    }

    public static Call stripCallArguments(@NotNull Call call) {
        if (call == null) {
            CallTransformer.$$$reportNull$$$0(0);
        }
        return new DelegatingCall(call){

            @Override
            public KtValueArgumentList getValueArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public List<LambdaArgument> getFunctionLiteralArguments() {
                List<LambdaArgument> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtExpression calleeExpression = this.getCalleeExpression();
                assert (calleeExpression != null) : "No callee expression: " + this.getCallElement().getText();
                KtExpression ktExpression = calleeExpression;
                if (ktExpression == null) {
                    1.$$$reportNull$$$0(3);
                }
                return ktExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/resolve/calls/CallTransformer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionLiteralArguments";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeArguments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static Call stripReceiver(@NotNull Call variableCall) {
        if (variableCall == null) {
            CallTransformer.$$$reportNull$$$0(1);
        }
        return new DelegatingCall(variableCall){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return null;
            }

            @Override
            @Nullable
            public ReceiverValue getExplicitReceiver() {
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/CallTransformer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "stripCallArguments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "stripReceiver";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CallForImplicitInvoke
    extends DelegatingCall {
        private final Call outerCall;
        private final Receiver explicitExtensionReceiver;
        private final ExpressionReceiver calleeExpressionAsDispatchReceiver;
        private final KtSimpleNameExpression fakeInvokeExpression;
        public final boolean itIsVariableAsFunctionCall;

        public CallForImplicitInvoke(@Nullable Receiver explicitExtensionReceiver, @NotNull ExpressionReceiver calleeExpressionAsDispatchReceiver, @NotNull Call call, boolean functionCall) {
            if (calleeExpressionAsDispatchReceiver == null) {
                CallForImplicitInvoke.$$$reportNull$$$0(0);
            }
            if (call == null) {
                CallForImplicitInvoke.$$$reportNull$$$0(1);
            }
            super(call);
            this.outerCall = call;
            this.explicitExtensionReceiver = explicitExtensionReceiver;
            this.calleeExpressionAsDispatchReceiver = calleeExpressionAsDispatchReceiver;
            this.fakeInvokeExpression = (KtSimpleNameExpression)new KtPsiFactory(call.getCallElement().getProject(), false).createExpression(OperatorNameConventions.INVOKE.asString());
            this.itIsVariableAsFunctionCall = functionCall;
        }

        @Override
        @Nullable
        public ASTNode getCallOperationNode() {
            return this.explicitExtensionReceiver != null ? super.getCallOperationNode() : null;
        }

        @Override
        @Nullable
        public Receiver getExplicitReceiver() {
            return this.explicitExtensionReceiver;
        }

        @Override
        @NotNull
        public ExpressionReceiver getDispatchReceiver() {
            ExpressionReceiver expressionReceiver = this.calleeExpressionAsDispatchReceiver;
            if (expressionReceiver == null) {
                CallForImplicitInvoke.$$$reportNull$$$0(2);
            }
            return expressionReceiver;
        }

        @Override
        public KtExpression getCalleeExpression() {
            return this.fakeInvokeExpression;
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = Call.CallType.INVOKE;
            if (callType == null) {
                CallForImplicitInvoke.$$$reportNull$$$0(3);
            }
            return callType;
        }

        @NotNull
        public Call getOuterCall() {
            Call call = this.outerCall;
            if (call == null) {
                CallForImplicitInvoke.$$$reportNull$$$0(4);
            }
            return call;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "calleeExpressionAsDispatchReceiver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDispatchReceiver";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOuterCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

