/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.enums;

import com.intellij.util.xml.NamedEnum;
import org.jetbrains.annotations.NonNls;

public enum HibernateTypeType implements NamedEnum
{
    INTEGER("integer"),
    LONG("long"),
    SHORT("short"),
    FLOAT("float"),
    DOUBLE("double"),
    CHARACTER("character"),
    BYTE("byte"),
    BOOLEAN("boolean"),
    YES_NO("yes_no"),
    TRUE_FALSE("true_false"),
    STRING("string"),
    DATE("date"),
    TIME("time"),
    TIMESTAMP("timestamp"),
    CALENDAR("calendar"),
    CALENDAR_DATE("calendar_date"),
    BIG_DECIMAL("big_decimal"),
    BIG_INTEGER("big_integer"),
    LOCALE("locale"),
    TIMEZONE("timezone"),
    CURRENCY("currency"),
    CLASS("class"),
    BINARY("binary"),
    TEXT("text"),
    SERIALIZABLE("serializable"),
    CLOB("clob"),
    BLOB("blob"),
    IMM_DATE("imm_date"),
    IMM_TIME("imm_time"),
    IMM_TIMESTAMP("imm_timestamp"),
    IMM_CALENDAR("imm_calendar"),
    IMM_CALENDAR_DATE("imm_calendar_date"),
    IMM_SERIALIZABLE("imm_serializable"),
    IMM_BINARY("imm_binary");

    private final String myValue;

    private HibernateTypeType(String value) {
        this.myValue = value;
    }

    public String getValue() {
        return this.myValue;
    }

    @NonNls
    public String getJavaTypeName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BIG_DECIMAL -> "java.math.BigDecimal";
            case BIG_INTEGER -> "java.math.BigInteger";
            case IMM_BINARY, BINARY -> "byte[]";
            case BLOB -> "java.sql.Blob";
            case BOOLEAN -> "boolean";
            case BYTE -> "byte";
            case IMM_CALENDAR, CALENDAR -> "java.util.Calendar";
            case IMM_CALENDAR_DATE, CALENDAR_DATE -> "java.util.Calendar";
            case CHARACTER -> "char";
            case CLASS -> "java.lang.Class";
            case CLOB -> "java.sql.Clob";
            case CURRENCY -> "java.util.Currency";
            case IMM_DATE, DATE -> "java.util.Date";
            case DOUBLE -> "double";
            case FLOAT -> "float";
            case INTEGER -> "int";
            case LOCALE -> "java.util.Locale";
            case LONG -> "long";
            case IMM_SERIALIZABLE, SERIALIZABLE -> "java.io.Serializable";
            case SHORT -> "short";
            case STRING, TEXT -> "java.lang.String";
            case TIME, IMM_TIME, IMM_TIMESTAMP, TIMESTAMP -> "java.util.Date";
            case TIMEZONE -> "java.util.TimeZone";
            case TRUE_FALSE, YES_NO -> "boolean";
        };
    }
}

