/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.RunSqlScriptAction;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunProfileState;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.ConsoleLogger;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u001a\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptFilesRunProfileState;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunProfileState;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetPairs", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/util/ObjectPath;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/List;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "executeImpl", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "CompletionAsProcessHandler", "intellij.database.impl"})
public final class DatabaseScriptFilesRunProfileState
extends DatabaseScriptRunProfileState {
    @NotNull
    private final List<VirtualFile> virtualFiles;
    @NotNull
    private final List<Pair<LocalDataSource, ObjectPath>> targetPairs;
    @NotNull
    private final ExecutionEnvironment environment;

    public DatabaseScriptFilesRunProfileState(@Nullable String name2, @NotNull Project project, @NotNull List<? extends VirtualFile> virtualFiles, @NotNull List<? extends Pair<LocalDataSource, ObjectPath>> targetPairs, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        Intrinsics.checkNotNullParameter(targetPairs, (String)"targetPairs");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(name2, project, null);
        this.virtualFiles = virtualFiles;
        this.targetPairs = targetPairs;
        this.environment = environment;
    }

    @Override
    @NotNull
    protected ExecutionResult executeImpl(@Nullable Executor executor, @NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        CompletionAsProcessHandler handler2 = new CompletionAsProcessHandler();
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"createBuilder(...)");
        TextConsoleBuilder builder = textConsoleBuilder;
        ConsoleView consoleView = builder.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView console = consoleView;
        JBIterable jBIterable = JBIterable.from((Iterable)this.virtualFiles);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable iterableTargetPairs = jBIterable;
        console.attachToProcess((ProcessHandler)handler2);
        String string = DatabaseBundle.message((String)"progress.title.running.scripts", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        handler2.start(string, (Function0<AsyncTask<Object>>)((Function0)() -> DatabaseScriptFilesRunProfileState.executeImpl$lambda$1(this, iterableTargetPairs, console)));
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)handler2);
    }

    private static final Unit executeImpl$lambda$1$lambda$0(DatabaseScriptFilesRunProfileState this$0, JBIterable $iterableTargetPairs, ConsoleView $console, AsyncTask.Frame $frame) {
        Project project = this$0.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<Pair<LocalDataSource, ObjectPath>> list = this$0.targetPairs;
        DataAuditors.PrintingAdapter printingAdapter = new ConsoleLogger($console);
        ProgressIndicator progressIndicator = AsyncTask.Companion.getIndicator($frame);
        Intrinsics.checkNotNull((Object)progressIndicator);
        RunSqlScriptAction.INSTANCE.performImpl(project, (JBIterable<VirtualFile>)$iterableTargetPairs, list, printingAdapter, progressIndicator);
        return Unit.INSTANCE;
    }

    private static final AsyncTask executeImpl$lambda$1(DatabaseScriptFilesRunProfileState this$0, JBIterable $iterableTargetPairs, ConsoleView $console) {
        RunSqlScriptAction.INSTANCE.prepare(this$0.getProject(), (JBIterable<VirtualFile>)$iterableTargetPairs, this$0.targetPairs);
        AsyncTask.Frame frame = AsyncTask.Companion.currentFrame();
        return frame.compute(AsyncUtil.getPoolExecutor(), () -> DatabaseScriptFilesRunProfileState.executeImpl$lambda$1$lambda$0(this$0, $iterableTargetPairs, $console, frame));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0014J\b\u0010\u0017\u001a\u00020\bH\u0014R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptFilesRunProfileState$CompletionAsProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "<init>", "()V", "indicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "kotlin.jvm.PlatformType", "start", "", "frameName", "", "s", "Lkotlin/Function0;", "Lcom/intellij/database/util/AsyncTask;", "", "onError", "e", "", "getProcessInput", "Ljava/io/OutputStream;", "detachIsDefault", "", "detachProcessImpl", "destroyProcessImpl", "Companion", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseScriptRunProfileState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptRunProfileState.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptFilesRunProfileState$CompletionAsProcessHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
    private static final class CompletionAsProcessHandler
    extends ProcessHandler {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final EmptyProgressIndicator indicator = (EmptyProgressIndicator)AsyncUtil.markAsyncFriendly((ProgressIndicator)((ProgressIndicator)new EmptyProgressIndicator()), (boolean)true);
        @NotNull
        private static final Logger LOG;

        public final void start(@NlsContexts.ProgressTitle @NotNull String frameName, @NotNull Function0<AsyncTask<Object>> s) {
            Intrinsics.checkNotNullParameter((Object)frameName, (String)"frameName");
            Intrinsics.checkNotNullParameter(s, (String)"s");
            this.indicator.start();
            AsyncTask.Frame frame = AsyncTask.Companion.frame(frameName);
            AsyncTask.Companion.storeIndicator(frame, (ProgressIndicator)this.indicator);
            AsyncTask completion = frame.computeAsync(null, () -> CompletionAsProcessHandler.start$lambda$0(s));
            this.startNotify();
            completion.whenComplete(null, (arg_0, arg_1) -> CompletionAsProcessHandler.start$lambda$2((arg_0, arg_1) -> CompletionAsProcessHandler.start$lambda$1(this, arg_0, arg_1), arg_0, arg_1));
        }

        private final void onError(Throwable e) {
            String string;
            if (AsyncUtil.isCancellation((Throwable)e)) {
                string = "Cancelled";
            } else {
                string = e.getMessage();
                if (string == null) {
                    string = e.toString();
                }
            }
            this.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
            if (!AsyncUtil.isCancellation((Throwable)e)) {
                LOG.warn(e);
            }
            this.notifyProcessTerminated(0);
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }

        public boolean detachIsDefault() {
            return false;
        }

        protected void detachProcessImpl() {
        }

        protected void destroyProcessImpl() {
            this.indicator.cancel();
        }

        private static final AsyncTask start$lambda$0(Function0 $tmp0) {
            return (AsyncTask)$tmp0.invoke();
        }

        private static final Unit start$lambda$1(CompletionAsProcessHandler this$0, Object object, Throwable exception) {
            Throwable throwable = exception;
            if (throwable != null) {
                Throwable p0 = throwable;
                boolean bl = false;
                this$0.onError(p0);
            } else {
                this$0.notifyProcessTerminated(0);
            }
            return Unit.INSTANCE;
        }

        private static final void start$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        static {
            Logger logger = Logger.getInstance(CompletionAsProcessHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptFilesRunProfileState$CompletionAsProcessHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

