/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ParamEditor;
import com.intellij.database.dataSource.url.TypeDescriptorUi;
import com.intellij.database.dataSource.url.TypesRegistryUi;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParametersLayoutUtils {
    private static final Key<String> PARAM_NAME = Key.create((String)"PARAM_NAME");
    private static final List<String> TO_REMOVE = Arrays.asList("user", "password");
    private static final List<String> HEADS = Arrays.asList("host", "port", "project", "region", "SID", "tns_name", "service", "instance", "driver", "file", "path", "localdb_pipe");
    private static final List<String> TAILS = Arrays.asList("role", "database", "schema");

    public static Pair<List<ParamEditor>, Map<String, ParamEditor>> createEditors(@NotNull List<String> params, @NotNull StatelessParametersHolder parametersHolder, @NotNull DataInterchange dataInterchange, @NotNull Disposable parent) {
        if (params == null) {
            ParametersLayoutUtils.$$$reportNull$$$0(0);
        }
        if (parametersHolder == null) {
            ParametersLayoutUtils.$$$reportNull$$$0(1);
        }
        if (dataInterchange == null) {
            ParametersLayoutUtils.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            ParametersLayoutUtils.$$$reportNull$$$0(3);
        }
        ArrayList<ParamEditor> editors2 = new ArrayList<ParamEditor>();
        HashMap<String, ParamEditor> fields = new HashMap<String, ParamEditor>();
        for (String param : params) {
            TypeDescriptorUi descriptor2;
            StatelessParametersHolder.ParameterInfo info2 = parametersHolder.getParameterInfo(param);
            if (info2 == null || info2.isHidden() || (descriptor2 = TypesRegistryUi.getInstance().get(info2.getType())) == null) continue;
            editors2.addAll(descriptor2.createSatellites(dataInterchange));
            ParamEditor field = descriptor2.createField(info2.getType(), param, info2.getConfiguration(), dataInterchange);
            editors2.add(field);
            fields.put(param, field);
            ClientProperty.put((JComponent)field.getComponent(), PARAM_NAME, (Object)param);
            UIUtil.uiTraverser((Component)field.getComponent()).filter(EditorTextField.class).forEach(etf -> etf.setDisposedWith(parent));
        }
        for (ParamEditor editor2 : editors2) {
            Disposer.register((Disposable)parent, (Disposable)editor2);
        }
        return new Pair(editors2, fields);
    }

    public static String getParamName(@Nullable ParamEditor e) {
        return e == null ? null : (String)UIUtil.getClientProperty((Object)e.getComponent(), PARAM_NAME);
    }

    public static Couple<List<String>> groupParameters(@NotNull List<String> params) {
        if (params == null) {
            ParametersLayoutUtils.$$$reportNull$$$0(4);
        }
        ArrayList<String> head = new ArrayList<String>();
        ArrayList tail = new ArrayList();
        for (String param : params) {
            if (param == null || ParametersLayoutUtils.isToRemove(param)) continue;
            (ParametersLayoutUtils.isHead(param) ? head : tail).add(param);
        }
        ContainerUtil.sort(head, Comparator.comparing(p2 -> ParametersLayoutUtils.priority(HEADS, p2)));
        ContainerUtil.sort(tail, Comparator.comparing(p2 -> ParametersLayoutUtils.priority(TAILS, p2)));
        return Couple.of(head, tail);
    }

    public static List<List<ParamEditor>> getLayout(Collection<ParamEditor> editors2, StatelessParametersHolder parametersHolder, DataInterchange dataInterchange) {
        ArrayList<List<ParamEditor>> res2 = new ArrayList<List<ParamEditor>>();
        for (ParamEditor editor2 : editors2) {
            boolean append2;
            String param = ParametersLayoutUtils.getParamName(editor2);
            if (!ParametersLayoutUtils.isVisible(param, dataInterchange, parametersHolder)) continue;
            ArrayList<ParamEditor> curRow = (ArrayList<ParamEditor>)ContainerUtil.getLastItem(res2);
            ParamEditor prev2 = (ParamEditor)ContainerUtil.getLastItem((List)curRow);
            assert (prev2 == null || curRow != null);
            boolean bl = append2 = prev2 != null && curRow.size() < 2 && ParametersLayoutUtils.isPair(prev2, editor2);
            if (curRow == null || !append2) {
                curRow = new ArrayList<ParamEditor>(1);
                res2.add(curRow);
            }
            curRow.add(editor2);
        }
        return res2;
    }

    public static void layoutComponent(JComponent comp, List<List<ParamEditor>> layoutData) {
        comp.removeAll();
        if (layoutData.isEmpty()) {
            return;
        }
        comp.setLayout((LayoutManager)new GridLayoutManager(layoutData.size(), 6));
        int row = 0;
        for (List<ParamEditor> entries : layoutData) {
            int column2 = 0;
            for (ParamEditor editor2 : entries) {
                int span;
                if (editor2.getCaption() != null) {
                    JComponent component = editor2.getEditorComponent();
                    JLabel label = DatabaseUIUtils.getLabelOf(component);
                    if (label == null) {
                        label = new JBLabel(editor2.getCaption());
                        if (column2 != 0) {
                            label.setBorder(DatabaseUIUtils.innerLabelBorder());
                        }
                        component.getAccessibleContext().setAccessibleName(label.getText());
                    }
                    comp.add((Component)label, DatabaseUIUtils.createLabelConstraints(row, column2, label.getPreferredSize().getWidth()));
                }
                if (column2 == 0) {
                    ++column2;
                    span = entries.size() < 2 && editor2.getFieldSize() != FieldSize.SMALL ? 5 : 3;
                } else if (editor2.getCaption() != null) {
                    ++column2;
                    span = 1;
                } else {
                    span = 2;
                }
                comp.add((Component)editor2.getComponent(), DatabaseUIUtils.createSimpleConstraints(row, column2, span));
                column2 += span;
            }
            ++row;
        }
        comp.revalidate();
        comp.repaint();
    }

    private static boolean isPair(@Nullable ParamEditor e1, @Nullable ParamEditor e2) {
        String param1 = ParametersLayoutUtils.getParamName(e1);
        String param2 = ParametersLayoutUtils.getParamName(e2);
        if (param1 == null || param2 == null) {
            return false;
        }
        if (param1.equals("host") && param2.equals("port")) {
            return true;
        }
        return e2.getFieldSize() == FieldSize.SMALL;
    }

    private static boolean isVisible(String param, DataInterchange dataInterchange, StatelessParametersHolder parametersHolder) {
        return !ParametersLayoutUtils.isExtra(param, parametersHolder) || StringUtil.isNotEmpty((String)dataInterchange.getProperty(param));
    }

    private static boolean isExtra(String param, StatelessParametersHolder parametersHolder) {
        StatelessParametersHolder.ParameterInfo info2 = param == null ? null : parametersHolder.getParameterInfo(param);
        return info2 != null && info2.isExtra();
    }

    private static int priority(List<String> list, String o) {
        int idx = list.indexOf(o);
        return idx == -1 ? Integer.MAX_VALUE : idx;
    }

    private static boolean isToRemove(@NotNull String param) {
        if (param == null) {
            ParametersLayoutUtils.$$$reportNull$$$0(5);
        }
        return TO_REMOVE.contains(param);
    }

    private static boolean isHead(@NotNull String param) {
        if (param == null) {
            ParametersLayoutUtils.$$$reportNull$$$0(6);
        }
        return HEADS.contains(param);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataInterchange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/url/ui/ParametersLayoutUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "groupParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isToRemove";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isHead";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

