/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationDialogKt;
import com.intellij.database.model.migration.DbMigrationElement;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.database.model.migration.SdColorsKt;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/model/migration/DbMigrationSideTree;", "Lcom/intellij/ui/treeStructure/Tree;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/TreeModel;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/TreeModel;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;)V", "isFileColorsEnabled", "", "getFileColorFor", "Ljava/awt/Color;", "obj", "", "getColorImpl", "color", "enclosingMapping", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "paintChangesBorders", "paintUpperBorder", "bounds", "Ljava/awt/Rectangle;", "paintLowerBorder", "paintLeftBorder", "paintRightBorder", "CellRenderer", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationSideTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationSideTree.kt\ncom/intellij/database/model/migration/DbMigrationSideTree\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,207:1\n14#2:208\n*S KotlinDebug\n*F\n+ 1 DbMigrationSideTree.kt\ncom/intellij/database/model/migration/DbMigrationSideTree\n*L\n53#1:208\n*E\n"})
public final class DbMigrationSideTree
extends Tree {
    @NotNull
    private final DbMigrationTreeModel.Side side;

    public DbMigrationSideTree(@NotNull Project project, @NotNull TreeModel model, @NotNull DbMigrationTreeModel.Side side) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        super(model);
        this.side = side;
        CellRenderer renderer2 = new CellRenderer(project, this.side, false);
        this.setCellRenderer(renderer2);
        Function1 treeSearchConvertor = arg_0 -> DbMigrationSideTree._init_$lambda$0(renderer2, arg_0);
        this.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, true);
        TreeSpeedSearch.installOn((JTree)((JTree)((Object)this)), (boolean)true, arg_0 -> DbMigrationSideTree._init_$lambda$1(treeSearchConvertor, arg_0));
        this.setRootVisible(false);
        this.setBackground(EditorColorsUtil.getGlobalOrDefaultColorScheme().getDefaultBackground());
    }

    public boolean isFileColorsEnabled() {
        return true;
    }

    @Nullable
    public Color getFileColorFor(@Nullable Object obj) {
        Color color;
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
        DbMigrationTreeModel.Node node = (DbMigrationTreeModel.Node)obj;
        DiffStatus diffStatus = node.getStatus();
        Color color2 = color = diffStatus != null ? SdColorsKt.getBackground(diffStatus) : null;
        if (color == null) {
            return super.getFileColorFor(obj);
        }
        DbMigrationTreeModel.MappingState enclosingMapping = node.enclosingMapping();
        if (!node.isBasicElementNode() && enclosingMapping == null) {
            return super.getFileColorFor(obj);
        }
        if (enclosingMapping == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DbMigrationDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("this node does not belong to any mapping: " + node);
            return super.getFileColorFor(obj);
        }
        return this.getColorImpl(color, enclosingMapping);
    }

    private final Color getColorImpl(Color color, DbMigrationTreeModel.MappingState enclosingMapping) {
        Color color2;
        if (this.side == DbMigrationTreeModel.Side.ORIGIN) {
            color2 = color;
        } else if (enclosingMapping.getIncluded()) {
            color2 = color;
        } else {
            Color color3 = ColorUtil.mix((Color)color, (Color)this.getBackground(), (double)0.3);
            color2 = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"mix(...)");
        }
        return color2;
    }

    protected void paintComponent(@Nullable Graphics g) {
        super.paintComponent(g);
        Graphics graphics = g;
        Intrinsics.checkNotNull((Object)graphics);
        this.paintChangesBorders(graphics);
    }

    private final void paintChangesBorders(Graphics g) {
        DbMigrationTreeModel.Node currentMappingNode = null;
        int n = this.getRowCount();
        for (int row = 0; row < n; ++row) {
            boolean changeContinues;
            boolean changeEnded;
            Rectangle bounds;
            TreePath path = this.getPathForRow(row);
            Intrinsics.checkNotNull((Object)path);
            DbMigrationTreeModel.Node node = DbMigrationDialogKt.last(path);
            if (DbMigrationDialogKt.nodeBounds(this, path) == null) continue;
            Container container = this.getParent();
            Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBViewport");
            Rectangle viewRect = ((JBViewport)container).getViewRect();
            if (!bounds.intersects(viewRect)) continue;
            boolean newChangeStarted = node.getContainsMapping();
            if (newChangeStarted) {
                currentMappingNode = node;
                DiffStatus diffStatus = currentMappingNode.getStatus();
                g.setColor(diffStatus != null ? SdColorsKt.borderColor(diffStatus) : null);
                this.paintUpperBorder(g, bounds);
                if (row == this.getRowCount() - 1) {
                    this.paintLowerBorder(g, bounds);
                }
                if (this.side != DbMigrationTreeModel.Side.TARGET) {
                    this.paintLeftBorder(g, bounds);
                }
                this.paintRightBorder(g, bounds);
                continue;
            }
            boolean bl = changeEnded = currentMappingNode != null && !Intrinsics.areEqual((Object)node.enclosingMappingNode(), (Object)currentMappingNode);
            if (changeEnded) {
                currentMappingNode = null;
                this.paintUpperBorder(g, bounds);
                continue;
            }
            boolean bl2 = changeContinues = currentMappingNode != null;
            if (!changeContinues) continue;
            if (row == this.getRowCount() - 1) {
                this.paintLowerBorder(g, bounds);
            }
            this.paintLeftBorder(g, bounds);
            this.paintRightBorder(g, bounds);
        }
    }

    private final void paintUpperBorder(Graphics g, Rectangle bounds) {
        g.drawLine(0, bounds.y, this.getWidth(), bounds.y);
    }

    private final void paintLowerBorder(Graphics g, Rectangle bounds) {
        g.drawLine(0, bounds.y + bounds.height, this.getWidth(), bounds.y + bounds.height);
    }

    private final void paintLeftBorder(Graphics g, Rectangle bounds) {
        g.drawLine(0, bounds.y, 0, bounds.y + bounds.height);
    }

    private final void paintRightBorder(Graphics g, Rectangle bounds) {
        g.drawLine(this.getWidth(), bounds.y, this.getWidth(), bounds.y + bounds.height);
    }

    private static final String _init_$lambda$0(CellRenderer $renderer, TreePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return $renderer.updatePresentation(DbMigrationDialogKt.last(path)).getPresentableText();
    }

    private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJB\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0016J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001fH\u0002J\u001e\u0010 \u001a\u0004\u0018\u00010!2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001f2\u0006\u0010\"\u001a\u00020!H\u0002J\u0014\u0010#\u001a\u00020\u00122\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001fH\u0002J\u0012\u0010$\u001a\u00020\f2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/intellij/database/model/migration/DbMigrationSideTree$CellRenderer;", "Ljavax/swing/tree/TreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "useForegroundColor", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;Z)V", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "getPresentation", "()Lcom/intellij/ide/projectView/PresentationData;", "setPresentation", "(Lcom/intellij/ide/projectView/PresentationData;)V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "", "hasFocus", "node", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "getForeground", "Ljava/awt/Color;", "bg", "addCounter", "updatePresentation", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMigrationSideTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationSideTree.kt\ncom/intellij/database/model/migration/DbMigrationSideTree$CellRenderer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,207:1\n30#2,2:208\n*S KotlinDebug\n*F\n+ 1 DbMigrationSideTree.kt\ncom/intellij/database/model/migration/DbMigrationSideTree$CellRenderer\n*L\n191#1:208,2\n*E\n"})
    public static final class CellRenderer
    extends ColoredTreeCellRenderer
    implements TreeCellRenderer {
        @NotNull
        private final Project project;
        @NotNull
        private final DbMigrationTreeModel.Side side;
        private final boolean useForegroundColor;
        @NotNull
        private PresentationData presentation;

        public CellRenderer(@NotNull Project project, @NotNull DbMigrationTreeModel.Side side, boolean useForegroundColor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            this.project = project;
            this.side = side;
            this.useForegroundColor = useForegroundColor;
            this.presentation = new PresentationData();
        }

        @NotNull
        public final PresentationData getPresentation() {
            return this.presentation;
        }

        public final void setPresentation(@NotNull PresentationData presentationData) {
            Intrinsics.checkNotNullParameter((Object)presentationData, (String)"<set-?>");
            this.presentation = presentationData;
        }

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
            DbMigrationTreeModel.Node node = (DbMigrationTreeModel.Node)value;
            this.updatePresentation(node);
            this.customizeCellRenderer(tree, row, node);
        }

        private final void customizeCellRenderer(JTree tree, int row, DbMigrationTreeModel.Node node) {
            this.setIcon(this.presentation.getIcon(false));
            boolean isMain = true;
            for (PresentableNodeDescriptor.ColoredFragment each : this.presentation.getColoredText()) {
                SimpleTextAttributes simpleTextAttributes;
                boolean grayed = Comparing.equal((Object)each.getAttributes().getFgColor(), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                if (grayed) {
                    isMain = false;
                }
                int style = each.getAttributes().getStyle();
                if (!Registry.Companion.is("database.schema.diff.table.view") && node.getStatus() == DiffStatus.ADDED && this.side == DbMigrationTreeModel.Side.TARGET) {
                    style |= 2;
                }
                if (isMain) {
                    SimpleTextAttributes simpleTextAttributes2 = each.getAttributes();
                    Color color = tree.getBackground();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
                    simpleTextAttributes = simpleTextAttributes2.derive(style, this.getForeground(node, color), null, null);
                } else {
                    simpleTextAttributes = each.getAttributes();
                }
                SimpleTextAttributes attributes = simpleTextAttributes;
                this.append(each.getText(), attributes, isMain);
            }
            if (this.side == DbMigrationTreeModel.Side.TARGET && !tree.getModel().isLeaf(node) && tree.isCollapsed(row) && node.getChildrenMappingCount() > 0) {
                this.addCounter(node);
            }
        }

        private final Color getForeground(DbMigrationTreeModel.Node node, Color bg) {
            boolean excluded;
            if (this.side == DbMigrationTreeModel.Side.ORIGIN) {
                return null;
            }
            if (!node.isBasicElementNode() && node.getParent() != null && node.getParent().getStatus() != node.getStatus()) {
                return null;
            }
            DbMigrationTreeModel.MappingState mapping = node.enclosingMapping();
            boolean bl = excluded = mapping != null && !mapping.getIncluded();
            if (!this.useForegroundColor) {
                return excluded ? SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor() : null;
            }
            DiffStatus diffStatus = node.getStatus();
            return diffStatus != null ? SdColorsKt.getForeground(diffStatus, bg, excluded) : null;
        }

        private final void addCounter(DbMigrationTreeModel.Node node) {
            String includedCounterText = " " + node.getIncludedChildrenMappingCount() + " / " + node.getChildrenMappingCount() + " ";
            this.append("\u2002", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            SimpleTextAttributes counterAttributes = DbNodeDescriptor.ACTIVE_LINK_ATTRS;
            this.append(includedCounterText, counterAttributes);
        }

        @NotNull
        public final PresentationData updatePresentation(@NotNull DbMigrationTreeModel.Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DbMigrationElement element = switch (WhenMappings.$EnumSwitchMapping$0[this.side.ordinal()]) {
                case 1 -> node.getOrigin();
                case 2 -> {
                    if (node.getStatus() == DiffStatus.ADDED) {
                        yield node.getOrigin();
                    }
                    yield node.getTarget();
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            if (element == null) {
                this.presentation.clear();
            } else {
                DvViewOptions viewOptions = DvViewOptionsFun.getDatabaseViewOptions((Project)this.project);
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                DvTreeStructureService treeStructure = (DvTreeStructureService)object;
                DbNodeDescriptor.updatePresentation(this.presentation, element.getBase(), this.project, viewOptions, (DvTreeStructure)treeStructure, null, false, false);
            }
            return this.presentation;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DbMigrationTreeModel.Side.values().length];
                try {
                    nArray[DbMigrationTreeModel.Side.ORIGIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DbMigrationTreeModel.Side.TARGET.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

